/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.jvm.impl;

import java.io.File;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u001a\u001e\u0010\r\u001a\u0004\u0018\u00010\u00012\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u001a\u0018\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010\u0018\u001a\u0004\u0018\u00010\n*\u00020\u0007H\u0000\u001a\u000e\u0010\u0019\u001a\u0004\u0018\u00010\n*\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"FILE_PROTOCOL", "", "JAR_PROTOCOL", "JAR_SEPARATOR", "SCHEME_SEPARATOR", "extractRoot", "resourceURL", "Ljava/net/URL;", "resourcePath", "getResourcePathForClass", "Ljava/io/File;", "aClass", "Ljava/lang/Class;", "getResourceRoot", "context", "path", "splitJarUrl", "Lkotlin/Pair;", "url", "tryGetResourcePathForClass", "tryGetResourcePathForClassByName", "name", "classLoader", "Ljava/lang/ClassLoader;", "toContainingJarOrNull", "toFileOrNull", "kotlin-scripting-jvm"})
public final class PathUtilKt {
    private static final String JAR_PROTOCOL = "jar";
    private static final String FILE_PROTOCOL = "file";
    private static final String JAR_SEPARATOR = "!/";
    private static final String SCHEME_SEPARATOR = "://";

    @Nullable
    public static final String getResourceRoot(@NotNull Class<?> context2, @NotNull String path2) {
        Intrinsics.checkParameterIsNotNull(context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        URL url = context2.getResource(path2);
        if (url == null) {
            String string2 = path2;
            int n = 1;
            boolean bl = false;
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            url = ClassLoader.getSystemResource(string3);
        }
        return url != null ? PathUtilKt.extractRoot(url, path2) : null;
    }

    private static final String extractRoot(URL resourceURL, String resourcePath) {
        if (!StringsKt.startsWith$default((CharSequence)resourcePath, (char)'/', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)resourcePath, (char)'\\', (boolean)false, (int)2, null)) {
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if (Intrinsics.areEqual((Object)protocol, (Object)FILE_PROTOCOL)) {
            String path2;
            File file2 = PathUtilKt.toFileOrNull(resourceURL);
            if (file2 == null) {
                Intrinsics.throwNpe();
            }
            String string2 = path2 = file2.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
            String testPath = StringsKt.replace$default((String)string2, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            String testResourcePath = StringsKt.replace$default((String)resourcePath, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            if (StringsKt.endsWith((String)testPath, (String)testResourcePath, (boolean)true)) {
                String string3 = path2;
                int n = 0;
                int n2 = path2.length() - resourcePath.length();
                boolean bl = false;
                String string4 = string3.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                resultPath = string4;
            }
        } else if (Intrinsics.areEqual((Object)protocol, (Object)JAR_PROTOCOL)) {
            Pair<String, String> paths;
            String string5 = resourceURL.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"resourceURL.file");
            Pair<String, String> pair = paths = PathUtilKt.splitJarUrl(string5);
            if ((pair != null ? (String)pair.getFirst() : null) != null) {
                resultPath = new File((String)paths.getFirst()).getCanonicalPath();
            }
        }
        String string6 = resultPath;
        return string6 != null ? StringsKt.trimEnd((String)string6, (char[])new char[]{File.separatorChar}) : null;
    }

    private static final Pair<String, String> splitJarUrl(String url) {
        String jarPath;
        String resourcePath;
        block13: {
            Integer n = StringsKt.indexOf$default((CharSequence)url, (String)JAR_SEPARATOR, (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            int n2 = 0;
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            Integer n3 = it >= 0 ? n : null;
            if (n3 == null) {
                return null;
            }
            int pivot = n3;
            String string2 = url;
            n2 = pivot + 2;
            int n4 = 0;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            resourcePath = string4;
            String string5 = url;
            n4 = 0;
            int n5 = 0;
            String string6 = string5;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n4, pivot);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            jarPath = string7;
            if (StringsKt.startsWith$default((String)jarPath, (String)"jar:", (boolean)false, (int)2, null)) {
                string5 = jarPath;
                n4 = 4;
                n5 = 0;
                String string8 = string5;
                if (string8 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.substring(n4);
                Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
                jarPath = string9;
            }
            if (StringsKt.startsWith$default((String)jarPath, (String)FILE_PROTOCOL, (boolean)false, (int)2, null)) {
                try {
                    File file2 = PathUtilKt.toFileOrNull(new URL(jarPath));
                    if (file2 == null) {
                        Intrinsics.throwNpe();
                    }
                    String string10 = file2.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"URL(jarPath).toFileOrNull()!!.path");
                    jarPath = StringsKt.replace$default((String)string10, (char)'\\', (char)'/', (boolean)false, (int)4, null);
                }
                catch (Exception e) {
                    String string11 = jarPath;
                    n5 = FILE_PROTOCOL.length();
                    boolean bl3 = false;
                    String string12 = string11;
                    if (string12 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string13 = string12.substring(n5);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"(this as java.lang.String).substring(startIndex)");
                    jarPath = string13;
                    if (StringsKt.startsWith$default((String)jarPath, (String)SCHEME_SEPARATOR, (boolean)false, (int)2, null)) {
                        string11 = jarPath;
                        n5 = SCHEME_SEPARATOR.length();
                        bl3 = false;
                        String string14 = string11;
                        if (string14 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string15 = string14.substring(n5);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string15, (String)"(this as java.lang.String).substring(startIndex)");
                        jarPath = string15;
                    }
                    if (!StringsKt.startsWith$default((CharSequence)jarPath, (char)':', (boolean)false, (int)2, null)) break block13;
                    string11 = jarPath;
                    n5 = 1;
                    bl3 = false;
                    String string16 = string11;
                    if (string16 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string17 = string16.substring(n5);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string17, (String)"(this as java.lang.String).substring(startIndex)");
                    jarPath = string17;
                }
            }
        }
        return new Pair((Object)jarPath, (Object)resourcePath);
    }

    @Nullable
    public static final File tryGetResourcePathForClass(@NotNull Class<?> aClass2) {
        File file2;
        Intrinsics.checkParameterIsNotNull(aClass2, (String)"aClass");
        StringBuilder stringBuilder2 = new StringBuilder().append("/");
        String string2 = aClass2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"aClass.name");
        String path2 = stringBuilder2.append(StringsKt.replace$default((String)string2, (char)'.', (char)'/', (boolean)false, (int)4, null)).append(".class").toString();
        String string3 = PathUtilKt.getResourceRoot(aClass2, path2);
        if (string3 != null) {
            String string4 = string3;
            boolean bl = false;
            boolean bl2 = false;
            String it = string4;
            boolean bl3 = false;
            file2 = new File(it).getAbsoluteFile();
        } else {
            file2 = null;
        }
        return file2;
    }

    @NotNull
    public static final File getResourcePathForClass(@NotNull Class<?> aClass2) {
        Intrinsics.checkParameterIsNotNull(aClass2, (String)"aClass");
        File file2 = PathUtilKt.tryGetResourcePathForClass(aClass2);
        if (file2 == null) {
            throw (Throwable)new IllegalStateException("Resource for class: " + aClass2.getName() + " not found");
        }
        return file2;
    }

    @Nullable
    public static final File tryGetResourcePathForClassByName(@NotNull String name2, @NotNull ClassLoader classLoader2) {
        Class<?> clazz;
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)classLoader2, (String)"classLoader");
        try {
            File file2;
            Class<?> clazz2 = classLoader2.loadClass(name2);
            if (clazz2 != null) {
                clazz = clazz2;
                boolean bl = false;
                boolean bl2 = false;
                Class<?> p1 = clazz;
                boolean bl3 = false;
                file2 = PathUtilKt.tryGetResourcePathForClass(p1);
            } else {
                file2 = null;
            }
            clazz = file2;
        }
        catch (ClassNotFoundException _) {
            clazz = null;
        }
        catch (NoClassDefFoundError _) {
            clazz = null;
        }
        return clazz;
    }

    @Nullable
    public static final File toFileOrNull(@NotNull URL $this$toFileOrNull) {
        File file2;
        Serializable serializable;
        Intrinsics.checkParameterIsNotNull((Object)$this$toFileOrNull, (String)"$this$toFileOrNull");
        try {
            serializable = new File($this$toFileOrNull.toURI());
        }
        catch (IllegalArgumentException e) {
            serializable = null;
        }
        catch (URISyntaxException e) {
            serializable = null;
        }
        if ((file2 = serializable) == null) {
            serializable = $this$toFileOrNull;
            boolean bl = false;
            boolean bl2 = false;
            Serializable $this$run = serializable;
            boolean bl3 = false;
            file2 = Intrinsics.areEqual((Object)((URL)$this$run).getProtocol(), (Object)FILE_PROTOCOL) ^ true ? null : new File(((URL)$this$run).getFile());
        }
        return file2;
    }

    @Nullable
    public static final File toContainingJarOrNull(@NotNull URL $this$toContainingJarOrNull) {
        File file2;
        Intrinsics.checkParameterIsNotNull((Object)$this$toContainingJarOrNull, (String)"$this$toContainingJarOrNull");
        if (Intrinsics.areEqual((Object)$this$toContainingJarOrNull.getProtocol(), (Object)JAR_PROTOCOL)) {
            Object object;
            URLConnection uRLConnection = $this$toContainingJarOrNull.openConnection();
            if (!(uRLConnection instanceof JarURLConnection)) {
                uRLConnection = null;
            }
            file2 = (object = (JarURLConnection)uRLConnection) != null && (object = ((JarURLConnection)object).getJarFileURL()) != null ? PathUtilKt.toFileOrNull((URL)object) : null;
        } else {
            file2 = null;
        }
        return file2;
    }
}

