/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import kotlin.io.FilesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.modules.ModuleChunk;
import org.jetbrains.kotlin.cli.common.modules.ModuleXmlParser;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.PathUtil;

public class CompileEnvironmentUtil {
    @NotNull
    public static ModuleChunk loadModuleChunk(File buildFile, MessageCollector messageCollector2) {
        if (!buildFile.exists()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Module definition file does not exist: " + buildFile, null);
            ModuleChunk moduleChunk2 = ModuleChunk.EMPTY;
            if (moduleChunk2 == null) {
                CompileEnvironmentUtil.$$$reportNull$$$0(0);
            }
            if (moduleChunk2 == null) {
                CompileEnvironmentUtil.$$$reportNull$$$1(0);
            }
            if (moduleChunk2 == null) {
                CompileEnvironmentUtil.$$$reportNull$$$2(0);
            }
            if (moduleChunk2 == null) {
                CompileEnvironmentUtil.$$$reportNull$$$3(0);
            }
            if (moduleChunk2 == null) {
                CompileEnvironmentUtil.$$$reportNull$$$4(0);
            }
            if (moduleChunk2 == null) {
                CompileEnvironmentUtil.$$$reportNull$$$5(0);
            }
            return moduleChunk2;
        }
        if ("xml".equalsIgnoreCase(FilesKt.getExtension((File)buildFile))) {
            ModuleChunk moduleChunk3 = ModuleXmlParser.parseModuleScript(buildFile.getPath(), messageCollector2);
            if (moduleChunk3 == null) {
                CompileEnvironmentUtil.$$$reportNull$$$0(1);
            }
            if (moduleChunk3 == null) {
                CompileEnvironmentUtil.$$$reportNull$$$1(1);
            }
            if (moduleChunk3 == null) {
                CompileEnvironmentUtil.$$$reportNull$$$2(1);
            }
            if (moduleChunk3 == null) {
                CompileEnvironmentUtil.$$$reportNull$$$3(1);
            }
            if (moduleChunk3 == null) {
                CompileEnvironmentUtil.$$$reportNull$$$4(1);
            }
            if (moduleChunk3 == null) {
                CompileEnvironmentUtil.$$$reportNull$$$5(1);
            }
            return moduleChunk3;
        }
        messageCollector2.report(CompilerMessageSeverity.ERROR, "Unknown module definition type: " + buildFile, null);
        ModuleChunk moduleChunk4 = ModuleChunk.EMPTY;
        if (moduleChunk4 == null) {
            CompileEnvironmentUtil.$$$reportNull$$$0(2);
        }
        if (moduleChunk4 == null) {
            CompileEnvironmentUtil.$$$reportNull$$$1(2);
        }
        if (moduleChunk4 == null) {
            CompileEnvironmentUtil.$$$reportNull$$$2(2);
        }
        if (moduleChunk4 == null) {
            CompileEnvironmentUtil.$$$reportNull$$$3(2);
        }
        if (moduleChunk4 == null) {
            CompileEnvironmentUtil.$$$reportNull$$$4(2);
        }
        if (moduleChunk4 == null) {
            CompileEnvironmentUtil.$$$reportNull$$$5(2);
        }
        return moduleChunk4;
    }

    private static void doWriteToJar(OutputFileCollection outputFiles, OutputStream fos, @Nullable FqName mainClass, boolean includeRuntime) {
        try {
            Manifest manifest2 = new Manifest();
            Attributes mainAttributes = manifest2.getMainAttributes();
            mainAttributes.putValue("Manifest-Version", "1.0");
            mainAttributes.putValue("Created-By", "JetBrains Kotlin");
            if (mainClass != null) {
                mainAttributes.putValue("Main-Class", mainClass.asString());
            }
            JarOutputStream stream = new JarOutputStream(fos, manifest2);
            for (OutputFile outputFile : outputFiles.asList()) {
                stream.putNextEntry(new JarEntry(outputFile.getRelativePath()));
                stream.write(outputFile.asByteArray());
            }
            if (includeRuntime) {
                CompileEnvironmentUtil.writeRuntimeToJar(stream);
            }
            stream.finish();
        }
        catch (IOException e) {
            throw new CompileEnvironmentException("Failed to generate jar file", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeToJar(File jarPath, boolean jarRuntime, FqName mainClass, OutputFileCollection outputFiles) {
        FileOutputStream outputStream2 = null;
        try {
            outputStream2 = new FileOutputStream(jarPath);
            CompileEnvironmentUtil.doWriteToJar(outputFiles, outputStream2, mainClass, jarRuntime);
            outputStream2.close();
        }
        catch (FileNotFoundException e) {
            try {
                throw new CompileEnvironmentException("Invalid jar path " + jarPath, e);
                catch (IOException e2) {
                    throw ExceptionUtilsKt.rethrow(e2);
                }
            }
            catch (Throwable throwable) {
                ExceptionUtilsKt.closeQuietly(outputStream2);
                throw throwable;
            }
        }
        ExceptionUtilsKt.closeQuietly(outputStream2);
    }

    private static void writeRuntimeToJar(JarOutputStream stream) throws IOException {
        File stdlibPath = PathUtil.getKotlinPathsForCompiler().getStdlibPath();
        if (!stdlibPath.exists()) {
            throw new CompileEnvironmentException("Couldn't find kotlin-stdlib at " + stdlibPath);
        }
        CompileEnvironmentUtil.copyJarImpl(stream, stdlibPath);
    }

    private static void copyJarImpl(JarOutputStream stream, File jarPath) throws IOException {
        try (JarInputStream jis = new JarInputStream(new FileInputStream(jarPath));){
            JarEntry e;
            while ((e = jis.getNextJarEntry()) != null) {
                if (!FileUtilRt.extensionEquals((String)e.getName(), (String)"class")) continue;
                stream.putNextEntry(e);
                FileUtil.copy((InputStream)jis, (OutputStream)stream);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "loadModuleChunk"));
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "loadModuleChunk"));
    }

    private static /* synthetic */ void $$$reportNull$$$2(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "loadModuleChunk"));
    }

    private static /* synthetic */ void $$$reportNull$$$3(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "loadModuleChunk"));
    }

    private static /* synthetic */ void $$$reportNull$$$4(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "loadModuleChunk"));
    }

    private static /* synthetic */ void $$$reportNull$$$5(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "loadModuleChunk"));
    }
}

