/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.general;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectScope;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.general.ModuleWrapperTranslation$WhenMappings;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J,\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J,\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J<\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J4\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J4\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/js/translate/general/ModuleWrapperTranslation;", "", "()V", "addModuleValidation", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "currentModuleId", "", "program", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;", "module", "Lorg/jetbrains/kotlin/js/backend/ast/JsImportedModule;", "makePlainInvocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "moduleId", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "importedModules", "", "makePlainModuleRef", "wrapAmd", "wrapCommonJs", "wrapIfNecessary", "kind", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "wrapPlain", "wrapUmd", "js.translator"})
public final class ModuleWrapperTranslation {
    public static final ModuleWrapperTranslation INSTANCE;

    @JvmStatic
    @NotNull
    public static final List<JsStatement> wrapIfNecessary(@NotNull String moduleId, @NotNull JsExpression function2, @NotNull List<JsImportedModule> importedModules, @NotNull JsProgram program, @NotNull ModuleKind kind) {
        List<JsStatement> list2;
        Intrinsics.checkParameterIsNotNull((Object)moduleId, (String)"moduleId");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull(importedModules, (String)"importedModules");
        Intrinsics.checkParameterIsNotNull((Object)program, (String)"program");
        Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
        switch (ModuleWrapperTranslation$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                list2 = INSTANCE.wrapAmd(function2, importedModules, program);
                break;
            }
            case 2: {
                list2 = INSTANCE.wrapCommonJs(function2, importedModules, program);
                break;
            }
            case 3: {
                list2 = INSTANCE.wrapUmd(moduleId, function2, importedModules, program);
                break;
            }
            case 4: {
                list2 = INSTANCE.wrapPlain(moduleId, function2, importedModules, program);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list2;
    }

    private final List<JsStatement> wrapUmd(String moduleId, JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        JsObjectScope scope2 = program.getScope();
        JsName jsName = scope2.declareName("define");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"scope.declareName(\"define\")");
        JsName defineName = jsName;
        JsName jsName2 = scope2.declareName("exports");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName2, (String)"scope.declareName(\"exports\")");
        JsName exportsName = jsName2;
        JsBlock adapterBody = new JsBlock();
        JsFunction adapter = new JsFunction((JsScope)program.getScope(), adapterBody, "Adapter");
        JsName jsName3 = adapter.getScope().declareName("root");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName3, (String)"adapter.scope.declareName(\"root\")");
        JsName rootName = jsName3;
        JsName jsName4 = adapter.getScope().declareName("factory");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName4, (String)"adapter.scope.declareName(\"factory\")");
        JsName factoryName = jsName4;
        Collection collection = adapter.getParameters();
        JsParameter jsParameter = new JsParameter(rootName);
        boolean bl = false;
        collection.add(jsParameter);
        collection = adapter.getParameters();
        jsParameter = new JsParameter(factoryName);
        bl = false;
        collection.add(jsParameter);
        JsBinaryOperation jsBinaryOperation = JsAstUtils.and(JsAstUtils.typeOfIs(defineName.makeRef(), new JsStringLiteral("function")), new JsNameRef("amd", (JsExpression)defineName.makeRef()));
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBinaryOperation, (String)"JsAstUtils.and(JsAstUtil\u2026\", defineName.makeRef()))");
        JsBinaryOperation amdTest = jsBinaryOperation;
        JsBinaryOperation jsBinaryOperation2 = JsAstUtils.typeOfIs(exportsName.makeRef(), new JsStringLiteral("object"));
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBinaryOperation2, (String)"JsAstUtils.typeOfIs(expo\u2026sStringLiteral(\"object\"))");
        JsBinaryOperation commonJsTest = jsBinaryOperation2;
        JsNameRef jsNameRef = factoryName.makeRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"factoryName.makeRef()");
        JsBlock amdBody = new JsBlock(this.wrapAmd(jsNameRef, importedModules, program));
        JsNameRef jsNameRef2 = factoryName.makeRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef2, (String)"factoryName.makeRef()");
        JsBlock commonJsBody = new JsBlock(this.wrapCommonJs(jsNameRef2, importedModules, program));
        JsNameRef jsNameRef3 = factoryName.makeRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef3, (String)"factoryName.makeRef()");
        JsInvocation plainInvocation = this.makePlainInvocation(moduleId, jsNameRef3, importedModules, program);
        JsExpression lhs = Namer.requiresEscaping(moduleId) ? (JsExpression)new JsArrayAccess(rootName.makeRef(), new JsStringLiteral(moduleId)) : (JsExpression)new JsNameRef(scope2.declareName(moduleId), (JsExpression)rootName.makeRef());
        JsBlock plainBlock = new JsBlock();
        for (JsImportedModule jsImportedModule : importedModules) {
            Collection collection2 = plainBlock.getStatements();
            JsStatement jsStatement = this.addModuleValidation(moduleId, program, jsImportedModule);
            boolean bl2 = false;
            collection2.add(jsStatement);
        }
        Collection collection3 = plainBlock.getStatements();
        Object object = JsAstUtils.assignment(lhs, plainInvocation).makeStmt();
        boolean bl3 = false;
        collection3.add(object);
        JsIf jsIf = JsAstUtils.newJsIf(amdTest, amdBody, JsAstUtils.newJsIf(commonJsTest, commonJsBody, plainBlock));
        Intrinsics.checkExpressionValueIsNotNull((Object)jsIf, (String)"JsAstUtils.newJsIf(amdTe\u2026ommonJsBody, plainBlock))");
        JsIf jsIf2 = jsIf;
        object = adapterBody.getStatements();
        bl3 = false;
        object.add(jsIf2);
        return CollectionsKt.listOf((Object)new JsInvocation((JsExpression)adapter, new JsThisRef(), function2).makeStmt());
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsStatement> wrapAmd(JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        Collection<JsStringLiteral> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] objectArray;
        JsObjectScope scope2 = program.getScope();
        JsName jsName = scope2.declareName("define");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"scope.declareName(\"define\")");
        JsName defineName = jsName;
        Iterable iterable = importedModules;
        Collection collection2 = CollectionsKt.listOf((Object)new JsStringLiteral("exports"));
        int n = 0;
        Object[] objectArray2 = objectArray = new JsExpression[2];
        boolean $i$f$map = false;
        void var9_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsImportedModule jsImportedModule = (JsImportedModule)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JsStringLiteral jsStringLiteral = new JsStringLiteral(it.getExternalName());
            collection.add(jsStringLiteral);
        }
        collection = (List)destination$iv$iv;
        List list2 = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
        objectArray[n] = new JsArrayLiteral(list2);
        objectArray2[1] = function2;
        List invocationArgs = CollectionsKt.listOf((Object[])objectArray2);
        JsInvocation invocation = new JsInvocation((JsExpression)defineName.makeRef(), invocationArgs);
        return CollectionsKt.listOf((Object)invocation.makeStmt());
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsStatement> wrapCommonJs(JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        void $this$mapTo$iv$iv;
        JsObjectScope scope2 = program.getScope();
        JsName jsName = scope2.declareName("module");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"scope.declareName(\"module\")");
        JsName moduleName = jsName;
        JsName jsName2 = scope2.declareName("require");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName2, (String)"scope.declareName(\"require\")");
        JsName requireName = jsName2;
        Iterable $this$map$iv = importedModules;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsImportedModule jsImportedModule = (JsImportedModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsInvocation jsInvocation = new JsInvocation((JsExpression)requireName.makeRef(), new JsStringLiteral(it.getExternalName()));
            collection.add(jsInvocation);
        }
        List invocationArgs = (List)destination$iv$iv;
        JsInvocation invocation = new JsInvocation(function2, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)new JsNameRef("exports", (JsExpression)moduleName.makeRef())), (Iterable)invocationArgs));
        return CollectionsKt.listOf((Object)invocation.makeStmt());
    }

    private final List<JsStatement> wrapPlain(String moduleId, JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        JsInvocation invocation = this.makePlainInvocation(moduleId, function2, importedModules, program);
        boolean bl = false;
        List statements = new ArrayList();
        for (JsImportedModule importedModule : importedModules) {
            Collection collection = statements;
            JsStatement jsStatement = this.addModuleValidation(moduleId, program, importedModule);
            boolean bl2 = false;
            collection.add(jsStatement);
        }
        Collection collection = statements;
        JsStatement jsStatement = Namer.requiresEscaping(moduleId) ? JsAstUtils.assignment(this.makePlainModuleRef(moduleId, program), invocation).makeStmt() : (JsStatement)JsAstUtils.newVar(program.getRootScope().declareName(moduleId), invocation);
        boolean bl3 = false;
        collection.add(jsStatement);
        return statements;
    }

    private final JsStatement addModuleValidation(String currentModuleId, JsProgram program, JsImportedModule module2) {
        JsExpression moduleRef = this.makePlainModuleRef(module2, program);
        JsBinaryOperation jsBinaryOperation = JsAstUtils.typeOfIs(moduleRef, new JsStringLiteral("undefined"));
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBinaryOperation, (String)"JsAstUtils.typeOfIs(modu\u2026ringLiteral(\"undefined\"))");
        JsBinaryOperation moduleExistsCond = jsBinaryOperation;
        JsStringLiteral moduleNotFoundMessage = new JsStringLiteral("Error loading module '" + currentModuleId + "'. Its dependency '" + module2.getExternalName() + "' was not found. " + "Please, check whether '" + module2.getExternalName() + "' is loaded prior to '" + currentModuleId + "'.");
        JsThrow moduleNotFoundThrow = new JsThrow(new JsNew(new JsNameRef("Error"), CollectionsKt.listOf((Object)moduleNotFoundMessage)));
        return new JsIf(moduleExistsCond, new JsBlock((JsStatement)moduleNotFoundThrow));
    }

    /*
     * WARNING - void declaration
     */
    private final JsInvocation makePlainInvocation(String moduleId, JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = importedModules;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsImportedModule jsImportedModule = (JsImportedModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsExpression jsExpression = INSTANCE.makePlainModuleRef((JsImportedModule)it, program);
            collection.add(jsExpression);
        }
        List invocationArgs = (List)destination$iv$iv;
        JsExpression moduleRef = this.makePlainModuleRef(moduleId, program);
        JsBinaryOperation jsBinaryOperation = JsAstUtils.typeOfIs(moduleRef, new JsStringLiteral("undefined"));
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBinaryOperation, (String)"JsAstUtils.typeOfIs(modu\u2026ringLiteral(\"undefined\"))");
        JsBinaryOperation testModuleDefined = jsBinaryOperation;
        JsConditional selfArg = new JsConditional(testModuleDefined, new JsObjectLiteral(false), moduleRef.deepCopy());
        return new JsInvocation(function2, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)selfArg), (Iterable)invocationArgs));
    }

    private final JsExpression makePlainModuleRef(JsImportedModule module2, JsProgram program) {
        JsExpression jsExpression = module2.getPlainReference();
        if (jsExpression == null) {
            jsExpression = this.makePlainModuleRef(module2.getExternalName(), program);
        }
        return jsExpression;
    }

    private final JsExpression makePlainModuleRef(String moduleId, JsProgram program) {
        JsExpression jsExpression;
        if (Namer.requiresEscaping(moduleId)) {
            jsExpression = new JsArrayAccess(new JsThisRef(), new JsStringLiteral(moduleId));
        } else {
            JsNameRef jsNameRef = program.getScope().declareName(moduleId).makeRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"program.scope.declareName(moduleId).makeRef()");
            jsExpression = jsNameRef;
        }
        return jsExpression;
    }

    private ModuleWrapperTranslation() {
    }

    static {
        ModuleWrapperTranslation moduleWrapperTranslation;
        INSTANCE = moduleWrapperTranslation = new ModuleWrapperTranslation();
    }
}

