/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.serialization.JpsGlobalExtensionSerializer;
import org.jetbrains.jps.model.serialization.JpsLoaderBase;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsPathVariablesConfiguration;
import org.jetbrains.jps.model.serialization.impl.JpsPathVariablesConfigurationImpl;
import org.jetbrains.jps.model.serialization.library.JpsLibraryTableSerializer;
import org.jetbrains.jps.model.serialization.library.JpsSdkTableSerializer;

public class JpsGlobalLoader
extends JpsLoaderBase {
    private static final Logger LOG = Logger.getInstance(JpsGlobalLoader.class);
    public static final String SDK_TABLE_COMPONENT_NAME = "ProjectJdkTable";
    public static final JpsElementChildRole<JpsPathVariablesConfiguration> PATH_VARIABLES_ROLE = JpsElementChildRoleBase.create("path variables");
    private static final JpsGlobalExtensionSerializer[] SERIALIZERS = new JpsGlobalExtensionSerializer[]{new GlobalLibrariesSerializer(), new SdkTableSerializer(), new FileTypesSerializer()};
    private final JpsGlobal myGlobal;

    private JpsGlobalLoader(JpsGlobal global, Map<String, String> pathVariables) {
        super(new JpsMacroExpander(pathVariables));
        this.myGlobal = global;
    }

    public static void loadGlobalSettings(JpsGlobal global, String optionsPath) throws IOException {
        Path optionsDir = Paths.get(FileUtil.toCanonicalPath((String)optionsPath), new String[0]);
        Map<String, String> pathVariables = JpsGlobalLoader.loadPathVariables(global, optionsDir);
        new JpsGlobalLoader(global, pathVariables).load(optionsDir);
    }

    private static Map<String, String> loadPathVariables(JpsGlobal global, Path optionsDir) {
        new JpsGlobalLoader(global, Collections.emptyMap()).loadGlobalComponents(optionsDir, optionsDir.resolve("other.xml"), new PathVariablesSerializer());
        return JpsModelSerializationDataService.computeAllPathVariables(global);
    }

    public static Map<String, String> computeAllPathVariables(@NotNull String optionsPath) {
        if (optionsPath == null) {
            JpsGlobalLoader.$$$reportNull$$$0(0);
        }
        JpsModel model = JpsElementFactory.getInstance().createModel();
        Path optionsDir = Paths.get(FileUtil.toCanonicalPath((String)optionsPath), new String[0]);
        return JpsGlobalLoader.loadPathVariables(model.getGlobal(), optionsDir);
    }

    @Deprecated
    @Nullable
    public static String getPathVariable(JpsGlobal global, String name2) {
        return JpsModelSerializationDataService.getPathVariableValue(global, name2);
    }

    private void load(@NotNull Path optionsDir) {
        if (optionsDir == null) {
            JpsGlobalLoader.$$$reportNull$$$0(1);
        }
        Path defaultConfigFile = optionsDir.resolve("other.xml");
        LOG.debug("Loading config from " + optionsDir.toAbsolutePath());
        for (JpsGlobalExtensionSerializer jpsGlobalExtensionSerializer : SERIALIZERS) {
            this.loadGlobalComponents(optionsDir, defaultConfigFile, jpsGlobalExtensionSerializer);
        }
        for (JpsModelSerializerExtension extension2 : JpsModelSerializerExtension.getExtensions()) {
            for (JpsGlobalExtensionSerializer jpsGlobalExtensionSerializer : extension2.getGlobalExtensionSerializers()) {
                this.loadGlobalComponents(optionsDir, defaultConfigFile, jpsGlobalExtensionSerializer);
            }
        }
    }

    private void loadGlobalComponents(@NotNull Path optionsDir, @NotNull Path defaultConfigFile, JpsGlobalExtensionSerializer serializer2) {
        if (optionsDir == null) {
            JpsGlobalLoader.$$$reportNull$$$0(2);
        }
        if (defaultConfigFile == null) {
            JpsGlobalLoader.$$$reportNull$$$0(3);
        }
        this.loadComponents(optionsDir, defaultConfigFile.getParent(), serializer2, this.myGlobal);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsPath";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultConfigFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/model/serialization/JpsGlobalLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeAllPathVariables";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "load";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "loadGlobalComponents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FileTypesSerializer
    extends JpsGlobalExtensionSerializer {
        private FileTypesSerializer() {
            super("filetypes.xml", System.getProperty("jps.file.types.component.name", "FileTypeManager"));
        }

        @Override
        public void loadExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            Element ignoreFilesTag;
            if (global == null) {
                FileTypesSerializer.$$$reportNull$$$0(0);
            }
            if (componentTag == null) {
                FileTypesSerializer.$$$reportNull$$$0(1);
            }
            if ((ignoreFilesTag = componentTag.getChild("ignoreFiles")) != null) {
                global.getFileTypesConfiguration().setIgnoredPatternString(ignoreFilesTag.getAttributeValue("list"));
            }
        }

        @Override
        public void saveExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                FileTypesSerializer.$$$reportNull$$$0(2);
            }
            if (componentTag == null) {
                FileTypesSerializer.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "global";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentTag";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/model/serialization/JpsGlobalLoader$FileTypesSerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadExtension";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveExtension";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SdkTableSerializer
    extends JpsGlobalExtensionSerializer {
        public SdkTableSerializer() {
            super("jdk.table.xml", JpsGlobalLoader.SDK_TABLE_COMPONENT_NAME);
        }

        @Override
        public void loadExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                SdkTableSerializer.$$$reportNull$$$0(0);
            }
            if (componentTag == null) {
                SdkTableSerializer.$$$reportNull$$$0(1);
            }
            JpsSdkTableSerializer.loadSdks(componentTag, global.getLibraryCollection());
        }

        @Override
        public void saveExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                SdkTableSerializer.$$$reportNull$$$0(2);
            }
            if (componentTag == null) {
                SdkTableSerializer.$$$reportNull$$$0(3);
            }
            JpsSdkTableSerializer.saveSdks(global.getLibraryCollection(), componentTag);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "global";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentTag";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/model/serialization/JpsGlobalLoader$SdkTableSerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadExtension";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveExtension";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class GlobalLibrariesSerializer
    extends JpsGlobalExtensionSerializer {
        public GlobalLibrariesSerializer() {
            super("applicationLibraries.xml", "libraryTable");
        }

        @Override
        public void loadExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                GlobalLibrariesSerializer.$$$reportNull$$$0(0);
            }
            if (componentTag == null) {
                GlobalLibrariesSerializer.$$$reportNull$$$0(1);
            }
            JpsLibraryTableSerializer.loadLibraries(componentTag, global.getLibraryCollection());
        }

        @Override
        public void saveExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                GlobalLibrariesSerializer.$$$reportNull$$$0(2);
            }
            if (componentTag == null) {
                GlobalLibrariesSerializer.$$$reportNull$$$0(3);
            }
            JpsLibraryTableSerializer.saveLibraries(global.getLibraryCollection(), componentTag);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "global";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentTag";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/model/serialization/JpsGlobalLoader$GlobalLibrariesSerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadExtension";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveExtension";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PathVariablesSerializer
    extends JpsGlobalExtensionSerializer {
        public static final String MACRO_TAG = "macro";
        public static final String NAME_ATTRIBUTE = "name";
        public static final String VALUE_ATTRIBUTE = "value";
        public static final String STORAGE_FILE_NAME = "path.macros.xml";

        public PathVariablesSerializer() {
            super(STORAGE_FILE_NAME, "PathMacrosImpl");
        }

        @Override
        public void loadExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                PathVariablesSerializer.$$$reportNull$$$0(0);
            }
            if (componentTag == null) {
                PathVariablesSerializer.$$$reportNull$$$0(1);
            }
            JpsPathVariablesConfiguration configuration = global.getContainer().setChild(PATH_VARIABLES_ROLE, new JpsPathVariablesConfigurationImpl());
            for (Element macroTag : JDOMUtil.getChildren((Element)componentTag, (String)MACRO_TAG)) {
                String name2 = macroTag.getAttributeValue(NAME_ATTRIBUTE);
                String value2 = macroTag.getAttributeValue(VALUE_ATTRIBUTE);
                if (name2 == null || value2 == null) continue;
                configuration.addPathVariable(name2, StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)value2), (String)"/"));
            }
        }

        @Override
        public void saveExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            JpsPathVariablesConfiguration configuration;
            if (global == null) {
                PathVariablesSerializer.$$$reportNull$$$0(2);
            }
            if (componentTag == null) {
                PathVariablesSerializer.$$$reportNull$$$0(3);
            }
            if ((configuration = JpsModelSerializationDataService.getPathVariablesConfiguration(global)) != null) {
                for (Map.Entry<String, String> entry : configuration.getAllUserVariables().entrySet()) {
                    Element tag = new Element(MACRO_TAG);
                    tag.setAttribute(NAME_ATTRIBUTE, entry.getKey());
                    tag.setAttribute(VALUE_ATTRIBUTE, entry.getValue());
                    componentTag.addContent(tag);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "global";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentTag";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/model/serialization/JpsGlobalLoader$PathVariablesSerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadExtension";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveExtension";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

