/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocator;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrBuildersKt;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\f\u0010\u0017\u001a\u00020\t*\u00020\u000eH\u0002J\u0014\u0010\u0018\u001a\u00020\t*\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FakeInliningLocalVariablesLowering;", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineReferenceLocator;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitFunctionNew", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitInlineLambda", "argument", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "callee", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "scope", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "addFakeInliningLocalVariables", "addFakeLocalVariable", "name", "", "backend.jvm"})
public final class FakeInliningLocalVariablesLowering
extends IrInlineReferenceLocator
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementVisitorVoidKt.acceptVoid(irFile, this);
    }

    @Override
    public void visitFunctionNew(@NotNull IrFunction declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        IrElementVisitorVoidKt.acceptChildrenVoid(declaration2, this);
        if (declaration2.isInline() && !declaration2.getOrigin().isSynthetic() && declaration2.getBody() != null) {
            this.addFakeInliningLocalVariables(declaration2);
        }
    }

    @Override
    public void visitInlineLambda(@NotNull IrFunctionReference argument, @NotNull IrFunction callee, @NotNull IrValueParameter parameter, @NotNull IrDeclaration scope2) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        IrFunction lambda2 = ((IrFunctionSymbol)argument.getSymbol()).getOwner();
        if (Intrinsics.areEqual((Object)lambda2.getOrigin(), (Object)IrDeclarationOrigin.LOCAL_FUNCTION_FOR_LAMBDA.INSTANCE)) {
            String argumentToFunctionName = this.context.getMethodSignatureMapper().mapFunctionName(callee);
            Type type2 = this.context.getLocalClassType$backend_jvm(argument);
            Intrinsics.checkNotNull((Object)type2);
            String string2 = type2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getLocalClassType(argument)!!.internalName");
            String lambdaReferenceName = StringsKt.substringAfterLast$default((String)string2, (String)"/", null, (int)2, null);
            String localName = "$i$a$-" + argumentToFunctionName + '-' + lambdaReferenceName;
            this.addFakeLocalVariable(lambda2, localName);
        }
    }

    private final void addFakeInliningLocalVariables(IrFunction $this$addFakeInliningLocalVariables) {
        String currentFunctionName = this.context.getMethodSignatureMapper().mapFunctionName($this$addFakeInliningLocalVariables);
        String localName = "$i$f$" + currentFunctionName;
        this.addFakeLocalVariable($this$addFakeInliningLocalVariables, localName);
    }

    /*
     * WARNING - void declaration
     */
    private final void addFakeLocalVariable(IrFunction $this$addFakeLocalVariable, String name2) {
        void $this$irBlockBody;
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder$default(this.context, $this$addFakeLocalVariable.getSymbol(), 0, 0, 6, null);
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder $this$run = declarationIrBuilder;
        boolean bl3 = false;
        IrBuilderWithScope $this$irBlockBody$iv = $this$run;
        int startOffset$iv = $this$irBlockBody$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder this_$iv$iv = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = this_$iv$iv;
        IrFunction irFunction = $this$addFakeLocalVariable;
        boolean bl4 = false;
        IrBuildersKt.createTmpVariable$default((IrStatementsBuilder)$this$irBlockBody, (IrExpression)ExpressionHelpersKt.irInt((IrBuilderWithScope)$this$irBlockBody, 0), StringsKt.removeSuffix((String)name2, (CharSequence)"$$forInline"), false, (IrDeclarationOrigin)IrDeclarationOrigin.DEFINED.INSTANCE, null, 20, null);
        if ($this$addFakeLocalVariable.getBody() instanceof IrExpressionBody) {
            IrBody irBody = $this$addFakeLocalVariable.getBody();
            if (irBody == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpressionBody");
            }
            $this$irBlockBody.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$irBlockBody, ((IrExpressionBody)irBody).getExpression()));
        } else {
            IrBody irBody = $this$addFakeLocalVariable.getBody();
            if (irBody == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
            }
            Iterable $this$forEach$iv = ((IrBlockBody)irBody).getStatements();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrStatement it = (IrStatement)element$iv;
                boolean bl5 = false;
                $this$irBlockBody.unaryPlus(it);
            }
        }
        Unit unit = Unit.INSTANCE;
        irFunction.setBody(this_$iv$iv.doBuild());
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public FakeInliningLocalVariablesLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
        this.context = context2;
    }
}

