/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.deprecation;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirement;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByAnnotation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByOverridden;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByVersionRequirement;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedTypealiasByAnnotation;
import org.jetbrains.kotlin.resolve.deprecation.Deprecation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationUtilKt$WhenMappings;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u000b\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u000f*\u00020\u000b\u001a\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u0005*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000f\u00a8\u0006\u0013"}, d2={"computeLevelForDeprecatedSinceKotlin", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "createDeprecationDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "element", "Lcom/intellij/psi/PsiElement;", "deprecation", "Lorg/jetbrains/kotlin/resolve/deprecation/Deprecation;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "deprecatedByAnnotationReplaceWithExpression", "", "deprecatedByOverriddenMessage", "getSinceVersion", "name", "frontend"})
public final class DeprecationUtilKt {
    @Nullable
    public static final String deprecatedByOverriddenMessage(@NotNull Deprecation $this$deprecatedByOverriddenMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$deprecatedByOverriddenMessage, (String)"$this$deprecatedByOverriddenMessage");
        Deprecation deprecation = $this$deprecatedByOverriddenMessage;
        if (!(deprecation instanceof DeprecatedByOverridden)) {
            deprecation = null;
        }
        DeprecatedByOverridden deprecatedByOverridden = (DeprecatedByOverridden)deprecation;
        return deprecatedByOverridden != null ? deprecatedByOverridden.additionalMessage$frontend() : null;
    }

    @Nullable
    public static final String deprecatedByAnnotationReplaceWithExpression(@NotNull Deprecation $this$deprecatedByAnnotationReplaceWithExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$deprecatedByAnnotationReplaceWithExpression, (String)"$this$deprecatedByAnnotationReplaceWithExpression");
        Deprecation deprecation = $this$deprecatedByAnnotationReplaceWithExpression;
        if (!(deprecation instanceof DeprecatedByAnnotation)) {
            deprecation = null;
        }
        DeprecatedByAnnotation deprecatedByAnnotation = (DeprecatedByAnnotation)deprecation;
        return deprecatedByAnnotation != null ? deprecatedByAnnotation.getReplaceWithValue$frontend() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final ApiVersion getSinceVersion(@NotNull AnnotationDescriptor $this$getSinceVersion, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)$this$getSinceVersion, (String)"$this$getSinceVersion");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        StringValue stringValue = AnnotationUtilKt.argumentValue($this$getSinceVersion, name2);
        Object object = stringValue;
        if (stringValue == null) return null;
        StringValue $this$safeAs$iv = object;
        boolean $i$f$safeAs = false;
        StringValue stringValue2 = $this$safeAs$iv;
        if (!(stringValue2 instanceof StringValue)) {
            stringValue2 = null;
        }
        StringValue stringValue3 = stringValue2;
        object = stringValue3;
        if (stringValue3 == null) return null;
        String string2 = (String)((ConstantValue)object).getValue();
        object = string2;
        if (string2 == null) return null;
        Object object2 = object;
        boolean bl = false;
        boolean bl2 = false;
        Object p1 = object2;
        boolean bl3 = false;
        CharSequence charSequence = (CharSequence)p1;
        boolean bl4 = false;
        if (charSequence.length() == 0) {
            return null;
        }
        boolean bl5 = false;
        if (bl5) return null;
        Object object3 = object2;
        object = object3;
        if (object3 == null) return null;
        object2 = object;
        ApiVersion.Companion companion = ApiVersion.Companion;
        bl2 = false;
        boolean bl6 = false;
        Object p12 = object2;
        boolean bl7 = false;
        ApiVersion apiVersion = companion.parse((String)p12);
        return apiVersion;
    }

    @Nullable
    public static final DeprecationLevelValue computeLevelForDeprecatedSinceKotlin(@NotNull AnnotationDescriptor annotation2, @NotNull ApiVersion apiVersion) {
        Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        ApiVersion hiddenSince = DeprecationUtilKt.getSinceVersion(annotation2, "hiddenSince");
        if (hiddenSince != null && apiVersion.compareTo(hiddenSince) >= 0) {
            return DeprecationLevelValue.HIDDEN;
        }
        ApiVersion errorSince = DeprecationUtilKt.getSinceVersion(annotation2, "errorSince");
        if (errorSince != null && apiVersion.compareTo(errorSince) >= 0) {
            return DeprecationLevelValue.ERROR;
        }
        ApiVersion warningSince = DeprecationUtilKt.getSinceVersion(annotation2, "warningSince");
        if (warningSince != null && apiVersion.compareTo(warningSince) >= 0) {
            return DeprecationLevelValue.WARNING;
        }
        return null;
    }

    @NotNull
    public static final Diagnostic createDeprecationDiagnostic(@NotNull PsiElement element, @NotNull Deprecation deprecation, @NotNull LanguageVersionSettings languageVersionSettings) {
        ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)deprecation, (String)"deprecation");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        DeclarationDescriptor declarationDescriptor = deprecation.getTarget().getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"deprecation.target.original");
        DeclarationDescriptor targetOriginal = declarationDescriptor;
        Deprecation deprecation2 = deprecation;
        if (deprecation2 instanceof DeprecatedByVersionRequirement) {
            DiagnosticFactory3<PsiElement, DeclarationDescriptor, VersionRequirement.Version, Pair<LanguageVersion, String>> diagnosticFactory3;
            switch (DeprecationUtilKt$WhenMappings.$EnumSwitchMapping$0[deprecation.getDeprecationLevel().ordinal()]) {
                case 1: {
                    diagnosticFactory3 = Errors.VERSION_REQUIREMENT_DEPRECATION;
                    break;
                }
                case 2: 
                case 3: {
                    diagnosticFactory3 = Errors.VERSION_REQUIREMENT_DEPRECATION_ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DiagnosticFactory3<PsiElement, DeclarationDescriptor, VersionRequirement.Version, Pair<LanguageVersion, String>> factory2 = diagnosticFactory3;
            parametrizedDiagnostic = factory2.on(element, targetOriginal, ((DeprecatedByVersionRequirement)deprecation).getVersionRequirement().getVersion(), (Pair<LanguageVersion, String>)TuplesKt.to((Object)languageVersionSettings.getLanguageVersion(), (Object)deprecation.getMessage()));
        } else if (deprecation2 instanceof DeprecatedTypealiasByAnnotation) {
            DiagnosticFactory3<PsiElement, TypeAliasDescriptor, DeclarationDescriptor, String> diagnosticFactory3;
            switch (DeprecationUtilKt$WhenMappings.$EnumSwitchMapping$1[deprecation.getDeprecationLevel().ordinal()]) {
                case 1: {
                    diagnosticFactory3 = Errors.TYPEALIAS_EXPANSION_DEPRECATION;
                    break;
                }
                case 2: 
                case 3: {
                    diagnosticFactory3 = Errors.TYPEALIAS_EXPANSION_DEPRECATION_ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DiagnosticFactory3<PsiElement, TypeAliasDescriptor, DeclarationDescriptor, String> factory3 = diagnosticFactory3;
            TypeAliasDescriptor typeAliasDescriptor = ((DeprecatedTypealiasByAnnotation)deprecation).getTypeAliasTarget().getOriginal();
            DeclarationDescriptor declarationDescriptor2 = ((DeprecatedTypealiasByAnnotation)deprecation).getNested().getTarget().getOriginal();
            String string2 = ((DeprecatedTypealiasByAnnotation)deprecation).getNested().getMessage();
            if (string2 == null) {
                string2 = "";
            }
            parametrizedDiagnostic = factory3.on(element, typeAliasDescriptor, declarationDescriptor2, string2);
        } else {
            DiagnosticFactory2<PsiElement, DeclarationDescriptor, String> diagnosticFactory2;
            switch (DeprecationUtilKt$WhenMappings.$EnumSwitchMapping$2[deprecation.getDeprecationLevel().ordinal()]) {
                case 1: {
                    diagnosticFactory2 = Errors.DEPRECATION;
                    break;
                }
                case 2: 
                case 3: {
                    diagnosticFactory2 = Errors.DEPRECATION_ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DiagnosticFactory2<PsiElement, DeclarationDescriptor, String> factory4 = diagnosticFactory2;
            String string3 = deprecation.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            parametrizedDiagnostic = factory4.on(element, targetOriginal, string3);
        }
        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"when (deprecation) {\n   \u2026ge ?: \"\")\n        }\n    }");
        return parametrizedDiagnostic;
    }
}

