/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.host;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ExternalSourceCode;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.script.experimental.api.ScriptSourceNamedFragment;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.host.FileScriptSource;
import kotlin.script.experimental.host.StringScriptSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u001a\n\u0010\n\u001a\u00020\u0007*\u00020\u000b\u001a\u0016\u0010\n\u001a\u00020\u0007*\u00020\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0001\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\r"}, d2={"textSafe", "", "Lkotlin/script/experimental/api/ExternalSourceCode;", "getTextSafe", "(Lkotlin/script/experimental/api/ExternalSourceCode;)Ljava/lang/String;", "getMergedScriptText", "script", "Lkotlin/script/experimental/api/SourceCode;", "configuration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "toScriptSource", "Ljava/io/File;", "name", "kotlin-scripting-common"})
public final class ScriptHostUtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getMergedScriptText(@NotNull SourceCode script, @Nullable ScriptCompilationConfiguration configuration) {
        String string2;
        List<ScriptSourceNamedFragment> sourceFragments;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        String originalScriptText = script.getText();
        ScriptCompilationConfiguration scriptCompilationConfiguration2 = configuration;
        List<ScriptSourceNamedFragment> list2 = sourceFragments = scriptCompilationConfiguration2 != null ? scriptCompilationConfiguration2.get(ScriptCompilationKt.getSourceFragments(ScriptCompilationConfiguration.Companion)) : null;
        if (sourceFragments == null || sourceFragments.isEmpty()) {
            string2 = originalScriptText;
        } else {
            StringBuilder sb = new StringBuilder(originalScriptText.length());
            ScriptSourceNamedFragment prevFragment = null;
            for (ScriptSourceNamedFragment fragment : sourceFragments) {
                int curPos;
                int n;
                Integer fragmentStartPos = fragment.getRange().getStart().getAbsolutePos();
                Integer fragmentEndPos = fragment.getRange().getEnd().getAbsolutePos();
                if (fragmentStartPos == null || fragmentEndPos == null) {
                    throw (Throwable)new RuntimeException("Script fragments require absolute positions (received: " + fragment + ')');
                }
                if (prevFragment == null) {
                    n = 0;
                } else {
                    Integer n2 = prevFragment.getRange().getEnd().getAbsolutePos();
                    Intrinsics.checkNotNull((Object)n2);
                    n = curPos = n2.intValue();
                }
                if (prevFragment != null) {
                    Integer n3 = prevFragment.getRange().getEnd().getAbsolutePos();
                    Intrinsics.checkNotNull((Object)n3);
                    if (n3 > fragmentStartPos) {
                        throw (Throwable)new RuntimeException("Unsorted or overlapping fragments: previous: " + prevFragment + ", current: " + fragment);
                    }
                }
                if (curPos < fragmentStartPos) {
                    Collection<Character> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    CharSequence charSequence = originalScriptText.subSequence(curPos, fragmentStartPos);
                    StringBuilder stringBuilder2 = sb;
                    boolean $i$f$map = false;
                    void var13_13 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.length());
                    boolean $i$f$mapTo = false;
                    void var16_16 = $this$mapTo$iv$iv;
                    for (int i = 0; i < var16_16.length(); ++i) {
                        int it;
                        char item$iv$iv;
                        char c = item$iv$iv = var16_16.charAt(i);
                        collection = destination$iv$iv;
                        boolean bl = false;
                        Character c2 = Character.valueOf((char)(it == 13 || it == 10 ? it : 32));
                        collection.add(c2);
                    }
                    collection = (List)destination$iv$iv;
                    stringBuilder2.append(collection);
                }
                sb.append(originalScriptText.subSequence(fragmentStartPos, fragmentEndPos));
                prevFragment = fragment;
            }
            String string3 = sb.toString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sb.toString()");
        }
        return string2;
    }

    @NotNull
    public static final SourceCode toScriptSource(@NotNull File $this$toScriptSource) {
        Intrinsics.checkNotNullParameter((Object)$this$toScriptSource, (String)"$this$toScriptSource");
        return new FileScriptSource($this$toScriptSource, null, 2, null);
    }

    @NotNull
    public static final SourceCode toScriptSource(@NotNull String $this$toScriptSource, @Nullable String name2) {
        Intrinsics.checkNotNullParameter((Object)$this$toScriptSource, (String)"$this$toScriptSource");
        return new StringScriptSource($this$toScriptSource, name2);
    }

    public static /* synthetic */ SourceCode toScriptSource$default(String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string3 = null;
        }
        return ScriptHostUtilKt.toScriptSource(string2, string3);
    }

    private static final String getTextSafe(ExternalSourceCode $this$textSafe) {
        String string2;
        try {
            string2 = $this$textSafe.getText();
        }
        catch (Throwable e) {
            string2 = null;
        }
        return string2;
    }

    public static final /* synthetic */ String access$getTextSafe$p(ExternalSourceCode $this$access_u24textSafe_u24p) {
        return ScriptHostUtilKt.getTextSafe($this$access_u24textSafe_u24p);
    }
}

