/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.incremental.ICReporter;
import org.jetbrains.kotlin.incremental.snapshots.FileSnapshotMap;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.incremental.storage.SourceToOutputFilesMap;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0014\u0010\u0012\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/incremental/InputsCache;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "workingDir", "Ljava/io/File;", "reporter", "Lorg/jetbrains/kotlin/incremental/ICReporter;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/ICReporter;)V", "sourceSnapshotMap", "Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotMap;", "getSourceSnapshotMap$incremental_compilation_impl", "()Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotMap;", "sourceToOutputMap", "Lorg/jetbrains/kotlin/incremental/storage/SourceToOutputFilesMap;", "registerOutputForSourceFiles", "", "generatedFiles", "", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "removeOutputForSourceFiles", "sources", "", "Companion", "incremental-compilation-impl"})
public final class InputsCache
extends BasicMapsOwner {
    @NotNull
    private final FileSnapshotMap sourceSnapshotMap;
    private final SourceToOutputFilesMap sourceToOutputMap;
    private final ICReporter reporter;
    private static final String SOURCE_SNAPSHOTS = "source-snapshot";
    private static final String SOURCE_TO_OUTPUT_FILES = "source-to-output";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final FileSnapshotMap getSourceSnapshotMap$incremental_compilation_impl() {
        return this.sourceSnapshotMap;
    }

    public final void removeOutputForSourceFiles(@NotNull Iterable<? extends File> sources) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        for (File file2 : sources) {
            Iterable $this$forEach$iv = this.sourceToOutputMap.remove(file2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                this.reporter.reportVerbose((Function0<String>)((Function0)new Function0<String>(it, this, file2){
                    final /* synthetic */ File $it;
                    final /* synthetic */ InputsCache this$0;
                    final /* synthetic */ File $sourceFile$inlined;
                    {
                        this.$it = file2;
                        this.this$0 = inputsCache;
                        this.$sourceFile$inlined = file3;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Deleting " + this.$it + " on clearing cache for " + this.$sourceFile$inlined;
                    }
                }));
                it.delete();
            }
        }
    }

    public final void registerOutputForSourceFiles(@NotNull List<? extends GeneratedFile> generatedFiles) {
        Intrinsics.checkNotNullParameter(generatedFiles, (String)"generatedFiles");
        MultiMap sourceToOutput = new MultiMap();
        for (GeneratedFile entry : generatedFiles) {
            for (File source : entry.getSourceFiles()) {
                sourceToOutput.putValue((Object)source, (Object)entry.getOutputFile());
            }
        }
        Iterator<GeneratedFile> iterator2 = sourceToOutput.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            File source;
            Map.Entry entry2 = entry = (Map.Entry)((Object)iterator2.next());
            boolean bl = false;
            source = (File)entry2.getKey();
            entry2 = entry;
            bl = false;
            Collection outputs = (Collection)entry2.getValue();
            File file2 = source;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"source");
            Collection collection = outputs;
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"outputs");
            this.sourceToOutputMap.set(file2, collection);
        }
    }

    public InputsCache(@NotNull File workingDir, @NotNull ICReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        super(workingDir);
        this.reporter = reporter2;
        this.sourceSnapshotMap = (FileSnapshotMap)this.registerMap((BasicMap)new FileSnapshotMap(this.getStorageFile(SOURCE_SNAPSHOTS)));
        this.sourceToOutputMap = (SourceToOutputFilesMap)this.registerMap((BasicMap)new SourceToOutputFilesMap(this.getStorageFile(SOURCE_TO_OUTPUT_FILES)));
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/incremental/InputsCache$Companion;", "", "()V", "SOURCE_SNAPSHOTS", "", "SOURCE_TO_OUTPUT_FILES", "incremental-compilation-impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

