/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.export.ErrorDeclaration;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGenerator$WhenMappings;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.export.Exportability;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedClass;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedConstructor;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedDeclaration;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedFunction;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedModule;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedNamespace;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedParameter;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedProperty;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedType;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6AddInternalParametersToConstructorPhase;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunctionKt;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0)2\u0006\u0010*\u001a\u00020+H\u0002J\f\u0010,\u001a\u00020-*\u00020.H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/export/ExportModelGenerator;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "classExportability", "Lorg/jetbrains/kotlin/ir/backend/js/export/Exportability;", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "exportClass", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedClass;", "exportConstructor", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedDeclaration;", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "exportDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "exportFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "exportParameter", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedParameter;", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "exportProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "exportType", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedType;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "exportTypeArgument", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "functionExportability", "generateExport", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedModule;", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "getExportedIdentifier", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "backend.js"})
public final class ExportModelGenerator {
    @NotNull
    private final JsIrBackendContext context;

    /*
     * WARNING - void declaration
     */
    private final List<ExportedDeclaration> generateExport(IrPackageFragment file2) {
        List list2;
        void $this$flatMapTo$iv$iv;
        FqName namespaceFqName = file2.getFqName();
        Iterable $this$flatMap$iv = file2.getDeclarations();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrDeclaration declaration2 = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = kotlin.collections.CollectionsKt.listOfNotNull((Object)this.exportDeclaration(declaration2));
            kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List exports = (List)destination$iv$iv;
        if (exports.isEmpty()) {
            list2 = kotlin.collections.CollectionsKt.emptyList();
        } else if (namespaceFqName.isRoot()) {
            list2 = exports;
        } else {
            String string2 = namespaceFqName.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"namespaceFqName.toString()");
            list2 = kotlin.collections.CollectionsKt.listOf((Object)new ExportedNamespace(string2, exports));
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExportedModule generateExport(@NotNull IrModuleFragment module2) {
        List list2;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        String string2 = this.context.getConfiguration().get(CommonConfigurationKeys.MODULE_NAME);
        Intrinsics.checkNotNull((Object)string2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.configuration[Co\u2026rationKeys.MODULE_NAME]!!");
        ModuleKind moduleKind = this.context.getConfiguration().get(JSConfigurationKeys.MODULE_KIND);
        Intrinsics.checkNotNull((Object)((Object)moduleKind));
        Intrinsics.checkNotNullExpressionValue((Object)((Object)moduleKind), (String)"context.configuration[JS\u2026rationKeys.MODULE_KIND]!!");
        Iterable iterable = kotlin.collections.CollectionsKt.plus(this.context.getExternalPackageFragment().values(), (Iterable)module2.getFiles());
        ModuleKind moduleKind2 = moduleKind;
        String string3 = string2;
        boolean $i$f$flatMap = false;
        void var4_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrFile it = (IrFile)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.generateExport(it);
            kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list3 = list2 = (List)destination$iv$iv;
        ModuleKind moduleKind3 = moduleKind2;
        String string4 = string3;
        return new ExportedModule(string4, moduleKind3, list3);
    }

    private final ExportedDeclaration exportDeclaration(IrDeclaration declaration2) {
        ExportedDeclaration exportedDeclaration;
        IrDeclarationWithName irDeclarationWithName = ExportModelGeneratorKt.access$getExportCandidate(declaration2);
        if (irDeclarationWithName == null) {
            return null;
        }
        IrDeclarationWithName candidate2 = irDeclarationWithName;
        if (!ExportModelGeneratorKt.access$shouldDeclarationBeExported(candidate2, this.context)) {
            return null;
        }
        IrDeclarationWithName irDeclarationWithName2 = candidate2;
        if (irDeclarationWithName2 instanceof IrSimpleFunction) {
            exportedDeclaration = this.exportFunction((IrSimpleFunction)candidate2);
        } else if (irDeclarationWithName2 instanceof IrProperty) {
            exportedDeclaration = this.exportProperty((IrProperty)candidate2);
        } else if (irDeclarationWithName2 instanceof IrClass) {
            exportedDeclaration = this.exportClass((IrClass)candidate2);
        } else if (irDeclarationWithName2 instanceof IrField) {
            exportedDeclaration = null;
        } else {
            String string2 = "Can't export declaration " + candidate2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return exportedDeclaration;
    }

    private final ExportedDeclaration exportFunction(IrSimpleFunction function2) {
        ExportedDeclaration exportedDeclaration;
        Exportability exportability = this.functionExportability(function2);
        if (exportability instanceof Exportability.NotNeeded) {
            exportedDeclaration = null;
        } else if (exportability instanceof Exportability.Prohibited) {
            exportedDeclaration = new ErrorDeclaration(((Exportability.Prohibited)exportability).getReason());
        } else if (exportability instanceof Exportability.Allowed) {
            Object object;
            IrTypeParameter it;
            Collection<ExportedParameter> collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            IrDeclarationParent parent2 = function2.getParent();
            Iterable iterable = kotlin.collections.CollectionsKt.plus((Collection)kotlin.collections.CollectionsKt.listOfNotNull((Object)function2.getExtensionReceiverParameter()), (Iterable)function2.getValueParameters());
            ExportedType exportedType = this.exportType(function2.getReturnType());
            String string2 = this.getExportedIdentifier(function2);
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                object = this.exportParameter((IrValueParameter)((Object)it));
                collection.add((ExportedParameter)object);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = function2.getTypeParameters();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string3;
                it = (IrTypeParameter)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getName().getIdentifier(), (String)"it.name.identifier");
                object.add(string3);
            }
            object = (List)destination$iv$iv;
            IrSimpleFunction irSimpleFunction = function2;
            boolean bl = parent2 instanceof IrClass && !IrUtilsKt.isInterface((IrClass)parent2) && function2.getModality() == Modality.ABSTRACT;
            boolean bl2 = IrFunctionKt.isStaticMethodOfClass(function2);
            boolean bl3 = parent2 instanceof IrClass;
            Object object2 = object;
            Collection<ExportedParameter> collection2 = collection;
            ExportedType exportedType2 = exportedType;
            String string4 = string2;
            exportedDeclaration = new ExportedFunction(string4, exportedType2, (List<ExportedParameter>)collection2, (List<String>)object2, bl3, bl2, bl, irSimpleFunction);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return exportedDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportConstructor(IrConstructor constructor) {
        Collection<ExportedParameter> collection;
        void $this$mapTo$iv$iv;
        IrValueParameter it;
        Iterable $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        if (!constructor.isPrimary()) {
            return null;
        }
        Iterable iterable = constructor.getValueParameters();
        Collection collection2 = kotlin.collections.CollectionsKt.listOfNotNull((Object)constructor.getExtensionReceiverParameter());
        boolean $i$f$filterNot = false;
        void var5_5 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (IrValueParameter)element$iv$iv;
            boolean bl = false;
            if (it.getOrigin() == ES6AddInternalParametersToConstructorPhase.ES6_RESULT_TYPE_PARAMETER.INSTANCE || it.getOrigin() == ES6AddInternalParametersToConstructorPhase.ES6_INIT_BOX_PARAMETER.INSTANCE) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        List allValueParameters = kotlin.collections.CollectionsKt.plus((Collection)collection2, (Iterable)list2);
        Iterable $this$map$iv = allValueParameters;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ExportedParameter exportedParameter = this.exportParameter(it);
            collection.add(exportedParameter);
        }
        collection = (List)destination$iv$iv;
        List list3 = collection;
        return new ExportedConstructor(list3);
    }

    private final ExportedParameter exportParameter(IrValueParameter parameter) {
        String string2 = parameter.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parameter.name.asString()");
        String parameterName = NameTablesKt.sanitizeName(string2);
        if (ExportModelGeneratorKt.access$getAllReservedWords$p().contains(parameterName)) {
            parameterName = '_' + parameterName;
        }
        return new ExportedParameter(parameterName, this.exportType(parameter.getType()));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ExportedDeclaration exportProperty(IrProperty property2) {
        boolean bl;
        for (IrSimpleFunction accessor : kotlin.collections.CollectionsKt.listOfNotNull((Object[])new IrSimpleFunction[]{property2.getGetter(), property2.getSetter()})) {
            if (accessor.getExtensionReceiverParameter() != null) {
                return null;
            }
            if (!accessor.isFakeOverride()) continue;
            return null;
        }
        IrDeclarationParent irDeclarationParent = property2.getParent();
        if (!(irDeclarationParent instanceof IrClass)) {
            irDeclarationParent = null;
        }
        IrClass parentClass = (IrClass)irDeclarationParent;
        String string2 = this.getExportedIdentifier(property2);
        IrSimpleFunction irSimpleFunction = property2.getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        ExportedType exportedType = this.exportType(irSimpleFunction.getReturnType());
        boolean bl2 = property2.isVar();
        boolean bl3 = parentClass != null;
        IrClass irClass2 = parentClass;
        if (irClass2 != null && !IrUtilsKt.isInterface(irClass2) && property2.getModality() == Modality.ABSTRACT) {
            bl = true;
            return new ExportedProperty(string2, exportedType, bl2, bl3, false, bl, property2);
        }
        bl = false;
        return new ExportedProperty(string2, exportedType, bl2, bl3, false, bl, property2);
    }

    private final Exportability classExportability(IrClass klass) {
        switch (ExportModelGenerator$WhenMappings.$EnumSwitchMapping$0[klass.getKind().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new Exportability.Prohibited("Class " + IrUtilsKt.getFqNameWhenAvailable(klass) + " with kind: " + (Object)((Object)klass.getKind()));
            }
            case 5: 
            case 6: {
                break;
            }
        }
        if (klass.isInline()) {
            return new Exportability.Prohibited("Inline class " + IrUtilsKt.getFqNameWhenAvailable(klass));
        }
        return Exportability.Allowed.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedClass exportClass(IrClass klass) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        ExportedType exportedType;
        Object it;
        Object v0;
        boolean $i$f$firstOrNull;
        Object $this$firstOrNull$iv;
        List typeParameters2;
        Object object;
        boolean bl;
        Collection collection;
        List nestedClasses2;
        List members;
        block16: {
            void $this$mapTo$iv$iv2;
            Object object2;
            Exportability exportability = this.classExportability(klass);
            if (exportability instanceof Exportability.Prohibited) {
                String string2 = ((Exportability.Prohibited)exportability).getReason();
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            if (exportability instanceof Exportability.NotNeeded) {
                return null;
            }
            boolean bl3 = false;
            members = new ArrayList();
            boolean bl4 = false;
            nestedClasses2 = new ArrayList();
            for (IrDeclaration declaration2 : klass.getDeclarations()) {
                boolean bl5;
                IrDeclarationWithName candidate2;
                if (ExportModelGeneratorKt.access$getExportCandidate(declaration2) == null) {
                    continue;
                }
                if (!ExportModelGeneratorKt.access$shouldDeclarationBeExported(candidate2, this.context)) continue;
                object2 = candidate2;
                if (object2 instanceof IrSimpleFunction) {
                    CollectionsKt.addIfNotNull(members, this.exportFunction((IrSimpleFunction)candidate2));
                    continue;
                }
                if (object2 instanceof IrConstructor) {
                    CollectionsKt.addIfNotNull(members, this.exportConstructor((IrConstructor)candidate2));
                    continue;
                }
                if (object2 instanceof IrProperty) {
                    CollectionsKt.addIfNotNull(members, this.exportProperty((IrProperty)candidate2));
                    continue;
                }
                if (object2 instanceof IrClass) {
                    CollectionsKt.addIfNotNull(nestedClasses2, this.exportClass((IrClass)candidate2));
                    continue;
                }
                if (object2 instanceof IrField) {
                    boolean bl6 = ((IrField)candidate2).getCorrespondingPropertySymbol() != null;
                    bl5 = false;
                    if (!_Assertions.ENABLED || bl6) continue;
                    boolean $i$a$-assert-ExportModelGenerator$exportClass$22 = false;
                    String $i$a$-assert-ExportModelGenerator$exportClass$22 = "Properties without fields are not supported " + IrUtilsKt.getFqNameWhenAvailable(candidate2);
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-ExportModelGenerator$exportClass$22));
                }
                String string3 = "Can't export member declaration " + declaration2;
                bl5 = false;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            Iterable $this$map$iv = klass.getTypeParameters();
            boolean $i$f$map = false;
            object2 = $this$map$iv;
            Object destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
                collection = destination$iv$iv;
                bl = false;
                object = it2.getName().getIdentifier();
                collection.add(object);
            }
            typeParameters2 = (List)destination$iv$iv;
            $this$firstOrNull$iv = klass.getSuperTypes();
            $i$f$firstOrNull = false;
            destination$iv$iv = $this$firstOrNull$iv.iterator();
            while (destination$iv$iv.hasNext()) {
                Object element$iv = destination$iv$iv.next();
                IrType it3 = (IrType)element$iv;
                boolean bl7 = false;
                if (!(!ExportModelGeneratorKt.access$isInterface$p(IrTypesKt.getClassifierOrFail(it3)) && !IrTypePredicatesKt.isAny(it3))) continue;
                v0 = element$iv;
                break block16;
            }
            v0 = null;
        }
        IrType irType = v0;
        if (irType != null) {
            $this$firstOrNull$iv = irType;
            $i$f$firstOrNull = false;
            boolean destination$iv$iv = false;
            Object it4 = $this$firstOrNull$iv;
            boolean bl8 = false;
            ExportedType bl7 = this.exportType((IrType)it4);
            boolean bl9 = false;
            bl = false;
            it = bl7;
            boolean bl10 = false;
            exportedType = !(it instanceof ExportedType.ErrorType) ? bl7 : null;
        } else {
            exportedType = null;
        }
        ExportedType superType = exportedType;
        Iterable $this$filter$iv = klass.getSuperTypes();
        boolean $i$f$filter = false;
        Iterable it4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrType)element$iv$iv;
            boolean bl11 = false;
            if (!ExportModelGeneratorKt.access$isInterface$p(IrTypesKt.getClassifierOrFail((IrType)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl12 = false;
            object = this.exportType((IrType)it);
            collection.add(object);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ExportedType)element$iv$iv;
            boolean bl13 = false;
            if (!(!(it instanceof ExportedType.ErrorType))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List superInterfaces = (List)destination$iv$iv;
        String name2 = this.getExportedIdentifier(klass);
        return new ExportedClass(name2, IrUtilsKt.isInterface(klass), klass.getModality() == Modality.ABSTRACT, superType, superInterfaces, typeParameters2, members, nestedClasses2, klass);
    }

    private final ExportedType exportTypeArgument(IrTypeArgument type2) {
        if (type2 instanceof IrTypeProjection) {
            return this.exportType(((IrTypeProjection)type2).getType());
        }
        if (type2 instanceof IrType) {
            return this.exportType((IrType)((Object)type2));
        }
        return new ExportedType.ErrorType("UnknownType " + RenderIrElementKt.render(type2));
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedType exportType(IrType type2) {
        Object object;
        Object object2;
        Iterable $this$mapTo$iv$iv3;
        ExportedType exportedType;
        if (type2 instanceof IrDynamicType) {
            return ExportedType.Primitive.Any.INSTANCE;
        }
        if (!(type2 instanceof IrSimpleType)) {
            return new ExportedType.ErrorType("NonSimpleType " + RenderIrElementKt.render(type2));
        }
        IrClassifierSymbol classifier2 = ((IrSimpleType)type2).getClassifier();
        boolean isNullable2 = ((IrSimpleType)type2).getHasQuestionMark();
        IrType irType = IrTypesKt.makeNotNull(type2);
        if (irType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        }
        IrSimpleType nonNullType = (IrSimpleType)irType;
        if (IrTypePredicatesKt.isBoolean(nonNullType)) {
            exportedType = ExportedType.Primitive.Boolean.INSTANCE;
        } else if (IrTypePredicatesKt.isPrimitiveType(nonNullType) && !IrTypePredicatesKt.isLong(nonNullType) && !IrTypePredicatesKt.isChar(nonNullType)) {
            exportedType = ExportedType.Primitive.Number.INSTANCE;
        } else if (IrTypePredicatesKt.isByteArray(nonNullType)) {
            exportedType = ExportedType.Primitive.ByteArray.INSTANCE;
        } else if (IrTypePredicatesKt.isShortArray(nonNullType)) {
            exportedType = ExportedType.Primitive.ShortArray.INSTANCE;
        } else if (IrTypePredicatesKt.isIntArray(nonNullType)) {
            exportedType = ExportedType.Primitive.IntArray.INSTANCE;
        } else if (IrTypePredicatesKt.isFloatArray(nonNullType)) {
            exportedType = ExportedType.Primitive.FloatArray.INSTANCE;
        } else if (IrTypePredicatesKt.isDoubleArray(nonNullType)) {
            exportedType = ExportedType.Primitive.DoubleArray.INSTANCE;
        } else if (IrTypePredicatesKt.isBooleanArray(nonNullType)) {
            exportedType = new ExportedType.ErrorType("BooleanArray");
        } else if (IrTypePredicatesKt.isLongArray(nonNullType)) {
            exportedType = new ExportedType.ErrorType("LongArray");
        } else if (IrTypePredicatesKt.isCharArray(nonNullType)) {
            exportedType = new ExportedType.ErrorType("CharArray");
        } else if (IrTypePredicatesKt.isString(nonNullType)) {
            exportedType = ExportedType.Primitive.String.INSTANCE;
        } else if (IrTypeUtilsKt.isThrowable(nonNullType)) {
            exportedType = ExportedType.Primitive.Throwable.INSTANCE;
        } else if (IrTypePredicatesKt.isAny(nonNullType)) {
            exportedType = ExportedType.Primitive.Any.INSTANCE;
        } else if (IrTypePredicatesKt.isUnit(nonNullType)) {
            exportedType = ExportedType.Primitive.Unit.INSTANCE;
        } else if (IrTypePredicatesKt.isNothing(nonNullType)) {
            exportedType = ExportedType.Primitive.Nothing.INSTANCE;
        } else if (IrTypePredicatesKt.isArray(nonNullType)) {
            exportedType = new ExportedType.Array(this.exportTypeArgument(nonNullType.getArguments().get(0)));
        } else if (IrTypeUtilsKt.isSuspendFunction(nonNullType)) {
            exportedType = new ExportedType.ErrorType("Suspend functions are not supported");
        } else if (IrTypeUtilsKt.isFunction(nonNullType)) {
            Iterable $this$map$iv = kotlin.collections.CollectionsKt.dropLast(nonNullType.getArguments(), (int)1);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                object = this.exportTypeArgument((IrTypeArgument)it);
                object2.add(object);
            }
            object2 = (List)destination$iv$iv;
            ExportedType exportedType2 = this.exportTypeArgument((IrTypeArgument)kotlin.collections.CollectionsKt.last(nonNullType.getArguments()));
            List list2 = object2;
            exportedType = new ExportedType.Function(list2, exportedType2);
        } else if (classifier2 instanceof IrTypeParameterSymbol) {
            String string2 = ((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner()).getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classifier.owner.name.identifier");
            exportedType = new ExportedType.TypeParameter(string2);
        } else if (classifier2 instanceof IrClassSymbol) {
            IrClass klass = (IrClass)((IrClassSymbol)classifier2).getOwner();
            Exportability exportability = this.classExportability(klass);
            if (exportability instanceof Exportability.Prohibited) {
                exportedType = new ExportedType.ErrorType(((Exportability.Prohibited)exportability).getReason());
            } else {
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                if (exportability instanceof Exportability.NotNeeded) {
                    String $this$mapTo$iv$iv3 = "Not needed classes types cannot be used";
                    boolean destination$iv$iv = false;
                    throw (Throwable)new IllegalStateException($this$mapTo$iv$iv3.toString());
                }
                FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(klass);
                Intrinsics.checkNotNull((Object)fqName2);
                String string3 = fqName2.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"klass.fqNameWhenAvailable!!.asString()");
                $this$mapTo$iv$iv3 = ((IrSimpleType)type2).getArguments();
                object2 = string3;
                boolean $i$f$map = false;
                void $i$f$mapTo = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    ExportedType exportedType3 = this.exportTypeArgument((IrTypeArgument)it);
                    object.add(exportedType3);
                }
                Object object3 = object = (List)destination$iv$iv;
                Object object4 = object2;
                exportedType = new ExportedType.ClassType((String)object4, (List<? extends ExportedType>)object3);
            }
        } else {
            String string4 = "Unexpected classifier " + classifier2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string4.toString());
        }
        ExportedType exportedType4 = exportedType;
        return exportedType4.withNullability(isNullable2);
    }

    private final String getExportedIdentifier(IrDeclarationWithName $this$getExportedIdentifier) {
        Name name2 = AnnotationUtilsKt.getJsNameOrKotlinName($this$getExportedIdentifier);
        boolean bl = false;
        boolean bl2 = false;
        Name $this$with = name2;
        boolean bl3 = false;
        if ($this$with.isSpecial()) {
            String string2 = "Cannot export special name: " + $this$getExportedIdentifier.getName().asString() + " for declaration " + IrUtilsKt.getFqNameWhenAvailable($this$getExportedIdentifier);
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String string3 = $this$with.getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"with(getJsNameOrKotlinNa\u2026else identifier\n        }");
        return string3;
    }

    private final Exportability functionExportability(IrSimpleFunction function2) {
        if (function2.isInline()) {
            boolean bl;
            block11: {
                Iterable $this$any$iv = function2.getTypeParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrTypeParameter it = (IrTypeParameter)element$iv;
                        boolean bl2 = false;
                        if (!it.isReified()) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return new Exportability.Prohibited("Inline reified function");
            }
        }
        if (function2.isSuspend()) {
            return new Exportability.Prohibited("Suspend function");
        }
        if (function2.isFakeOverride()) {
            return Exportability.NotNeeded.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)function2.getOrigin(), (Object)IrDeclarationOrigin.BRIDGE.INSTANCE) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JsLoweredDeclarationOrigin.BRIDGE_TO_EXTERNAL_FUNCTION.INSTANCE) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)IrDeclarationOrigin.FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        if (IrUtilsKt.isFakeOverriddenFromAny(function2)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        String string2 = function2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"function.name.asString()");
        if (StringsKt.endsWith$default((String)string2, (String)"-impl", (boolean)false, (int)2, null)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        String name2 = this.getExportedIdentifier(function2);
        if (ExportModelGeneratorKt.access$getAllReservedWords$p().contains(name2)) {
            return new Exportability.Prohibited("Name is a reserved word");
        }
        return Exportability.Allowed.INSTANCE;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public ExportModelGenerator(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }
}

