/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.lexer;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.kdoc.lexer.KDocLexer;
import org.jetbrains.kotlin.kdoc.lexer.KDocToken;
import org.jetbrains.kotlin.kdoc.parser.KDocLinkParser;
import org.jetbrains.kotlin.kdoc.parser.KDocParser;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocImpl;

public interface KDocTokens {
    public static final ILazyParseableElementType KDOC = new ILazyParseableElementType("KDoc", KotlinLanguage.INSTANCE){

        public ASTNode parseContents(ASTNode chameleon) {
            PsiElement parentElement = chameleon.getTreeParent().getPsi();
            Project project = parentElement.getProject();
            PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, (Lexer)new KDocLexer(), this.getLanguage(), (CharSequence)chameleon.getText());
            KDocParser parser = new KDocParser();
            return parser.parse((IElementType)this, builder).getFirstChildNode();
        }

        @Nullable
        public ASTNode createNode(CharSequence text2) {
            return new KDocImpl(text2);
        }
    };
    public static final KDocToken START = new KDocToken("KDOC_START");
    public static final KDocToken END = new KDocToken("KDOC_END");
    public static final KDocToken LEADING_ASTERISK = new KDocToken("KDOC_LEADING_ASTERISK");
    public static final KDocToken TEXT = new KDocToken("KDOC_TEXT");
    public static final KDocToken CODE_BLOCK_TEXT = new KDocToken("KDOC_CODE_BLOCK_TEXT");
    public static final KDocToken TAG_NAME = new KDocToken("KDOC_TAG_NAME");
    public static final ILazyParseableElementType MARKDOWN_LINK = new ILazyParseableElementType("KDOC_MARKDOWN_LINK", KotlinLanguage.INSTANCE){

        public ASTNode parseContents(ASTNode chameleon) {
            return KDocLinkParser.parseMarkdownLink((IElementType)this, chameleon);
        }
    };
    public static final KDocToken MARKDOWN_ESCAPED_CHAR = new KDocToken("KDOC_MARKDOWN_ESCAPED_CHAR");
    public static final KDocToken MARKDOWN_INLINE_LINK = new KDocToken("KDOC_MARKDOWN_INLINE_LINK");
    public static final TokenSet KDOC_HIGHLIGHT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{START, END, LEADING_ASTERISK, TEXT, CODE_BLOCK_TEXT, MARKDOWN_LINK, MARKDOWN_ESCAPED_CHAR, MARKDOWN_INLINE_LINK});
    public static final TokenSet CONTENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{TEXT, CODE_BLOCK_TEXT, TAG_NAME, MARKDOWN_LINK, MARKDOWN_ESCAPED_CHAR, MARKDOWN_INLINE_LINK});
}

