/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Maps;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;

public class TopDownAnalysisContext
implements BodiesResolveContext {
    private final DataFlowInfo outerDataFlowInfo;
    private final Map<KtClassOrObject, ClassDescriptorWithResolutionScopes> classes;
    private final Map<KtAnonymousInitializer, ClassDescriptorWithResolutionScopes> anonymousInitializers;
    private final Set<KtFile> files;
    private final Map<KtSecondaryConstructor, ClassConstructorDescriptor> secondaryConstructors;
    private final Map<KtNamedFunction, SimpleFunctionDescriptor> functions;
    private final Map<KtProperty, PropertyDescriptor> properties;
    private final Map<KtParameter, PropertyDescriptor> primaryConstructorParameterProperties;
    private final Map<KtTypeAlias, TypeAliasDescriptor> typeAliases;
    private final Map<KtDestructuringDeclarationEntry, PropertyDescriptor> destructuringDeclarationEntries;
    private Map<KtCallableDeclaration, CallableMemberDescriptor> members;
    private final Map<KtScript, ClassDescriptorWithResolutionScopes> scripts;
    private final TopDownAnalysisMode topDownAnalysisMode;
    private final DeclarationScopeProvider declarationScopeProvider;
    private StringBuilder debugOutput;

    public TopDownAnalysisContext(@NotNull TopDownAnalysisMode topDownAnalysisMode, @NotNull DataFlowInfo outerDataFlowInfo, @NotNull DeclarationScopeProvider declarationScopeProvider) {
        if (topDownAnalysisMode == null) {
            TopDownAnalysisContext.$$$reportNull$$$0(0);
        }
        if (outerDataFlowInfo == null) {
            TopDownAnalysisContext.$$$reportNull$$$0(1);
        }
        if (declarationScopeProvider == null) {
            TopDownAnalysisContext.$$$reportNull$$$0(2);
        }
        this.classes = Maps.newLinkedHashMap();
        this.anonymousInitializers = Maps.newLinkedHashMap();
        this.files = new LinkedHashSet<KtFile>();
        this.secondaryConstructors = Maps.newLinkedHashMap();
        this.functions = Maps.newLinkedHashMap();
        this.properties = Maps.newLinkedHashMap();
        this.primaryConstructorParameterProperties = new HashMap<KtParameter, PropertyDescriptor>();
        this.typeAliases = Maps.newLinkedHashMap();
        this.destructuringDeclarationEntries = Maps.newLinkedHashMap();
        this.members = null;
        this.scripts = Maps.newLinkedHashMap();
        this.topDownAnalysisMode = topDownAnalysisMode;
        this.outerDataFlowInfo = outerDataFlowInfo;
        this.declarationScopeProvider = declarationScopeProvider;
    }

    @Override
    @NotNull
    public TopDownAnalysisMode getTopDownAnalysisMode() {
        TopDownAnalysisMode topDownAnalysisMode = this.topDownAnalysisMode;
        if (topDownAnalysisMode == null) {
            TopDownAnalysisContext.$$$reportNull$$$0(3);
        }
        return topDownAnalysisMode;
    }

    public void debug(Object message2) {
        if (this.debugOutput != null) {
            this.debugOutput.append(message2).append("\n");
        }
    }

    void enableDebugOutput() {
        if (this.debugOutput == null) {
            this.debugOutput = new StringBuilder();
        }
    }

    void printDebugOutput(PrintStream out) {
        if (this.debugOutput != null) {
            out.print(this.debugOutput);
        }
    }

    @Override
    public Map<KtClassOrObject, ClassDescriptorWithResolutionScopes> getDeclaredClasses() {
        return this.classes;
    }

    @Override
    public Map<KtAnonymousInitializer, ClassDescriptorWithResolutionScopes> getAnonymousInitializers() {
        return this.anonymousInitializers;
    }

    @Override
    public Map<KtSecondaryConstructor, ClassConstructorDescriptor> getSecondaryConstructors() {
        return this.secondaryConstructors;
    }

    @Override
    public Collection<KtFile> getFiles() {
        return this.files;
    }

    public void addFile(@NotNull KtFile file2) {
        if (file2 == null) {
            TopDownAnalysisContext.$$$reportNull$$$0(4);
        }
        this.files.add(file2);
    }

    @Override
    @NotNull
    public Map<KtScript, ClassDescriptorWithResolutionScopes> getScripts() {
        Map<KtScript, ClassDescriptorWithResolutionScopes> map2 = this.scripts;
        if (map2 == null) {
            TopDownAnalysisContext.$$$reportNull$$$0(5);
        }
        return map2;
    }

    public Map<KtParameter, PropertyDescriptor> getPrimaryConstructorParameterProperties() {
        return this.primaryConstructorParameterProperties;
    }

    @Override
    public Map<KtProperty, PropertyDescriptor> getProperties() {
        return this.properties;
    }

    @Override
    @Nullable
    public LexicalScope getDeclaringScope(@NotNull KtDeclaration declaration2) {
        if (declaration2 == null) {
            TopDownAnalysisContext.$$$reportNull$$$0(6);
        }
        return this.declarationScopeProvider.getResolutionScopeForDeclaration(declaration2);
    }

    @Override
    public Map<KtNamedFunction, SimpleFunctionDescriptor> getFunctions() {
        return this.functions;
    }

    @Override
    public Map<KtTypeAlias, TypeAliasDescriptor> getTypeAliases() {
        return this.typeAliases;
    }

    @Override
    public Map<KtDestructuringDeclarationEntry, PropertyDescriptor> getDestructuringDeclarationEntries() {
        return this.destructuringDeclarationEntries;
    }

    @NotNull
    public Map<KtCallableDeclaration, CallableMemberDescriptor> getMembers() {
        if (this.members == null) {
            this.members = Maps.newLinkedHashMap();
            this.members.putAll(this.functions);
            this.members.putAll(this.properties);
            this.members.putAll(this.primaryConstructorParameterProperties);
        }
        Map<KtCallableDeclaration, CallableMemberDescriptor> map2 = this.members;
        if (map2 == null) {
            TopDownAnalysisContext.$$$reportNull$$$0(7);
        }
        return map2;
    }

    @Override
    @NotNull
    public DataFlowInfo getOuterDataFlowInfo() {
        DataFlowInfo dataFlowInfo = this.outerDataFlowInfo;
        if (dataFlowInfo == null) {
            TopDownAnalysisContext.$$$reportNull$$$0(8);
        }
        return dataFlowInfo;
    }

    @NotNull
    public Collection<ClassDescriptorWithResolutionScopes> getAllClasses() {
        List list2 = CollectionsKt.plus(this.getDeclaredClasses().values(), this.getScripts().values());
        if (list2 == null) {
            TopDownAnalysisContext.$$$reportNull$$$0(9);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topDownAnalysisMode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerDataFlowInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationScopeProvider";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/TopDownAnalysisContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/TopDownAnalysisContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopDownAnalysisMode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getScripts";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembers";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterDataFlowInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaringScope";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

