/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.jvm.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.jvm.impl.PathUtilKt;
import kotlin.script.experimental.jvm.util.ClassLoaderResourceRootFIlePathCalculator;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\u001a2\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00012\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u0016H\u0000\u001a2\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u0016H\u0000\u001a2\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u0016H\u0000\u001a2\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u0016H\u0000\u001a\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0001H\u0000\u001a\f\u0010#\u001a\u00020\u0001*\u00020$H\u0002\u001aE\u0010%\u001a\u00020\u0011*\u00020&2\u0006\u0010\u0014\u001a\u00020\u00012\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010(\"\u00020\u00012\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u0016\u00a2\u0006\u0002\u0010)\u001a\f\u0010*\u001a\u00020\u0001*\u00020\u0001H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0014\u0010\b\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"\u0014\u0010\n\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0014\u0010\f\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\"\u0014\u0010\u000e\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006+"}, d2={"pathElementPattern", "", "getPathElementPattern", "()Ljava/lang/String;", "pathSeparatorChars", "", "getPathSeparatorChars", "()[C", "pathSeparatorPattern", "getPathSeparatorPattern", "patternCharsToEscape", "getPatternCharsToEscape", "specialPatternChars", "getSpecialPatternChars", "wildcardChars", "getWildcardChars", "forAllMatchingFilesInDirectory", "", "baseDir", "Ljava/io/File;", "namePattern", "body", "Lkotlin/Function2;", "Ljava/io/InputStream;", "forAllMatchingFilesInJar", "jarFile", "nameRegex", "Lkotlin/text/Regex;", "forAllMatchingFilesInJarFile", "Ljava/util/jar/JarFile;", "forAllMatchingFilesInJarStream", "jarInputStream", "Ljava/util/jar/JarInputStream;", "namePatternToRegex", "pattern", "escape", "", "forAllMatchingFiles", "Ljava/lang/ClassLoader;", "keyResourcePaths", "", "(Ljava/lang/ClassLoader;Ljava/lang/String;[Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "toUniversalSeparator", "kotlin-scripting-jvm"})
public final class JvmClassLoaderUtilKt {
    @NotNull
    private static final char[] wildcardChars;
    @NotNull
    private static final char[] patternCharsToEscape;
    @NotNull
    private static final char[] pathSeparatorChars;
    @NotNull
    private static final String pathElementPattern;
    @NotNull
    private static final String pathSeparatorPattern;
    @NotNull
    private static final char[] specialPatternChars;

    public static final void forAllMatchingFiles(@NotNull ClassLoader $this$forAllMatchingFiles, @NotNull String namePattern, @NotNull String[] keyResourcePaths, @NotNull Function2<? super String, ? super InputStream, Unit> body2) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)$this$forAllMatchingFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)namePattern, (String)"namePattern");
        Intrinsics.checkNotNullParameter((Object)keyResourcePaths, (String)"keyResourcePaths");
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        HashSet<File> processedDirs = new HashSet<File>();
        HashSet<URL> processedJars = new HashSet<URL>();
        Regex nameRegex = JvmClassLoaderUtilKt.namePatternToRegex(namePattern);
        String[] stringArray2 = keyResourcePaths;
        boolean bl = false;
        if (stringArray2.length == 0) {
            stringArray2 = new String[]{"", "META-INF/MANIFEST.MF"};
            stringArray = stringArray2;
        } else {
            stringArray = keyResourcePaths;
        }
        JvmClassLoaderUtilKt.forAllMatchingFiles$iterateResources($this$forAllMatchingFiles, processedJars, processedDirs, namePattern, body2, nameRegex, stringArray);
    }

    @NotNull
    public static final char[] getWildcardChars() {
        return wildcardChars;
    }

    @NotNull
    public static final char[] getPatternCharsToEscape() {
        return patternCharsToEscape;
    }

    private static final String escape(char $this$escape) {
        return Intrinsics.stringPlus((String)($this$escape == '\\' || ArraysKt.contains((char[])patternCharsToEscape, (char)$this$escape) ? "\\" : ""), (Object)Character.valueOf($this$escape));
    }

    @NotNull
    public static final char[] getPathSeparatorChars() {
        return pathSeparatorChars;
    }

    @NotNull
    public static final String getPathElementPattern() {
        return pathElementPattern;
    }

    @NotNull
    public static final String getPathSeparatorPattern() {
        return pathSeparatorPattern;
    }

    @NotNull
    public static final char[] getSpecialPatternChars() {
        return specialPatternChars;
    }

    @NotNull
    public static final String toUniversalSeparator(@NotNull String $this$toUniversalSeparator) {
        Intrinsics.checkNotNullParameter((Object)$this$toUniversalSeparator, (String)"<this>");
        return File.separatorChar == '/' ? $this$toUniversalSeparator : StringsKt.replace$default((String)$this$toUniversalSeparator, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final void forAllMatchingFilesInDirectory(@NotNull File baseDir, @NotNull String namePattern, @NotNull Function2<? super String, ? super InputStream, Unit> body2) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter((Object)namePattern, (String)"namePattern");
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        int patternStart = StringsKt.indexOfAny$default((CharSequence)namePattern, (char[])wildcardChars, (int)0, (boolean)false, (int)6, null);
        if (patternStart < 0) {
            File file2;
            File file3 = FilesKt.resolve((File)baseDir, (String)namePattern);
            boolean bl = false;
            boolean bl2 = false;
            File it = file3;
            boolean bl3 = false;
            File file4 = file2 = it.exists() && it.isFile() ? file3 : null;
            if (file2 != null) {
                file3 = file2;
                bl = false;
                bl2 = false;
                File file5 = file3;
                boolean bl4 = false;
                Object object = FilesKt.relativeToOrSelf((File)file5, (File)baseDir).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file.relativeToOrSelf(baseDir).path");
                String string2 = JvmClassLoaderUtilKt.toUniversalSeparator((String)object);
                object = file5;
                boolean bl5 = false;
                body2.invoke((Object)string2, (Object)new FileInputStream((File)object));
            }
        } else {
            File root2;
            int file5;
            File file6;
            int patternDirStart = StringsKt.lastIndexOfAny$default((CharSequence)namePattern, (char[])pathSeparatorChars, (int)patternStart, (boolean)false, (int)4, null);
            if (patternDirStart <= 0) {
                file6 = baseDir;
            } else {
                String string3 = namePattern;
                int n = 0;
                file5 = 0;
                String string4 = string3.substring(n, patternDirStart);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                file6 = root2 = FilesKt.resolve((File)baseDir, (String)string4);
            }
            if (root2.exists() && root2.isDirectory()) {
                void $this$forEach$iv;
                String string5 = namePattern;
                file5 = patternDirStart + 1;
                boolean bl = false;
                String string6 = string5.substring(file5);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                Regex re = JvmClassLoaderUtilKt.namePatternToRegex(string6);
                string5 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)root2)), (Function1)((Function1)new Function1<File, Boolean>(re, root2){
                    final /* synthetic */ Regex $re;
                    final /* synthetic */ File $root;
                    {
                        this.$re = $re;
                        this.$root = $root;
                        super(1);
                    }

                    public final boolean invoke(@NotNull File it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        String string2 = FilesKt.relativeToOrSelf((File)it, (File)this.$root).getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.relativeToOrSelf(root).path");
                        return this.$re.matches((CharSequence)string2);
                    }
                }));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File file7 = (File)element$iv;
                    boolean bl6 = false;
                    Object object = FilesKt.relativeToOrSelf((File)file7, (File)baseDir).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file.relativeToOrSelf(baseDir).path");
                    String string7 = JvmClassLoaderUtilKt.toUniversalSeparator((String)object);
                    object = file7;
                    boolean bl7 = false;
                    body2.invoke((Object)string7, (Object)new FileInputStream((File)object));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void forAllMatchingFilesInJarStream(@NotNull JarInputStream jarInputStream, @NotNull Regex nameRegex, @NotNull Function2<? super String, ? super InputStream, Unit> body2) {
        JarEntry entry;
        Intrinsics.checkNotNullParameter((Object)jarInputStream, (String)"jarInputStream");
        Intrinsics.checkNotNullParameter((Object)nameRegex, (String)"nameRegex");
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        do {
            if ((entry = jarInputStream.getNextJarEntry()) == null) continue;
            try {
                if (entry.isDirectory()) continue;
                String string2 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
                if (!nameRegex.matches((CharSequence)string2)) continue;
                string2 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
                body2.invoke((Object)string2, (Object)jarInputStream);
            }
            finally {
                jarInputStream.closeEntry();
            }
        } while (entry != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void forAllMatchingFilesInJar(@NotNull File jarFile, @NotNull Regex nameRegex, @NotNull Function2<? super String, ? super InputStream, Unit> body2) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)nameRegex, (String)"nameRegex");
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        Closeable closeable = new JarInputStream(new FileInputStream(jarFile));
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            JarInputStream it = (JarInputStream)closeable;
            boolean bl3 = false;
            JvmClassLoaderUtilKt.forAllMatchingFilesInJarStream(it, nameRegex, body2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void forAllMatchingFilesInJarFile(@NotNull JarFile jarFile, @NotNull Regex nameRegex, @NotNull Function2<? super String, ? super InputStream, Unit> body2) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)nameRegex, (String)"nameRegex");
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        Enumeration<JarEntry> enumeration = jarFile.entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"jarFile.entries()");
        boolean bl = false;
        Sequence $this$forEach$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JarEntry entry = (JarEntry)element$iv;
            boolean bl2 = false;
            if (entry.isDirectory()) continue;
            Object object = entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"entry.name");
            if (!nameRegex.matches((CharSequence)object)) continue;
            object = jarFile.getInputStream(entry);
            boolean bl3 = false;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)object;
                boolean bl5 = false;
                String string2 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
                Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
                body2.invoke((Object)string2, (Object)stream);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
    }

    @NotNull
    public static final Regex namePatternToRegex(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$namePatternToRegex_u24lambda_u2d11 = stringBuilder2;
        boolean bl5 = false;
        int current2 = 0;
        while (current2 < pattern.length()) {
            int nextIndex = StringsKt.indexOfAny$default((CharSequence)pattern, (char[])JvmClassLoaderUtilKt.getSpecialPatternChars(), (int)current2, (boolean)false, (int)4, null);
            int next = nextIndex < 0 ? pattern.length() : nextIndex;
            String string2 = pattern;
            boolean bl6 = false;
            String string3 = string2.substring(current2, next);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            $this$namePatternToRegex_u24lambda_u2d11.append(string3);
            current2 = next + 1;
            if (next >= pattern.length()) break;
            if (ArraysKt.contains((char[])JvmClassLoaderUtilKt.getPathSeparatorChars(), (char)pattern.charAt(next))) {
                $this$namePatternToRegex_u24lambda_u2d11.append(JvmClassLoaderUtilKt.getPathSeparatorPattern());
                continue;
            }
            if (pattern.charAt(next) == '?') {
                $this$namePatternToRegex_u24lambda_u2d11.append('.');
                continue;
            }
            if (pattern.charAt(next) == '*' && next + 1 < pattern.length() && pattern.charAt(next + 1) == '*') {
                $this$namePatternToRegex_u24lambda_u2d11.append(".*");
                int n = current2;
                current2 = n + 1;
                continue;
            }
            if (pattern.charAt(next) == '*') {
                $this$namePatternToRegex_u24lambda_u2d11.append(JvmClassLoaderUtilKt.getPathElementPattern());
                continue;
            }
            $this$namePatternToRegex_u24lambda_u2d11.append('\\');
            $this$namePatternToRegex_u24lambda_u2d11.append(pattern.charAt(next));
        }
        Unit unit = Unit.INSTANCE;
        String string4 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        String string5 = string4;
        return new Regex(string5);
    }

    private static final void forAllMatchingFiles$iterateResources(ClassLoader $this_forAllMatchingFiles, HashSet<URL> processedJars, HashSet<File> processedDirs, String $namePattern, Function2<? super String, ? super InputStream, Unit> $body, Regex nameRegex, String[] keyResourcePaths) {
        String[] stringArray = keyResourcePaths;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String keyResourcePath = stringArray[n];
            ++n;
            ClassLoaderResourceRootFIlePathCalculator resourceRootCalc = new ClassLoaderResourceRootFIlePathCalculator(keyResourcePath);
            Enumeration<URL> enumeration = $this_forAllMatchingFiles.getResources(keyResourcePath);
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(keyResourcePath)");
            Iterator iterator2 = CollectionsKt.iterator(enumeration);
            while (iterator2.hasNext()) {
                File rootDir;
                File file2;
                Object object;
                Object object2;
                URL url = (URL)iterator2.next();
                if (Intrinsics.areEqual((Object)url.getProtocol(), (Object)"jar")) {
                    Object object3;
                    object2 = url.openConnection();
                    JarURLConnection jarConnection = object2 instanceof JarURLConnection ? (JarURLConnection)object2 : null;
                    object = jarConnection;
                    URL jarUrl = object == null ? null : ((JarURLConnection)object).getJarFileURL();
                    if (jarUrl == null || processedJars.contains(jarUrl)) continue;
                    processedJars.add(jarUrl);
                    try {
                        object3 = jarConnection.getJarFile();
                    }
                    catch (IOException _) {
                        object3 = null;
                    }
                    object = object3;
                    if (object == null) continue;
                    object3 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object3;
                    boolean bl3 = false;
                    JvmClassLoaderUtilKt.forAllMatchingFilesInJarFile((JarFile)it, nameRegex, $body);
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
                object2 = PathUtilKt.toFileOrNull(url);
                if (object2 == null) {
                    file2 = null;
                } else {
                    object = object2;
                    boolean bl = false;
                    boolean bl4 = false;
                    Object it = object;
                    boolean bl5 = false;
                    file2 = resourceRootCalc.invoke((File)it);
                }
                if ((rootDir = file2) == null || !rootDir.isDirectory() || processedDirs.contains(rootDir)) continue;
                processedDirs.add(rootDir);
                JvmClassLoaderUtilKt.forAllMatchingFilesInDirectory(rootDir, $namePattern, $body);
            }
        }
    }

    static {
        boolean bl;
        int n;
        Object it;
        boolean bl2;
        boolean bl3;
        Object object;
        block3: {
            object = "*?";
            bl3 = false;
            char[] cArray = ((String)object).toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            wildcardChars = cArray;
            object = ".*?+()[]^${}|";
            bl3 = false;
            char[] cArray2 = ((String)object).toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"(this as java.lang.String).toCharArray()");
            object = cArray2;
            bl3 = false;
            bl2 = false;
            it = object;
            boolean bl4 = false;
            char[] $this$all$iv = JvmClassLoaderUtilKt.getWildcardChars();
            boolean $i$f$all = false;
            char[] cArray3 = $this$all$iv;
            n = cArray3.length;
            for (int i = 0; i < n; ++i) {
                char element$iv;
                char wc = element$iv = cArray3[i];
                boolean bl5 = false;
                if (ArraysKt.contains((char[])it, (char)wc)) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        boolean bl6 = bl;
        boolean bl7 = false;
        boolean bl8 = false;
        if (_Assertions.ENABLED && !bl6) {
            n = 0;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        patternCharsToEscape = (char[])object;
        object = "/";
        bl3 = false;
        bl2 = false;
        it = object;
        boolean bl9 = false;
        object = File.separatorChar == '/' ? it : Intrinsics.stringPlus((String)it, (Object)File.separator);
        bl3 = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = ((String)object2).toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        pathSeparatorChars = cArray;
        pathElementPattern = File.separatorChar == '/' ? "[^/]*" : "[^/" + JvmClassLoaderUtilKt.escape(File.separatorChar) + "]*";
        pathSeparatorPattern = File.separatorChar == '/' ? "/" : "[/" + JvmClassLoaderUtilKt.escape(File.separatorChar) + ']';
        specialPatternChars = ArraysKt.plus((char[])patternCharsToEscape, (char[])pathSeparatorChars);
    }
}

