/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.java.compiler;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;

public final class AnnotationProcessorProfileSerializer {
    private static final Comparator<String> ALPHA_COMPARATOR = (o1, o2) -> o1.compareToIgnoreCase((String)o2);
    private static final String ENTRY = "entry";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String ENABLED = "enabled";
    private static final String OPTION = "option";
    private static final String MODULE = "module";
    private static final String USE_CLASSPATH = "useClasspath";
    private static final String USE_PROC_MODULE_PATH = "useProcessorModulePath";

    public static void readExternal(ProcessorConfigProfile profile, Element element) {
        profile.setName(element.getAttributeValue(NAME, ""));
        profile.setEnabled(Boolean.valueOf(element.getAttributeValue(ENABLED, "false")));
        Element srcOutput = element.getChild("sourceOutputDir");
        String out = srcOutput != null ? srcOutput.getAttributeValue(NAME) : null;
        profile.setGeneratedSourcesDirectoryName(out != null ? FileUtil.toSystemDependentName((String)out) : null, false);
        Element srcTestOutput = element.getChild("sourceTestOutputDir");
        String testOut = srcTestOutput != null ? srcTestOutput.getAttributeValue(NAME) : null;
        profile.setGeneratedSourcesDirectoryName(testOut != null ? FileUtil.toSystemDependentName((String)testOut) : null, true);
        Element isRelativeToContentRoot = element.getChild("outputRelativeToContentRoot");
        if (isRelativeToContentRoot != null) {
            profile.setOutputRelativeToContentRoot(Boolean.parseBoolean(isRelativeToContentRoot.getAttributeValue(VALUE)));
        }
        profile.clearProcessorOptions();
        for (Object optionElement : element.getChildren(OPTION)) {
            Element elem = (Element)optionElement;
            String key = elem.getAttributeValue(NAME);
            String value2 = elem.getAttributeValue(VALUE);
            if (StringUtil.isEmptyOrSpaces((String)key) || value2 == null) continue;
            profile.setOption(key, value2);
        }
        profile.clearProcessors();
        for (Object procElement : element.getChildren("processor")) {
            String name2 = ((Element)procElement).getAttributeValue(NAME);
            if (StringUtil.isEmptyOrSpaces((String)name2)) continue;
            profile.addProcessor(name2);
        }
        Element pathElement = element.getChild("processorPath");
        if (pathElement != null) {
            profile.setObtainProcessorsFromClasspath(Boolean.parseBoolean(pathElement.getAttributeValue(USE_CLASSPATH, "true")));
            profile.setUseProcessorModulePath(Boolean.parseBoolean(pathElement.getAttributeValue(USE_PROC_MODULE_PATH, "false")));
            StringBuilder pathBuilder = new StringBuilder();
            for (Object entry : pathElement.getChildren(ENTRY)) {
                String path2 = ((Element)entry).getAttributeValue(NAME);
                if (StringUtil.isEmptyOrSpaces((String)path2)) continue;
                if (pathBuilder.length() > 0) {
                    pathBuilder.append(File.pathSeparator);
                }
                pathBuilder.append(FileUtil.toSystemDependentName((String)path2));
            }
            profile.setProcessorPath(pathBuilder.toString());
        }
        profile.clearModuleNames();
        for (Object moduleElement : element.getChildren(MODULE)) {
            String name3 = ((Element)moduleElement).getAttributeValue(NAME);
            if (StringUtil.isEmptyOrSpaces((String)name3)) continue;
            profile.addModuleName(name3);
        }
    }

    public static void writeExternal(@NotNull ProcessorConfigProfile profile, @NotNull Element element) {
        Set<String> moduleNames;
        String string2;
        Set<String> processors;
        Map<String, String> options;
        String testSrcDirName;
        String srcDirName;
        if (profile == null) {
            AnnotationProcessorProfileSerializer.$$$reportNull$$$0(0);
        }
        if (element == null) {
            AnnotationProcessorProfileSerializer.$$$reportNull$$$0(1);
        }
        element.setAttribute(NAME, profile.getName());
        if (profile.isEnabled()) {
            element.setAttribute(ENABLED, Boolean.toString(profile.isEnabled()));
        }
        if (!StringUtil.equals((CharSequence)"generated", (CharSequence)(srcDirName = profile.getGeneratedSourcesDirectoryName(false)))) {
            AnnotationProcessorProfileSerializer.addChild(element, "sourceOutputDir").setAttribute(NAME, FileUtil.toSystemIndependentName((String)srcDirName));
        }
        if (!StringUtil.equals((CharSequence)"generated_tests", (CharSequence)(testSrcDirName = profile.getGeneratedSourcesDirectoryName(true)))) {
            AnnotationProcessorProfileSerializer.addChild(element, "sourceTestOutputDir").setAttribute(NAME, FileUtil.toSystemIndependentName((String)testSrcDirName));
        }
        if (profile.isOutputRelativeToContentRoot()) {
            AnnotationProcessorProfileSerializer.addChild(element, "outputRelativeToContentRoot").setAttribute(VALUE, "true");
        }
        if (!(options = profile.getProcessorOptions()).isEmpty()) {
            ArrayList<String> keys = new ArrayList<String>(options.keySet());
            keys.sort(ALPHA_COMPARATOR);
            for (String string3 : keys) {
                AnnotationProcessorProfileSerializer.addChild(element, OPTION).setAttribute(NAME, string3).setAttribute(VALUE, options.get(string3));
            }
        }
        if (!(processors = profile.getProcessors()).isEmpty()) {
            ArrayList<String> processorList = new ArrayList<String>(processors);
            for (String proc : processorList) {
                AnnotationProcessorProfileSerializer.addChild(element, "processor").setAttribute(NAME, proc);
            }
        }
        Element pathElement = null;
        if (!profile.isObtainProcessorsFromClasspath()) {
            pathElement = AnnotationProcessorProfileSerializer.addChild(element, "processorPath");
            pathElement.setAttribute(USE_CLASSPATH, Boolean.toString(profile.isObtainProcessorsFromClasspath()));
            if (profile.isUseProcessorModulePath()) {
                pathElement.setAttribute(USE_PROC_MODULE_PATH, Boolean.toString(profile.isUseProcessorModulePath()));
            }
        }
        if (!StringUtil.isEmpty((String)(string2 = profile.getProcessorPath()))) {
            if (pathElement == null) {
                pathElement = AnnotationProcessorProfileSerializer.addChild(element, "processorPath");
                if (profile.isUseProcessorModulePath()) {
                    pathElement.setAttribute(USE_PROC_MODULE_PATH, Boolean.toString(profile.isUseProcessorModulePath()));
                }
            }
            StringTokenizer tokenizer = new StringTokenizer(string2, File.pathSeparator, false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                AnnotationProcessorProfileSerializer.addChild(pathElement, ENTRY).setAttribute(NAME, FileUtil.toSystemIndependentName((String)token));
            }
        }
        if (!(moduleNames = profile.getModuleNames()).isEmpty()) {
            ArrayList<String> names2 = new ArrayList<String>(moduleNames);
            for (String name2 : names2) {
                AnnotationProcessorProfileSerializer.addChild(element, MODULE).setAttribute(NAME, name2);
            }
        }
    }

    private static Element addChild(Element parent2, String childName) {
        Element child = new Element(childName);
        parent2.addContent(child);
        return child;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "profile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/jps/model/serialization/java/compiler/AnnotationProcessorProfileSerializer";
        objectArray[2] = "writeExternal";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

