/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesLoweringKt;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesSupport;
import org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u00020\u000f*\u00020\u00132\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesMemberBodyLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "innerClassesSupport", "Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "classForImplicitThis", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "getClassForImplicitThis", "(Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;)Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "fixThisReference", "irClass", "ir.backend.common"})
public final class InnerClassesMemberBodyLowering
implements BodyLoweringPass {
    @NotNull
    private final BackendContext context;
    @NotNull
    private final InnerClassesSupport innerClassesSupport;

    public InnerClassesMemberBodyLowering(@NotNull BackendContext context2, @NotNull InnerClassesSupport innerClassesSupport) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)innerClassesSupport, (String)"innerClassesSupport");
        this.context = context2;
        this.innerClassesSupport = innerClassesSupport;
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        LowerKt.runOnFilePostfix$default(this, irFile, true, false, 4, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final IrClass getClassForImplicitThis(IrValueSymbol $this$classForImplicitThis) {
        if (!($this$classForImplicitThis instanceof IrValueParameterSymbol)) return null;
        if (((IrValueParameter)((IrValueParameterSymbol)$this$classForImplicitThis).getOwner()).getIndex() != -1) return null;
        IrDeclarationParent irDeclarationParent = ((IrValueParameter)((IrValueParameterSymbol)$this$classForImplicitThis).getOwner()).getParent();
        Object object = irDeclarationParent instanceof IrFunction ? (IrFunction)irDeclarationParent : null;
        if (!Intrinsics.areEqual((Object)((IrValueParameterSymbol)$this$classForImplicitThis).getOwner(), (Object)(object == null ? null : ((IrFunction)object).getDispatchReceiverParameter()))) {
            irDeclarationParent = ((IrValueParameter)((IrValueParameterSymbol)$this$classForImplicitThis).getOwner()).getParent();
            object = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
            if (!Intrinsics.areEqual((Object)((IrValueParameterSymbol)$this$classForImplicitThis).getOwner(), (Object)(object == null ? null : ((IrClass)object).getThisReceiver()))) return null;
        }
        if ((object = IrTypesKt.getClassOrNull(((IrValueParameter)((IrValueParameterSymbol)$this$classForImplicitThis).getOwner()).getType())) == null) {
            return null;
        }
        IrClass irClass2 = (IrClass)object.getOwner();
        return irClass2;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container2) {
        IrConstructor primaryConstructor2;
        IrClass irClass2;
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        IrDeclarationParent irDeclarationParent = container2.getParent();
        IrClass irClass3 = irClass2 = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        if (irClass2 == null) {
            return;
        }
        IrClass irClass4 = irClass2;
        if (!irClass4.isInner()) {
            return;
        }
        if ((container2 instanceof IrField || container2 instanceof IrAnonymousInitializer || container2 instanceof IrValueParameter) && (primaryConstructor2 = this.innerClassesSupport.getInnerClassOriginalPrimaryConstructorOrNull(irClass4)) != null) {
            Map oldConstructorParameterToNew = InnerClassesLoweringKt.access$primaryConstructorParameterMap(this.innerClassesSupport, primaryConstructor2);
            IrElementTransformerVoidKt.transformChildrenVoid(irBody, new VariableRemapper(oldConstructorParameterToNew));
        }
        this.fixThisReference(irBody, irClass4, container2);
    }

    private final void fixThisReference(IrBody $this$fixThisReference, IrClass irClass2, IrDeclaration container2) {
        IrBody irBody = $this$fixThisReference;
        boolean bl = false;
        boolean bl2 = false;
        IrBody $this$fixThisReference_u24lambda_u2d0 = irBody;
        boolean bl3 = false;
        IrDeclaration current2 = container2;
        while (current2 != null && !(current2 instanceof IrFunction) && !(current2 instanceof IrClass)) {
            IrDeclarationParent irDeclarationParent = current2.getParent();
            current2 = irDeclarationParent instanceof IrDeclaration ? (IrDeclaration)((Object)irDeclarationParent) : null;
        }
        IrDeclaration enclosingFunction = current2;
        IrElementTransformerVoidKt.transformChildrenVoid($this$fixThisReference, new IrElementTransformerVoidWithContext(this, irClass2, enclosingFunction){
            final /* synthetic */ InnerClassesMemberBodyLowering this$0;
            final /* synthetic */ IrClass $irClass;
            final /* synthetic */ IrDeclaration $enclosingFunction;
            {
                this.this$0 = $receiver;
                this.$irClass = $irClass;
                this.$enclosingFunction = $enclosingFunction;
            }

            @NotNull
            public IrStatement visitClassNew(@NotNull IrClass declaration2) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                return declaration2;
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrClass implicitThisClass = InnerClassesMemberBodyLowering.access$getClassForImplicitThis(this.this$0, expression2.getSymbol());
                if (implicitThisClass == null || Intrinsics.areEqual((Object)implicitThisClass, (Object)this.$irClass)) {
                    return expression2;
                }
                int startOffset = expression2.getStartOffset();
                int endOffset = expression2.getEndOffset();
                IrStatementOrigin origin = expression2.getOrigin();
                Object object2 = this.getCurrentFunction();
                IrElement irElement = object2 == null ? null : ((ScopeWithIr)object2).getIrElement();
                IrElement irElement2 = irElement == null ? (IrElement)this.$enclosingFunction : irElement;
                IrFunction function2 = irElement2 instanceof IrFunction ? (IrFunction)irElement2 : null;
                object2 = function2;
                IrElement irElement3 = irElement = object2 == null ? null : ((IrFunction)object2).getDispatchReceiverParameter();
                if (irElement == null) {
                    object2 = this.$irClass.getThisReceiver();
                    Intrinsics.checkNotNull((Object)object2);
                    object = object2;
                } else {
                    object = irElement;
                }
                IrElement enclosingThisReceiver = object;
                IrExpression irThis = new IrGetValueImpl(startOffset, endOffset, ((IrValueParameter)enclosingThisReceiver).getSymbol(), origin);
                IrClass innerClass = this.$irClass;
                while (!Intrinsics.areEqual((Object)innerClass, (Object)implicitThisClass)) {
                    IrExpression irExpression;
                    if (!innerClass.isInner()) {
                        return expression2;
                    }
                    if (function2 instanceof IrConstructor && Intrinsics.areEqual((Object)this.$irClass, (Object)innerClass)) {
                        irExpression = new IrGetValueImpl(startOffset, endOffset, ((IrConstructor)function2).getValueParameters().get(0).getSymbol(), origin);
                    } else {
                        IrField outerThisField = InnerClassesMemberBodyLowering.access$getInnerClassesSupport$p(this.this$0).getOuterThisField(innerClass);
                        irExpression = new IrGetFieldImpl(startOffset, endOffset, outerThisField.getSymbol(), outerThisField.getType(), irThis, origin, null, 64, null);
                    }
                    irThis = irExpression;
                    innerClass = IrUtilsKt.getParentAsClass(innerClass);
                }
                return irThis;
            }
        });
    }

    public static final /* synthetic */ IrClass access$getClassForImplicitThis(InnerClassesMemberBodyLowering $this, IrValueSymbol $receiver) {
        return $this.getClassForImplicitThis($receiver);
    }

    public static final /* synthetic */ InnerClassesSupport access$getInnerClassesSupport$p(InnerClassesMemberBodyLowering $this) {
        return $this.innerClassesSupport;
    }
}

