/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins.jvm;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.CompanionObjectMapping;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001:B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u0017H\u0002J\u001c\u0010%\u001a\u00020\u001d2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010(\u001a\u00020\u0007H\u0002J\u001c\u0010%\u001a\u00020\u001d2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0014\u0010)\u001a\u00020\u00042\n\u0010*\u001a\u0006\u0012\u0002\b\u00030'H\u0002J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0007J\u0018\u0010.\u001a\u00020,2\u0006\u0010(\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\rH\u0002J\u0010\u00100\u001a\u00020,2\b\u00101\u001a\u0004\u0018\u00010\u0013J\u0010\u00102\u001a\u00020,2\b\u00101\u001a\u0004\u0018\u00010\u0013J\u0010\u00103\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020\u0007J\u0010\u00104\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020\u0007J\u0010\u00105\u001a\u0004\u0018\u00010\u00042\u0006\u0010(\u001a\u00020\u0013J!\u00106\u001a\u00020\u0017\"\u0006\b\u0000\u00107\u0018\u00012\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u0007H\u0082\bJ\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00072\b\u00101\u001a\u0004\u0018\u00010\u0013J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00072\b\u00101\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00070\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00070\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMap;", "", "()V", "CLASS_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "FUNCTION_N_CLASS_ID", "FUNCTION_N_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getFUNCTION_N_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "K_CLASS_CLASS_ID", "K_FUNCTION_CLASS_ID", "NUMBERED_FUNCTION_PREFIX", "", "NUMBERED_K_FUNCTION_PREFIX", "NUMBERED_K_SUSPEND_FUNCTION_PREFIX", "NUMBERED_SUSPEND_FUNCTION_PREFIX", "javaToKotlin", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "kotlinToJava", "mutabilityMappings", "", "Lorg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMap$PlatformMutabilityMapping;", "getMutabilityMappings", "()Ljava/util/List;", "mutableToReadOnly", "readOnlyToMutable", "add", "", "javaClassId", "kotlinClassId", "addJavaToKotlin", "addKotlinToJava", "kotlinFqNameUnsafe", "addMapping", "platformMutabilityMapping", "addTopLevel", "javaClass", "Ljava/lang/Class;", "kotlinFqName", "classId", "clazz", "isJavaPlatformClass", "", "fqName", "isKotlinFunctionWithBigArity", "prefix", "isMutable", "fqNameUnsafe", "isReadOnly", "mapJavaToKotlin", "mapJavaToKotlinIncludingClassMapping", "mapKotlinToJava", "mutabilityMapping", "T", "kotlinReadOnly", "kotlinMutable", "PlatformMutabilityMapping", "compiler.common.jvm"})
public final class JavaToKotlinClassMap {
    @NotNull
    public static final JavaToKotlinClassMap INSTANCE;
    @NotNull
    private static final String NUMBERED_FUNCTION_PREFIX;
    @NotNull
    private static final String NUMBERED_K_FUNCTION_PREFIX;
    @NotNull
    private static final String NUMBERED_SUSPEND_FUNCTION_PREFIX;
    @NotNull
    private static final String NUMBERED_K_SUSPEND_FUNCTION_PREFIX;
    @NotNull
    private static final ClassId FUNCTION_N_CLASS_ID;
    @NotNull
    private static final FqName FUNCTION_N_FQ_NAME;
    @NotNull
    private static final ClassId K_FUNCTION_CLASS_ID;
    @NotNull
    private static final ClassId K_CLASS_CLASS_ID;
    @NotNull
    private static final ClassId CLASS_CLASS_ID;
    @NotNull
    private static final HashMap<FqNameUnsafe, ClassId> javaToKotlin;
    @NotNull
    private static final HashMap<FqNameUnsafe, ClassId> kotlinToJava;
    @NotNull
    private static final HashMap<FqNameUnsafe, FqName> mutableToReadOnly;
    @NotNull
    private static final HashMap<FqNameUnsafe, FqName> readOnlyToMutable;
    @NotNull
    private static final List<PlatformMutabilityMapping> mutabilityMappings;

    private JavaToKotlinClassMap() {
    }

    @NotNull
    public final FqName getFUNCTION_N_FQ_NAME() {
        return FUNCTION_N_FQ_NAME;
    }

    private final /* synthetic */ PlatformMutabilityMapping mutabilityMapping(ClassId kotlinReadOnly, FqName kotlinMutable) {
        FqName fqName2;
        boolean $i$f$mutabilityMapping = false;
        FqName fqName3 = fqName2 = kotlinReadOnly.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"kotlinReadOnly.packageFqName");
        ClassId mutableClassId = new ClassId(fqName3, FqNamesUtilKt.tail(kotlinMutable, fqName2), false);
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return new PlatformMutabilityMapping(this.classId(Object.class), kotlinReadOnly, mutableClassId);
    }

    @NotNull
    public final List<PlatformMutabilityMapping> getMutabilityMappings() {
        return mutabilityMappings;
    }

    @Nullable
    public final ClassId mapJavaToKotlin(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return javaToKotlin.get(fqName2.toUnsafe());
    }

    @Nullable
    public final ClassId mapJavaToKotlinIncludingClassMapping(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        if (Intrinsics.areEqual((Object)fqName2, (Object)CLASS_CLASS_ID.asSingleFqName())) {
            return K_CLASS_CLASS_ID;
        }
        return this.mapJavaToKotlin(fqName2);
    }

    @Nullable
    public final ClassId mapKotlinToJava(@NotNull FqNameUnsafe kotlinFqName) {
        Intrinsics.checkNotNullParameter((Object)kotlinFqName, (String)"kotlinFqName");
        return this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_FUNCTION_PREFIX) ? FUNCTION_N_CLASS_ID : (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_SUSPEND_FUNCTION_PREFIX) ? FUNCTION_N_CLASS_ID : (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_K_FUNCTION_PREFIX) ? K_FUNCTION_CLASS_ID : (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_K_SUSPEND_FUNCTION_PREFIX) ? K_FUNCTION_CLASS_ID : kotlinToJava.get(kotlinFqName))));
    }

    private final boolean isKotlinFunctionWithBigArity(FqNameUnsafe kotlinFqName, String prefix) {
        CharSequence charSequence = kotlinFqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"kotlinFqName.asString()");
        String arityString = StringsKt.substringAfter((String)charSequence, (String)prefix, (String)"");
        charSequence = arityString;
        boolean bl = false;
        if (charSequence.length() > 0 && !StringsKt.startsWith$default((CharSequence)arityString, (char)'0', (boolean)false, (int)2, null)) {
            Integer arity = StringsKt.toIntOrNull((String)arityString);
            return arity != null && arity >= 23;
        }
        return false;
    }

    private final void addMapping(PlatformMutabilityMapping platformMutabilityMapping) {
        PlatformMutabilityMapping platformMutabilityMapping2 = platformMutabilityMapping;
        ClassId javaClassId = platformMutabilityMapping2.component1();
        ClassId readOnlyClassId = platformMutabilityMapping2.component2();
        ClassId mutableClassId = platformMutabilityMapping2.component3();
        this.add(javaClassId, readOnlyClassId);
        FqName fqName2 = mutableClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"mutableClassId.asSingleFqName()");
        this.addKotlinToJava(fqName2, javaClassId);
        FqName fqName3 = readOnlyClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"readOnlyClassId.asSingleFqName()");
        FqName readOnlyFqName = fqName3;
        Object object = mutableClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mutableClassId.asSingleFqName()");
        FqName mutableFqName = object;
        object = mutableToReadOnly;
        FqNameUnsafe fqNameUnsafe = mutableClassId.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"mutableClassId.asSingleFqName().toUnsafe()");
        boolean bl = false;
        object.put(fqNameUnsafe, readOnlyFqName);
        object = readOnlyToMutable;
        fqNameUnsafe = readOnlyFqName.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"readOnlyFqName.toUnsafe()");
        bl = false;
        object.put(fqNameUnsafe, mutableFqName);
    }

    private final void add(ClassId javaClassId, ClassId kotlinClassId) {
        this.addJavaToKotlin(javaClassId, kotlinClassId);
        FqName fqName2 = kotlinClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"kotlinClassId.asSingleFqName()");
        this.addKotlinToJava(fqName2, javaClassId);
    }

    private final void addTopLevel(Class<?> javaClass, FqNameUnsafe kotlinFqName) {
        FqName fqName2 = kotlinFqName.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"kotlinFqName.toSafe()");
        this.addTopLevel(javaClass, fqName2);
    }

    private final void addTopLevel(Class<?> javaClass, FqName kotlinFqName) {
        ClassId classId = this.classId(javaClass);
        ClassId classId2 = ClassId.topLevel(kotlinFqName);
        Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"topLevel(kotlinFqName)");
        this.add(classId, classId2);
    }

    private final void addJavaToKotlin(ClassId javaClassId, ClassId kotlinClassId) {
        Map map = javaToKotlin;
        FqNameUnsafe fqNameUnsafe = javaClassId.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"javaClassId.asSingleFqName().toUnsafe()");
        boolean bl = false;
        map.put(fqNameUnsafe, kotlinClassId);
    }

    private final void addKotlinToJava(FqName kotlinFqNameUnsafe, ClassId javaClassId) {
        Map map = kotlinToJava;
        FqNameUnsafe fqNameUnsafe = kotlinFqNameUnsafe.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"kotlinFqNameUnsafe.toUnsafe()");
        boolean bl = false;
        map.put(fqNameUnsafe, javaClassId);
    }

    public final boolean isJavaPlatformClass(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return this.mapJavaToKotlin(fqName2) != null;
    }

    @Nullable
    public final FqName mutableToReadOnly(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map = mutableToReadOnly;
        boolean bl = false;
        return (FqName)map.get(fqNameUnsafe);
    }

    @Nullable
    public final FqName readOnlyToMutable(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map = readOnlyToMutable;
        boolean bl = false;
        return (FqName)map.get(fqNameUnsafe);
    }

    public final boolean isMutable(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map = mutableToReadOnly;
        boolean bl = false;
        Map map2 = map;
        if (map2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        return map2.containsKey(fqNameUnsafe);
    }

    public final boolean isReadOnly(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map = readOnlyToMutable;
        boolean bl = false;
        Map map2 = map;
        if (map2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        return map2.containsKey(fqNameUnsafe);
    }

    private final ClassId classId(Class<?> clazz) {
        ClassId classId;
        boolean bl = !clazz.isPrimitive() && !clazz.isArray();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus((String)"Invalid class: ", clazz);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        Class<?> outer = clazz.getDeclaringClass();
        if (outer == null) {
            ClassId classId2 = ClassId.topLevel(new FqName(clazz.getCanonicalName()));
            Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"topLevel(FqName(clazz.canonicalName))");
            classId = classId2;
        } else {
            ClassId classId3 = this.classId(outer).createNestedClassId(Name.identifier(clazz.getSimpleName()));
            Intrinsics.checkNotNullExpressionValue((Object)classId3, (String)"classId(outer).createNestedClassId(Name.identifier(clazz.simpleName))");
            classId = classId3;
        }
        return classId;
    }

    static {
        int i;
        JavaToKotlinClassMap this_$iv;
        ClassId kotlinReadOnly$iv;
        Object object;
        INSTANCE = new JavaToKotlinClassMap();
        NUMBERED_FUNCTION_PREFIX = FunctionClassKind.Function.getPackageFqName().toString() + '.' + FunctionClassKind.Function.getClassNamePrefix();
        NUMBERED_K_FUNCTION_PREFIX = FunctionClassKind.KFunction.getPackageFqName().toString() + '.' + FunctionClassKind.KFunction.getClassNamePrefix();
        NUMBERED_SUSPEND_FUNCTION_PREFIX = FunctionClassKind.SuspendFunction.getPackageFqName().toString() + '.' + FunctionClassKind.SuspendFunction.getClassNamePrefix();
        NUMBERED_K_SUSPEND_FUNCTION_PREFIX = FunctionClassKind.KSuspendFunction.getPackageFqName().toString() + '.' + FunctionClassKind.KSuspendFunction.getClassNamePrefix();
        Object object2 = ClassId.topLevel(new FqName("kotlin.jvm.functions.FunctionN"));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"topLevel(FqName(\"kotlin.jvm.functions.FunctionN\"))");
        FUNCTION_N_CLASS_ID = object2;
        object2 = FUNCTION_N_CLASS_ID.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"FUNCTION_N_CLASS_ID.asSingleFqName()");
        FUNCTION_N_FQ_NAME = object2;
        object2 = ClassId.topLevel(new FqName("kotlin.reflect.KFunction"));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"topLevel(FqName(\"kotlin.reflect.KFunction\"))");
        K_FUNCTION_CLASS_ID = object2;
        object2 = ClassId.topLevel(new FqName("kotlin.reflect.KClass"));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"topLevel(FqName(\"kotlin.reflect.KClass\"))");
        K_CLASS_CLASS_ID = object2;
        CLASS_CLASS_ID = INSTANCE.classId(Class.class);
        javaToKotlin = new HashMap();
        kotlinToJava = new HashMap();
        mutableToReadOnly = new HashMap();
        readOnlyToMutable = new HashMap();
        object2 = new PlatformMutabilityMapping[8];
        JavaToKotlinClassMap javaToKotlinClassMap = INSTANCE;
        ClassId classId = ClassId.topLevel(StandardNames.FqNames.iterable);
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(FqNames.iterable)");
        FqName kotlinMutable$iv = StandardNames.FqNames.mutableIterable;
        boolean $i$f$mutabilityMapping = false;
        FqName fqName2 = object = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kotlinReadOnly.packageFqName");
        ClassId mutableClassId$iv = new ClassId(fqName2, FqNamesUtilKt.tail(kotlinMutable$iv, object), false);
        object2[0] = new PlatformMutabilityMapping(this_$iv.classId(Iterable.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.topLevel(StandardNames.FqNames.iterator);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"topLevel(FqNames.iterator)");
        kotlinMutable$iv = StandardNames.FqNames.mutableIterator;
        $i$f$mutabilityMapping = false;
        FqName fqName3 = object = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName3, FqNamesUtilKt.tail(kotlinMutable$iv, object), false);
        object2[1] = new PlatformMutabilityMapping(this_$iv.classId(Iterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.topLevel(StandardNames.FqNames.collection);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"topLevel(FqNames.collection)");
        kotlinMutable$iv = StandardNames.FqNames.mutableCollection;
        $i$f$mutabilityMapping = false;
        FqName fqName4 = object = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName4, FqNamesUtilKt.tail(kotlinMutable$iv, object), false);
        object2[2] = new PlatformMutabilityMapping(this_$iv.classId(Collection.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.topLevel(StandardNames.FqNames.list);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"topLevel(FqNames.list)");
        kotlinMutable$iv = StandardNames.FqNames.mutableList;
        $i$f$mutabilityMapping = false;
        FqName fqName5 = object = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName5, FqNamesUtilKt.tail(kotlinMutable$iv, object), false);
        object2[3] = new PlatformMutabilityMapping(this_$iv.classId(List.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.topLevel(StandardNames.FqNames.set);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"topLevel(FqNames.set)");
        kotlinMutable$iv = StandardNames.FqNames.mutableSet;
        $i$f$mutabilityMapping = false;
        FqName fqName6 = object = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName6, FqNamesUtilKt.tail(kotlinMutable$iv, object), false);
        object2[4] = new PlatformMutabilityMapping(this_$iv.classId(Set.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.topLevel(StandardNames.FqNames.listIterator);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"topLevel(FqNames.listIterator)");
        kotlinMutable$iv = StandardNames.FqNames.mutableListIterator;
        $i$f$mutabilityMapping = false;
        FqName fqName7 = object = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName7, FqNamesUtilKt.tail(kotlinMutable$iv, object), false);
        object2[5] = new PlatformMutabilityMapping(this_$iv.classId(ListIterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.topLevel(StandardNames.FqNames.map);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"topLevel(FqNames.map)");
        kotlinMutable$iv = StandardNames.FqNames.mutableMap;
        $i$f$mutabilityMapping = false;
        FqName fqName8 = object = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName8, FqNamesUtilKt.tail(kotlinMutable$iv, object), false);
        object2[6] = new PlatformMutabilityMapping(this_$iv.classId(Map.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.topLevel(StandardNames.FqNames.map).createNestedClassId(StandardNames.FqNames.mapEntry.shortName());
        Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"topLevel(FqNames.map).createNestedClassId(FqNames.mapEntry.shortName())");
        kotlinMutable$iv = StandardNames.FqNames.mutableMapEntry;
        $i$f$mutabilityMapping = false;
        FqName fqName9 = object = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName9, FqNamesUtilKt.tail(kotlinMutable$iv, object), false);
        object2[7] = new PlatformMutabilityMapping(this_$iv.classId(Map.Entry.class), kotlinReadOnly$iv, mutableClassId$iv);
        mutabilityMappings = CollectionsKt.listOf((Object[])object2);
        INSTANCE.addTopLevel(Object.class, StandardNames.FqNames.any);
        INSTANCE.addTopLevel(String.class, StandardNames.FqNames.string);
        INSTANCE.addTopLevel(CharSequence.class, StandardNames.FqNames.charSequence);
        INSTANCE.addTopLevel(Throwable.class, StandardNames.FqNames.throwable);
        INSTANCE.addTopLevel(Cloneable.class, StandardNames.FqNames.cloneable);
        INSTANCE.addTopLevel(Number.class, StandardNames.FqNames.number);
        INSTANCE.addTopLevel(Comparable.class, StandardNames.FqNames.comparable);
        INSTANCE.addTopLevel(Enum.class, StandardNames.FqNames._enum);
        INSTANCE.addTopLevel(Annotation.class, StandardNames.FqNames.annotation);
        for (PlatformMutabilityMapping platformCollection : mutabilityMappings) {
            INSTANCE.addMapping(platformCollection);
        }
        for (JvmPrimitiveType jvmType : JvmPrimitiveType.values()) {
            ClassId classId2 = ClassId.topLevel(jvmType.getWrapperFqName());
            Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"topLevel(jvmType.wrapperFqName)");
            ClassId classId3 = classId2;
            object = jvmType.getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jvmType.primitiveType");
            classId2 = ClassId.topLevel(StandardNames.getPrimitiveFqName((PrimitiveType)((Object)object)));
            Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"topLevel(StandardNames.getPrimitiveFqName(jvmType.primitiveType))");
            INSTANCE.add(classId3, classId2);
        }
        for (ClassId classId4 : CompanionObjectMapping.INSTANCE.allClassesWithIntrinsicCompanions()) {
            kotlinReadOnly$iv = ClassId.topLevel(new FqName("kotlin.jvm.internal." + classId4.getShortClassName().asString() + "CompanionObject"));
            Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"topLevel(FqName(\"kotlin.jvm.internal.\" + classId.shortClassName.asString() + \"CompanionObject\"))");
            ClassId classId5 = kotlinReadOnly$iv;
            kotlinReadOnly$iv = classId4.createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"classId.createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT)");
            INSTANCE.add(classId5, kotlinReadOnly$iv);
        }
        int n = 0;
        do {
            i = n++;
            kotlinReadOnly$iv = ClassId.topLevel(new FqName(Intrinsics.stringPlus((String)"kotlin.jvm.functions.Function", (Object)i)));
            Intrinsics.checkNotNullExpressionValue((Object)kotlinReadOnly$iv, (String)"topLevel(FqName(\"kotlin.jvm.functions.Function$i\"))");
            INSTANCE.add(kotlinReadOnly$iv, StandardNames.getFunctionClassId(i));
            INSTANCE.addKotlinToJava(new FqName(Intrinsics.stringPlus((String)NUMBERED_K_FUNCTION_PREFIX, (Object)i)), K_FUNCTION_CLASS_ID);
        } while (n < 23);
        n = 0;
        do {
            i = n++;
            FunctionClassKind kSuspendFunction = FunctionClassKind.KSuspendFunction;
            String kSuspendFun = kSuspendFunction.getPackageFqName().toString() + '.' + kSuspendFunction.getClassNamePrefix();
            INSTANCE.addKotlinToJava(new FqName(Intrinsics.stringPlus((String)kSuspendFun, (Object)i)), K_FUNCTION_CLASS_ID);
        } while (n < 22);
        FqName fqName10 = StandardNames.FqNames.nothing.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName10, (String)"nothing.toSafe()");
        INSTANCE.addKotlinToJava(fqName10, INSTANCE.classId(Void.class));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMap$PlatformMutabilityMapping;", "", "javaClass", "Lorg/jetbrains/kotlin/name/ClassId;", "kotlinReadOnly", "kotlinMutable", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/name/ClassId;)V", "getJavaClass", "()Lorg/jetbrains/kotlin/name/ClassId;", "getKotlinMutable", "getKotlinReadOnly", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "compiler.common.jvm"})
    public static final class PlatformMutabilityMapping {
        @NotNull
        private final ClassId javaClass;
        @NotNull
        private final ClassId kotlinReadOnly;
        @NotNull
        private final ClassId kotlinMutable;

        public PlatformMutabilityMapping(@NotNull ClassId javaClass, @NotNull ClassId kotlinReadOnly, @NotNull ClassId kotlinMutable) {
            Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
            Intrinsics.checkNotNullParameter((Object)kotlinReadOnly, (String)"kotlinReadOnly");
            Intrinsics.checkNotNullParameter((Object)kotlinMutable, (String)"kotlinMutable");
            this.javaClass = javaClass;
            this.kotlinReadOnly = kotlinReadOnly;
            this.kotlinMutable = kotlinMutable;
        }

        @NotNull
        public final ClassId getJavaClass() {
            return this.javaClass;
        }

        @NotNull
        public final ClassId getKotlinReadOnly() {
            return this.kotlinReadOnly;
        }

        @NotNull
        public final ClassId getKotlinMutable() {
            return this.kotlinMutable;
        }

        @NotNull
        public final ClassId component1() {
            return this.javaClass;
        }

        @NotNull
        public final ClassId component2() {
            return this.kotlinReadOnly;
        }

        @NotNull
        public final ClassId component3() {
            return this.kotlinMutable;
        }

        @NotNull
        public final PlatformMutabilityMapping copy(@NotNull ClassId javaClass, @NotNull ClassId kotlinReadOnly, @NotNull ClassId kotlinMutable) {
            Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
            Intrinsics.checkNotNullParameter((Object)kotlinReadOnly, (String)"kotlinReadOnly");
            Intrinsics.checkNotNullParameter((Object)kotlinMutable, (String)"kotlinMutable");
            return new PlatformMutabilityMapping(javaClass, kotlinReadOnly, kotlinMutable);
        }

        public static /* synthetic */ PlatformMutabilityMapping copy$default(PlatformMutabilityMapping platformMutabilityMapping, ClassId classId, ClassId classId2, ClassId classId3, int n, Object object) {
            if ((n & 1) != 0) {
                classId = platformMutabilityMapping.javaClass;
            }
            if ((n & 2) != 0) {
                classId2 = platformMutabilityMapping.kotlinReadOnly;
            }
            if ((n & 4) != 0) {
                classId3 = platformMutabilityMapping.kotlinMutable;
            }
            return platformMutabilityMapping.copy(classId, classId2, classId3);
        }

        @NotNull
        public String toString() {
            return "PlatformMutabilityMapping(javaClass=" + this.javaClass + ", kotlinReadOnly=" + this.kotlinReadOnly + ", kotlinMutable=" + this.kotlinMutable + ')';
        }

        public int hashCode() {
            int result2 = this.javaClass.hashCode();
            result2 = result2 * 31 + this.kotlinReadOnly.hashCode();
            result2 = result2 * 31 + this.kotlinMutable.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PlatformMutabilityMapping)) {
                return false;
            }
            PlatformMutabilityMapping platformMutabilityMapping = (PlatformMutabilityMapping)other;
            if (!Intrinsics.areEqual((Object)this.javaClass, (Object)platformMutabilityMapping.javaClass)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.kotlinReadOnly, (Object)platformMutabilityMapping.kotlinReadOnly)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.kotlinMutable, (Object)platformMutabilityMapping.kotlinMutable);
        }
    }
}

