/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.util.Logger;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a>\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0010\u00a8\u0006\u0014"}, d2={"checkKotlinPackageUsage", "", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "getLibraryFromHome", "Ljava/io/File;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "getLibrary", "Lkotlin/Function1;", "libraryName", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "noLibraryArgument", "toLogger", "Lorg/jetbrains/kotlin/util/Logger;", "cli"})
public final class UtilsKt {
    public static final boolean checkKotlinPackageUsage(@NotNull KotlinCoreEnvironment environment2, @NotNull Collection<? extends KtFile> files2) {
        Intrinsics.checkParameterIsNotNull((Object)environment2, (String)"environment");
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        if (environment2.getConfiguration().getBoolean(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE)) {
            return true;
        }
        MessageCollector messageCollector2 = environment2.getConfiguration().get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.Companion.getNONE());
        Intrinsics.checkExpressionValueIsNotNull((Object)messageCollector2, (String)"environment.configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.NONE)");
        MessageCollector messageCollector3 = messageCollector2;
        FqName kotlinPackage = new FqName("kotlin");
        for (KtFile ktFile : files2) {
            if (!FqNamesUtilKt.isSubpackageOf(ktFile.getPackageFqName(), kotlinPackage)) continue;
            KtPackageDirective ktPackageDirective = ktFile.getPackageDirective();
            if (ktPackageDirective == null) {
                Intrinsics.throwNpe();
            }
            messageCollector3.report(CompilerMessageSeverity.ERROR, "Only the Kotlin standard library is allowed to use the 'kotlin' package", MessageUtil.psiElementToMessageLocation(ktPackageDirective));
            return false;
        }
        return true;
    }

    @Nullable
    public static final File getLibraryFromHome(@Nullable KotlinPaths paths, @NotNull Function1<? super KotlinPaths, ? extends File> getLibrary, @NotNull String libraryName2, @NotNull MessageCollector messageCollector2, @NotNull String noLibraryArgument) {
        File stdlibJar;
        Intrinsics.checkParameterIsNotNull(getLibrary, (String)"getLibrary");
        Intrinsics.checkParameterIsNotNull((Object)libraryName2, (String)"libraryName");
        Intrinsics.checkParameterIsNotNull((Object)messageCollector2, (String)"messageCollector");
        Intrinsics.checkParameterIsNotNull((Object)noLibraryArgument, (String)"noLibraryArgument");
        if (paths != null && (stdlibJar = (File)getLibrary.invoke((Object)paths)).exists()) {
            return stdlibJar;
        }
        messageCollector2.report(CompilerMessageSeverity.STRONG_WARNING, "Unable to find " + libraryName2 + " in the Kotlin home directory. Pass either " + noLibraryArgument + " to prevent adding it to the classpath, or the correct '-kotlin-home'", null);
        return null;
    }

    @NotNull
    public static final Logger toLogger(@NotNull MessageCollector $this$toLogger) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toLogger, (String)"<this>");
        return new Logger($this$toLogger){
            final /* synthetic */ MessageCollector $this_toLogger;
            {
                this.$this_toLogger = $receiver;
            }

            public void error(@NotNull String message2) {
                Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
                MessageCollector.DefaultImpls.report$default(this.$this_toLogger, CompilerMessageSeverity.ERROR, message2, null, 4, null);
            }

            @NotNull
            public Void fatal(@NotNull String message2) {
                Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
                MessageCollector.DefaultImpls.report$default(this.$this_toLogger, CompilerMessageSeverity.ERROR, message2, null, 4, null);
                int n = 1;
                boolean bl = false;
                System.exit(n);
                throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }

            public void warning(@NotNull String message2) {
                Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
                MessageCollector.DefaultImpls.report$default(this.$this_toLogger, CompilerMessageSeverity.WARNING, message2, null, 4, null);
            }

            public void log(@NotNull String message2) {
                Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
                MessageCollector.DefaultImpls.report$default(this.$this_toLogger, CompilerMessageSeverity.LOGGING, message2, null, 4, null);
            }
        };
    }
}

