/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTable;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTables;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.backend.js.utils.ParameterTypeBasedSignature;
import org.jetbrains.kotlin.ir.backend.js.utils.Signature;
import org.jetbrains.kotlin.ir.backend.js.utils.StableNameSignature;
import org.jetbrains.kotlin.ir.backend.js.utils.StableNamesCollector;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00015BW\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u0006\u0010\u001d\u001a\u00020\u0007J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u0010\u0010$\u001a\u0004\u0018\u00010\u00072\u0006\u0010%\u001a\u00020\u0015J\u000e\u0010&\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\"J\u000e\u0010)\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020*J\"\u0010+\u001a\u00020\u001b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\b\u0010.\u001a\u00020/H\u0002J8\u00100\u001a\u00020\u001b\"\u0004\b\u0000\u00101\"\u0004\b\u0001\u00102*\u000e\u0012\u0004\u0012\u0002H1\u0012\u0004\u0012\u0002H20\n2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u0002H1\u0012\u0004\u0012\u0002H204H\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTables;", "", "packages", "", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "reservedForGlobal", "", "", "reservedForMember", "mappedNames", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Ljava/util/List;Ljava/util/Set;Ljava/util/Set;Ljava/util/Map;Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "globalNames", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getGlobalNames", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "localNames", "loopNames", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "getMappedNames", "()Ljava/util/Map;", "memberNames", "Lorg/jetbrains/kotlin/ir/backend/js/utils/Signature;", "acceptDeclaration", "", "declaration", "dump", "generateNameForMemberField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "generateNameForMemberFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "generateNamesForTopLevelDecl", "getNameForLoop", "loop", "getNameForMemberField", "getNameForMemberFunction", "function", "getNameForStaticDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "merge", "files", "additionalPackages", "packagesAdded", "", "addAllIfAbsent", "T", "K", "other", "", "LocalNameGenerator", "backend.js"})
public final class NameTables {
    @Nullable
    private final Map<String, String> mappedNames;
    @Nullable
    private final JsIrBackendContext context;
    @NotNull
    private final NameTable<IrDeclaration> globalNames;
    @NotNull
    private final NameTable<Signature> memberNames;
    @NotNull
    private final Map<IrDeclaration, NameTable<IrDeclaration>> localNames;
    @NotNull
    private final Map<IrLoop, String> loopNames;

    public NameTables(@NotNull List<? extends IrPackageFragment> packages2, @NotNull Set<String> reservedForGlobal, @NotNull Set<String> reservedForMember, @Nullable Map<String, String> mappedNames, @Nullable JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(packages2, (String)"packages");
        Intrinsics.checkNotNullParameter(reservedForGlobal, (String)"reservedForGlobal");
        Intrinsics.checkNotNullParameter(reservedForMember, (String)"reservedForMember");
        this.mappedNames = mappedNames;
        this.context = context2;
        boolean bl = false;
        this.localNames = new LinkedHashMap();
        bl = false;
        this.loopNames = new LinkedHashMap();
        StableNamesCollector stableNamesCollector = new StableNamesCollector();
        Iterable $this$forEach$iv = packages2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrPackageFragment it = (IrPackageFragment)element$iv;
            boolean bl2 = false;
            IrElementVisitorVoidKt.acceptChildrenVoid(it, stableNamesCollector);
        }
        this.globalNames = new NameTable(null, CollectionsKt.toMutableSet((Iterable)SetsKt.plus(stableNamesCollector.getStaticNames(), (Iterable)reservedForGlobal)), null, this.mappedNames, 5, null);
        this.memberNames = new NameTable(null, CollectionsKt.toMutableSet((Iterable)SetsKt.plus(stableNamesCollector.getMemberNames(), (Iterable)reservedForMember)), null, this.mappedNames, 5, null);
        boolean bl3 = false;
        List classDeclaration = new ArrayList();
        for (IrPackageFragment irPackageFragment : packages2) {
            for (IrDeclaration declaration2 : irPackageFragment.getDeclarations()) {
                this.generateNamesForTopLevelDecl(declaration2);
                if (!(declaration2 instanceof IrScript)) continue;
                for (IrStatement memberDecl : ((IrScript)declaration2).getStatements()) {
                    if (!(memberDecl instanceof IrDeclaration)) continue;
                    this.generateNamesForTopLevelDecl((IrDeclaration)memberDecl);
                    if (!(memberDecl instanceof IrClass)) continue;
                    Collection collection = classDeclaration;
                    IrStatement irStatement = memberDecl;
                    boolean bl2 = false;
                    collection.add(irStatement);
                }
            }
        }
        this.globalNames.setFinished(true);
        for (IrClass irClass2 : classDeclaration) {
            this.acceptDeclaration(irClass2);
        }
        for (IrPackageFragment irPackageFragment : packages2) {
            for (IrDeclaration declaration2 : irPackageFragment.getDeclarations()) {
                this.acceptDeclaration(declaration2);
            }
        }
    }

    public /* synthetic */ NameTables(List list2, Set set, Set set2, Map map, JsIrBackendContext jsIrBackendContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean bl;
        if ((n & 2) != 0) {
            bl = false;
            set = new LinkedHashSet();
        }
        if ((n & 4) != 0) {
            bl = false;
            set2 = new LinkedHashSet();
        }
        if ((n & 8) != 0) {
            map = null;
        }
        if ((n & 0x10) != 0) {
            jsIrBackendContext = null;
        }
        this(list2, set, set2, map, jsIrBackendContext);
    }

    @Nullable
    public final Map<String, String> getMappedNames() {
        return this.mappedNames;
    }

    @NotNull
    public final NameTable<IrDeclaration> getGlobalNames() {
        return this.globalNames;
    }

    private final void acceptDeclaration(IrDeclaration declaration2) {
        LocalNameGenerator localNameGenerator = new LocalNameGenerator(declaration2);
        if (declaration2 instanceof IrClass) {
            if (IrUtilsKt.isEffectivelyExternal(declaration2)) {
                IrElementVisitorVoidKt.acceptChildrenVoid(declaration2, new IrElementVisitorVoid(this){
                    final /* synthetic */ NameTables this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void visitElement(@NotNull IrElement element) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
                    }

                    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
                        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                        IrDeclarationParent parent2 = declaration2.getParent();
                        if (parent2 instanceof IrClass && !IrUtilsKt.isEnumClass((IrClass)parent2)) {
                            NameTables.access$generateNameForMemberFunction(this.this$0, declaration2);
                        }
                    }

                    public void visitField(@NotNull IrField declaration2) {
                        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                        IrDeclarationParent parent2 = declaration2.getParent();
                        if (parent2 instanceof IrClass && !IrUtilsKt.isEnumClass((IrClass)parent2)) {
                            NameTables.access$generateNameForMemberField(this.this$0, declaration2);
                        }
                    }

                    public <T> void visitConst(@NotNull IrConst<T> expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
                    }

                    public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
                    }

                    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
                    }

                    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
                    }

                    public void visitBlock(@NotNull IrBlock expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
                    }

                    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
                    }

                    public void visitBlockBody(@NotNull IrBlockBody body2) {
                        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
                    }

                    public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
                    }

                    public void visitBody(@NotNull IrBody body2) {
                        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
                    }

                    public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
                    }

                    public void visitBranch(@NotNull IrBranch branch) {
                        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
                    }

                    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
                    }

                    public void visitBreak(@NotNull IrBreak jump) {
                        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
                    }

                    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
                    }

                    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
                    }

                    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
                    }

                    public void visitCall(@NotNull IrCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
                    }

                    public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
                    }

                    public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
                    }

                    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
                    }

                    public void visitCatch(@NotNull IrCatch aCatch) {
                        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
                    }

                    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
                    }

                    public void visitClass(@NotNull IrClass declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
                    }

                    public void visitClass(@NotNull IrClass declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
                    }

                    public void visitClassReference(@NotNull IrClassReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
                    }

                    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
                    }

                    public void visitComposite(@NotNull IrComposite expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
                    }

                    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
                    }

                    public void visitConstructor(@NotNull IrConstructor declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
                    }

                    public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
                    }

                    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
                    }

                    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
                    }

                    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
                    }

                    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
                    }

                    public void visitContinue(@NotNull IrContinue jump) {
                        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
                    }

                    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
                    }

                    public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
                    }

                    public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
                    }

                    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
                    }

                    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
                    }

                    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
                    }

                    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
                    }

                    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
                    }

                    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
                    }

                    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
                    }

                    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
                    }

                    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
                    }

                    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
                    }

                    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
                    }

                    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
                    }

                    public void visitElement(@NotNull IrElement element, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
                    }

                    public void visitElseBranch(@NotNull IrElseBranch branch) {
                        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
                    }

                    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
                    }

                    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
                    }

                    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
                    }

                    public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
                    }

                    public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
                    }

                    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
                    }

                    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
                    }

                    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
                    }

                    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
                    }

                    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
                    }

                    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
                    }

                    public void visitExpression(@NotNull IrExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
                    }

                    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
                    }

                    public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
                    }

                    public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
                    }

                    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
                    }

                    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
                    }

                    public void visitField(@NotNull IrField declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
                    }

                    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
                    }

                    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
                    }

                    public void visitFile(@NotNull IrFile declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
                    }

                    public void visitFile(@NotNull IrFile declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
                    }

                    public void visitFunction(@NotNull IrFunction declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
                    }

                    public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
                    }

                    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
                    }

                    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
                    }

                    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
                    }

                    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
                    }

                    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
                    }

                    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
                    }

                    public void visitGetClass(@NotNull IrGetClass expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
                    }

                    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
                    }

                    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
                    }

                    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
                    }

                    public void visitGetField(@NotNull IrGetField expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
                    }

                    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
                    }

                    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
                    }

                    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
                    }

                    public void visitGetValue(@NotNull IrGetValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
                    }

                    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
                    }

                    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
                    }

                    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
                    }

                    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
                    }

                    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
                    }

                    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
                    }

                    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
                    }

                    public void visitLoop(@NotNull IrLoop loop2) {
                        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
                    }

                    public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
                    }

                    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
                    }

                    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
                    }

                    public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
                    }

                    public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
                    }

                    public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
                    }

                    public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
                    }

                    public void visitProperty(@NotNull IrProperty declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
                    }

                    public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
                    }

                    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
                    }

                    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
                    }

                    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
                    }

                    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
                    }

                    public void visitReturn(@NotNull IrReturn expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
                    }

                    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
                    }

                    public void visitScript(@NotNull IrScript declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
                    }

                    public void visitScript(@NotNull IrScript declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data);
                    }

                    public void visitSetField(@NotNull IrSetField expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
                    }

                    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
                    }

                    public void visitSetValue(@NotNull IrSetValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
                    }

                    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
                    }

                    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
                    }

                    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
                    }

                    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
                    }

                    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
                    }

                    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
                    }

                    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
                    }

                    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
                    }

                    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
                    }

                    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
                    }

                    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
                    }

                    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
                    }

                    public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
                    }

                    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
                    }

                    public void visitThrow(@NotNull IrThrow expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
                    }

                    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
                    }

                    public void visitTry(@NotNull IrTry aTry) {
                        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
                    }

                    public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
                    }

                    public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
                    }

                    public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data);
                    }

                    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
                    }

                    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
                    }

                    public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
                    }

                    public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
                    }

                    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
                    }

                    public void visitValueParameter(@NotNull IrValueParameter declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
                    }

                    public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
                    }

                    public void visitVararg(@NotNull IrVararg expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
                    }

                    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
                    }

                    public void visitVariable(@NotNull IrVariable declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
                    }

                    public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
                    }

                    public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
                    }

                    public void visitWhen(@NotNull IrWhen expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
                    }

                    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
                    }

                    public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
                    }

                    public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
                    }
                });
            } else {
                IrValueParameter irValueParameter = ((IrClass)declaration2).getThisReceiver();
                Intrinsics.checkNotNull((Object)irValueParameter);
                IrElementVisitorVoidKt.acceptVoid(irValueParameter, localNameGenerator);
                for (IrDeclaration memberDecl : ((IrClass)declaration2).getDeclarations()) {
                    IrElementVisitorVoidKt.acceptChildrenVoid(memberDecl, new LocalNameGenerator(memberDecl));
                    IrDeclaration irDeclaration2 = memberDecl;
                    if (irDeclaration2 instanceof IrSimpleFunction) {
                        this.generateNameForMemberFunction((IrSimpleFunction)memberDecl);
                        continue;
                    }
                    if (!(irDeclaration2 instanceof IrField)) continue;
                    this.generateNameForMemberField((IrField)memberDecl);
                }
            }
        } else {
            IrElementVisitorVoidKt.acceptChildrenVoid(declaration2, localNameGenerator);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <T, K> void addAllIfAbsent(Map<T, K> $this$addAllIfAbsent, Map<T, ? extends K> other) {
        void $this$filterTo$iv$iv;
        Map<T, K> map = $this$addAllIfAbsent;
        Map<T, ? extends K> $this$filter$iv = other;
        boolean $i$f$filter = false;
        Map<T, ? extends K> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var9_9 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var9_9.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            Map<T, K> map3 = $this$addAllIfAbsent;
            Object k = it.getKey();
            boolean bl3 = false;
            Map<T, K> map4 = map3;
            boolean bl4 = false;
            boolean bl5 = !map4.containsKey(k);
            if (!bl5) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map map5 = destination$iv$iv;
        boolean bl6 = false;
        map.putAll(map5);
    }

    private final boolean packagesAdded() {
        Map<String, String> map = this.mappedNames;
        boolean bl = false;
        boolean bl2 = false;
        return map == null || map.isEmpty();
    }

    public final void merge(@NotNull List<? extends IrPackageFragment> files2, @NotNull List<? extends IrPackageFragment> additionalPackages) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter(additionalPackages, (String)"additionalPackages");
        boolean bl = false;
        List list2 = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List it = list2;
        boolean bl4 = false;
        it.addAll((Collection)files2);
        List packages2 = list2;
        if (this.packagesAdded()) {
            packages2.addAll((Collection)additionalPackages);
        }
        NameTables table = new NameTables(packages2, this.globalNames.getReserved(), this.memberNames.getReserved(), this.mappedNames, this.context);
        this.addAllIfAbsent(this.globalNames.getNames(), table.globalNames.getNames());
        this.addAllIfAbsent(this.memberNames.getNames(), table.memberNames.getNames());
        this.addAllIfAbsent(this.localNames, table.localNames);
        this.addAllIfAbsent(this.loopNames, table.loopNames);
        this.globalNames.getReserved().addAll((Collection<String>)table.globalNames.getReserved());
        this.memberNames.getReserved().addAll((Collection<String>)table.memberNames.getReserved());
    }

    private final void generateNameForMemberField(IrField field) {
        boolean bl = !org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isTopLevel(field);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        bl = !field.isStatic();
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string3 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        Signature signature2 = NameTablesKt.fieldSignature(field);
        if (IrUtilsKt.isEffectivelyExternal(field)) {
            String string4 = field.getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"field.name.identifier");
            this.memberNames.declareStableName(signature2, string4);
        } else {
            String string5 = field.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"field.name.asString()");
            this.memberNames.declareFreshName(signature2, Intrinsics.stringPlus((String)"_", (Object)NameTablesKt.sanitizeName(string5)));
        }
    }

    private final void generateNameForMemberFunction(IrSimpleFunction declaration2) {
        Signature signature2 = NameTablesKt.jsFunctionSignature(declaration2, this.context);
        if (signature2 instanceof StableNameSignature) {
            this.memberNames.declareStableName(signature2, ((StableNameSignature)signature2).getName());
        } else if (signature2 instanceof ParameterTypeBasedSignature) {
            this.memberNames.declareFreshName(signature2, ((ParameterTypeBasedSignature)signature2).getSuggestedName());
        }
    }

    @NotNull
    public final String dump() {
        String local2 = CollectionsKt.joinToString$default((Iterable)MapsKt.toList(this.localNames), (CharSequence)"\n", null, null, (int)0, null, (Function1)dump.local.1.INSTANCE, (int)30, null);
        return "Global names:\n" + NameTablesKt.dump(this.globalNames) + "\nLocal names:\n" + local2 + '\n';
    }

    @NotNull
    public final String getNameForStaticDeclaration(@NotNull IrDeclarationWithName declaration2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        String global = this.globalNames.getNames().get(declaration2);
        if (global != null) {
            return global;
        }
        IrDeclarationParent parent2 = declaration2.getParent();
        while (parent2 instanceof IrDeclaration) {
            String localName;
            NameTable<IrDeclaration> parentLocalNames = this.localNames.get(parent2);
            if (parentLocalNames != null && (localName = parentLocalNames.getNames().get(declaration2)) != null) {
                return localName;
            }
            parent2 = ((IrDeclaration)((Object)parent2)).getParent();
        }
        Map<String, String> map = this.mappedNames;
        if (map != null && (string2 = map.get(NameTablesKt.access$mapToKey(declaration2))) != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            return it;
        }
        map = Intrinsics.stringPlus((String)"Can't find name for declaration ", (Object)RenderIrElementKt.render(declaration2));
        boolean bl = false;
        throw (Throwable)new IllegalStateException(map.toString());
    }

    @NotNull
    public final String getNameForMemberField(@NotNull IrField field) {
        String name2;
        Map<String, String> map;
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Signature signature2 = NameTablesKt.fieldSignature(field);
        String string2 = this.memberNames.getNames().get(signature2);
        Object object = string2 == null ? ((map = this.mappedNames) == null ? null : map.get(NameTablesKt.access$mapToKey(signature2))) : (name2 = string2);
        if (name2 == null) {
            string2 = field.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"field.name.asString()");
            return Intrinsics.stringPlus((String)NameTablesKt.sanitizeName(string2), (Object)"__error");
        }
        return name2;
    }

    @NotNull
    public final String getNameForMemberFunction(@NotNull IrSimpleFunction function2) {
        String name2;
        Map<String, String> map;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Signature signature2 = NameTablesKt.jsFunctionSignature(function2, this.context);
        String string2 = this.memberNames.getNames().get(signature2);
        Object object = string2 == null ? ((map = this.mappedNames) == null ? null : map.get(NameTablesKt.access$mapToKey(signature2))) : (name2 = string2);
        if (name2 == null) {
            string2 = function2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"function.name.asString()");
            return Intrinsics.stringPlus((String)NameTablesKt.sanitizeName(string2), (Object)"__error");
        }
        return name2;
    }

    private final void generateNamesForTopLevelDecl(IrDeclaration declaration2) {
        if (!(declaration2 instanceof IrDeclarationWithName)) {
            return;
        }
        if (IrUtilsKt.isEffectivelyExternal(declaration2) && (AnnotationUtilsKt.getJsModule(declaration2) == null || AnnotationUtilsKt.isJsNonModule(declaration2))) {
            if (AnnotationUtilsKt.getJsModule(IrUtilsKt.getFile(declaration2)) != null) {
                String string2 = ((IrDeclarationWithName)declaration2).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"declaration.name.asString()");
                this.globalNames.declareFreshName(declaration2, string2);
            } else {
                String string3 = AnnotationUtilsKt.getJsNameOrKotlinName((IrDeclarationWithName)declaration2).getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"declaration.getJsNameOrKotlinName().identifier");
                this.globalNames.declareStableName(declaration2, string3);
            }
        } else {
            String string4 = ((IrDeclarationWithName)declaration2).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"declaration.name.asString()");
            this.globalNames.declareFreshName(declaration2, string4);
        }
    }

    @Nullable
    public final String getNameForLoop(@NotNull IrLoop loop2) {
        Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
        return this.loopNames.get(loop2);
    }

    public static final /* synthetic */ void access$generateNameForMemberFunction(NameTables $this, IrSimpleFunction declaration2) {
        $this.generateNameForMemberFunction(declaration2);
    }

    public static final /* synthetic */ void access$generateNameForMemberField(NameTables $this, IrField field) {
        $this.generateNameForMemberField(field);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTables$LocalNameGenerator;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "parentDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "(Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTables;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "breakableDeque", "Ljava/util/Deque;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "localLoopNames", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "table", "getTable", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "persistLoopName", "", "label", "", "loop", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "visitDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitLoop", "visitWhen", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "backend.js"})
    public final class LocalNameGenerator
    implements IrElementVisitorVoid {
        @NotNull
        private final NameTable<IrDeclaration> table;
        @NotNull
        private final Deque<IrExpression> breakableDeque;
        @NotNull
        private final NameTable<IrLoop> localLoopNames;

        public LocalNameGenerator(IrDeclaration parentDeclaration) {
            Intrinsics.checkNotNullParameter((Object)NameTables.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)parentDeclaration, (String)"parentDeclaration");
            this.table = new NameTable(NameTables.this.getGlobalNames(), null, null, null, 14, null);
            this.breakableDeque = new LinkedList();
            Map map = NameTables.this.localNames;
            NameTable<IrDeclaration> nameTable = this.table;
            boolean bl = false;
            map.put(parentDeclaration, nameTable);
            this.localLoopNames = new NameTable(null, null, null, null, 15, null);
        }

        @NotNull
        public final NameTable<IrDeclaration> getTable() {
            return this.table;
        }

        @Override
        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            if (declaration2 instanceof IrDeclarationWithName) {
                String string2 = ((IrDeclarationWithName)((Object)declaration2)).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"declaration.name.asString()");
                this.table.declareFreshName(declaration2, string2);
            }
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump) {
            Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
            IrLoop loop2 = jump.getLoop();
            if (loop2.getLabel() == null && !Intrinsics.areEqual((Object)loop2, (Object)CollectionsKt.firstOrNull((Iterable)this.breakableDeque))) {
                this.persistLoopName("$l$break", loop2);
            }
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.breakableDeque.push(expression2);
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            this.breakableDeque.pop();
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2) {
            Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
            this.breakableDeque.push(loop2);
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
            this.breakableDeque.pop();
            String label = loop2.getLabel();
            if (label != null) {
                this.persistLoopName(label, loop2);
            }
        }

        private final void persistLoopName(String label, IrLoop loop2) {
            this.localLoopNames.declareFreshName(loop2, label);
            Map map = NameTables.this.loopNames;
            String string2 = this.localLoopNames.getNames().get(loop2);
            Intrinsics.checkNotNull((Object)string2);
            boolean bl = false;
            map.put(loop2, string2);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2) {
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2) {
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
        }

        @Override
        public void visitBody(@NotNull IrBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
        }

        @Override
        public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch) {
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump) {
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch) {
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2) {
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump) {
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
        }

        @Override
        public void visitElement(@NotNull IrElement element, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch) {
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
        }

        @Override
        public void visitField(@NotNull IrField declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
        }

        @Override
        public void visitField(@NotNull IrField declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
        }

        @Override
        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
        }

        @Override
        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2) {
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
        }

        @Override
        public void visitScript(@NotNull IrScript declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
        }

        @Override
        public void visitScript(@NotNull IrScript declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
        }

        @Override
        public void visitSetValue(@NotNull IrSetValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
        }

        @Override
        public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread) {
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2) {
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry) {
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2) {
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
        }

        @Override
        public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
        }
    }
}

