/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallDataRenderer;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallDataWithCode;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsRenderersKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsCallDataHtmlRenderer;", "Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsCallDataRenderer;", "()V", "format", "", "data", "Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsCallDataWithCode;", "js.frontend"})
public final class JsCallDataHtmlRenderer
extends JsCallDataRenderer {
    @NotNull
    public static final JsCallDataHtmlRenderer INSTANCE = new JsCallDataHtmlRenderer();

    private JsCallDataHtmlRenderer() {
    }

    @Override
    @NotNull
    protected String format(@NotNull JsCallDataWithCode data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        TextRange codeRange = data.getCodeRange();
        String code = JsRenderersKt.underlineAsHtml(data.getCode(), codeRange.getStartOffset(), codeRange.getEndOffset());
        return data.getMessage() + " in code:<br><pre>" + code + "</pre>";
    }
}

