/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.jsAstUtils.AstUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u001b\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/DefaultPropertyTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "delegateReference", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)V", "getDelegateReference", "()Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "generateDefaultGetterFunction", "", "getterDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableAccessorDescriptor;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "generateDefaultSetterFunction", "setterDescriptor", "generateDelegatedGetterFunction", "delegatedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "translateHost", "accessorDescriptor", "newDeclarationIfNecessary", "js.translator"})
public final class DefaultPropertyTranslator
extends AbstractTranslator {
    @NotNull
    private final VariableDescriptorWithAccessors descriptor;
    @NotNull
    private final JsExpression delegateReference;

    public DefaultPropertyTranslator(@NotNull VariableDescriptorWithAccessors descriptor2, @NotNull TranslationContext context2, @NotNull JsExpression delegateReference) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)delegateReference, (String)"delegateReference");
        super(context2);
        this.descriptor = descriptor2;
        this.delegateReference = delegateReference;
    }

    @NotNull
    public final VariableDescriptorWithAccessors getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public final JsExpression getDelegateReference() {
        return this.delegateReference;
    }

    public final void generateDefaultGetterFunction(@NotNull VariableAccessorDescriptor getterDescriptor, @NotNull JsFunction function2) {
        boolean bl;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)getterDescriptor, (String)"getterDescriptor");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        ResolvedCall delegatedCall = (ResolvedCall)this.bindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, getterDescriptor);
        if (delegatedCall != null) {
            this.generateDelegatedGetterFunction(getterDescriptor, delegatedCall, function2);
            return;
        }
        boolean bl2 = !DescriptorUtilsKt.isExtension(this.descriptor);
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-DefaultPropertyTranslator$generateDefaultGetterFunction$32 = false;
            String $i$a$-assert-DefaultPropertyTranslator$generateDefaultGetterFunction$32 = "Unexpected extension property " + this.getDescriptor() + '}';
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-DefaultPropertyTranslator$generateDefaultGetterFunction$32));
        }
        bl2 = this.descriptor instanceof PropertyDescriptor;
        bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string2 = Intrinsics.stringPlus((String)"Property descriptor expected: ", (Object)this.getDescriptor());
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        SourceInfoAwareJsNode sourceInfoAwareJsNode = TranslationUtils.backingFieldReference(this.context(), (PropertyDescriptor)this.descriptor);
        Intrinsics.checkNotNullExpressionValue((Object)sourceInfoAwareJsNode, (String)"backingFieldReference(context(), descriptor as PropertyDescriptor)");
        JsExpression result2 = (JsExpression)sourceInfoAwareJsNode;
        if (getterDescriptor instanceof PropertyAccessorDescriptor && ((PropertyAccessorDescriptor)getterDescriptor).getCorrespondingProperty().isLateInit()) {
            object2 = this.context().getReferenceToIntrinsic("throwUPAE");
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context().getReferenceToIntrinsic(Namer.THROW_UNINITIALIZED_PROPERTY_ACCESS_EXCEPTION)");
            JsExpression throwFunction = object2;
            object2 = function2.getBody();
            object = ((JsBlock)object2).getStatements();
            Intrinsics.checkNotNullExpressionValue(object, (String)"function.body.statements");
            object = (Collection)object;
            Object object3 = new JsExpression[]{new JsStringLiteral(((PropertyAccessorDescriptor)getterDescriptor).getCorrespondingProperty().getName().asString())};
            object3 = new JsIf(new JsBinaryOperation(JsBinaryOperator.EQ, result2, new JsNullLiteral()), new JsReturn(new JsInvocation(throwFunction, (JsExpression)object3)));
            bl = false;
            object.add(object3);
        }
        sourceInfoAwareJsNode = TranslationUtils.coerce(this.context(), result2, TranslationUtils.getReturnTypeForCoercion(getterDescriptor));
        Intrinsics.checkNotNullExpressionValue((Object)sourceInfoAwareJsNode, (String)"coerce(context(), result, TranslationUtils.getReturnTypeForCoercion(getterDescriptor))");
        result2 = sourceInfoAwareJsNode;
        sourceInfoAwareJsNode = function2.getBody();
        object2 = ((JsBlock)sourceInfoAwareJsNode).getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"function.body.statements");
        object2 = (Collection)object2;
        object = new JsReturn(result2);
        boolean bl5 = false;
        bl = false;
        Object $this$generateDefaultGetterFunction_u24lambda_u2d2 = object;
        boolean bl6 = false;
        SourceElement sourceElement = ((PropertyDescriptor)this.getDescriptor()).getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"descriptor.source");
        ((SourceInfoAwareJsNode)$this$generateDefaultGetterFunction_u24lambda_u2d2).setSource(KotlinSourceElementKt.getPsi(sourceElement));
        bl5 = false;
        object2.add(object);
    }

    private final void generateDelegatedGetterFunction(VariableAccessorDescriptor getterDescriptor, ResolvedCall<FunctionDescriptor> delegatedCall, JsFunction function2) {
        JsExpression host = this.translateHost(getterDescriptor, function2);
        TranslationContext translationContext = this.context();
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context()");
        TranslationContext delegateContext = PropertyTranslatorKt.contextWithPropertyMetadataCreationIntrinsified(this.newDeclarationIfNecessary(translationContext, getterDescriptor, function2), delegatedCall, this.descriptor, host);
        JsExpression jsExpression = CallTranslator.translate(delegateContext, delegatedCall, this.delegateReference);
        boolean bl = false;
        boolean bl2 = false;
        JsExpression $this$generateDelegatedGetterFunction_u24lambda_u2d3 = jsExpression;
        boolean bl3 = false;
        SourceElement sourceElement = getterDescriptor.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getterDescriptor.source");
        $this$generateDelegatedGetterFunction_u24lambda_u2d3.setSource(KotlinSourceElementKt.getPsi(sourceElement));
        JsExpression delegatedJsCall = jsExpression;
        JsReturn returnResult = new JsReturn(delegatedJsCall);
        AstUtilsKt.addStatement(function2, returnResult);
    }

    /*
     * WARNING - void declaration
     */
    public final void generateDefaultSetterFunction(@NotNull VariableAccessorDescriptor setterDescriptor, @NotNull JsFunction function2) {
        Intrinsics.checkNotNullParameter((Object)setterDescriptor, (String)"setterDescriptor");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        boolean bl = setterDescriptor.getValueParameters().size() == 1;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-DefaultPropertyTranslator$generateDefaultSetterFunction$42 = false;
            String $i$a$-assert-DefaultPropertyTranslator$generateDefaultSetterFunction$42 = "Setter must have 1 parameter";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-DefaultPropertyTranslator$generateDefaultSetterFunction$42));
        }
        String string2 = setterDescriptor.getCorrespondingVariable().getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"setterDescriptor.correspondingVariable.name.asString()");
        String correspondingPropertyName = string2;
        JsName $i$a$-assert-DefaultPropertyTranslator$generateDefaultSetterFunction$42 = AstUtilsKt.addParameter$default(function2, correspondingPropertyName, null, 2, null).getName();
        Intrinsics.checkNotNullExpressionValue((Object)$i$a$-assert-DefaultPropertyTranslator$generateDefaultSetterFunction$42, (String)"function.addParameter(correspondingPropertyName).name");
        JsName valueParameter2 = $i$a$-assert-DefaultPropertyTranslator$generateDefaultSetterFunction$42;
        ValueParameterDescriptor parameter = setterDescriptor.getValueParameters().get(0);
        TranslationContext translationContext = this.context().innerContextWithAliased(parameter, valueParameter2.makeRef());
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context().innerContextWithAliased(parameter, valueParameter.makeRef())");
        TranslationContext withAliased = translationContext;
        ResolvedCall delegatedCall = (ResolvedCall)this.bindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, setterDescriptor);
        if (delegatedCall != null) {
            JsExpression host = this.translateHost(setterDescriptor, function2);
            TranslationContext delegateContext22 = PropertyTranslatorKt.contextWithPropertyMetadataCreationIntrinsified(this.newDeclarationIfNecessary(withAliased, setterDescriptor, function2), delegatedCall, this.descriptor, host);
            JsNode jsNode = CallTranslator.translate(delegateContext22, delegatedCall, this.delegateReference);
            boolean bl3 = false;
            boolean bl4 = false;
            JsExpression $this$generateDefaultSetterFunction_u24lambda_u2d5 = jsNode;
            boolean bl5 = false;
            SourceElement sourceElement = setterDescriptor.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"setterDescriptor.source");
            $this$generateDefaultSetterFunction_u24lambda_u2d5.setSource(KotlinSourceElementKt.getPsi(sourceElement));
            JsExpression delegatedJsCall = jsNode;
            jsNode = delegatedJsCall.makeStmt();
            Intrinsics.checkNotNullExpressionValue((Object)jsNode, (String)"delegatedJsCall.makeStmt()");
            AstUtilsKt.addStatement(function2, (JsStatement)jsNode);
        } else {
            void $this$generateDefaultSetterFunction_u24lambda_u2d9;
            JsExpression assignment;
            boolean host = !DescriptorUtilsKt.isExtension(this.descriptor);
            boolean delegateContext22 = false;
            if (_Assertions.ENABLED && !host) {
                boolean $i$a$-assert-DefaultPropertyTranslator$generateDefaultSetterFunction$52 = false;
                String $i$a$-assert-DefaultPropertyTranslator$generateDefaultSetterFunction$52 = "Unexpected extension property " + this.getDescriptor() + '}';
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-DefaultPropertyTranslator$generateDefaultSetterFunction$52));
            }
            host = this.descriptor instanceof PropertyDescriptor;
            delegateContext22 = false;
            if (_Assertions.ENABLED && !host) {
                boolean bl6 = false;
                String string3 = Intrinsics.stringPlus((String)"Property descriptor expected: ", (Object)this.getDescriptor());
                throw (Throwable)((Object)new AssertionError((Object)string3));
            }
            JsNode jsNode = valueParameter2.makeRef();
            boolean bl7 = false;
            boolean bl8 = false;
            JsNameRef $this$generateDefaultSetterFunction_u24lambda_u2d8 = jsNode;
            boolean $i$a$-apply-DefaultPropertyTranslator$generateDefaultSetterFunction$value$22 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$generateDefaultSetterFunction_u24lambda_u2d8, (String)"");
            MetadataProperties.setType($this$generateDefaultSetterFunction_u24lambda_u2d8, TranslationUtils.getReturnTypeForCoercion(setterDescriptor.getCorrespondingVariable()));
            JsExpression delegateContext22 = jsNode;
            Intrinsics.checkNotNullExpressionValue((Object)delegateContext22, (String)"valueParameter.makeRef().apply {\n                type = TranslationUtils.getReturnTypeForCoercion(setterDescriptor.correspondingVariable)\n            }");
            JsExpression value2 = delegateContext22;
            delegateContext22 = TranslationUtils.coerce(this.context(), value2, TranslationUtils.getReturnTypeForCoercion(setterDescriptor.getCorrespondingVariable(), true));
            Intrinsics.checkNotNullExpressionValue((Object)delegateContext22, (String)"coerce(\n                    context(), value, TranslationUtils.getReturnTypeForCoercion(setterDescriptor.correspondingVariable, true))");
            value2 = delegateContext22;
            jsNode = TranslationUtils.assignmentToBackingField(withAliased, (PropertyDescriptor)this.descriptor, value2);
            Intrinsics.checkNotNullExpressionValue((Object)jsNode, (String)"assignmentToBackingField(withAliased, descriptor as PropertyDescriptor, value)");
            JsExpression jsExpression = assignment = jsNode;
            bl8 = false;
            boolean bl9 = false;
            JsExpression $i$a$-apply-DefaultPropertyTranslator$generateDefaultSetterFunction$value$22 = jsExpression;
            JsFunction jsFunction = function2;
            boolean bl10 = false;
            SourceElement sourceElement = ((PropertyDescriptor)this.getDescriptor()).getSource();
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"descriptor.source");
            $this$generateDefaultSetterFunction_u24lambda_u2d9.setSource(KotlinSourceElementKt.getPsi(sourceElement));
            Unit unit = Unit.INSTANCE;
            jsNode = jsExpression.makeStmt();
            Intrinsics.checkNotNullExpressionValue((Object)jsNode, (String)"assignment.apply { source = descriptor.source.getPsi() }.makeStmt()");
            AstUtilsKt.addStatement(jsFunction, (JsStatement)jsNode);
        }
    }

    private final TranslationContext newDeclarationIfNecessary(TranslationContext $this$newDeclarationIfNecessary, VariableAccessorDescriptor descriptor2, JsFunction function2) {
        TranslationContext translationContext;
        if (!(descriptor2.getCorrespondingVariable() instanceof LocalVariableDescriptor)) {
            TranslationContext translationContext2 = $this$newDeclarationIfNecessary.newDeclaration(descriptor2);
            Intrinsics.checkNotNullExpressionValue((Object)translationContext2, (String)"{\n            newDeclaration(descriptor)\n        }");
            translationContext = translationContext2;
        } else {
            TranslationContext translationContext3 = $this$newDeclarationIfNecessary.innerBlock(function2.getBody());
            Intrinsics.checkNotNullExpressionValue((Object)translationContext3, (String)"{\n            innerBlock(function.body)\n        }");
            translationContext = translationContext3;
        }
        return translationContext;
    }

    private final JsExpression translateHost(VariableAccessorDescriptor accessorDescriptor, JsFunction function2) {
        JsExpression jsExpression;
        if (DescriptorUtilsKt.isExtension(accessorDescriptor)) {
            String string2 = Namer.getReceiverParameterName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getReceiverParameterName()");
            JsNameRef jsNameRef = AstUtilsKt.addParameter(function2, string2, 0).getName().makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"{\n            function.addParameter(getReceiverParameterName(), 0).name.makeRef()\n        }");
            jsExpression = jsNameRef;
        } else {
            jsExpression = new JsThisRef();
        }
        return jsExpression;
    }
}

