/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DelegationResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/DelegationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkDescriptor", "classDeclaration", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "delegatedDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "delegatedToDescriptor", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "frontend"})
public final class DelegationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        if (!(declaration2 instanceof KtClassOrObject)) {
            return;
        }
        for (KtSuperTypeListEntry specifier : ((KtClassOrObject)declaration2).getSuperTypeListEntries()) {
            Object object;
            boolean bl;
            KotlinType kotlinType;
            if (!(specifier instanceof KtDelegatedSuperTypeEntry)) continue;
            Object object2 = ((KtDelegatedSuperTypeEntry)specifier).getTypeReference();
            if (object2 == null) {
                kotlinType = null;
            } else {
                KtTypeReference ktTypeReference = object2;
                boolean bl2 = false;
                bl = false;
                KtTypeReference it = ktTypeReference;
                boolean bl3 = false;
                kotlinType = (KotlinType)context2.getTrace().get(BindingContext.TYPE, it);
            }
            if ((object = kotlinType) == null) continue;
            Object object3 = object;
            KotlinType superType = object3;
            object2 = superType.getConstructor().getDeclarationDescriptor();
            Object object4 = object = object2 instanceof ClassDescriptor ? (ClassDescriptor)object2 : null;
            if (object == null) continue;
            Annotated superTypeDescriptor = object;
            object2 = DelegationResolver.Companion.getDelegates$default(DelegationResolver.Companion, (ClassDescriptor)descriptor2, (ClassDescriptor)superTypeDescriptor, null, 4, null);
            boolean bl4 = false;
            object = object2.entrySet().iterator();
            while (object.hasNext()) {
                Object object5 = object2 = (Map.Entry)object.next();
                bl = false;
                CallableMemberDescriptor delegated = (CallableMemberDescriptor)object5.getKey();
                Object object6 = object2;
                boolean bl5 = false;
                CallableMemberDescriptor delegatedTo = (CallableMemberDescriptor)object6.getValue();
                this.checkDescriptor((KtClassOrObject)declaration2, delegated, delegatedTo, context2.getTrace());
            }
        }
    }

    private final void checkDescriptor(KtClassOrObject classDeclaration, CallableMemberDescriptor delegatedDescriptor, CallableMemberDescriptor delegatedToDescriptor, DiagnosticSink diagnosticHolder) {
        CallableMemberDescriptor it;
        Iterable $this$filterTo$iv$iv;
        Collection<CallableDescriptor> collection = DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)delegatedDescriptor);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllOverriddenDescriptors(delegatedDescriptor)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CallableMemberDescriptor)element$iv$iv;
            boolean bl = false;
            if (!it.getKind().isReal()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set set = OverridingUtil.filterOutOverridden(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        Intrinsics.checkNotNullExpressionValue(set, (String)"filterOutOverridden(\n                DescriptorUtils.getAllOverriddenDescriptors(delegatedDescriptor).filter { it.kind.isReal }.toSet()\n            )");
        Set reachableFromDelegated = SetsKt.minus(set, (Object)DescriptorUtils.unwrapFakeOverride(delegatedToDescriptor).getOriginal());
        $this$filter$iv = reachableFromDelegated;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CallableMemberDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(it.getModality() == Modality.OPEN)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonAbstractReachable = (List)destination$iv$iv;
        collection = nonAbstractReachable;
        boolean bl = false;
        if (!collection.isEmpty()) {
            diagnosticHolder.report(Errors.DELEGATED_MEMBER_HIDES_SUPERTYPE_OVERRIDE.on((KtClassOrObject)((PsiElement)classDeclaration), delegatedDescriptor, nonAbstractReachable));
        }
    }
}

