/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.deprecation;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.MavenComparableVersion;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.DescriptorDerivedFromTypeAlias;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirement;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.OperatorCallCheckerKt;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker;
import org.jetbrains.kotlin.resolve.deprecation.CoroutineCompatibilitySupport;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByAnnotation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByOverridden;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByVersionRequirement;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedExperimentalCoroutine;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedOperatorMod;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedTypealiasByAnnotation;
import org.jetbrains.kotlin.resolve.deprecation.Deprecation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationKt;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationSettings;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 22\u00020\u0001:\u00012B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000e2\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u001f\u001a\u00020\rJ\u000e\u0010 \u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\rJ<\u0010!\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\r2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%2\b\b\u0002\u0010&\u001a\u00020\u00132\b\b\u0002\u0010'\u001a\u00020\u0013H\u0007J2\u0010!\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\r2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0013J\u0018\u0010*\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001a\u0010+\u001a\u00020,*\u00020\r2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000f0.H\u0002J\u0012\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u000200H\u0002J\u0012\u00101\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\rH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "coroutineCompatibilitySupport", "Lorg/jetbrains/kotlin/resolve/deprecation/CoroutineCompatibilitySupport;", "deprecationSettings", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationSettings;", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/deprecation/CoroutineCompatibilitySupport;Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationSettings;)V", "deprecations", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "", "Lorg/jetbrains/kotlin/resolve/deprecation/Deprecation;", "isHiddenBecauseOfKotlinVersionAccessibility", "Lorg/jetbrains/kotlin/resolve/SinceKotlinAccessibility;", "isBuiltInOperatorMod", "", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "deprecationByOverridden", "root", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "getDeprecationByCoroutinesVersion", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecatedExperimentalCoroutine;", "target", "getDeprecationByVersionRequirement", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecatedByVersionRequirement;", "getDeprecationFromUserData", "getDeprecations", "descriptor", "isDeprecatedHidden", "isHiddenInResolution", "call", "Lorg/jetbrains/kotlin/psi/Call;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isSuperCall", "fromImportingScope", "callElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "shouldSkipDeprecationOnKotlinIoReadBytes", "addDeprecationIfPresent", "", "result", "", "deprecationsByConstituentTypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "getOwnDeprecations", "Companion", "frontend"})
public final class DeprecationResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final CoroutineCompatibilitySupport coroutineCompatibilitySupport;
    @NotNull
    private final DeprecationSettings deprecationSettings;
    @NotNull
    private final MemoizedFunctionToNotNull<DeclarationDescriptor, List<Deprecation>> deprecations;
    @NotNull
    private final MemoizedFunctionToNotNull<DeclarationDescriptor, SinceKotlinAccessibility> isHiddenBecauseOfKotlinVersionAccessibility;
    @NotNull
    private static final FqName JAVA_DEPRECATED = new FqName("java.lang.Deprecated");

    public DeprecationResolver(@NotNull StorageManager storageManager, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull CoroutineCompatibilitySupport coroutineCompatibilitySupport, @NotNull DeprecationSettings deprecationSettings) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)coroutineCompatibilitySupport, (String)"coroutineCompatibilitySupport");
        Intrinsics.checkNotNullParameter((Object)deprecationSettings, (String)"deprecationSettings");
        this.languageVersionSettings = languageVersionSettings;
        this.coroutineCompatibilitySupport = coroutineCompatibilitySupport;
        this.deprecationSettings = deprecationSettings;
        this.deprecations = storageManager.createMemoizedFunction((Function1)new Function1<DeclarationDescriptor, List<? extends Deprecation>>(this){
            final /* synthetic */ DeprecationResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<Deprecation> invoke(@NotNull DeclarationDescriptor descriptor2) {
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                List deprecations2 = DeprecationResolver.access$getOwnDeprecations(this.this$0, descriptor2);
                Collection collection = deprecations2;
                boolean bl = false;
                return !collection.isEmpty() ? deprecations2 : (descriptor2 instanceof CallableMemberDescriptor ? CollectionsKt.listOfNotNull((Object)DeprecationResolver.access$deprecationByOverridden(this.this$0, (CallableMemberDescriptor)descriptor2)) : CollectionsKt.emptyList());
            }
        });
        this.isHiddenBecauseOfKotlinVersionAccessibility = storageManager.createMemoizedFunction((Function1)new Function1<DeclarationDescriptor, SinceKotlinAccessibility>(this){
            final /* synthetic */ DeprecationResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final SinceKotlinAccessibility invoke(@NotNull DeclarationDescriptor descriptor2) {
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                return SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility(descriptor2, DeprecationResolver.access$getLanguageVersionSettings$p(this.this$0));
            }
        });
    }

    @NotNull
    public final List<Deprecation> getDeprecations(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.original");
        return (List)this.deprecations.invoke(declarationDescriptor);
    }

    public final boolean isDeprecatedHidden(@NotNull DeclarationDescriptor descriptor2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Iterable $this$any$iv = this.getDeprecations(descriptor2);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Deprecation it = (Deprecation)element$iv;
                    boolean bl2 = false;
                    if (!(it.getDeprecationLevel() == DeprecationLevelValue.HIDDEN)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmOverloads
    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2, @Nullable Call call2, @Nullable BindingContext bindingContext, boolean isSuperCall, boolean fromImportingScope) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Call call3 = call2;
        return this.isHiddenInResolution(descriptor2, call3 == null ? null : call3.getCallElement(), bindingContext, isSuperCall, fromImportingScope);
    }

    public static /* synthetic */ boolean isHiddenInResolution$default(DeprecationResolver deprecationResolver, DeclarationDescriptor declarationDescriptor, Call call2, BindingContext bindingContext, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            call2 = null;
        }
        if ((n & 4) != 0) {
            bindingContext = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return deprecationResolver.isHiddenInResolution(declarationDescriptor, call2, bindingContext, bl, bl2);
    }

    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2, @Nullable KtElement callElement, @Nullable BindingContext bindingContext, boolean isSuperCall, boolean fromImportingScope) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (descriptor2 instanceof FunctionDescriptor) {
            if (((FunctionDescriptor)descriptor2).isHiddenToOvercomeSignatureClash()) {
                return true;
            }
            if (((FunctionDescriptor)descriptor2).isHiddenForResolutionEverywhereBesideSupercalls() && !isSuperCall) {
                return true;
            }
        }
        Object object = descriptor2.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.original");
        SinceKotlinAccessibility sinceKotlinAccessibility = (SinceKotlinAccessibility)this.isHiddenBecauseOfKotlinVersionAccessibility.invoke(object);
        if (sinceKotlinAccessibility instanceof SinceKotlinAccessibility.NotAccessible) {
            return true;
        }
        if (sinceKotlinAccessibility instanceof SinceKotlinAccessibility.NotAccessibleButWasExperimental) {
            boolean bl;
            block10: {
                if (callElement != null && bindingContext != null) {
                    object = ExperimentalUsageChecker.Companion;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Object $this$isHiddenInResolution_u24lambda_u2d2 = object;
                    boolean bl4 = false;
                    Iterable $this$any$iv = ((SinceKotlinAccessibility.NotAccessibleButWasExperimental)sinceKotlinAccessibility).getMarkerClasses();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ClassDescriptor classDescriptor = (ClassDescriptor)element$iv;
                            boolean bl5 = false;
                            if (!(!((ExperimentalUsageChecker.Companion)$this$isHiddenInResolution_u24lambda_u2d2).isExperimentalityAccepted((PsiElement)callElement, DescriptorUtilsKt.getFqNameSafe(classDescriptor), this.languageVersionSettings, bindingContext))) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                } else {
                    bl = !fromImportingScope;
                }
            }
            return bl;
        }
        return this.isDeprecatedHidden(descriptor2);
    }

    private final List<Deprecation> deprecationsByConstituentTypes(KotlinType $this$deprecationsByConstituentTypes) {
        SmartList<Deprecation> smartList = new SmartList<Deprecation>();
        boolean bl = false;
        boolean bl2 = false;
        SmartList<Deprecation> deprecations2 = smartList;
        boolean bl3 = false;
        TypeUtils.contains($this$deprecationsByConstituentTypes, (Function1<UnwrappedType, Boolean>)((Function1)new Function1<UnwrappedType, Boolean>(deprecations2, this){
            final /* synthetic */ SmartList<Deprecation> $deprecations;
            final /* synthetic */ DeprecationResolver this$0;
            {
                this.$deprecations = $deprecations;
                this.this$0 = $receiver;
                super(1);
            }

            public final Boolean invoke(UnwrappedType type2) {
                ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
                if (classifierDescriptor != null) {
                    ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
                    SmartList<Deprecation> smartList = this.$deprecations;
                    DeprecationResolver deprecationResolver = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    ClassifierDescriptor it = classifierDescriptor2;
                    boolean bl3 = false;
                    smartList.addAll((Collection<Deprecation>)deprecationResolver.getDeprecations(it));
                }
                return false;
            }
        }));
        return smartList;
    }

    private final Deprecation deprecationByOverridden(CallableMemberDescriptor root2) {
        HashSet<CallableMemberDescriptor> visited2 = new HashSet<CallableMemberDescriptor>();
        LinkedHashSet<Deprecation> deprecations2 = new LinkedHashSet<Deprecation>();
        Ref.BooleanRef hasUndeprecatedOverridden = new Ref.BooleanRef();
        DeprecationResolver.deprecationByOverridden$traverse(visited2, this, deprecations2, hasUndeprecatedOverridden, root2);
        if (hasUndeprecatedOverridden.element || deprecations2.isEmpty()) {
            return null;
        }
        if (root2.getKind().isReal()) {
            boolean bl;
            block6: {
                Iterable $this$none$iv = deprecations2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Deprecation p0 = (Deprecation)element$iv;
                        boolean bl2 = false;
                        if (!p0.getPropagatesToOverrides()) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return null;
            }
        }
        return new DeprecatedByOverridden((Collection<? extends Deprecation>)deprecations2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Deprecation> getOwnDeprecations(DeclarationDescriptor $this$getOwnDeprecations) {
        if (this.isBuiltInOperatorMod($this$getOwnDeprecations) && !OperatorCallCheckerKt.shouldWarnAboutDeprecatedModFromBuiltIns(this.languageVersionSettings)) {
            return CollectionsKt.emptyList();
        }
        if (this.shouldSkipDeprecationOnKotlinIoReadBytes($this$getOwnDeprecations, this.languageVersionSettings)) {
            return CollectionsKt.emptyList();
        }
        SmartList result2 = new SmartList();
        this.addDeprecationIfPresent($this$getOwnDeprecations, result2);
        DeclarationDescriptor declarationDescriptor = $this$getOwnDeprecations;
        if (declarationDescriptor instanceof TypeAliasDescriptor) {
            Iterable $this$mapTo$iv = this.deprecationsByConstituentTypes(((TypeAliasDescriptor)$this$getOwnDeprecations).getExpandedType());
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void deprecation;
                Deprecation deprecation2 = (Deprecation)item$iv;
                Collection collection = result2;
                boolean bl = false;
                void var10_11 = deprecation;
                void var12_13 = var10_11 instanceof DeprecatedByAnnotation ? (Deprecation)new DeprecatedTypealiasByAnnotation((TypeAliasDescriptor)$this$getOwnDeprecations, (DeprecatedByAnnotation)deprecation) : deprecation;
                collection.add(var12_13);
            }
        } else if (declarationDescriptor instanceof DescriptorDerivedFromTypeAlias) {
            result2.addAll(this.getOwnDeprecations(((DescriptorDerivedFromTypeAlias)((Object)$this$getOwnDeprecations)).getTypeAliasDescriptor()));
        } else if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$this$getOwnDeprecations).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"correspondingProperty");
            this.addDeprecationIfPresent(propertyDescriptor, result2);
        }
        return CollectionsKt.distinct((Iterable)result2);
    }

    private final void addDeprecationIfPresent(DeclarationDescriptor $this$addDeprecationIfPresent, List<Deprecation> result2) {
        Object p0;
        boolean bl;
        boolean bl2;
        Object object;
        DeprecatedByAnnotation deprecatedByAnnotation;
        AnnotationDescriptor annotation2;
        Object object2 = $this$addDeprecationIfPresent.getAnnotations().findAnnotation(StandardNames.FqNames.deprecated);
        AnnotationDescriptor annotationDescriptor = annotation2 = object2 == null ? $this$addDeprecationIfPresent.getAnnotations().findAnnotation(JAVA_DEPRECATED) : object2;
        if (annotation2 != null && (deprecatedByAnnotation = DeprecatedByAnnotation.Companion.create(annotation2, $this$addDeprecationIfPresent.getAnnotations().findAnnotation(StandardNames.FqNames.deprecatedSinceKotlin), $this$addDeprecationIfPresent, this.deprecationSettings.propagatedToOverrides(annotation2), this.languageVersionSettings.getApiVersion())) != null) {
            Deprecation deprecation = $this$addDeprecationIfPresent instanceof TypeAliasConstructorDescriptor ? (Deprecation)new DeprecatedTypealiasByAnnotation(((TypeAliasConstructorDescriptor)$this$addDeprecationIfPresent).getTypeAliasDescriptor(), deprecatedByAnnotation) : (this.isBuiltInOperatorMod($this$addDeprecationIfPresent) ? (Deprecation)new DeprecatedOperatorMod(this.languageVersionSettings, deprecatedByAnnotation) : (Deprecation)deprecatedByAnnotation);
            result2.add(deprecation);
        }
        for (Deprecation deprecation : this.getDeprecationByVersionRequirement($this$addDeprecationIfPresent)) {
            result2.add(deprecation);
        }
        object2 = this.getDeprecationByCoroutinesVersion($this$addDeprecationIfPresent);
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            p0 = object;
            boolean bl3 = false;
            result2.add((Deprecation)p0);
        }
        object2 = this.getDeprecationFromUserData($this$addDeprecationIfPresent);
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            p0 = object;
            boolean bl4 = false;
            result2.add((Deprecation)p0);
        }
    }

    private final boolean isBuiltInOperatorMod(DeclarationDescriptor $this$isBuiltInOperatorMod) {
        return $this$isBuiltInOperatorMod instanceof FunctionDescriptor && OperatorCallCheckerKt.isOperatorMod((FunctionDescriptor)$this$isBuiltInOperatorMod) && KotlinBuiltIns.isUnderKotlinPackage($this$isBuiltInOperatorMod);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldSkipDeprecationOnKotlinIoReadBytes(DeclarationDescriptor descriptor2, LanguageVersionSettings languageVersionSettings) {
        Boolean bl;
        DeclarationDescriptorNonRoot declarationDescriptorNonRoot;
        if (!Intrinsics.areEqual((Object)descriptor2.getName().asString(), (Object)"readBytes")) return false;
        Object object = descriptor2.getContainingDeclaration();
        DeclarationDescriptorNonRoot declarationDescriptorNonRoot2 = declarationDescriptorNonRoot = object instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)object : null;
        if (!Intrinsics.areEqual(declarationDescriptorNonRoot == null ? null : ((object = declarationDescriptorNonRoot.getFqName()) == null ? null : ((FqName)object).asString()), (Object)"kotlin.io")) return false;
        if (!(descriptor2 instanceof FunctionDescriptor)) return false;
        object = ((FunctionDescriptor)descriptor2).getValueParameters();
        Intrinsics.checkNotNullExpressionValue(object, (String)"descriptor.valueParameters");
        declarationDescriptorNonRoot = (ValueParameterDescriptor)CollectionsKt.singleOrNull(object);
        if (declarationDescriptorNonRoot == null) {
            bl = null;
        } else {
            object = declarationDescriptorNonRoot.getType();
            if (object == null) {
                bl = null;
            } else {
                Object object2 = object;
                boolean bl2 = false;
                boolean bl3 = false;
                Object p0 = object2;
                boolean bl4 = false;
                bl = KotlinBuiltIns.isInt((KotlinType)p0);
            }
        }
        if (!Intrinsics.areEqual(bl, (Object)true)) return false;
        if (languageVersionSettings.getApiVersion().compareTo(ApiVersion.KOTLIN_1_3) >= 0) return false;
        return true;
    }

    private final DeprecatedExperimentalCoroutine getDeprecationByCoroutinesVersion(DeclarationDescriptor target) {
        if (!(target instanceof DeserializedMemberDescriptor)) {
            return null;
        }
        DeserializedMemberDescriptor.CoroutinesCompatibilityMode coroutinesCompatibilityMode = ((DeserializedMemberDescriptor)target).getCoroutinesExperimentalCompatibilityMode();
        boolean bl = false;
        boolean bl2 = false;
        DeserializedMemberDescriptor.CoroutinesCompatibilityMode mode = coroutinesCompatibilityMode;
        boolean bl3 = false;
        return mode == DeserializedMemberDescriptor.CoroutinesCompatibilityMode.COMPATIBLE ? null : (mode == DeserializedMemberDescriptor.CoroutinesCompatibilityMode.NEEDS_WRAPPER && this.coroutineCompatibilitySupport.getEnabled() ? new DeprecatedExperimentalCoroutine(target, DeprecationLevelValue.WARNING) : new DeprecatedExperimentalCoroutine(target, DeprecationLevelValue.ERROR));
    }

    private final Deprecation getDeprecationFromUserData(DeclarationDescriptor target) {
        CallableDescriptor callableDescriptor;
        DeclarationDescriptor $this$safeAs$iv = target;
        boolean $i$f$safeAs = false;
        DeclarationDescriptor declarationDescriptor = $this$safeAs$iv;
        if (!(declarationDescriptor instanceof CallableDescriptor)) {
            declarationDescriptor = null;
        }
        return (callableDescriptor = (CallableDescriptor)declarationDescriptor) == null ? null : callableDescriptor.getUserData(DeprecationKt.getDEPRECATED_FUNCTION_KEY());
    }

    /*
     * WARNING - void declaration
     */
    private final List<DeprecatedByVersionRequirement> getDeprecationByVersionRequirement(DeclarationDescriptor target) {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        Object object2;
        List<VersionRequirement> list2;
        Object object3 = target instanceof DeserializedMemberDescriptor ? (DeserializedMemberDescriptor)target : null;
        List<VersionRequirement> list3 = list2 = object3 == null ? null : object3.getVersionRequirements();
        if (list2 == null) {
            object2 = target instanceof DeserializedClassDescriptor ? (DeserializedClassDescriptor)target : null;
            Object object4 = object3 = object2 == null ? null : ((DeserializedClassDescriptor)object2).getVersionRequirements();
            if (object3 == null) {
                return CollectionsKt.emptyList();
            }
            object = object3;
        } else {
            object = list2;
        }
        List<VersionRequirement> versionRequirements = object;
        Iterable $this$mapNotNull$iv = versionRequirements;
        boolean $i$f$mapNotNull = false;
        object2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            DeprecatedByVersionRequirement deprecatedByVersionRequirement;
            MavenComparableVersion currentVersion;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            VersionRequirement versionRequirement = (VersionRequirement)element$iv$iv;
            boolean bl2 = false;
            MavenComparableVersion requiredVersion = DeprecationResolver.getDeprecationByVersionRequirement$createVersion(versionRequirement.getVersion().asString());
            ProtoBuf.VersionRequirement.VersionKind versionKind = versionRequirement.getKind();
            int n = WhenMappings.$EnumSwitchMapping$0[versionKind.ordinal()];
            switch (n) {
                case 1: {
                    MavenComparableVersion mavenComparableVersion = new MavenComparableVersion(this.languageVersionSettings.getLanguageVersion().getVersionString());
                    break;
                }
                case 2: {
                    MavenComparableVersion mavenComparableVersion = this.languageVersionSettings.getApiVersion().getVersion();
                    break;
                }
                case 3: {
                    MavenComparableVersion mavenComparableVersion;
                    String string2 = KotlinCompilerVersion.getVersion();
                    if (string2 == null) {
                        mavenComparableVersion = null;
                        break;
                    }
                    String string3 = StringsKt.substringBefore$default((String)string2, (char)'-', null, (int)2, null);
                    if (string3 == null) {
                        mavenComparableVersion = null;
                        break;
                    }
                    String string4 = string3;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    String p0 = string4;
                    boolean bl5 = false;
                    mavenComparableVersion = DeprecationResolver.getDeprecationByVersionRequirement$createVersion(p0);
                    break;
                }
                default: {
                    MavenComparableVersion mavenComparableVersion = currentVersion = null;
                }
            }
            if ((currentVersion != null && currentVersion.compareTo(requiredVersion) < 0 ? new DeprecatedByVersionRequirement(versionRequirement, target) : null) == null) continue;
            deprecatedByVersionRequirement = deprecatedByVersionRequirement;
            boolean bl6 = false;
            boolean bl7 = false;
            DeprecatedByVersionRequirement it$iv$iv = deprecatedByVersionRequirement;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmOverloads
    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2, @Nullable Call call2, @Nullable BindingContext bindingContext, boolean isSuperCall) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return DeprecationResolver.isHiddenInResolution$default(this, descriptor2, call2, bindingContext, isSuperCall, false, 16, null);
    }

    @JvmOverloads
    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2, @Nullable Call call2, @Nullable BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return DeprecationResolver.isHiddenInResolution$default(this, descriptor2, call2, bindingContext, false, false, 24, null);
    }

    @JvmOverloads
    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2, @Nullable Call call2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return DeprecationResolver.isHiddenInResolution$default(this, descriptor2, call2, null, false, false, 28, null);
    }

    @JvmOverloads
    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return DeprecationResolver.isHiddenInResolution$default(this, descriptor2, null, null, false, false, 30, null);
    }

    private static final void deprecationByOverridden$traverse(HashSet<CallableMemberDescriptor> visited2, DeprecationResolver this$0, LinkedHashSet<Deprecation> deprecations2, Ref.BooleanRef hasUndeprecatedOverridden, CallableMemberDescriptor node) {
        if (visited2.contains(node)) {
            return;
        }
        visited2.add(node);
        List<Deprecation> deprecationsByAnnotation = this$0.getOwnDeprecations(node);
        Collection collection = node.getOriginal().getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"node.original.overriddenDescriptors");
        Collection overriddenDescriptors = collection;
        collection = deprecationsByAnnotation;
        boolean bl = false;
        if (!collection.isEmpty()) {
            deprecations2.addAll((Collection<Deprecation>)deprecationsByAnnotation);
        } else {
            if (overriddenDescriptors.isEmpty()) {
                hasUndeprecatedOverridden.element = true;
                return;
            }
            Iterable $this$forEach$iv = overriddenDescriptors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CallableMemberDescriptor p0 = (CallableMemberDescriptor)element$iv;
                boolean bl2 = false;
                DeprecationResolver.deprecationByOverridden$traverse(visited2, this$0, deprecations2, hasUndeprecatedOverridden, p0);
            }
        }
    }

    private static final MavenComparableVersion getDeprecationByVersionRequirement$createVersion(String version) {
        MavenComparableVersion mavenComparableVersion;
        try {
            mavenComparableVersion = new MavenComparableVersion(version);
        }
        catch (Exception e) {
            mavenComparableVersion = null;
        }
        return mavenComparableVersion;
    }

    public static final /* synthetic */ List access$getOwnDeprecations(DeprecationResolver $this, DeclarationDescriptor $receiver) {
        return $this.getOwnDeprecations($receiver);
    }

    public static final /* synthetic */ Deprecation access$deprecationByOverridden(DeprecationResolver $this, CallableMemberDescriptor root2) {
        return $this.deprecationByOverridden(root2);
    }

    public static final /* synthetic */ LanguageVersionSettings access$getLanguageVersionSettings$p(DeprecationResolver $this) {
        return $this.languageVersionSettings;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver$Companion;", "", "()V", "JAVA_DEPRECATED", "Lorg/jetbrains/kotlin/name/FqName;", "getJAVA_DEPRECATED", "()Lorg/jetbrains/kotlin/name/FqName;", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FqName getJAVA_DEPRECATED() {
            return JAVA_DEPRECATED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoBuf.VersionRequirement.VersionKind.values().length];
            nArray[ProtoBuf.VersionRequirement.VersionKind.LANGUAGE_VERSION.ordinal()] = 1;
            nArray[ProtoBuf.VersionRequirement.VersionKind.API_VERSION.ordinal()] = 2;
            nArray[ProtoBuf.VersionRequirement.VersionKind.COMPILER_VERSION.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

