/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util.rewriters;

import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00122\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u00182\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/js/inline/util/rewriters/LabelNameRefreshingVisitor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "functionScope", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunctionScope;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsFunctionScope;)V", "getFunctionScope", "()Lorg/jetbrains/kotlin/js/backend/ast/JsFunctionScope;", "substitutions", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Ljava/util/ArrayDeque;", "endVisit", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsBreak;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "Lorg/jetbrains/kotlin/js/backend/ast/JsContinue;", "Lorg/jetbrains/kotlin/js/backend/ast/JsLabel;", "getSubstitution", "name", "visit", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "js.translator"})
public final class LabelNameRefreshingVisitor
extends JsVisitorWithContextImpl {
    @NotNull
    private final JsFunctionScope functionScope;
    @NotNull
    private final Map<JsName, ArrayDeque<JsName>> substitutions;

    public LabelNameRefreshingVisitor(@NotNull JsFunctionScope functionScope) {
        Intrinsics.checkNotNullParameter((Object)functionScope, (String)"functionScope");
        this.functionScope = functionScope;
        boolean bl = false;
        this.substitutions = new LinkedHashMap();
    }

    @NotNull
    public final JsFunctionScope getFunctionScope() {
        return this.functionScope;
    }

    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        return false;
    }

    public void endVisit(@NotNull JsBreak x, @NotNull JsContext<JsNode> ctx) {
        JsName label;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        JsNameRef jsNameRef = x.getLabel();
        JsName jsName = label = jsNameRef == null ? null : jsNameRef.getName();
        if (label != null) {
            ctx.replaceMe(new JsBreak(this.getSubstitution(label).makeRef()).source(x.getSource()));
        }
        super.endVisit(x, ctx);
    }

    public void endVisit(@NotNull JsContinue x, @NotNull JsContext<JsNode> ctx) {
        JsName label;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        JsNameRef jsNameRef = x.getLabel();
        JsName jsName = label = jsNameRef == null ? null : jsNameRef.getName();
        if (label != null) {
            ctx.replaceMe(new JsContinue(this.getSubstitution(label).makeRef()).source(x.getSource()));
        }
        super.endVisit(x, ctx);
    }

    /*
     * WARNING - void declaration
     */
    public boolean visit(@NotNull JsLabel x, @NotNull JsContext<JsNode> ctx) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        JsName labelName = x.getName();
        Object object2 = labelName.getIdent();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"labelName.ident");
        String string2 = object2;
        object2 = labelName.getIdent();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"labelName.ident");
        JsName freshName = this.functionScope.enterLabel(string2, (String)object2);
        object2 = this.substitutions;
        Intrinsics.checkNotNullExpressionValue((Object)labelName, (String)"labelName");
        JsName key$iv = labelName;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            ArrayDeque answer$iv = new ArrayDeque();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((ArrayDeque)object).push(freshName);
        return super.visit(x, ctx);
    }

    public void endVisit(@NotNull JsLabel x, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        JsName labelName = x.getName();
        ArrayDeque<JsName> arrayDeque = this.substitutions.get(labelName);
        Intrinsics.checkNotNull(arrayDeque);
        ArrayDeque<JsName> stack = arrayDeque;
        JsLabel jsLabel = new JsLabel(stack.pop(), x.getStatement());
        boolean bl = false;
        boolean bl2 = false;
        JsLabel $this$endVisit_u24lambda_u2d1 = jsLabel;
        boolean bl3 = false;
        $this$endVisit_u24lambda_u2d1.copyMetadataFrom(x);
        JsLabel replacementLabel = jsLabel;
        ctx.replaceMe((JsNode)replacementLabel);
        this.functionScope.exitLabel();
        super.endVisit(x, ctx);
    }

    private final JsName getSubstitution(JsName name2) {
        JsName jsName;
        ArrayDeque<JsName> arrayDeque = this.substitutions.get(name2);
        return arrayDeque == null ? name2 : ((jsName = arrayDeque.peek()) == null ? name2 : jsName);
    }
}

