/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.stack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFileKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterError;
import org.jetbrains.kotlin.ir.interpreter.stack.SubFrame;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u0000 42\u00020\u0001:\u00014B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bJ\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u0004\u0018\u00010\u000bJ\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\"J\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020$H\u0002J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010(\u001a\u00020\u001dJ\u0006\u0010)\u001a\u00020\u001dJ\b\u0010*\u001a\u0004\u0018\u00010'J\u0006\u0010+\u001a\u00020\u000bJ\u0006\u0010,\u001a\u00020'J\u000e\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020'J\u0006\u0010/\u001a\u00020\u0015J\u0006\u00100\u001a\u00020\u0015J\u0016\u00101\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00102\u001a\u00020'J\b\u00103\u001a\u00020$H\u0016R\u0014\u0010\u0007\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/stack/Frame;", "", "subFrame", "Lorg/jetbrains/kotlin/ir/interpreter/stack/SubFrame;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "(Lorg/jetbrains/kotlin/ir/interpreter/stack/SubFrame;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "currentFrame", "getCurrentFrame", "()Lorg/jetbrains/kotlin/ir/interpreter/stack/SubFrame;", "currentInstruction", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "currentSubFrameOwner", "Lorg/jetbrains/kotlin/ir/IrElement;", "getCurrentSubFrameOwner", "()Lorg/jetbrains/kotlin/ir/IrElement;", "innerStack", "", "getIrFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "addInstruction", "", "instruction", "addSubFrame", "frame", "addVariable", "variable", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "containsVariable", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "dropInstructions", "getAll", "", "getFileAndPositionInfo", "", "getLineNumberForCurrentInstruction", "getState", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "hasNoInstructions", "hasNoSubFrames", "peekState", "popInstruction", "popState", "pushState", "state", "removeSubFrame", "removeSubFrameWithoutDataPropagation", "setState", "newState", "toString", "Companion", "ir.interpreter"})
public final class Frame {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final IrFile irFile;
    @NotNull
    private final List<SubFrame> innerStack;
    @Nullable
    private Instruction currentInstruction;
    @NotNull
    public static final String NOT_DEFINED = "Not defined";

    public Frame(@NotNull SubFrame subFrame, @Nullable IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)subFrame, (String)"subFrame");
        this.irFile = irFile;
        Object[] objectArray = new SubFrame[]{subFrame};
        this.innerStack = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public /* synthetic */ Frame(SubFrame subFrame, IrFile irFile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            irFile = null;
        }
        this(subFrame, irFile);
    }

    @Nullable
    public final IrFile getIrFile() {
        return this.irFile;
    }

    private final SubFrame getCurrentFrame() {
        return (SubFrame)CollectionsKt.last(this.innerStack);
    }

    @NotNull
    public final IrElement getCurrentSubFrameOwner() {
        return this.getCurrentFrame().getOwner();
    }

    public final void addSubFrame(@NotNull SubFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.innerStack.add(frame);
    }

    public final void removeSubFrame() {
        State state2 = this.getCurrentFrame().peekState();
        if (state2 != null) {
            State state3 = state2;
            boolean bl = false;
            boolean bl2 = false;
            State it = state3;
            boolean bl3 = false;
            if (this.innerStack.size() > 1) {
                this.innerStack.get(this.innerStack.size() - 2).pushState(it);
            }
        }
        this.removeSubFrameWithoutDataPropagation();
    }

    public final void removeSubFrameWithoutDataPropagation() {
        CollectionsKt.removeLast(this.innerStack);
    }

    public final boolean hasNoSubFrames() {
        return this.innerStack.isEmpty();
    }

    public final boolean hasNoInstructions() {
        return this.hasNoSubFrames() || this.innerStack.size() == 1 && ((SubFrame)CollectionsKt.first(this.innerStack)).isEmpty();
    }

    public final void addInstruction(@NotNull Instruction instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        this.getCurrentFrame().pushInstruction(instruction);
    }

    @NotNull
    public final Instruction popInstruction() {
        Instruction instruction = this.getCurrentFrame().popInstruction();
        boolean bl = false;
        boolean bl2 = false;
        Instruction $this$popInstruction_u24lambda_u2d1 = instruction;
        boolean bl3 = false;
        this.currentInstruction = $this$popInstruction_u24lambda_u2d1;
        return instruction;
    }

    @Nullable
    public final Instruction dropInstructions() {
        return this.getCurrentFrame().dropInstructions();
    }

    public final void pushState(@NotNull State state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.getCurrentFrame().pushState(state2);
    }

    @NotNull
    public final State popState() {
        return this.getCurrentFrame().popState();
    }

    @Nullable
    public final State peekState() {
        return this.getCurrentFrame().peekState();
    }

    public final void addVariable(@NotNull Variable variable2) {
        Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
        this.getCurrentFrame().addVariable(variable2);
    }

    @NotNull
    public final State getState(@NotNull IrSymbol symbol2) {
        State state2;
        block2: {
            State state3;
            Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
            Iterable iterable = (Iterable)RangesKt.downTo((int)CollectionsKt.getLastIndex(this.innerStack), (int)0);
            boolean bl = false;
            Iterator iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                int n;
                int it = n = ((IntIterator)iterator2).nextInt();
                boolean bl2 = false;
                State state4 = this.innerStack.get(it).getState(symbol2);
                if (state4 == null) continue;
                state3 = state4;
                break block2;
            }
            state3 = state2 = null;
        }
        if (state2 == null) {
            throw new InterpreterError(symbol2 + " not found");
        }
        return state2;
    }

    public final void setState(@NotNull IrSymbol symbol2, @NotNull State newState) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        Iterable $this$forEach$iv = (Iterable)RangesKt.downTo((int)CollectionsKt.getLastIndex(this.innerStack), (int)0);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            if (!this.innerStack.get(it).containsVariable(symbol2)) continue;
            this.innerStack.get(it).setState(symbol2, newState);
            return;
        }
    }

    public final boolean containsVariable(@NotNull IrSymbol symbol2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
            Iterable $this$any$iv = (Iterable)RangesKt.downTo((int)CollectionsKt.getLastIndex(this.innerStack), (int)0);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (!this.innerStack.get(it).containsVariable(symbol2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Variable> getAll() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.innerStack;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SubFrame it = (SubFrame)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getAll();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String getLineNumberForCurrentInstruction() {
        IrFile irFile = this.irFile;
        if (irFile == null) {
            return "";
        }
        Instruction instruction = this.currentInstruction;
        IrElement frameOwner = instruction == null ? null : instruction.getElement();
        return frameOwner instanceof IrExpression || frameOwner instanceof IrDeclaration && Intrinsics.areEqual((Object)((IrDeclaration)frameOwner).getOrigin(), (Object)IrDeclarationOrigin.DEFINED.INSTANCE) ? Intrinsics.stringPlus((String)":", (Object)(this.irFile.getFileEntry().getLineNumber(frameOwner.getStartOffset()) + 1)) : "";
    }

    @NotNull
    public final String getFileAndPositionInfo() {
        IrFile irFile = this.irFile;
        if (irFile == null) {
            return NOT_DEFINED;
        }
        String lineNum = this.getLineNumberForCurrentInstruction();
        return Intrinsics.stringPlus((String)IrFileKt.getName(this.irFile), (Object)lineNum);
    }

    @NotNull
    public String toString() {
        FqName fqName2;
        Object v0;
        String fileNameCapitalized;
        block2: {
            IrFile irFile = this.irFile;
            if (irFile == null) {
                return NOT_DEFINED;
            }
            fileNameCapitalized = CapitalizeDecapitalizeKt.capitalizeAsciiOnly(StringsKt.replace$default((String)IrFileKt.getName(this.irFile), (String)".kt", (String)"Kt", (boolean)false, (int)4, null));
            Iterable $this$firstOrNull$iv = this.innerStack;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SubFrame it = (SubFrame)element$iv;
                boolean bl = false;
                if (!(it.getOwner() instanceof IrFunction)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Object object = v0;
        IrElement irElement = object == null ? null : ((SubFrame)object).getOwner();
        IrFunction entryPoint = irElement instanceof IrFunction ? (IrFunction)irElement : null;
        String lineNum = this.getLineNumberForCurrentInstruction();
        object = entryPoint;
        return "at " + fileNameCapitalized + '.' + (object == null ? "<clinit>" : ((fqName2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) == null ? "<clinit>" : fqName2)) + '(' + IrFileKt.getName(this.irFile) + lineNum + ')';
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/stack/Frame$Companion;", "", "()V", "NOT_DEFINED", "", "ir.interpreter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

