/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatus;
import org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatusKt;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\bR\u0018\u0010\t\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExhaustiveWhenChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenExpressionChecker;", "()V", "isIfExpression", "", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "(Lorg/jetbrains/kotlin/fir/FirSourceElement;)Z", "isWhenExpression", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirExhaustiveWhenChecker
extends FirExpressionChecker<FirWhenExpression> {
    @NotNull
    public static final FirExhaustiveWhenChecker INSTANCE = new FirExhaustiveWhenChecker();

    private FirExhaustiveWhenChecker() {
    }

    @Override
    public void check(@NotNull FirWhenExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        if (expression2.getUsedAsExpression() && !ExhaustivenessStatusKt.isExhaustive(expression2)) {
            FirSourceElement firSourceElement = expression2.getSource();
            if (firSourceElement == null) {
                return;
            }
            Object source = firSourceElement;
            if (this.isIfExpression((FirSourceElement)source)) {
                DiagnosticReporterKt.reportOn$default(reporter2, (FirSourceElement)source, FirErrors.INSTANCE.getINVALID_IF_AS_EXPRESSION(), context2, null, 8, null);
                return;
            }
            if (this.isWhenExpression((FirSourceElement)source)) {
                ExhaustivenessStatus exhaustivenessStatus = expression2.getExhaustivenessStatus();
                if (exhaustivenessStatus == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatus.NotExhaustive");
                }
                List<WhenMissingCase> missingCases = ((ExhaustivenessStatus.NotExhaustive)exhaustivenessStatus).getReasons();
                DiagnosticReporterKt.reportOn$default(reporter2, (FirSourceElement)source, FirErrors.INSTANCE.getNO_ELSE_IN_WHEN(), missingCases, context2, null, 16, null);
            }
        }
        int branchesCount = expression2.getBranches().size();
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)expression2.getBranches())) {
            FirWhenBranch branch = (FirWhenBranch)indexedValue.getValue();
            if (!(branch.getCondition() instanceof FirElseIfTrueCondition) || indexedValue.getIndex() >= branchesCount - 1) continue;
            DiagnosticReporterKt.reportOn$default(reporter2, branch.getSource(), FirErrors.INSTANCE.getELSE_MISPLACED_IN_WHEN(), context2, null, 8, null);
        }
    }

    private final boolean isIfExpression(FirSourceElement $this$isIfExpression) {
        return Intrinsics.areEqual((Object)$this$isIfExpression.getElementType(), (Object)KtNodeTypes.IF);
    }

    private final boolean isWhenExpression(FirSourceElement $this$isWhenExpression) {
        return Intrinsics.areEqual((Object)$this$isWhenExpression.getElementType(), (Object)KtNodeTypes.WHEN);
    }
}

