/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.BuildUtilKt;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ExpectActualTrackerImpl;
import org.jetbrains.kotlin.incremental.IncrementalCacheCommon;
import org.jetbrains.kotlin.incremental.storage.AbstractDirtyClassesMap;
import org.jetbrains.kotlin.incremental.storage.AbstractSourceToOutputMap;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.ClassAttributesMap;
import org.jetbrains.kotlin.incremental.storage.ComplementarySourceFilesMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.ICClassesAttributes;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.PathStringDescriptor;
import org.jetbrains.kotlin.incremental.storage.SubtypesMap;
import org.jetbrains.kotlin.incremental.storage.SupertypesMap;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 L*\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u0003:\u0002KLB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J \u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0005H\u0004J\u001c\u00103\u001a\b\u0012\u0004\u0012\u000205042\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00050%H\u0016J\u001c\u00107\u001a\b\u0012\u0004\u0012\u00020\u0005042\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000504H\u0016J\u0012\u00109\u001a\u0004\u0018\u00010\u00052\u0006\u0010:\u001a\u000205H\u0016J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u0002050<2\u0006\u0010=\u001a\u000205H\u0016J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u0002050<2\u0006\u0010=\u001a\u000205H\u0016J\u0017\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010=\u001a\u000205H\u0016\u00a2\u0006\u0002\u0010AJ\u0016\u0010B\u001a\u00020+2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u000504H\u0016J\u001e\u0010D\u001a\u00020+2\f\u0010E\u001a\b\u0012\u0004\u0012\u000205042\u0006\u0010F\u001a\u00020GH\u0004J\u001e\u0010H\u001a\u00020+2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u0005042\u0006\u0010I\u001a\u00020JH\u0016R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0013\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u0014j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000%8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b&\u0010'\u00a8\u0006M"}, d2={"Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache;", "ClassName", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheCommon;", "workingDir", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "classAttributesMap", "Lorg/jetbrains/kotlin/incremental/storage/ClassAttributesMap;", "getClassAttributesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/ClassAttributesMap;", "classFqNameToSourceMap", "Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache$ClassFqNameToSourceMap;", "getClassFqNameToSourceMap", "()Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache$ClassFqNameToSourceMap;", "complementaryFilesMap", "Lorg/jetbrains/kotlin/incremental/storage/ComplementarySourceFilesMap;", "dependents", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "dirtyOutputClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/AbstractDirtyClassesMap;", "getDirtyOutputClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/AbstractDirtyClassesMap;", "getPathConverter", "()Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "sourceToClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/AbstractSourceToOutputMap;", "getSourceToClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/AbstractSourceToOutputMap;", "subtypesMap", "Lorg/jetbrains/kotlin/incremental/storage/SubtypesMap;", "supertypesMap", "Lorg/jetbrains/kotlin/incremental/storage/SupertypesMap;", "thisWithDependentCaches", "", "getThisWithDependentCaches", "()Ljava/lang/Iterable;", "thisWithDependentCaches$delegate", "Lkotlin/Lazy;", "addDependentCache", "", "cache", "addToClassStorage", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "srcFile", "classesFqNamesBySources", "", "Lorg/jetbrains/kotlin/name/FqName;", "files", "getComplementaryFilesRecursive", "dirtyFiles", "getSourceFileIfClass", "fqName", "getSubtypesOf", "Lkotlin/sequences/Sequence;", "className", "getSupertypesOf", "isSealed", "", "(Lorg/jetbrains/kotlin/name/FqName;)Ljava/lang/Boolean;", "markDirty", "removedAndCompiledSources", "removeAllFromClassStorage", "removedClasses", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "updateComplementaryFiles", "expectActualTracker", "Lorg/jetbrains/kotlin/incremental/ExpectActualTrackerImpl;", "ClassFqNameToSourceMap", "Companion", "kotlin-build-common"})
public abstract class AbstractIncrementalCache<ClassName>
extends BasicMapsOwner
implements IncrementalCacheCommon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileToPathConverter pathConverter;
    @NotNull
    private final ArrayList<AbstractIncrementalCache<ClassName>> dependents;
    @NotNull
    private final Lazy thisWithDependentCaches$delegate;
    @NotNull
    private final ClassAttributesMap classAttributesMap;
    @NotNull
    private final SubtypesMap subtypesMap;
    @NotNull
    private final SupertypesMap supertypesMap;
    @NotNull
    private final ClassFqNameToSourceMap classFqNameToSourceMap;
    @NotNull
    private final ComplementarySourceFilesMap complementaryFilesMap;
    @NotNull
    private static final String CLASS_ATTRIBUTES = "class-attributes";
    @NotNull
    private static final String SUBTYPES = "subtypes";
    @NotNull
    private static final String SUPERTYPES = "supertypes";
    @NotNull
    private static final String CLASS_FQ_NAME_TO_SOURCE = "class-fq-name-to-source";
    @NotNull
    private static final String COMPLEMENTARY_FILES = "complementary-files";
    @NotNull
    private static final String SOURCE_TO_CLASSES = "source-to-classes";
    @NotNull
    private static final String DIRTY_OUTPUT_CLASSES = "dirty-output-classes";

    public AbstractIncrementalCache(@NotNull File workingDir, @NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        super(workingDir);
        this.pathConverter = pathConverter;
        boolean bl = false;
        this.dependents = new ArrayList();
        this.thisWithDependentCaches$delegate = LazyKt.lazy((Function0)new Function0<ArrayList<AbstractIncrementalCache<ClassName>>>(this){
            final /* synthetic */ AbstractIncrementalCache<ClassName> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ArrayList<AbstractIncrementalCache<ClassName>> invoke() {
                Object[] objectArray = new AbstractIncrementalCache[]{this.this$0};
                ArrayList result2 = CollectionsKt.arrayListOf((Object[])objectArray);
                result2.addAll(AbstractIncrementalCache.access$getDependents$p(this.this$0));
                return result2;
            }
        });
        this.classAttributesMap = (ClassAttributesMap)this.registerMap((BasicMap)new ClassAttributesMap(this.getStorageFile(CLASS_ATTRIBUTES)));
        this.subtypesMap = (SubtypesMap)this.registerMap((BasicMap)new SubtypesMap(this.getStorageFile(SUBTYPES)));
        this.supertypesMap = (SupertypesMap)this.registerMap((BasicMap)new SupertypesMap(this.getStorageFile(SUPERTYPES)));
        this.classFqNameToSourceMap = (ClassFqNameToSourceMap)this.registerMap((BasicMap)new ClassFqNameToSourceMap(this.getStorageFile(CLASS_FQ_NAME_TO_SOURCE), this.pathConverter));
        this.complementaryFilesMap = (ComplementarySourceFilesMap)this.registerMap((BasicMap)new ComplementarySourceFilesMap(this.getStorageFile(COMPLEMENTARY_FILES), this.pathConverter));
    }

    @NotNull
    protected final FileToPathConverter getPathConverter() {
        return this.pathConverter;
    }

    public final void addDependentCache(@NotNull AbstractIncrementalCache<ClassName> cache2) {
        Intrinsics.checkNotNullParameter(cache2, (String)"cache");
        this.dependents.add(cache2);
    }

    @NotNull
    public Iterable<AbstractIncrementalCache<ClassName>> getThisWithDependentCaches() {
        Lazy lazy = this.thisWithDependentCaches$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Iterable)lazy.getValue();
    }

    @NotNull
    public final ClassAttributesMap getClassAttributesMap$kotlin_build_common() {
        return this.classAttributesMap;
    }

    @NotNull
    protected final ClassFqNameToSourceMap getClassFqNameToSourceMap() {
        return this.classFqNameToSourceMap;
    }

    @NotNull
    public abstract AbstractSourceToOutputMap<ClassName> getSourceToClassesMap$kotlin_build_common();

    @NotNull
    public abstract AbstractDirtyClassesMap<ClassName> getDirtyOutputClassesMap$kotlin_build_common();

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<FqName> classesFqNamesBySources(@NotNull Iterable<? extends File> files2) {
        void var3_3;
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Iterable<? extends File> iterable = files2;
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            Iterable list$iv = this.getSourceToClassesMap$kotlin_build_common().getFqNames(it);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return var3_3;
    }

    @Override
    @NotNull
    public Sequence<FqName> getSubtypesOf(@NotNull FqName className2) {
        Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
        return CollectionsKt.asSequence((Iterable)this.subtypesMap.get(className2));
    }

    @Override
    @NotNull
    public Sequence<FqName> getSupertypesOf(@NotNull FqName className2) {
        Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
        return CollectionsKt.asSequence((Iterable)this.supertypesMap.get(className2));
    }

    @Override
    @Nullable
    public Boolean isSealed(@NotNull FqName className2) {
        Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
        ICClassesAttributes iCClassesAttributes = this.classAttributesMap.get(className2);
        return iCClassesAttributes == null ? null : Boolean.valueOf(iCClassesAttributes.isSealed());
    }

    @Override
    @Nullable
    public File getSourceFileIfClass(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return this.classFqNameToSourceMap.get(fqName2);
    }

    @Override
    public void markDirty(@NotNull Collection<? extends File> removedAndCompiledSources) {
        Intrinsics.checkNotNullParameter(removedAndCompiledSources, (String)"removedAndCompiledSources");
        for (File file2 : removedAndCompiledSources) {
            Collection<ClassName> classes2 = this.getSourceToClassesMap$kotlin_build_common().get(file2);
            Iterable $this$forEach$iv = classes2;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator2.next();
                boolean bl = false;
                this.getDirtyOutputClassesMap$kotlin_build_common().markDirty(it);
            }
            this.getSourceToClassesMap$kotlin_build_common().clearOutputsForSource(file2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void addToClassStorage(@NotNull ProtoBuf.Class proto, @NotNull NameResolver nameResolver2, @NotNull File srcFile) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv;
        FqName it;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)srcFile, (String)"srcFile");
        ProtoBuf.TypeTable typeTable = proto.getTypeTable();
        Intrinsics.checkNotNullExpressionValue((Object)typeTable, (String)"proto.typeTable");
        List<ProtoBuf.Type> supertypes2 = ProtoTypeTableUtilKt.supertypes(proto, new TypeTable(typeTable));
        Iterable $this$map$iv = supertypes2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ProtoBuf.Type type2 = (ProtoBuf.Type)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FqName fqName2 = NameResolverUtilKt.getClassId(nameResolver2, ((ProtoBuf.Type)((Object)it)).getClassName()).asSingleFqName();
            collection.add(fqName2);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter22 = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (FqName)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.asString(), (Object)"kotlin.Any"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set parents2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        FqName $i$f$filter22 = NameResolverUtilKt.getClassId(nameResolver2, proto.getFqName()).asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$filter22, (String)"nameResolver.getClassId(\u2026.fqName).asSingleFqName()");
        FqName child = $i$f$filter22;
        Iterable $this$forEach$iv = parents2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FqName it2 = (FqName)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
            this.subtypesMap.add(it2, child);
        }
        Iterable $this$filter$iv2 = this.supertypesMap.get(child);
        boolean $i$f$filter = false;
        Iterable element$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FqName it3 = (FqName)element$iv$iv;
            boolean bl = false;
            if (!(!parents2.contains(it3))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List removedSupertypes = (List)destination$iv$iv2;
        Iterable $this$forEach$iv2 = removedSupertypes;
        boolean $i$f$forEach2 = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            FqName it4 = (FqName)element$iv2;
            boolean bl = false;
            this.subtypesMap.removeValues(it4, SetsKt.setOf((Object)child));
        }
        this.supertypesMap.set(child, parents2);
        this.classFqNameToSourceMap.set(child, srcFile);
        this.classAttributesMap.set(child, new ICClassesAttributes(ProtoBuf.Modality.SEALED == Flags.MODALITY.get(proto.getFlags())));
    }

    protected final void removeAllFromClassStorage(@NotNull Collection<FqName> removedClasses, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkNotNullParameter(removedClasses, (String)"removedClasses");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        if (removedClasses.isEmpty()) {
            return;
        }
        Set removedFqNames = CollectionsKt.toSet((Iterable)removedClasses);
        for (FqName fqName2 : removedFqNames) {
            for (FqName affectedClass : BuildUtilKt.withSubtypes(fqName2, this.getThisWithDependentCaches())) {
                changesCollector.collectSignature(affectedClass, false);
            }
        }
        for (AbstractIncrementalCache abstractIncrementalCache : this.getThisWithDependentCaches()) {
            boolean affectedClass = false;
            HashSet<FqName> parentsFqNames = new HashSet<FqName>();
            boolean bl = false;
            HashSet<FqName> childrenFqNames = new HashSet<FqName>();
            for (FqName removedFqName : removedFqNames) {
                parentsFqNames.addAll(abstractIncrementalCache.supertypesMap.get(removedFqName));
                childrenFqNames.addAll(abstractIncrementalCache.subtypesMap.get(removedFqName));
                abstractIncrementalCache.supertypesMap.remove(removedFqName);
                abstractIncrementalCache.subtypesMap.remove(removedFqName);
            }
            for (FqName child : childrenFqNames) {
                SupertypesMap supertypesMap = abstractIncrementalCache.supertypesMap;
                Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                supertypesMap.removeValues(child, removedFqNames);
            }
            for (FqName parent2 : parentsFqNames) {
                SubtypesMap subtypesMap = abstractIncrementalCache.subtypesMap;
                Intrinsics.checkNotNullExpressionValue((Object)parent2, (String)"parent");
                subtypesMap.removeValues(parent2, removedFqNames);
            }
        }
        Iterable $this$forEach$iv = removedFqNames;
        boolean bl = false;
        Iterator<FqName> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            FqName element$iv;
            FqName it = element$iv = iterator2.next();
            boolean bl2 = false;
            this.getClassFqNameToSourceMap().remove(it);
            this.getClassAttributesMap$kotlin_build_common().remove(it);
        }
    }

    @Override
    @NotNull
    public Collection<File> getComplementaryFilesRecursive(@NotNull Collection<? extends File> dirtyFiles) {
        Intrinsics.checkNotNullParameter(dirtyFiles, (String)"dirtyFiles");
        HashSet<File> complementaryFiles = new HashSet<File>();
        ArrayDeque<? extends File> filesQueue = new ArrayDeque<File>(dirtyFiles);
        block0: while (true) {
            Collection collection = filesQueue;
            boolean bl = false;
            if (!(!collection.isEmpty())) break;
            File file2 = filesQueue.pollFirst();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            Iterable $this$forEach$iv = this.complementaryFilesMap.get(file2);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block0;
                Object element$iv = iterator2.next();
                File it = (File)element$iv;
                boolean bl2 = false;
                if (!complementaryFiles.add(it)) continue;
                filesQueue.add(it);
            }
            break;
        }
        complementaryFiles.removeAll(dirtyFiles);
        return complementaryFiles;
    }

    @Override
    public void updateComplementaryFiles(@NotNull Collection<? extends File> dirtyFiles, @NotNull ExpectActualTrackerImpl expectActualTracker) {
        Object actuals;
        boolean bl;
        Object it;
        Intrinsics.checkNotNullParameter(dirtyFiles, (String)"dirtyFiles");
        Intrinsics.checkNotNullParameter((Object)expectActualTracker, (String)"expectActualTracker");
        Iterable $this$forEach$iv = dirtyFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (File)element$iv;
            boolean bl2 = false;
            this.complementaryFilesMap.remove((File)it);
        }
        boolean bl3 = false;
        HashMap actualToExpect = new HashMap();
        Map.Entry entry2 = expectActualTracker.getExpectToActualMap();
        boolean element$iv = false;
        for (Map.Entry entry2 : entry2.entrySet()) {
            it = entry2;
            boolean bl4 = false;
            File expect = (File)it.getKey();
            Object object = entry2;
            bl = false;
            actuals = (Set)object.getValue();
            object = actuals.iterator();
            while (object.hasNext()) {
                Object object2;
                File actual = (File)object.next();
                Map $this$getOrPut$iv = actualToExpect;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(actual);
                if (value$iv == null) {
                    boolean bl5 = false;
                    boolean bl6 = false;
                    Set answer$iv = new HashSet();
                    $this$getOrPut$iv.put(actual, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((Set)object2).add(expect);
            }
            this.complementaryFilesMap.set(expect, (Collection)actuals);
        }
        entry2 = actualToExpect;
        boolean expect = false;
        for (Map.Entry entry2 : entry2.entrySet()) {
            actuals = entry2;
            boolean bl7 = false;
            File actual = (File)actuals.getKey();
            Map.Entry entry3 = entry2;
            bl = false;
            Set expects = (Set)entry3.getValue();
            this.complementaryFilesMap.set(actual, expects);
        }
    }

    @NotNull
    protected static final String getSOURCE_TO_CLASSES() {
        return Companion.getSOURCE_TO_CLASSES();
    }

    @NotNull
    protected static final String getDIRTY_OUTPUT_CLASSES() {
        return Companion.getDIRTY_OUTPUT_CLASSES();
    }

    public static final /* synthetic */ ArrayList access$getDependents$p(AbstractIncrementalCache $this) {
        return $this.dependents;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u00020\u00048\u0004X\u0085D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u00020\u00048\u0004X\u0085D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\nR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache$Companion;", "", "()V", "CLASS_ATTRIBUTES", "", "CLASS_FQ_NAME_TO_SOURCE", "COMPLEMENTARY_FILES", "DIRTY_OUTPUT_CLASSES", "getDIRTY_OUTPUT_CLASSES$annotations", "getDIRTY_OUTPUT_CLASSES", "()Ljava/lang/String;", "SOURCE_TO_CLASSES", "getSOURCE_TO_CLASSES$annotations", "getSOURCE_TO_CLASSES", "SUBTYPES", "SUPERTYPES", "kotlin-build-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final String getSOURCE_TO_CLASSES() {
            return SOURCE_TO_CLASSES;
        }

        @JvmStatic
        protected static /* synthetic */ void getSOURCE_TO_CLASSES$annotations() {
        }

        @NotNull
        protected final String getDIRTY_OUTPUT_CLASSES() {
            return DIRTY_OUTPUT_CLASSES;
        }

        @JvmStatic
        protected static /* synthetic */ void getDIRTY_OUTPUT_CLASSES$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u0013\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u0019\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0086\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache$ClassFqNameToSourceMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "dumpValue", "value", "get", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "remove", "", "set", "sourceFile", "kotlin-build-common"})
    protected static final class ClassFqNameToSourceMap
    extends BasicStringMap<String> {
        @NotNull
        private final FileToPathConverter pathConverter;

        public ClassFqNameToSourceMap(@NotNull File storageFile, @NotNull FileToPathConverter pathConverter) {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
            super(storageFile, (KeyDescriptor<String>)((KeyDescriptor)new EnumeratorStringDescriptor()), (DataExternalizer)PathStringDescriptor.INSTANCE);
            this.pathConverter = pathConverter;
        }

        public final void set(@NotNull FqName fqName2, @NotNull File sourceFile) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
            LazyStorage<String, String> lazyStorage = this.getStorage();
            String string2 = fqName2.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fqName.asString()");
            lazyStorage.set(string2, this.pathConverter.toPath(sourceFile));
        }

        @Nullable
        public final File get(@NotNull FqName fqName2) {
            File file2;
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = fqName2.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fqName.asString()");
            String string3 = (String)lazyStorage.get(string2);
            if (string3 == null) {
                file2 = null;
            } else {
                string2 = string3;
                FileToPathConverter fileToPathConverter = this.pathConverter;
                boolean bl = false;
                boolean bl2 = false;
                String p0 = string2;
                boolean bl3 = false;
                file2 = fileToPathConverter.toFile(p0);
            }
            return file2;
        }

        public final void remove(@NotNull FqName fqName2) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = fqName2.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fqName.asString()");
            lazyStorage.remove(string2);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return value2;
        }
    }
}

