/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.SuperCallCheckersKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSupertypesResolutionKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedSupertypeExtendedByOtherSupertypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirQualifiedSupertypeExtendedByOtherSupertypeChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirQualifiedSupertypeExtendedByOtherSupertypeChecker INSTANCE = new FirQualifiedSupertypeExtendedByOtherSupertypeChecker();

    private FirQualifiedSupertypeExtendedByOtherSupertypeChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        FirSuperReference firSuperReference;
        FirElement firElement;
        FirElement firElement2;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirElement $this$safeAs$iv = expression2.getCalleeReference();
        boolean $i$f$safeAs = false;
        FirElement firElement3 = $this$safeAs$iv;
        if (!(firElement3 instanceof FirSuperReference)) {
            firElement3 = null;
        }
        if ((firElement2 = (FirSuperReference)firElement3) == null) {
            firElement = null;
        } else {
            $this$safeAs$iv = firElement2;
            $i$f$safeAs = false;
            boolean bl = false;
            FirReference firReference = $this$safeAs$iv;
            boolean bl2 = false;
            firElement = firSuperReference = SuperCallCheckersKt.hadExplicitTypeInSource((FirSuperReference)firReference) ? $this$safeAs$iv : null;
        }
        if (firSuperReference == null) {
            return;
        }
        FirSuperReference superReference = firSuperReference;
        $this$safeAs$iv = FirSupertypesResolutionKt.firClassLike(superReference.getSuperTypeRef(), context2.getSession());
        $this$safeAs$iv = $this$safeAs$iv == null ? null : FirHelpersKt.followAllAlias($this$safeAs$iv, context2.getSession());
        $i$f$safeAs = false;
        FirElement firElement4 = $this$safeAs$iv;
        if (!(firElement4 instanceof FirClass)) {
            firElement4 = null;
        }
        if ((firElement2 = (FirClass)firElement4) == null) {
            return;
        }
        FirElement explicitType = firElement2;
        $this$safeAs$iv = FirHelpersKt.findClosestClassOrObject(context2);
        if ($this$safeAs$iv == null) {
            return;
        }
        FirElement surroundingType = $this$safeAs$iv;
        int count = 0;
        FirClass candidate2 = null;
        for (FirTypeRef firTypeRef : surroundingType.getSuperTypeRefs()) {
            FirClass firClass;
            FirClassLikeDeclaration<?> firClassLikeDeclaration = FirSupertypesResolutionKt.firClassLike(firTypeRef, context2.getSession());
            FirClassLikeDeclaration<?> $this$safeAs$iv2 = firClassLikeDeclaration == null ? null : FirHelpersKt.followAllAlias(firClassLikeDeclaration, context2.getSession());
            boolean $i$f$safeAs2 = false;
            FirClassLikeDeclaration<?> firClassLikeDeclaration2 = $this$safeAs$iv2;
            if (!(firClassLikeDeclaration2 instanceof FirClass)) {
                firClassLikeDeclaration2 = null;
            }
            if ((firClass = (FirClass)firClassLikeDeclaration2) == null) continue;
            FirClass that = firClass;
            boolean isSupertype = FirHelpersKt.isSupertypeOf(explicitType, that, context2.getSession());
            if (!Intrinsics.areEqual((Object)explicitType, (Object)that) && !isSupertype) continue;
            if (isSupertype) {
                candidate2 = that;
            }
            if (++count < 2) continue;
        }
        if (count >= 2 && candidate2 != null) {
            DiagnosticReporterKt.reportOn$default(reporter2, superReference.getSuperTypeRef().getSource(), FirErrors.INSTANCE.getQUALIFIED_SUPERTYPE_EXTENDED_BY_OTHER_SUPERTYPE(), candidate2, context2, null, 16, null);
        }
    }
}

