/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReifiedTypeParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "areAccessorsInline", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkers"})
public final class FirReifiedTypeParameterChecker
extends FirDeclarationChecker<FirTypeParameter> {
    @NotNull
    public static final FirReifiedTypeParameterChecker INSTANCE = new FirReifiedTypeParameterChecker();

    private FirReifiedTypeParameterChecker() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirTypeParameter declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        block5: {
            FirDeclaration containingDeclaration;
            block6: {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
                if (!declaration.isReified()) {
                    return;
                }
                FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
                if (firDeclaration == null) {
                    return;
                }
                containingDeclaration = firDeclaration;
                if (containingDeclaration instanceof FirRegularClass) break block5;
                if (!(containingDeclaration instanceof FirSimpleFunction)) break block6;
                FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)((Object)containingDeclaration);
                boolean $i$f$isInline = false;
                if (!$this$isInline$iv.getStatus().isInline()) break block5;
            }
            if (!(containingDeclaration instanceof FirProperty)) return;
            if (this.areAccessorsInline((FirProperty)containingDeclaration)) return;
        }
        boolean bl = true;
        boolean forbidReified = bl;
        if (!forbidReified) return;
        DiagnosticReporterKt.reportOn$default(reporter2, declaration.getSource(), FirErrors.INSTANCE.getREIFIED_TYPE_PARAMETER_NO_INLINE(), context2, null, 8, null);
    }

    private final boolean areAccessorsInline(FirProperty $this$areAccessorsInline) {
        boolean $i$f$isInline;
        FirMemberDeclaration $this$isInline$iv;
        boolean bl;
        FirPropertyAccessor firPropertyAccessor = $this$areAccessorsInline.getGetter();
        if (firPropertyAccessor == null) {
            bl = false;
        } else {
            $this$isInline$iv = firPropertyAccessor;
            $i$f$isInline = false;
            bl = $this$isInline$iv.getStatus().isInline();
        }
        if (!bl) {
            return false;
        }
        if ($this$areAccessorsInline.isVar()) {
            boolean bl2;
            firPropertyAccessor = $this$areAccessorsInline.getSetter();
            if (firPropertyAccessor == null) {
                bl2 = false;
            } else {
                $this$isInline$iv = firPropertyAccessor;
                $i$f$isInline = false;
                bl2 = $this$isInline$iv.getStatus().isInline();
            }
            if (!bl2) {
                return false;
            }
        }
        return true;
    }
}

