/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.DataClassArrayToString;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/DataClassArrayToString;", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "()V", "arrayToString", "", "array", "", "evaluate", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getListOfAcceptableFunctions", "", "ir.interpreter"})
public final class DataClassArrayToString
extends IntrinsicBase {
    @NotNull
    public static final DataClassArrayToString INSTANCE = new DataClassArrayToString();

    private DataClassArrayToString() {
        super(null);
    }

    @Override
    @NotNull
    public List<String> getListOfAcceptableFunctions() {
        return CollectionsKt.listOf((Object)"kotlin.internal.ir.dataClassArrayMemberToString");
    }

    private final String arrayToString(Object array2) {
        String string2;
        Object object = array2;
        if (object == null) {
            string2 = "null";
        } else if (object instanceof Object[]) {
            String string3 = Arrays.toString((Object[])array2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(array)");
            string2 = string3;
        } else if (object instanceof byte[]) {
            String string4 = Arrays.toString((byte[])array2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(array)");
            string2 = string4;
        } else if (object instanceof short[]) {
            String string5 = Arrays.toString((short[])array2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(array)");
            string2 = string5;
        } else if (object instanceof int[]) {
            String string6 = Arrays.toString((int[])array2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(array)");
            string2 = string6;
        } else if (object instanceof long[]) {
            String string7 = Arrays.toString((long[])array2);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(array)");
            string2 = string7;
        } else if (object instanceof char[]) {
            String string8 = Arrays.toString((char[])array2);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toString(array)");
            string2 = string8;
        } else if (object instanceof boolean[]) {
            String string9 = Arrays.toString((boolean[])array2);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toString(array)");
            string2 = string9;
        } else if (object instanceof float[]) {
            String string10 = Arrays.toString((float[])array2);
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toString(array)");
            string2 = string10;
        } else if (object instanceof double[]) {
            String string11 = Arrays.toString((double[])array2);
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"toString(array)");
            string2 = string11;
        } else {
            ExceptionUtilsKt.stop((Function0<? extends Object>)((Function0)arrayToString.1.INSTANCE));
            throw null;
        }
        return string2;
    }

    @Override
    public void evaluate(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment2) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Primitive array2 = (Primitive)environment2.getCallStack$ir_interpreter().loadState(((IrValueParameter)CollectionsKt.single(irFunction2.getValueParameters())).getSymbol());
        environment2.getCallStack$ir_interpreter().pushState(environment2.convertToState$ir_interpreter(this.arrayToString(array2.getValue()), irFunction2.getReturnType()));
    }
}

