/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslatorKt;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 )2\u00020\u0001:\u0002()B%\b\u0002\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ4\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0002J \u0010\u001a\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00050\u001f2\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0002J6\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00050\u001f2\u0006\u0010$\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010%\u001a\u00020\n*\u00020\u0013H\u0002J\u0014\u0010&\u001a\u00020\u0005*\u00020\u00052\u0006\u0010'\u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiver", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "isNativeFunctionCall", "", "typeToUTypeArray", "", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "prepareConcatArguments", "", "arguments", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "list", "varargElementType", "Lorg/jetbrains/kotlin/types/KotlinType;", "removeLastUndefinedArguments", "", "result", "toArray", "elements", "translate", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "translateUnresolvedArguments", "", "translateVarargArgument", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "translatedArgs", "shouldWrapVarargInArray", "hasSpreadElementOrNamedArgument", "wrapInUArray", "elementType", "ArgumentsInfo", "Companion", "js.translator"})
public final class CallArgumentTranslator
extends AbstractTranslator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResolvedCall<?> resolvedCall;
    @Nullable
    private final JsExpression receiver;
    @NotNull
    private final TranslationContext context;
    private final boolean isNativeFunctionCall;
    @NotNull
    private final Map<PrimitiveType, ClassDescriptor> typeToUTypeArray;

    private CallArgumentTranslator(ResolvedCall<?> resolvedCall2, JsExpression receiver, TranslationContext context2) {
        super(context2);
        this.resolvedCall = resolvedCall2;
        this.receiver = receiver;
        this.context = context2;
        this.isNativeFunctionCall = AnnotationsUtils.isNativeObject((DeclarationDescriptor)this.resolvedCall.getCandidateDescriptor());
        this.typeToUTypeArray = new LinkedHashMap();
    }

    private final void removeLastUndefinedArguments(List<JsExpression> result2) {
        int i = CollectionsKt.getLastIndex(result2);
        while (i >= 0 && JsAstUtils.isUndefinedExpression(result2.get(i))) {
            int n = i;
            i = n + -1;
        }
        result2.subList(i + 1, result2.size()).clear();
    }

    private final boolean hasSpreadElementOrNamedArgument(ValueArgument $this$hasSpreadElementOrNamedArgument) {
        return $this$hasSpreadElementOrNamedArgument.getSpreadElement() != null || this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowAssigningArrayElementsToVarargsInNamedFormForFunctions) && $this$hasSpreadElementOrNamedArgument.isNamed();
    }

    private final ArgumentsInfo translate() {
        Object callableDescriptor;
        List<ResolvedValueArgument> list2;
        List<ValueParameterDescriptor> list3 = this.resolvedCall.getResultingDescriptor().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"resolvedCall.resultingDescriptor.valueParameters");
        List<ValueParameterDescriptor> valueParameters2 = list3;
        boolean hasSpreadOperator = false;
        TemporaryConstVariable cachedReceiver = null;
        List<Object[]> result2 = null;
        result2 = new ArrayList(valueParameters2.size());
        List<ResolvedValueArgument> list4 = this.resolvedCall.getValueArgumentsByIndex();
        if (list4 == null) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Failed to arrange value arguments by index: ", this.resolvedCall.getResultingDescriptor()));
        }
        List<ResolvedValueArgument> valueArgumentsByIndex = list2 = list4;
        List argsBeforeVararg = null;
        List<JsExpression> concatArguments = null;
        TranslationContext translationContext = this.context();
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context()");
        Map<ValueArgument, JsExpression> argsToJsExpr = this.translateUnresolvedArguments(translationContext, this.resolvedCall);
        KotlinType varargElementType = null;
        for (ValueParameterDescriptor parameterDescriptor : valueParameters2) {
            ResolvedValueArgument actualArgument = valueArgumentsByIndex.get(parameterDescriptor.getIndex());
            if (actualArgument instanceof VarargValueArgument) {
                Object object;
                Object it;
                Object object2 = actualArgument.getArguments();
                Intrinsics.checkNotNullExpressionValue(object2, (String)"actualArgument.getArguments()");
                List<ValueArgument> arguments2 = object2;
                if (!hasSpreadOperator) {
                    boolean bl;
                    block20: {
                        Iterable $this$any$iv = arguments2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                ValueArgument it2 = (ValueArgument)element$iv;
                                boolean bl2 = false;
                                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                                if (!this.hasSpreadElementOrNamedArgument(it2)) continue;
                                bl = true;
                                break block20;
                            }
                            bl = false;
                        }
                    }
                    hasSpreadOperator = bl;
                }
                Intrinsics.checkNotNull((Object)parameterDescriptor.getOriginal().getVarargElementType());
                if (hasSpreadOperator) {
                    Object object3;
                    if (this.isNativeFunctionCall) {
                        argsBeforeVararg = result2;
                        result2 = new ArrayList();
                        concatArguments = this.prepareConcatArguments(arguments2, CallArgumentTranslator.Companion.translateResolvedArgument(actualArgument, argsToJsExpr), null);
                        continue;
                    }
                    object2 = this.translateVarargArgument(actualArgument, argsToJsExpr, ((VarargValueArgument)actualArgument).getArguments().size() > 1, varargElementType);
                    if (object2 == null) continue;
                    it = object3 = object2;
                    boolean bl = false;
                    ((List)result2).add(it);
                    continue;
                }
                if (this.isNativeFunctionCall) {
                    ((List)result2).addAll(CallArgumentTranslator.Companion.translateResolvedArgument(actualArgument, argsToJsExpr));
                    continue;
                }
                object2 = this.translateVarargArgument(actualArgument, argsToJsExpr, true, varargElementType);
                if (object2 == null) continue;
                it = object = object2;
                boolean bl = false;
                ((List)result2).add(it);
                continue;
            }
            List list5 = result2;
            Intrinsics.checkNotNullExpressionValue((Object)actualArgument, (String)"actualArgument");
            list5.addAll(CallArgumentTranslator.Companion.translateResolvedArgument(actualArgument, argsToJsExpr));
        }
        if (this.isNativeFunctionCall && hasSpreadOperator) {
            boolean bl;
            boolean bl3 = bl = argsBeforeVararg != null;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-CallArgumentTranslator$translate$62 = false;
                String $i$a$-assert-CallArgumentTranslator$translate$62 = "argsBeforeVararg should not be null";
                throw new AssertionError((Object)$i$a$-assert-CallArgumentTranslator$translate$62);
            }
            boolean bl4 = bl = concatArguments != null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl5 = false;
                String string2 = "concatArguments should not be null";
                throw new AssertionError((Object)string2);
            }
            if (!((List)result2).isEmpty()) {
                List<JsExpression> list6 = concatArguments;
                Intrinsics.checkNotNull(list6);
                list6.add(this.toArray(null, (List<? extends JsExpression>)result2));
            }
            List list7 = argsBeforeVararg;
            Intrinsics.checkNotNull(list7);
            if (!list7.isEmpty()) {
                List<JsExpression> list8 = concatArguments;
                Intrinsics.checkNotNull(list8);
                list8.add(0, this.toArray(null, argsBeforeVararg));
            }
            Object object = new JsExpression[1];
            List<JsExpression> list9 = concatArguments;
            Intrinsics.checkNotNull((Object)list9);
            object[0] = CallArgumentTranslator.Companion.concatArgumentsIfNeeded(list9, varargElementType, true);
            result2 = CollectionsKt.mutableListOf((Object[])object);
            if (this.receiver != null) {
                cachedReceiver = this.context().getOrDeclareTemporaryConstVariable(this.receiver);
                object = cachedReceiver.reference();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cachedReceiver.reference()");
                result2.add(0, (Object[])object);
            } else if (DescriptorUtils.isObject(this.resolvedCall.getResultingDescriptor().getContainingDeclaration())) {
                cachedReceiver = this.context().getOrDeclareTemporaryConstVariable(ReferenceTranslator.translateAsValueReference(this.resolvedCall.getResultingDescriptor().getContainingDeclaration(), this.context()));
                object = cachedReceiver.reference();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cachedReceiver.reference()");
                result2.add(0, (Object[])object);
            } else {
                result2.add(0, (Object[])new JsNullLiteral());
            }
        }
        if ((callableDescriptor = this.resolvedCall.getResultingDescriptor()) instanceof FunctionDescriptor && ((FunctionDescriptor)callableDescriptor).isSuspend()) {
            List list10 = result2;
            JsExpression jsExpression = TranslationUtils.translateContinuationArgument(this.context());
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"translateContinuationArgument(context())");
            list10.add(jsExpression);
        }
        this.removeLastUndefinedArguments((List<JsExpression>)result2);
        return new ArgumentsInfo(result2, hasSpreadOperator, cachedReceiver, null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ValueArgument, JsExpression> translateUnresolvedArguments(TranslationContext context2, ResolvedCall<?> resolvedCall2) {
        boolean bl;
        boolean argumentsAreOrdered;
        Object destination$iv$iv;
        Map result2;
        Map argumentContexts;
        block22: {
            boolean bl2;
            block21: {
                void $this$associate$iv;
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                void $this$associateTo$iv$iv2;
                void $this$associateTo$iv$iv3;
                Object $dstr$param$arg;
                void $this$associateTo$iv$iv4;
                void $this$associate$iv2;
                Object object;
                Object $this$mapTo$iv$iv;
                void $this$flatMapTo$iv$iv2;
                Iterable $this$flatMap$iv2;
                Map<ValueParameterDescriptor, ResolvedValueArgument> map = resolvedCall2.getValueArguments();
                Intrinsics.checkNotNullExpressionValue(map, (String)"resolvedCall.valueArguments");
                boolean $i$f$flatMap = false;
                void var6_6 = $this$flatMap$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator iterator2 = $this$flatMapTo$iv$iv2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry;
                    Map.Entry $dstr$param$args = entry = iterator2.next();
                    boolean bl3 = false;
                    ValueParameterDescriptor param = (ValueParameterDescriptor)$dstr$param$args.getKey();
                    ResolvedValueArgument args = (ResolvedValueArgument)$dstr$param$args.getValue();
                    List<ValueArgument> list2 = args.getArguments();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"args.arguments");
                    Iterable $this$map$iv = list2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        object = (ValueArgument)item$iv$iv;
                        Collection collection = destination$iv$iv3;
                        boolean bl4 = false;
                        Pair pair = TuplesKt.to((Object)param, (Object)it);
                        collection.add(pair);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv3;
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv2 = (List)destination$iv$iv2;
                boolean $i$f$associate232 = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
                destination$iv$iv2 = $this$associate$iv2;
                Object destination$iv$iv4 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv3 : $this$associateTo$iv$iv4) {
                    Map bl3 = destination$iv$iv4;
                    $dstr$param$arg = (Pair)element$iv$iv3;
                    boolean bl5 = false;
                    ValueParameterDescriptor param = (ValueParameterDescriptor)$dstr$param$arg.component1();
                    ValueArgument arg = (ValueArgument)$dstr$param$arg.component2();
                    $dstr$param$arg = TuplesKt.to((Object)arg, (Object)param);
                    bl3.put($dstr$param$arg.getFirst(), $dstr$param$arg.getSecond());
                }
                Map argsToParameters = destination$iv$iv4;
                List<? extends ValueArgument> $i$f$associate232 = resolvedCall2.getCall().getValueArguments();
                Intrinsics.checkNotNullExpressionValue($i$f$associate232, (String)"resolvedCall.call.valueArguments");
                Iterable $this$associate$iv3 = $i$f$associate232;
                boolean $i$f$associate332 = false;
                int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv3, (int)10)), (int)16);
                destination$iv$iv4 = $this$associate$iv3;
                Object destination$iv$iv5 = new LinkedHashMap(capacity$iv2);
                boolean bl3 = false;
                for (Object element$iv$iv4 : $this$associateTo$iv$iv3) {
                    $dstr$param$arg = destination$iv$iv5;
                    ValueArgument it = (ValueArgument)element$iv$iv4;
                    boolean bl6 = false;
                    it = TuplesKt.to((Object)it, (Object)context2.innerBlock());
                    $dstr$param$arg.put(it.getFirst(), it.getSecond());
                }
                argumentContexts = destination$iv$iv5;
                List<? extends ValueArgument> $i$f$associate332 = resolvedCall2.getCall().getValueArguments();
                Intrinsics.checkNotNullExpressionValue($i$f$associate332, (String)"resolvedCall.call.valueArguments");
                Iterable $this$associate$iv4 = $i$f$associate332;
                boolean $i$f$associate432 = false;
                int capacity$iv2232 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv4, (int)10)), (int)16);
                destination$iv$iv5 = $this$associate$iv4;
                Map map2 = new LinkedHashMap(capacity$iv2232);
                boolean $i$f$associateTo3 = false;
                for (Object element$iv$iv5 : $this$associateTo$iv$iv2) {
                    Object object2;
                    Map it = map2;
                    ValueArgument arg = (ValueArgument)element$iv$iv5;
                    boolean bl7 = false;
                    Intrinsics.checkNotNull(argumentContexts.get(arg));
                    Intrinsics.checkNotNullExpressionValue($this$mapTo$iv$iv, (String)"argumentContexts[arg]!!");
                    TranslationContext argumentContext = (TranslationContext)$this$mapTo$iv$iv;
                    KtExpression parenthisedArgumentExpression = arg.getArgumentExpression();
                    Object v = argsToParameters.get(arg);
                    Intrinsics.checkNotNull(v);
                    ValueParameterDescriptor param = ((ValueParameterDescriptor)v).getOriginal();
                    Iterator<Object> iterator3 = resolvedCall2.getResultingDescriptor();
                    Object it2 = iterator3;
                    boolean bl8 = false;
                    Intrinsics.checkNotNullExpressionValue(it2, (String)"it");
                    boolean isLambda = FunctionTypesKt.getFunctionalClassKind((DeclarationDescriptor)it2) != null || it2 instanceof FunctionInvokeDescriptor;
                    if (!isLambda) {
                        it2 = param.getVarargElementType();
                        if (it2 == null) {
                            KotlinType kotlinType = param.getType();
                            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"param.type");
                            object2 = kotlinType;
                        } else {
                            object2 = it2;
                        }
                    } else {
                        it2 = context2.getCurrentModule().getBuiltIns().getAnyType();
                        Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"context.currentModule.builtIns.anyType");
                        object2 = (KotlinType)it2;
                    }
                    Object parameterType = object2;
                    KtExpression ktExpression = parenthisedArgumentExpression;
                    Intrinsics.checkNotNull((Object)ktExpression);
                    object = Translation.translateAsExpression(ktExpression, argumentContext);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"translateAsExpression(pa\u2026ssion!!, argumentContext)");
                    Object argJs = object;
                    if (!ArgumentsUtilsKt.isVararg(param) || arg.getSpreadElement() == null) {
                        object = TranslationUtils.coerce(context2, (JsExpression)argJs, (KotlinType)parameterType);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"coerce(context, argJs, parameterType)");
                        argJs = object;
                    }
                    Pair pair = TuplesKt.to((Object)arg, (Object)argJs);
                    it.put(pair.getFirst(), pair.getSecond());
                }
                result2 = map2;
                List<ResolvedValueArgument> capacity$iv2232 = resolvedCall2.getValueArgumentsByIndex();
                Iterable $i$f$associate432 = capacity$iv2232 == null ? CollectionsKt.emptyList() : capacity$iv2232;
                boolean $i$f$flatMap2 = false;
                $this$associateTo$iv$iv2 = $this$flatMap$iv;
                Collection collection = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    ResolvedValueArgument it = (ResolvedValueArgument)element$iv$iv;
                    boolean bl9 = false;
                    List<ValueArgument> bl7 = it.getArguments();
                    Intrinsics.checkNotNullExpressionValue(bl7, (String)"it.arguments");
                    Iterable list$iv$iv = bl7;
                    CollectionsKt.addAll((Collection)collection, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = CollectionsKt.withIndex((Iterable)((List)collection));
                boolean $i$f$associate532 = false;
                int capacity$iv3 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                void var10_28 = $this$associate$iv;
                destination$iv$iv = new LinkedHashMap(capacity$iv3);
                boolean $i$f$associateTo4 = false;
                for (Object element$iv$iv6 : var10_28) {
                    Map bl9 = destination$iv$iv;
                    IndexedValue $dstr$index$arg2 = (IndexedValue)element$iv$iv6;
                    boolean bl10 = false;
                    int index2 = $dstr$index$arg2.component1();
                    ValueArgument arg = (ValueArgument)$dstr$index$arg2.component2();
                    $dstr$index$arg2 = TuplesKt.to((Object)arg, (Object)index2);
                    bl9.put($dstr$index$arg2.getFirst(), $dstr$index$arg2.getSecond());
                }
                Map resolvedOrder = destination$iv$iv;
                List<? extends ValueArgument> $i$f$associate532 = resolvedCall2.getCall().getValueArguments();
                Intrinsics.checkNotNullExpressionValue($i$f$associate532, (String)"resolvedCall.call.valueArguments");
                Iterable $this$none$iv = CollectionsKt.withIndex((Iterable)$i$f$associate532);
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        IndexedValue $dstr$index$arg = (IndexedValue)element$iv;
                        boolean bl11 = false;
                        int index3 = $dstr$index$arg.component1();
                        ValueArgument arg = (ValueArgument)$dstr$index$arg.component2();
                        Integer n = (Integer)resolvedOrder.get(arg);
                        int $dstr$index$arg2 = index3;
                        if (!(n == null || n != $dstr$index$arg2)) continue;
                        bl2 = false;
                        break block21;
                    }
                    bl2 = true;
                }
            }
            argumentsAreOrdered = bl2;
            Iterable $this$any$iv = argumentContexts.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TranslationContext it = (TranslationContext)element$iv;
                    boolean bl12 = false;
                    if (!(!it.currentBlockIsEmpty())) continue;
                    bl = true;
                    break block22;
                }
                bl = false;
            }
        }
        if (bl || !argumentsAreOrdered) {
            Map $this$map$iv = result2;
            boolean $i$f$map = false;
            Map map = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator bl12 = map.entrySet().iterator();
            while (bl12.hasNext()) {
                Object v;
                void $dstr$arg$expr;
                Map.Entry item$iv$iv;
                Map.Entry arg = item$iv$iv = bl12.next();
                Object object = destination$iv$iv;
                boolean bl13 = false;
                ValueArgument arg2 = (ValueArgument)$dstr$arg$expr.getKey();
                JsExpression expr = (JsExpression)$dstr$arg$expr.getValue();
                Intrinsics.checkNotNull(argumentContexts.get(arg2));
                Intrinsics.checkNotNullExpressionValue(v, (String)"argumentContexts[arg]!!");
                TranslationContext argumentContext = (TranslationContext)v;
                Pair pair = TuplesKt.to((Object)arg2, (Object)argumentContext.cacheExpressionIfNeeded(expr));
                object.add(pair);
            }
            result2 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }
        Iterable $this$forEach$iv = argumentContexts.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TranslationContext it = (TranslationContext)element$iv;
            boolean bl14 = false;
            context2.moveVarsFrom(it);
            context2.addStatementsToCurrentBlockFrom(it);
        }
        return result2;
    }

    private final JsExpression wrapInUArray(JsExpression $this$wrapInUArray, KotlinType elementType) {
        JsExpression jsExpression;
        PrimitiveType primitiveType = ArrayFIF.INSTANCE.unsignedPrimitiveToSigned(elementType);
        if (primitiveType == null) {
            jsExpression = $this$wrapInUArray;
        } else {
            PrimitiveType primitiveType2;
            PrimitiveType primitiveType3 = primitiveType2 = primitiveType;
            boolean bl = false;
            ModuleDescriptor moduleDescriptor = this.context.getCurrentModule();
            FqName fqName2 = new FqNameUnsafe("kotlin").toSafe();
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"FqNameUnsafe(\"kotlin\").toSafe()");
            MemberScope kotlinMemberScope = moduleDescriptor.getPackage(fqName2).getMemberScope();
            ClassDescriptor classDescriptor = this.typeToUTypeArray.computeIfAbsent(primitiveType3, arg_0 -> CallArgumentTranslator.wrapInUArray$lambda-18$lambda-17(primitiveType3, kotlinMemberScope, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"typeToUTypeArray.compute\u2026sDescriptor\n            }");
            ClassDescriptor classDescriptor2 = classDescriptor;
            jsExpression = new JsNew(ReferenceTranslator.translateAsTypeReference(classDescriptor2, this.context), CollectionsKt.listOf((Object)$this$wrapInUArray));
        }
        return jsExpression;
    }

    private final JsExpression translateVarargArgument(ResolvedValueArgument resolvedArgument, Map<ValueArgument, ? extends JsExpression> translatedArgs, boolean shouldWrapVarargInArray, KotlinType varargElementType) {
        JsExpression jsExpression;
        List<ValueArgument> list2 = resolvedArgument.getArguments();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"resolvedArgument.arguments");
        List<ValueArgument> arguments2 = list2;
        if (arguments2.isEmpty()) {
            if (shouldWrapVarargInArray) {
                return this.wrapInUArray(this.toArray(varargElementType, new ArrayList()), varargElementType);
            }
            return null;
        }
        List list3 = CallArgumentTranslator.Companion.translateResolvedArgument(resolvedArgument, translatedArgs);
        CallArgumentTranslator callArgumentTranslator = this;
        if (shouldWrapVarargInArray) {
            JsExpression concatExpression;
            List<JsExpression> concatArguments = this.prepareConcatArguments(arguments2, list3, varargElementType);
            jsExpression = concatExpression = CallArgumentTranslator.Companion.concatArgumentsIfNeeded(concatArguments, varargElementType, false);
        } else {
            JsExpression jsExpression2;
            PrimitiveType primitiveType = ArrayFIF.INSTANCE.unsignedPrimitiveToSigned(varargElementType);
            if (primitiveType == null) {
                jsExpression2 = (JsExpression)list3.get(0);
            } else {
                PrimitiveType primitiveType2;
                PrimitiveType primitiveType3 = primitiveType2 = primitiveType;
                CallArgumentTranslator callArgumentTranslator2 = callArgumentTranslator;
                boolean bl = false;
                JsInvocation jsInvocation = new JsInvocation((JsExpression)new JsNameRef("unbox", (JsExpression)list3.get(0)), new JsExpression[0]);
                callArgumentTranslator = callArgumentTranslator2;
                jsExpression2 = jsInvocation;
            }
            JsExpression arg = jsExpression2;
            JsInvocation jsInvocation = JsAstUtils.invokeMethod(arg, "slice", new JsExpression[0]);
            Intrinsics.checkNotNullExpressionValue((Object)jsInvocation, (String)"{\n            val arg = \u2026d(arg, \"slice\")\n        }");
            jsExpression = jsInvocation;
        }
        return callArgumentTranslator.wrapInUArray(jsExpression, varargElementType);
    }

    private final JsExpression toArray(KotlinType varargElementType, List<? extends JsExpression> elements) {
        Object object = new JsArrayLiteral(elements);
        JsArrayLiteral $this$toArray_u24lambda_u2d20 = object;
        boolean bl = false;
        MetadataProperties.setSideEffects($this$toArray_u24lambda_u2d20, SideEffectKind.PURE);
        JsArrayLiteral argument2 = object;
        if (varargElementType == null) {
            return argument2;
        }
        object = this.context();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context()");
        return ArrayFIF.INSTANCE.castOrCreatePrimitiveArray((TranslationContext)object, varargElementType, argument2);
    }

    private final List<JsExpression> prepareConcatArguments(List<? extends ValueArgument> arguments2, List<? extends JsExpression> list2, KotlinType varargElementType) {
        boolean bl;
        boolean bl2 = bl = !((Collection)arguments2).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CallArgumentTranslator$prepareConcatArguments$32 = false;
            String $i$a$-assert-CallArgumentTranslator$prepareConcatArguments$32 = "arguments.size should not be 0";
            throw new AssertionError((Object)$i$a$-assert-CallArgumentTranslator$prepareConcatArguments$32);
        }
        boolean bl3 = bl = arguments2.size() == list2.size();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CallArgumentTranslator$prepareConcatArguments$42 = false;
            String $i$a$-assert-CallArgumentTranslator$prepareConcatArguments$42 = "arguments.size: " + arguments2.size() + " != list.size: " + list2.size();
            throw new AssertionError((Object)$i$a$-assert-CallArgumentTranslator$prepareConcatArguments$42);
        }
        List concatArguments = new ArrayList();
        List lastArrayContent = new ArrayList();
        int size = arguments2.size();
        int n = 0;
        while (n < size) {
            int index2 = n++;
            ValueArgument valueArgument = arguments2.get(index2);
            JsExpression expressionArgument = list2.get(index2);
            if (this.hasSpreadElementOrNamedArgument(valueArgument)) {
                if (lastArrayContent.size() > 0) {
                    concatArguments.add(this.toArray(varargElementType, lastArrayContent));
                    lastArrayContent = new ArrayList();
                }
                JsExpression e = varargElementType != null && ArrayFIF.INSTANCE.unsignedPrimitiveToSigned(varargElementType) != null ? (JsExpression)new JsInvocation((JsExpression)new JsNameRef("unbox", expressionArgument), new JsExpression[0]) : expressionArgument;
                concatArguments.add(e);
                continue;
            }
            lastArrayContent.add(expressionArgument);
        }
        if (lastArrayContent.size() > 0) {
            concatArguments.add(this.toArray(varargElementType, lastArrayContent));
        }
        return concatArguments;
    }

    private static final ClassDescriptor wrapInUArray$lambda-18$lambda-17(PrimitiveType $primitiveType, MemberScope $kotlinMemberScope, PrimitiveType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$primitiveType), (String)"$primitiveType");
        Intrinsics.checkNotNullParameter((Object)$kotlinMemberScope, (String)"$kotlinMemberScope");
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object object = Name.identifier("" + 'U' + $primitiveType.getTypeName() + "Array");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier(\"U${primitiveType.typeName}Array\")");
        Name className2 = object;
        object = $kotlinMemberScope.getContributedClassifier(className2, NoLookupLocation.FROM_BACKEND);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        return (ClassDescriptor)object;
    }

    @JvmStatic
    @NotNull
    public static final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context2) {
        return Companion.translate(resolvedCall2, receiver, context2);
    }

    @JvmStatic
    @NotNull
    public static final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context2, @NotNull JsBlock block) {
        return Companion.translate(resolvedCall2, receiver, context2, block);
    }

    public /* synthetic */ CallArgumentTranslator(ResolvedCall resolvedCall2, JsExpression receiver, TranslationContext context2, DefaultConstructorMarker $constructor_marker) {
        this(resolvedCall2, receiver, context2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J?\u0010\u0018\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "", "valueArguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "hasSpreadOperator", "", "cachedReceiver", "Lorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;", "reifiedArguments", "(Ljava/util/List;ZLorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;Ljava/util/List;)V", "getCachedReceiver", "()Lorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;", "getHasSpreadOperator", "()Z", "getReifiedArguments", "()Ljava/util/List;", "translateArguments", "getTranslateArguments", "getValueArguments", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "js.translator"})
    public static final class ArgumentsInfo {
        @NotNull
        private final List<JsExpression> valueArguments;
        private final boolean hasSpreadOperator;
        @Nullable
        private final TemporaryConstVariable cachedReceiver;
        @NotNull
        private final List<JsExpression> reifiedArguments;

        public ArgumentsInfo(@NotNull List<? extends JsExpression> valueArguments, boolean hasSpreadOperator, @Nullable TemporaryConstVariable cachedReceiver, @NotNull List<? extends JsExpression> reifiedArguments) {
            Intrinsics.checkNotNullParameter(valueArguments, (String)"valueArguments");
            Intrinsics.checkNotNullParameter(reifiedArguments, (String)"reifiedArguments");
            this.valueArguments = valueArguments;
            this.hasSpreadOperator = hasSpreadOperator;
            this.cachedReceiver = cachedReceiver;
            this.reifiedArguments = reifiedArguments;
        }

        public /* synthetic */ ArgumentsInfo(List list2, boolean bl, TemporaryConstVariable temporaryConstVariable, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                list3 = CollectionsKt.emptyList();
            }
            this(list2, bl, temporaryConstVariable, list3);
        }

        @NotNull
        public final List<JsExpression> getValueArguments() {
            return this.valueArguments;
        }

        public final boolean getHasSpreadOperator() {
            return this.hasSpreadOperator;
        }

        @Nullable
        public final TemporaryConstVariable getCachedReceiver() {
            return this.cachedReceiver;
        }

        @NotNull
        public final List<JsExpression> getReifiedArguments() {
            return this.reifiedArguments;
        }

        @NotNull
        public final List<JsExpression> getTranslateArguments() {
            return CollectionsKt.plus((Collection)this.reifiedArguments, (Iterable)this.valueArguments);
        }

        @NotNull
        public final List<JsExpression> component1() {
            return this.valueArguments;
        }

        public final boolean component2() {
            return this.hasSpreadOperator;
        }

        @Nullable
        public final TemporaryConstVariable component3() {
            return this.cachedReceiver;
        }

        @NotNull
        public final List<JsExpression> component4() {
            return this.reifiedArguments;
        }

        @NotNull
        public final ArgumentsInfo copy(@NotNull List<? extends JsExpression> valueArguments, boolean hasSpreadOperator, @Nullable TemporaryConstVariable cachedReceiver, @NotNull List<? extends JsExpression> reifiedArguments) {
            Intrinsics.checkNotNullParameter(valueArguments, (String)"valueArguments");
            Intrinsics.checkNotNullParameter(reifiedArguments, (String)"reifiedArguments");
            return new ArgumentsInfo(valueArguments, hasSpreadOperator, cachedReceiver, reifiedArguments);
        }

        public static /* synthetic */ ArgumentsInfo copy$default(ArgumentsInfo argumentsInfo, List list2, boolean bl, TemporaryConstVariable temporaryConstVariable, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = argumentsInfo.valueArguments;
            }
            if ((n & 2) != 0) {
                bl = argumentsInfo.hasSpreadOperator;
            }
            if ((n & 4) != 0) {
                temporaryConstVariable = argumentsInfo.cachedReceiver;
            }
            if ((n & 8) != 0) {
                list3 = argumentsInfo.reifiedArguments;
            }
            return argumentsInfo.copy(list2, bl, temporaryConstVariable, list3);
        }

        @NotNull
        public String toString() {
            return "ArgumentsInfo(valueArguments=" + this.valueArguments + ", hasSpreadOperator=" + this.hasSpreadOperator + ", cachedReceiver=" + this.cachedReceiver + ", reifiedArguments=" + this.reifiedArguments + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.valueArguments).hashCode();
            int n = this.hasSpreadOperator ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            result2 = result2 * 31 + (this.cachedReceiver == null ? 0 : this.cachedReceiver.hashCode());
            result2 = result2 * 31 + ((Object)this.reifiedArguments).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArgumentsInfo)) {
                return false;
            }
            ArgumentsInfo argumentsInfo = (ArgumentsInfo)other;
            if (!Intrinsics.areEqual(this.valueArguments, argumentsInfo.valueArguments)) {
                return false;
            }
            if (this.hasSpreadOperator != argumentsInfo.hasSpreadOperator) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cachedReceiver, (Object)argumentsInfo.cachedReceiver)) {
                return false;
            }
            return Intrinsics.areEqual(this.reifiedArguments, argumentsInfo.reifiedArguments);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J.\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00040\u0018H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$Companion;", "", "()V", "concatArgumentsIfNeeded", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "concatArguments", "", "varargElementType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isMixed", "", "translate", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiver", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "block", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "translateResolvedArgument", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "translatedArgs", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "js.translator"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context2) {
            Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            JsBlock jsBlock = context2.dynamicContext().jsBlock();
            Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"context.dynamicContext().jsBlock()");
            return this.translate(resolvedCall2, receiver, context2, jsBlock);
        }

        @JvmStatic
        @NotNull
        public final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context2, @NotNull JsBlock block) {
            Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            TranslationContext translationContext = context2.innerBlock(block);
            Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context.innerBlock(block)");
            TranslationContext innerContext = translationContext;
            CallArgumentTranslator argumentTranslator = new CallArgumentTranslator(resolvedCall2, receiver, innerContext, null);
            ArgumentsInfo result2 = argumentTranslator.translate();
            context2.moveVarsFrom(innerContext);
            Object callDescriptor = resolvedCall2.getCandidateDescriptor();
            if (CallExpressionTranslator.shouldBeInlined(callDescriptor)) {
                Map<TypeParameterDescriptor, KotlinType> map = resolvedCall2.getTypeArguments();
                Intrinsics.checkNotNullExpressionValue(map, (String)"resolvedCall.typeArguments");
                Map<TypeParameterDescriptor, KotlinType> typeArgs = map;
                return ArgumentsInfo.copy$default(result2, null, false, null, CallArgumentTranslatorKt.buildReifiedTypeArgs(typeArgs, context2), 7, null);
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<JsExpression> translateResolvedArgument(ResolvedValueArgument resolvedArgument, Map<ValueArgument, ? extends JsExpression> translatedArgs) {
            void $this$mapTo$iv$iv;
            if (resolvedArgument instanceof DefaultValueArgument) {
                JsExpression jsExpression = Namer.getUndefinedExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getUndefinedExpression()");
                return CollectionsKt.listOf((Object)jsExpression);
            }
            List<ValueArgument> list2 = resolvedArgument.getArguments();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"resolvedArgument.arguments");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                JsExpression jsExpression;
                void it;
                ValueArgument valueArgument = (ValueArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)translatedArgs.get(it));
                collection.add(jsExpression);
            }
            return (List)destination$iv$iv;
        }

        private final JsExpression concatArgumentsIfNeeded(List<? extends JsExpression> concatArguments, KotlinType varargElementType, boolean isMixed) {
            JsExpression jsExpression;
            boolean bl;
            boolean bl2 = bl = !((Collection)concatArguments).isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-CallArgumentTranslator$Companion$concatArgumentsIfNeeded$22 = false;
                String $i$a$-assert-CallArgumentTranslator$Companion$concatArgumentsIfNeeded$22 = "concatArguments.size should not be 0";
                throw new AssertionError((Object)$i$a$-assert-CallArgumentTranslator$Companion$concatArgumentsIfNeeded$22);
            }
            if (concatArguments.size() > 1) {
                JsInvocation jsInvocation;
                if (varargElementType != null && (TypeUtilsKt.isPrimitiveNumberType(varargElementType) || ArrayFIF.INSTANCE.unsignedPrimitiveToSigned(varargElementType) != null)) {
                    String method = isMixed ? "arrayConcat" : "primitiveArrayConcat";
                    SpreadBuilder spreadBuilder2 = new SpreadBuilder(2);
                    spreadBuilder2.add((Object)concatArguments.get(0));
                    Collection $this$toTypedArray$iv = concatArguments.subList(1, concatArguments.size());
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    JsExpression[] jsExpressionArray = thisCollection$iv.toArray(new JsExpression[0]);
                    if (jsExpressionArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    spreadBuilder2.addSpread((Object)jsExpressionArray);
                    jsInvocation = JsAstUtils.invokeKotlinFunction(method, (JsExpression[])spreadBuilder2.toArray((Object[])new JsExpression[spreadBuilder2.size()]));
                } else {
                    jsInvocation = new JsInvocation((JsExpression)new JsNameRef("concat", concatArguments.get(0)), concatArguments.subList(1, concatArguments.size()));
                }
                JsInvocation jsInvocation2 = jsInvocation;
                Intrinsics.checkNotNullExpressionValue((Object)jsInvocation2, (String)"{\n                if (va\u2026          }\n            }");
                jsExpression = jsInvocation2;
            } else {
                jsExpression = concatArguments.get(0);
            }
            return jsExpression;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

