/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.io.File;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CompilerSystemProperties;
import org.jetbrains.kotlin.daemon.common.FileSystemUtilsKt;
import org.jetbrains.kotlin.daemon.common.OSKind;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\r\u001a\u00020\u00042\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000f\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/daemon/common/FileSystem;", "", "()V", "logFilesPath", "", "getLogFilesPath", "()Ljava/lang/String;", "runtimeStateFilesBasePath", "getRuntimeStateFilesBasePath", "tempPath", "getTempPath", "userHomePath", "getUserHomePath", "getRuntimeStateFilesPath", "names", "", "([Ljava/lang/String;)Ljava/lang/String;", "daemon-common"})
public final class FileSystem {
    @NotNull
    public static final FileSystem INSTANCE = new FileSystem();

    private FileSystem() {
    }

    @NotNull
    public final String getUserHomePath() {
        return CompilerSystemProperties.USER_HOME.getSafeValue();
    }

    @NotNull
    public final String getTempPath() {
        return CompilerSystemProperties.TMP_DIR.getSafeValue();
    }

    @NotNull
    public final String getLogFilesPath() {
        return this.getTempPath();
    }

    @NotNull
    public final String getRuntimeStateFilesBasePath() {
        String string2;
        OSKind oSKind = OSKind.Companion.getCurrent();
        int n = WhenMappings.$EnumSwitchMapping$0[oSKind.ordinal()];
        switch (n) {
            case 1: {
                string2 = FileSystemUtilsKt.access$orDefault(System.getenv("LOCALAPPDATA"), this.getTempPath());
                break;
            }
            case 2: {
                string2 = Intrinsics.stringPlus((String)this.getUserHomePath(), (Object)"/Library/Application Support");
                break;
            }
            case 3: {
                string2 = FileSystemUtilsKt.access$orDefault(System.getenv("XDG_DATA_HOME"), Intrinsics.stringPlus((String)this.getUserHomePath(), (Object)"/.local/share"));
                break;
            }
            case 4: {
                string2 = this.getTempPath();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getRuntimeStateFilesPath(String ... names2) {
        String string2;
        File dir;
        File file2;
        Object $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)names2, (String)"names");
        boolean bl = ArraysKt.any((Object[])names2);
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        File base2 = new File(this.getRuntimeStateFilesBasePath());
        if (base2.exists() && base2.isDirectory()) {
            $this$fold$iv = names2;
            boolean $i$f$fold = false;
            File accumulator$iv = base2;
            for (String element$iv : $this$fold$iv) {
                void p1;
                String string4 = element$iv;
                File p0 = accumulator$iv;
                boolean bl2 = false;
                accumulator$iv = new File(p0, (String)p1);
            }
            file2 = accumulator$iv;
        } else {
            void it;
            $this$fold$iv = ArraysKt.drop((Object[])names2, (int)1);
            Object $i$f$fold = ArraysKt.first((Object[])names2);
            String accumulator$iv = (String)$i$f$fold;
            String string5 = this.getUserHomePath();
            boolean bl3 = false;
            void var15_24 = StringsKt.startsWith$default((String)it, (String)".", (boolean)false, (int)2, null) ? it : Intrinsics.stringPlus((String)".", (Object)it);
            void var16_25 = var15_24;
            String string6 = string5;
            File initial$iv = new File(string6, (String)var16_25);
            boolean $i$f$fold2 = false;
            File accumulator$iv2 = initial$iv;
            Iterator iterator2 = $this$fold$iv.iterator();
            while (iterator2.hasNext()) {
                void p1;
                String element$iv;
                Object element$iv2 = iterator2.next();
                element$iv = (String)element$iv2;
                File p0 = accumulator$iv2;
                boolean bl4 = false;
                accumulator$iv2 = new File(p0, (String)p1);
            }
            file2 = dir = accumulator$iv2;
        }
        if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
            String string7 = dir.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"dir.absolutePath");
            string2 = string7;
        } else {
            string2 = this.getTempPath();
        }
        return string2;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OSKind.values().length];
            nArray[OSKind.Windows.ordinal()] = 1;
            nArray[OSKind.OSX.ordinal()] = 2;
            nArray[OSKind.Unix.ordinal()] = 3;
            nArray[OSKind.Unknown.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

