/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRenderer;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory3;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J.\u0010\u001b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001c*\u00020\u001f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u001eH\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "checkFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "checkMemberReceiver", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "memberDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "checkParameterBounds", "checkProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkSupertypes", "checkTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "findVisibilityExposure", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "base", "checkers"})
public final class FirExposedVisibilityDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExposedVisibilityDeclarationChecker INSTANCE = new FirExposedVisibilityDeclarationChecker();

    private FirExposedVisibilityDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirAnonymousFunction) {
            return;
        }
        if (firDeclaration instanceof FirTypeAlias) {
            this.checkTypeAlias((FirTypeAlias)declaration, reporter2, context2);
        } else if (firDeclaration instanceof FirProperty) {
            this.checkProperty((FirProperty)declaration, reporter2, context2);
        } else if (firDeclaration instanceof FirFunction) {
            this.checkFunction((FirFunction)declaration, reporter2, context2);
        } else if (firDeclaration instanceof FirRegularClass) {
            this.checkClass((FirRegularClass)declaration, reporter2, context2);
        }
    }

    private final void checkClass(FirRegularClass declaration, DiagnosticReporter reporter2, CheckerContext context2) {
        this.checkSupertypes(declaration, reporter2, context2);
        this.checkParameterBounds(declaration, reporter2, context2);
    }

    private final void checkSupertypes(FirRegularClass declaration, DiagnosticReporter reporter2, CheckerContext context2) {
        FirResolvedDeclarationStatus firResolvedDeclarationStatus;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        FirResolvedDeclarationStatus firResolvedDeclarationStatus2 = firResolvedDeclarationStatus = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (firResolvedDeclarationStatus == null) {
            throw new IllegalStateException(("Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved").toString());
        }
        EffectiveVisibility classVisibility = firResolvedDeclarationStatus.getEffectiveVisibility();
        if (Intrinsics.areEqual((Object)classVisibility, (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        List<FirTypeRef> supertypes2 = declaration.getSuperTypeRefs();
        boolean isInterface = declaration.getClassKind() == ClassKind.INTERFACE;
        for (FirTypeRef supertypeRef : supertypes2) {
            Object classSymbol;
            boolean superIsInterface;
            ConeClassLikeType supertype2;
            ConeClassLikeType coneClassLikeType;
            Object $this$coneTypeSafe$iv = supertypeRef;
            boolean $i$f$coneTypeSafe = false;
            Pair<FirBasedSymbol<?>, EffectiveVisibility> pair = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (Pair<FirBasedSymbol<?>, EffectiveVisibility>)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = pair == null ? null : pair.getType();
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null || ($this$coneTypeSafe$iv = FirHelpersKt.toRegularClassSymbol(supertype2 = coneClassLikeType, context2.getSession())) == null || (superIsInterface = ((FirClassSymbol)(classSymbol = $this$coneTypeSafe$iv)).getClassKind() == ClassKind.INTERFACE) != isInterface || (pair = this.findVisibilityExposure(supertype2, context2, classVisibility)) == null) continue;
            Pair<FirBasedSymbol<?>, EffectiveVisibility> pair2 = pair;
            FirBasedSymbol restricting = (FirBasedSymbol)pair2.component1();
            EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair2.component2();
            FirSourceElement firSourceElement = supertypeRef.getSource();
            DiagnosticReporterKt.reportOn$default(reporter2, firSourceElement == null ? declaration.getSource() : firSourceElement, isInterface ? FirErrors.INSTANCE.getEXPOSED_SUPER_INTERFACE() : FirErrors.INSTANCE.getEXPOSED_SUPER_CLASS(), (Object)classVisibility, (Object)restricting, (Object)restrictingVisibility, context2, null, 64, null);
        }
    }

    private final void checkParameterBounds(FirRegularClass declaration, DiagnosticReporter reporter2, CheckerContext context2) {
        FirResolvedDeclarationStatus firResolvedDeclarationStatus;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        FirResolvedDeclarationStatus firResolvedDeclarationStatus2 = firResolvedDeclarationStatus = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (firResolvedDeclarationStatus == null) {
            throw new IllegalStateException(("Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved").toString());
        }
        EffectiveVisibility classVisibility = firResolvedDeclarationStatus.getEffectiveVisibility();
        if (Intrinsics.areEqual((Object)classVisibility, (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        for (FirTypeParameterRef parameter : declaration.getTypeParameters()) {
            for (FirResolvedTypeRef bound : parameter.getSymbol().getResolvedBounds()) {
                Pair<FirBasedSymbol<?>, EffectiveVisibility> pair = this.findVisibilityExposure(FirTypeUtilsKt.getConeType(bound), context2, classVisibility);
                if (pair == null) continue;
                Pair<FirBasedSymbol<?>, EffectiveVisibility> pair2 = pair;
                FirBasedSymbol restricting = (FirBasedSymbol)pair2.component1();
                EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair2.component2();
                DiagnosticReporterKt.reportOn$default(reporter2, bound.getSource(), FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND(), (Object)classVisibility, (Object)restricting, (Object)restrictingVisibility, context2, null, 64, null);
            }
        }
    }

    private final void checkTypeAlias(FirTypeAlias declaration, DiagnosticReporter reporter2, CheckerContext context2) {
        FirResolvedDeclarationStatus firResolvedDeclarationStatus;
        ConeClassLikeType expandedType2 = FirDeclarationUtilKt.getExpandedConeType(declaration);
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        Object object = $this$effectiveVisibility$iv.getStatus();
        FirResolvedDeclarationStatus firResolvedDeclarationStatus2 = firResolvedDeclarationStatus = object instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)object : null;
        if (firResolvedDeclarationStatus == null) {
            throw new IllegalStateException(("Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved").toString());
        }
        EffectiveVisibility typeAliasVisibility = firResolvedDeclarationStatus.getEffectiveVisibility();
        if (Intrinsics.areEqual((Object)typeAliasVisibility, (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        object = expandedType2;
        Pair<FirBasedSymbol<?>, EffectiveVisibility> pair = $i$f$getEffectiveVisibility = object == null ? null : this.findVisibilityExposure((ConeKotlinType)object, context2, typeAliasVisibility);
        if ($i$f$getEffectiveVisibility == null) {
            return;
        }
        Pair<FirBasedSymbol<?>, EffectiveVisibility> pair2 = $i$f$getEffectiveVisibility;
        FirBasedSymbol restricting = (FirBasedSymbol)pair2.component1();
        EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair2.component2();
        DiagnosticReporterKt.reportOn$default(reporter2, declaration.getSource(), FirErrors.INSTANCE.getEXPOSED_TYPEALIAS_EXPANDED_TYPE(), (Object)typeAliasVisibility, (Object)restricting, (Object)restrictingVisibility, context2, null, 64, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFunction(FirFunction declaration, DiagnosticReporter reporter2, CheckerContext context2) {
        Object restrictingVisibility;
        Object object;
        Object $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object2 = object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null) {
            throw new IllegalStateException(("Effective visibility for " + FirRendererKt.render((FirElement)$this$effectiveVisibility$iv, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved").toString());
        }
        EffectiveVisibility functionVisibility = object.getEffectiveVisibility();
        if (Intrinsics.areEqual((Object)functionVisibility, (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        if (!(declaration instanceof FirConstructor) && !(declaration instanceof FirPropertyAccessor)) {
            Pair<FirBasedSymbol<?>, EffectiveVisibility> $this$coneTypeSafe$iv = declaration.getReturnTypeRef();
            boolean $i$f$coneTypeSafe = false;
            object = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = object == null ? null : ((FirResolvedTypeRef)object).getType();
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                coneKotlinType = null;
            }
            if (($this$effectiveVisibility$iv = coneKotlinType) != null && ($this$coneTypeSafe$iv = this.findVisibilityExposure((ConeKotlinType)$this$effectiveVisibility$iv, context2, functionVisibility)) != null) {
                Pair<FirBasedSymbol<?>, EffectiveVisibility> $dstr$restricting$restrictingVisibility = $i$f$coneTypeSafe = $this$coneTypeSafe$iv;
                boolean bl = false;
                FirBasedSymbol restricting = (FirBasedSymbol)$dstr$restricting$restrictingVisibility.component1();
                restrictingVisibility = (EffectiveVisibility)$dstr$restricting$restrictingVisibility.component2();
                DiagnosticReporterKt.reportOn$default(reporter2, declaration.getSource(), FirErrors.INSTANCE.getEXPOSED_FUNCTION_RETURN_TYPE(), (Object)functionVisibility, (Object)restricting, restrictingVisibility, context2, null, 64, null);
            }
        }
        Iterable $this$forEachIndexed$iv = declaration.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            ConeKotlinType coneKotlinType;
            Pair<FirBasedSymbol<?>, EffectiveVisibility> pair;
            void valueParameter2;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            restrictingVisibility = (FirValueParameter)item$iv;
            int i = n;
            boolean bl = false;
            if (i >= declaration.getValueParameters().size()) continue;
            FirTypeRef $this$coneTypeSafe$iv = valueParameter2.getReturnTypeRef();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
            if (!(coneKotlinType2 instanceof ConeKotlinType)) {
                coneKotlinType2 = null;
            }
            Pair<FirBasedSymbol<?>, EffectiveVisibility> pair2 = pair = (coneKotlinType = coneKotlinType2) == null ? null : INSTANCE.findVisibilityExposure(coneKotlinType, context2, functionVisibility);
            if (pair == null) continue;
            Pair<FirBasedSymbol<?>, EffectiveVisibility> pair3 = pair;
            FirBasedSymbol restricting = (FirBasedSymbol)pair3.component1();
            EffectiveVisibility restrictingVisibility2 = (EffectiveVisibility)pair3.component2();
            DiagnosticReporterKt.reportOn$default(reporter2, valueParameter2.getSource(), FirErrors.INSTANCE.getEXPOSED_PARAMETER_TYPE(), (Object)functionVisibility, (Object)restricting, (Object)restrictingVisibility2, context2, null, 64, null);
        }
        this.checkMemberReceiver(declaration.getReceiverTypeRef(), declaration instanceof FirCallableDeclaration ? (FirCallableDeclaration)declaration : null, reporter2, context2);
    }

    private final void checkProperty(FirProperty declaration, DiagnosticReporter reporter2, CheckerContext context2) {
        Pair<FirBasedSymbol<?>, EffectiveVisibility> pair;
        ConeKotlinType coneKotlinType;
        FirElement firElement;
        if (declaration.isLocal()) {
            return;
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        FirElement firElement2 = firElement = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (firElement == null) {
            throw new IllegalStateException(("Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved").toString());
        }
        EffectiveVisibility propertyVisibility = firElement.getEffectiveVisibility();
        if (Intrinsics.areEqual((Object)propertyVisibility, (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        FirTypeRef $this$coneTypeSafe$iv = declaration.getReturnTypeRef();
        boolean $i$f$coneTypeSafe = false;
        firElement = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType2 = firElement == null ? null : ((FirResolvedTypeRef)firElement).getType();
        if (!(coneKotlinType2 instanceof ConeKotlinType)) {
            coneKotlinType2 = null;
        }
        if ((coneKotlinType = coneKotlinType2) != null && (pair = this.findVisibilityExposure(coneKotlinType, context2, propertyVisibility)) != null) {
            Pair<FirBasedSymbol<?>, EffectiveVisibility> pair2;
            Pair<FirBasedSymbol<?>, EffectiveVisibility> $dstr$restricting$restrictingVisibility = pair2 = pair;
            boolean bl = false;
            FirBasedSymbol restricting = (FirBasedSymbol)$dstr$restricting$restrictingVisibility.component1();
            EffectiveVisibility restrictingVisibility = (EffectiveVisibility)$dstr$restricting$restrictingVisibility.component2();
            FirDiagnosticFactory3<EffectiveVisibility, FirBasedSymbol<?>, EffectiveVisibility> diagnostic = Intrinsics.areEqual((Object)DeclarationAttributesKt.getFromPrimaryConstructor(declaration), (Object)true) ? FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR() : FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE();
            DiagnosticReporterKt.reportOn$default(reporter2, declaration.getSource(), diagnostic, (Object)propertyVisibility, (Object)restricting, (Object)restrictingVisibility, context2, null, 64, null);
        }
        this.checkMemberReceiver(declaration.getReceiverTypeRef(), declaration, reporter2, context2);
    }

    private final void checkMemberReceiver(FirTypeRef typeRef, FirCallableDeclaration memberDeclaration, DiagnosticReporter reporter2, CheckerContext context2) {
        FirResolvedDeclarationStatus firResolvedDeclarationStatus;
        if (typeRef == null || memberDeclaration == null) {
            return;
        }
        ConeKotlinType receiverParameterType = FirTypeUtilsKt.getConeType(typeRef);
        FirMemberDeclaration $this$effectiveVisibility$iv = memberDeclaration;
        boolean $i$f$getEffectiveVisibility22 = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        FirResolvedDeclarationStatus firResolvedDeclarationStatus2 = firResolvedDeclarationStatus = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (firResolvedDeclarationStatus == null) {
            throw new IllegalStateException(("Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved").toString());
        }
        EffectiveVisibility memberVisibility = firResolvedDeclarationStatus.getEffectiveVisibility();
        if (Intrinsics.areEqual((Object)memberVisibility, (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        Pair<FirBasedSymbol<?>, EffectiveVisibility> $i$f$getEffectiveVisibility22 = this.findVisibilityExposure(receiverParameterType, context2, memberVisibility);
        if ($i$f$getEffectiveVisibility22 == null) {
            return;
        }
        Pair<FirBasedSymbol<?>, EffectiveVisibility> pair = $i$f$getEffectiveVisibility22;
        FirBasedSymbol restricting = (FirBasedSymbol)pair.component1();
        EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair.component2();
        DiagnosticReporterKt.reportOn$default(reporter2, typeRef.getSource(), FirErrors.INSTANCE.getEXPOSED_RECEIVER_TYPE(), (Object)memberVisibility, (Object)restricting, (Object)restrictingVisibility, context2, null, 64, null);
    }

    private final Pair<FirBasedSymbol<?>, EffectiveVisibility> findVisibilityExposure(ConeKotlinType $this$findVisibilityExposure, CheckerContext context2, EffectiveVisibility base2) {
        EffectiveVisibility effectiveVisibility;
        EffectiveVisibility effectiveVisibility2;
        boolean $i$f$getEffectiveVisibility;
        FirClassLikeSymbol $this$effectiveVisibility$iv;
        ConeClassLikeType coneClassLikeType;
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType = $this$findVisibilityExposure instanceof ConeClassLikeType ? (ConeClassLikeType)$this$findVisibilityExposure : null;
        if (coneClassLikeType == null) {
            return null;
        }
        ConeClassLikeType type2 = coneClassLikeType;
        ConeTypeProjection[] coneTypeProjectionArray = LookupTagUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType$default(type2, context2.getSession(), null, 2, null).getLookupTag(), context2.getSession());
        if (coneTypeProjectionArray == null) {
            return null;
        }
        ConeTypeProjection[] classSymbol = coneTypeProjectionArray;
        Object object = classSymbol;
        if (object instanceof FirRegularClassSymbol) {
            $this$effectiveVisibility$iv = (FirRegularClassSymbol)classSymbol;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = ((FirRegularClassSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
        } else if (object instanceof FirTypeAliasSymbol) {
            $this$effectiveVisibility$iv = (FirTypeAliasSymbol)classSymbol;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = ((FirTypeAliasSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
        } else {
            effectiveVisibility2 = effectiveVisibility = null;
        }
        if (effectiveVisibility != null) {
            object = effectiveVisibility.relation(base2, SessionUtilsKt.getTypeContext(context2.getSession()));
            int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
            switch (n) {
                case 1: 
                case 2: {
                    return TuplesKt.to((Object)classSymbol, (Object)effectiveVisibility);
                }
            }
        }
        object = type2.getTypeArguments();
        int n = 0;
        int n2 = ((ConeTypeProjection[])object).length;
        while (n < n2) {
            Pair<FirBasedSymbol<?>, EffectiveVisibility> pair;
            Pair<FirBasedSymbol<?>, EffectiveVisibility> pair2;
            ConeClassLikeType coneClassLikeType3;
            Object it = object[n];
            ++n;
            Object $this$safeAs$iv = it;
            boolean $i$f$safeAs = false;
            Object object2 = $this$safeAs$iv;
            if (!(object2 instanceof ConeClassLikeType)) {
                object2 = null;
            }
            if ((coneClassLikeType3 = (ConeClassLikeType)object2) == null || (pair2 = this.findVisibilityExposure(coneClassLikeType3, context2, base2)) == null) continue;
            Pair<FirBasedSymbol<?>, EffectiveVisibility> it2 = pair = pair2;
            boolean bl = false;
            return it2;
        }
        return null;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EffectiveVisibility.Permissiveness.values().length];
            nArray[EffectiveVisibility.Permissiveness.LESS.ordinal()] = 1;
            nArray[EffectiveVisibility.Permissiveness.UNKNOWN.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

