/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirCatch;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCatchParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirTryExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTryExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirCatchParameterChecker
extends FirExpressionChecker<FirTryExpression> {
    @NotNull
    public static final FirCatchParameterChecker INSTANCE = new FirCatchParameterChecker();

    private FirCatchParameterChecker() {
    }

    @Override
    public void check(@NotNull FirTryExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        for (FirCatch catchEntry : expression2.getCatches()) {
            FirSession session2;
            FirValueParameter catchParameter = catchEntry.getParameter();
            Object object = catchParameter.getSource();
            if (object == null) continue;
            FirSourceElement source = object;
            if (catchParameter.getDefaultValue() != null) {
                DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getCATCH_PARAMETER_WITH_DEFAULT_VALUE(), context2, null, 8, null);
            }
            if ((object = FirKeywordUtilsKt.getValOrVarKeyword(source)) != null) {
                Object object2;
                Object it = object2 = object;
                boolean bl = false;
                DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getVAL_OR_VAR_ON_CATCH_PARAMETER(), it, context2, null, 16, null);
            }
            ConeKotlinType coneType = FirTypeUtilsKt.getConeType(catchParameter.getReturnTypeRef());
            if (coneType instanceof ConeTypeParameterType) {
                boolean isReified = ((ConeTypeParameterType)coneType).getLookupTag().getTypeParameterSymbol().isReified();
                if (isReified) {
                    DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getREIFIED_TYPE_IN_CATCH_CLAUSE(), context2, null, 8, null);
                } else {
                    DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getTYPE_PARAMETER_IN_CATCH_CLAUSE(), context2, null, 8, null);
                }
            }
            if (FirHelpersKt.isSubtypeOfThrowable(coneType, session2 = context2.getSession())) continue;
            DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getTHROWABLE_TYPE_MISMATCH(), (Object)coneType, context2, null, 16, null);
        }
    }
}

