/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory1;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactoryForDeprecation;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J2\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u0013\u001a\u00020\u0012*\u00020\u000eH\u0002J\f\u0010\u0014\u001a\u00020\u0012*\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReifiedChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkArgumentAndReport", "typeArgument", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "isArray", "", "cannotBeReified", "isReifiedTypeParameterOrFromKotlinArray", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "checkers"})
public final class FirReifiedChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirReifiedChecker INSTANCE = new FirReifiedChecker();

    private FirReifiedChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirReference calleReference = expression2.getCalleeReference();
        List<FirTypeProjection> typeArguments2 = expression2.getTypeArguments();
        FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(calleReference);
        if (firCallableSymbol == null) {
            return;
        }
        List<FirTypeParameterSymbol> typeParameters2 = firCallableSymbol.getTypeParameterSymbols();
        int n = typeArguments2.size();
        int n2 = typeParameters2.size();
        int count = Math.min(n, n2);
        n = 0;
        while (n < count) {
            int index2;
            FirTypeProjection typeArgumentProjection;
            FirSourceElement firSourceElement;
            List<FirTypeProjection> list2 = typeArguments2;
            FirSourceElement source = (firSourceElement = (typeArgumentProjection = list2.get(index2 = n++)).getSource()) == null ? calleReference.getSource() : firSourceElement;
            ConeKotlinType typeArgument = ConeTypesKt.getType(FirTypeUtilsKt.toConeTypeProjection(typeArgumentProjection));
            FirTypeParameterSymbol typeParameter = typeParameters2.get(index2);
            if (source == null || !this.isReifiedTypeParameterOrFromKotlinArray(typeParameter)) continue;
            this.checkArgumentAndReport(typeArgument, source, false, context2, reporter2);
        }
    }

    private final boolean isReifiedTypeParameterOrFromKotlinArray(FirTypeParameterSymbol $this$isReifiedTypeParameterOrFromKotlinArray) {
        FirBasedSymbol<?> containingDeclaration = $this$isReifiedTypeParameterOrFromKotlinArray.getContainingDeclarationSymbol();
        return $this$isReifiedTypeParameterOrFromKotlinArray.isReified() || containingDeclaration instanceof FirRegularClassSymbol && Intrinsics.areEqual((Object)((FirRegularClassSymbol)containingDeclaration).getClassId(), (Object)StandardClassIds.INSTANCE.getArray());
    }

    private final void checkArgumentAndReport(ConeKotlinType typeArgument, FirSourceElement source, boolean isArray, CheckerContext context2, DiagnosticReporter reporter2) {
        ConeKotlinType coneKotlinType = typeArgument;
        if (Intrinsics.areEqual((Object)(coneKotlinType == null ? null : ConeTypeUtilsKt.getClassId(coneKotlinType)), (Object)StandardClassIds.INSTANCE.getArray())) {
            this.checkArgumentAndReport(ConeTypesKt.getType(typeArgument.getTypeArguments()[0]), source, true, context2, reporter2);
            return;
        }
        FirDiagnosticFactory1 factory2 = null;
        FirTypeParameterSymbol symbol2 = null;
        if (typeArgument instanceof ConeTypeParameterType) {
            factory2 = isArray ? (FirDiagnosticFactory1)DiagnosticReporterKt.chooseFactory((FirDiagnosticFactoryForDeprecation)FirErrors.INSTANCE.getTYPE_PARAMETER_AS_REIFIED_ARRAY(), context2) : FirErrors.INSTANCE.getTYPE_PARAMETER_AS_REIFIED();
            FirBasedSymbol<?> firBasedSymbol = TypeUtilsKt.toSymbol(typeArgument, context2.getSession());
            if (firBasedSymbol == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol");
            }
            symbol2 = (FirTypeParameterSymbol)firBasedSymbol;
        } else if (typeArgument != null && this.cannotBeReified(typeArgument)) {
            DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getREIFIED_TYPE_FORBIDDEN_SUBSTITUTION(), (Object)typeArgument, context2, null, 16, null);
            return;
        }
        if (factory2 != null) {
            FirTypeParameterSymbol firTypeParameterSymbol;
            if (symbol2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"symbol");
                firTypeParameterSymbol = null;
            } else {
                firTypeParameterSymbol = symbol2;
            }
            if (!firTypeParameterSymbol.isReified()) {
                DiagnosticReporterKt.reportOn$default(reporter2, source, factory2, (Object)symbol2, context2, null, 16, null);
            }
        }
    }

    private final boolean cannotBeReified(ConeKotlinType $this$cannotBeReified) {
        return ConeTypeUtilsKt.isNothing($this$cannotBeReified) || ConeTypeUtilsKt.isNullableNothing($this$cannotBeReified) || $this$cannotBeReified instanceof ConeCapturedType;
    }
}

