/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import com.intellij.lang.LighterASTNode;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.fir.FirFakeSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.PathAwarePropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.PropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.TraverseDirection;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JT\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0016\u0010\f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u001cR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "()V", "canBeValOccurrenceRanges", "", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "analyze", "", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "data", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/PathAwarePropertyInitializationInfo;", "properties", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "capturedWrites", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "canBeVal", "", "symbol", "value", "getDestructuringChildrenCount", "", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Ljava/lang/Integer;", "UninitializedPropertyReporter", "checkers"})
public final class CanBeValChecker
extends AbstractFirPropertyInitializationChecker {
    @NotNull
    public static final CanBeValChecker INSTANCE = new CanBeValChecker();
    @NotNull
    private static final Set<EventOccurrencesRange> canBeValOccurrenceRanges;

    private CanBeValChecker() {
    }

    @Override
    public void analyze(@NotNull ControlFlowGraph graph2, @NotNull DiagnosticReporter reporter2, @NotNull Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data, @NotNull Set<? extends FirPropertySymbol> properties2, @NotNull Set<? extends FirVariableAssignment> capturedWrites, @NotNull CheckerContext context2) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(properties2, (String)"properties");
        Intrinsics.checkNotNullParameter(capturedWrites, (String)"capturedWrites");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Set unprocessedProperties = new LinkedHashSet();
        Map propertiesCharacteristics = new LinkedHashMap();
        UninitializedPropertyReporter reporterVisitor = new UninitializedPropertyReporter(data, properties2, unprocessedProperties, propertiesCharacteristics);
        CfgTraverserKt.traverse(graph2, TraverseDirection.Forward, reporterVisitor);
        for (FirPropertySymbol property2 : unprocessedProperties) {
            FirSourceElement source = property2.getSource();
            if (source instanceof FirFakeSourceElement || Intrinsics.areEqual((Object)((object2 = source) == null ? null : ((FirSourceElement)object2).getElementType()), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) continue;
            object2 = propertiesCharacteristics;
            object = EventOccurrencesRange.ZERO;
            object2.put(property2, object);
        }
        FirSourceElement lastDestructuringSource = null;
        boolean destructuringCanBeVal = false;
        int lastDestructuredVariables = 0;
        object = propertiesCharacteristics;
        object2 = object.entrySet().iterator();
        while (object2.hasNext()) {
            Object object3 = object = (Map.Entry)object2.next();
            FirPropertySymbol symbol2 = (FirPropertySymbol)object3.getKey();
            Object object4 = object;
            EventOccurrencesRange value2 = (EventOccurrencesRange)((Object)object4.getValue());
            FirSourceElement source = symbol2.getSource();
            Object object5 = source;
            if (Intrinsics.areEqual((Object)(object5 == null ? null : ((FirSourceElement)object5).getElementType()), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) {
                lastDestructuringSource = source;
                object5 = this.getDestructuringChildrenCount(symbol2);
                if (object5 == null) continue;
                lastDestructuredVariables = (Integer)object5;
                destructuringCanBeVal = true;
                continue;
            }
            if (lastDestructuringSource != null) {
                if (lastDestructuredVariables == 1 && destructuringCanBeVal && this.canBeVal(symbol2, value2)) {
                    DiagnosticReporterKt.reportOn$default(reporter2, lastDestructuringSource, FirErrors.INSTANCE.getCAN_BE_VAL(), context2, null, 8, null);
                    lastDestructuringSource = null;
                } else if (!this.canBeVal(symbol2, value2)) {
                    destructuringCanBeVal = false;
                }
                int n = lastDestructuredVariables;
                lastDestructuredVariables = n + -1;
                continue;
            }
            if (!this.canBeVal(symbol2, value2) || symbol2.getHasDelegate()) continue;
            DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getCAN_BE_VAL(), context2, null, 8, null);
        }
    }

    private final boolean canBeVal(FirPropertySymbol symbol2, EventOccurrencesRange value2) {
        return canBeValOccurrenceRanges.contains((Object)value2) && symbol2.isVar();
    }

    private final Integer getDestructuringChildrenCount(FirPropertySymbol $this$getDestructuringChildrenCount) {
        int n;
        FirSourceElement firSourceElement = $this$getDestructuringChildrenCount.getSource();
        if (firSourceElement == null) {
            return null;
        }
        FirSourceElement source = firSourceElement;
        Iterable $this$count$iv = SourceHelpersKt.getChildren(source.getLighterASTNode(), source.getTreeStructure());
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                int n2;
                LighterASTNode it = (LighterASTNode)element$iv;
                boolean bl = false;
                LighterASTNode lighterASTNode2 = it;
                if (!Intrinsics.areEqual((Object)(lighterASTNode2 == null ? null : lighterASTNode2.getTokenType()), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY) || (n2 = ++count$iv) >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    static {
        EventOccurrencesRange[] eventOccurrencesRangeArray = new EventOccurrencesRange[]{EventOccurrencesRange.EXACTLY_ONCE, EventOccurrencesRange.AT_MOST_ONCE, EventOccurrencesRange.ZERO};
        canBeValOccurrenceRanges = SetsKt.setOf((Object[])eventOccurrencesRangeArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BM\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001bH\u0016R!\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker$UninitializedPropertyReporter;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/PathAwarePropertyInitializationInfo;", "localProperties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "unprocessedProperties", "", "propertiesCharacteristics", "", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "(Ljava/util/Map;Ljava/util/Set;Ljava/util/Set;Ljava/util/Map;)V", "getData", "()Ljava/util/Map;", "getLocalProperties", "()Ljava/util/Set;", "getPropertiesCharacteristics", "getUnprocessedProperties", "visitNode", "", "node", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "checkers"})
    private static final class UninitializedPropertyReporter
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data;
        @NotNull
        private final Set<FirPropertySymbol> localProperties;
        @NotNull
        private final Set<FirPropertySymbol> unprocessedProperties;
        @NotNull
        private final Map<FirPropertySymbol, EventOccurrencesRange> propertiesCharacteristics;

        public UninitializedPropertyReporter(@NotNull Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data, @NotNull Set<? extends FirPropertySymbol> localProperties, @NotNull Set<FirPropertySymbol> unprocessedProperties, @NotNull Map<FirPropertySymbol, EventOccurrencesRange> propertiesCharacteristics) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            Intrinsics.checkNotNullParameter(localProperties, (String)"localProperties");
            Intrinsics.checkNotNullParameter(unprocessedProperties, (String)"unprocessedProperties");
            Intrinsics.checkNotNullParameter(propertiesCharacteristics, (String)"propertiesCharacteristics");
            this.data = data;
            this.localProperties = localProperties;
            this.unprocessedProperties = unprocessedProperties;
            this.propertiesCharacteristics = propertiesCharacteristics;
        }

        @NotNull
        public final Map<CFGNode<?>, PathAwarePropertyInitializationInfo> getData() {
            return this.data;
        }

        @NotNull
        public final Set<FirPropertySymbol> getLocalProperties() {
            return this.localProperties;
        }

        @NotNull
        public final Set<FirPropertySymbol> getUnprocessedProperties() {
            return this.unprocessedProperties;
        }

        @NotNull
        public final Map<FirPropertySymbol, EventOccurrencesRange> getPropertiesCharacteristics() {
            return this.propertiesCharacteristics;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
        }

        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
            FirPropertySymbol firPropertySymbol;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Object object = node.getFir().getCalleeReference();
            Object object2 = object instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)object : null;
            FirBasedSymbol<?> firBasedSymbol = object2 == null ? null : ((FirResolvedNamedReference)object2).getResolvedSymbol();
            FirPropertySymbol firPropertySymbol2 = firPropertySymbol = firBasedSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)firBasedSymbol : null;
            if (firPropertySymbol == null) {
                return;
            }
            FirPropertySymbol symbol2 = firPropertySymbol;
            if (!this.localProperties.contains(symbol2)) {
                return;
            }
            this.unprocessedProperties.remove(symbol2);
            EventOccurrencesRange currentCharacteristic = this.propertiesCharacteristics.getOrDefault(symbol2, EventOccurrencesRange.ZERO);
            PathAwarePropertyInitializationInfo info = (PathAwarePropertyInitializationInfo)MapsKt.getValue(this.data, (Object)node);
            object2 = this.propertiesCharacteristics;
            object = (EventOccurrencesRange)((Object)((PropertyInitializationInfo)info.getInfoAtNormalPath$checkers()).get(symbol2));
            object = currentCharacteristic.or((EventOccurrencesRange)((Object)(object == null ? EventOccurrencesRange.ZERO : object)));
            object2.put(symbol2, object);
        }

        @Override
        public void visitVariableDeclarationNode(@NotNull VariableDeclarationNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            FirPropertySymbol symbol2 = node.getFir().getSymbol();
            if (node.getFir().getInitializer() == null && node.getFir().getDelegate() == null) {
                this.unprocessedProperties.add(symbol2);
            } else {
                Map<FirPropertySymbol, EventOccurrencesRange> map = this.propertiesCharacteristics;
                EventOccurrencesRange eventOccurrencesRange = EventOccurrencesRange.AT_MOST_ONCE;
                map.put(symbol2, eventOccurrencesRange);
            }
        }
    }
}

