/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00132\b\b\u0002\u0010\u0017\u001a\u00020\u00132\b\b\u0002\u0010\u0018\u001a\u00020\u0013H\u0007J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010\u0016\u001a\u00020\u00132\b\b\u0002\u0010\u0018\u001a\u00020\u0013H\u0007J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J \u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013H\u0002R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/MainFunctionDetector;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "functionResolver", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lkotlin/jvm/functions/Function1;)V", "getFunctionDescriptor", "getMainFunction", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "packageView", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "isMain", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "checkJvmStaticAnnotation", "checkReturnType", "allowParameterless", "function", "isMainWithParameter", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isParameterNumberSuitsForMain", "parametersCount", "", "isTopLevel", "Companion", "Factory", "frontend"})
public final class MainFunctionDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<KtNamedFunction, FunctionDescriptor> getFunctionDescriptor;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public MainFunctionDetector(final @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.getFunctionDescriptor = (Function1)new Function1<KtNamedFunction, FunctionDescriptor>(){

            @NotNull
            public final FunctionDescriptor invoke(@NotNull KtNamedFunction function2) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)bindingContext.get(BindingContext.FUNCTION, function2);
                if (simpleFunctionDescriptor == null) {
                    throw new KotlinExceptionWithAttachments(Intrinsics.stringPlus((String)"No descriptor resolved for ", (Object)function2)).withAttachment("function.text", function2.getText());
                }
                return simpleFunctionDescriptor;
            }
        };
        this.languageVersionSettings = languageVersionSettings;
    }

    public MainFunctionDetector(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull Function1<? super KtNamedFunction, ? extends FunctionDescriptor> functionResolver) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter(functionResolver, (String)"functionResolver");
        this.getFunctionDescriptor = functionResolver;
        this.languageVersionSettings = languageVersionSettings;
    }

    @JvmOverloads
    public final boolean isMain(@NotNull KtNamedFunction function2, boolean checkJvmStaticAnnotation, boolean allowParameterless) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        if (function2.isLocal()) {
            return false;
        }
        int parametersCount = function2.getValueParameters().size();
        if (function2.getReceiverTypeReference() != null) {
            int n = parametersCount;
            parametersCount = n + 1;
        }
        if (!this.isParameterNumberSuitsForMain(parametersCount, function2.isTopLevel(), allowParameterless)) {
            return false;
        }
        if (!function2.getTypeParameters().isEmpty()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)"main", (Object)function2.getName()) && !MainFunctionDetector.Companion.hasAnnotationWithExactNumberOfArguments(function2, 1)) {
            return false;
        }
        if (checkJvmStaticAnnotation && !function2.isTopLevel() && !MainFunctionDetector.Companion.hasAnnotationWithExactNumberOfArguments(function2, 0)) {
            return false;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.getFunctionDescriptor.invoke((Object)function2);
        if (functionDescriptor == null) {
            return false;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        return MainFunctionDetector.isMain$default(this, functionDescriptor2, checkJvmStaticAnnotation, false, allowParameterless, 4, null);
    }

    public static /* synthetic */ boolean isMain$default(MainFunctionDetector mainFunctionDetector, KtNamedFunction ktNamedFunction, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return mainFunctionDetector.isMain(ktNamedFunction, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final boolean isMain(@NotNull DeclarationDescriptor descriptor2, boolean checkJvmStaticAnnotation, boolean checkReturnType, boolean allowParameterless) {
        KotlinType it;
        KotlinType destination$iv;
        Iterator iterator2;
        Object $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)MainFunctionDetector.Companion.getJVMFunctionName((FunctionDescriptor)descriptor2), (Object)"main")) {
            return false;
        }
        Iterable<ValueParameterDescriptor> iterable = ((FunctionDescriptor)descriptor2).getValueParameters();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"descriptor.valueParameters");
        iterable = iterable;
        Object object = new ArrayList();
        boolean $i$f$mapTo = false;
        Iterator iterator3 = $this$mapTo$iv.iterator();
        while (iterator3.hasNext()) {
            void it2;
            Object item$iv = iterator3.next();
            iterator2 = (ValueParameterDescriptor)item$iv;
            void var15_23 = destination$iv;
            boolean bl = false;
            KotlinType kotlinType = it2.getType();
            var15_23.add(kotlinType);
        }
        List parameters2 = (List)((Object)destination$iv);
        $this$mapTo$iv = ((FunctionDescriptor)descriptor2).getExtensionReceiverParameter();
        if ($this$mapTo$iv != null) {
            it = $i$f$mapTo = (destination$iv = $this$mapTo$iv.getType());
            boolean bl = false;
            iterator2 = parameters2;
            iterator2.add(it);
        }
        if (!this.isParameterNumberSuitsForMain(parameters2.size(), DescriptorUtils.isTopLevelDeclaration(descriptor2), allowParameterless)) {
            return false;
        }
        $this$mapTo$iv = ((FunctionDescriptor)descriptor2).getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)$this$mapTo$iv, (String)"descriptor.typeParameters");
        if (!((Collection)$this$mapTo$iv).isEmpty()) {
            return false;
        }
        if (parameters2.size() == 1) {
            destination$iv = parameters2.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)destination$iv, (String)"parameters[0]");
            KotlinType parameterType = destination$iv;
            if (!KotlinBuiltIns.isArray(parameterType)) {
                return false;
            }
            List<TypeProjection> typeArguments2 = parameterType.getArguments();
            if (typeArguments2.size() != 1) {
                return false;
            }
            it = typeArguments2.get(0).getType();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"typeArguments[0].type");
            KotlinType typeArgument = it;
            if (!KotlinBuiltIns.isString(typeArgument)) {
                return false;
            }
            if (typeArguments2.get(0).getProjectionKind() == Variance.IN_VARIANCE) {
                return false;
            }
        } else {
            boolean bl;
            boolean parameterType;
            boolean bl2 = parameterType = parameters2.size() == 0;
            if (_Assertions.ENABLED && !parameterType) {
                boolean $i$a$-assert-MainFunctionDetector$isMain$42 = false;
                String $i$a$-assert-MainFunctionDetector$isMain$42 = "Parameter list is expected to be empty";
                throw new AssertionError((Object)$i$a$-assert-MainFunctionDetector$isMain$42);
            }
            parameterType = DescriptorUtils.isTopLevelDeclaration(descriptor2);
            if (_Assertions.ENABLED && !parameterType) {
                boolean bl3 = false;
                String string2 = "main without parameters works only for top-level";
                throw new AssertionError((Object)string2);
            }
            KtFile containingFile = DescriptorToSourceUtils.getContainingFile(descriptor2);
            if (!Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor2).getName().asString(), (Object)"main")) {
                return false;
            }
            object = containingFile;
            if (object == null) {
                bl = false;
            } else {
                boolean bl4;
                block24: {
                    List<KtDeclaration> list2 = ((KtFile)object).getDeclarations();
                    Iterable $this$any$iv = list2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KtDeclaration declaration = (KtDeclaration)element$iv;
                            boolean bl5 = false;
                            if (!this.isMainWithParameter(declaration, checkJvmStaticAnnotation)) continue;
                            bl4 = true;
                            break block24;
                        }
                        bl4 = false;
                    }
                }
                bl = bl4;
            }
            if (bl) {
                return false;
            }
        }
        if (((FunctionDescriptor)descriptor2).isSuspend() && !this.languageVersionSettings.supportsFeature(LanguageFeature.ExtendedMainConvention)) {
            return false;
        }
        if (checkReturnType && !MainFunctionDetector.Companion.isMainReturnType((FunctionDescriptor)descriptor2)) {
            return false;
        }
        if (DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            return true;
        }
        object = ((FunctionDescriptor)descriptor2).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.containingDeclaration");
        Object containingDeclaration = object;
        return containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind().isSingleton() && (AnnotationUtilKt.hasJvmStaticAnnotation(descriptor2) || !checkJvmStaticAnnotation);
    }

    public static /* synthetic */ boolean isMain$default(MainFunctionDetector mainFunctionDetector, DeclarationDescriptor declarationDescriptor, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        return mainFunctionDetector.isMain(declarationDescriptor, bl, bl2, bl3);
    }

    private final boolean isMainWithParameter(KtDeclaration declaration, boolean checkJvmStaticAnnotation) {
        return declaration instanceof KtNamedFunction && this.isMain((KtNamedFunction)declaration, checkJvmStaticAnnotation, false);
    }

    @Nullable
    public final FunctionDescriptor getMainFunction(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"ROOT");
        return this.getMainFunction(module2, module2.getPackage(fqName2));
    }

    /*
     * WARNING - void declaration
     */
    private final FunctionDescriptor getMainFunction(ModuleDescriptor module2, PackageViewDescriptor packageView) {
        Iterable<DeclarationDescriptor> $this$filterTo$iv$iv;
        Iterable $this$filter$iv = packageView.getFragments();
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object t : $this$filterTo$iv$iv) {
            PackageFragmentDescriptor it = (PackageFragmentDescriptor)t;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getModule(it), (Object)module2)) continue;
            destination$iv$iv.add(t);
        }
        for (PackageFragmentDescriptor packageFragment : (List)destination$iv$iv) {
            Object v0;
            block5: {
                void $this$firstOrNull$iv;
                Iterator $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                $this$filterTo$iv$iv = DescriptorUtils.getAllDescriptors(packageFragment.getMemberScope());
                Intrinsics.checkNotNullExpressionValue($this$filterTo$iv$iv, (String)"getAllDescriptors(packag\u2026ragment.getMemberScope())");
                $this$filterTo$iv$iv = $this$filterTo$iv$iv;
                boolean $i$f$filterIsInstance = false;
                void $i$f$filterTo22 = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean bl = false;
                Iterator it = $this$filterIsInstanceTo$iv$iv.iterator();
                while (it.hasNext()) {
                    Object element$iv$iv = it.next();
                    if (!(element$iv$iv instanceof FunctionDescriptor)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv2;
                boolean $i$f$firstOrNull = false;
                $this$filterIsInstanceTo$iv$iv = $this$firstOrNull$iv.iterator();
                while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
                    Object element$iv = $this$filterIsInstanceTo$iv$iv.next();
                    FunctionDescriptor functionDescriptor = (FunctionDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!MainFunctionDetector.isMain$default(this, functionDescriptor, false, false, false, 14, null)) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            FunctionDescriptor functionDescriptor = v0;
            if (functionDescriptor == null) continue;
            Object it = object = functionDescriptor;
            boolean bl = false;
            return it;
        }
        for (FqName subpackageName : module2.getSubPackagesOf(packageView.getFqName(), MemberScope.Companion.getALL_NAME_FILTER())) {
            FunctionDescriptor functionDescriptor = this.getMainFunction(module2, module2.getPackage(subpackageName));
            if (functionDescriptor == null) continue;
            Object it = object = functionDescriptor;
            boolean bl = false;
            return it;
        }
        return null;
    }

    private final boolean isParameterNumberSuitsForMain(int parametersCount, boolean isTopLevel, boolean allowParameterless) {
        boolean bl;
        int n = parametersCount;
        switch (n) {
            case 1: {
                bl = true;
                break;
            }
            case 0: {
                if (isTopLevel && allowParameterless && this.languageVersionSettings.supportsFeature(LanguageFeature.ExtendedMainConvention)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @JvmOverloads
    public final boolean isMain(@NotNull KtNamedFunction function2, boolean checkJvmStaticAnnotation) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return MainFunctionDetector.isMain$default(this, function2, checkJvmStaticAnnotation, false, 4, null);
    }

    @JvmOverloads
    public final boolean isMain(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return MainFunctionDetector.isMain$default(this, function2, false, false, 6, null);
    }

    @JvmOverloads
    public final boolean isMain(@NotNull DeclarationDescriptor descriptor2, boolean checkJvmStaticAnnotation, boolean checkReturnType) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return MainFunctionDetector.isMain$default(this, descriptor2, checkJvmStaticAnnotation, checkReturnType, false, 8, null);
    }

    @JvmOverloads
    public final boolean isMain(@NotNull DeclarationDescriptor descriptor2, boolean checkJvmStaticAnnotation) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return MainFunctionDetector.isMain$default(this, descriptor2, checkJvmStaticAnnotation, false, false, 12, null);
    }

    @JvmOverloads
    public final boolean isMain(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return MainFunctionDetector.isMain$default(this, descriptor2, false, false, false, 14, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/MainFunctionDetector$Companion;", "", "()V", "getJVMFunctionName", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "hasAnnotationWithExactNumberOfArguments", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "number", "", "isMainReturnType", "descriptor", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isMainReturnType(FunctionDescriptor descriptor2) {
            KotlinType returnType2 = descriptor2.getReturnType();
            return returnType2 != null && KotlinBuiltIns.isUnit(returnType2);
        }

        private final String getJVMFunctionName(FunctionDescriptor functionDescriptor) {
            String string2;
            String string3 = DescriptorUtils.getJvmName(functionDescriptor);
            if (string3 == null) {
                String string4 = functionDescriptor.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"functionDescriptor.name.asString()");
                string2 = string4;
            } else {
                string2 = string3;
            }
            return string2;
        }

        private final boolean hasAnnotationWithExactNumberOfArguments(KtNamedFunction function2, int number2) {
            boolean bl;
            block3: {
                List<KtAnnotationEntry> list2 = function2.getAnnotationEntries();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"function.annotationEntries");
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                        boolean bl2 = false;
                        if (!(it.getValueArguments().size() == number2)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\bJ\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/MainFunctionDetector$Factory;", "", "createMainFunctionDetector", "Lorg/jetbrains/kotlin/idea/MainFunctionDetector;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "Ordinary", "frontend"})
    public static interface Factory {
        @NotNull
        public MainFunctionDetector createMainFunctionDetector(@NotNull BindingTrace var1, @NotNull LanguageVersionSettings var2);

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/MainFunctionDetector$Factory$Ordinary;", "Lorg/jetbrains/kotlin/idea/MainFunctionDetector$Factory;", "()V", "createMainFunctionDetector", "Lorg/jetbrains/kotlin/idea/MainFunctionDetector;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend"})
        public static final class Ordinary
        implements Factory {
            @Override
            @NotNull
            public MainFunctionDetector createMainFunctionDetector(@NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings) {
                Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
                Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                return new MainFunctionDetector(bindingContext, languageVersionSettings);
            }
        }
    }
}

