/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.naming;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityUtilsKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.js.naming.EncodeSignatureKt;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.NameSuggestionKt;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nR\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/naming/NameSuggestion;", "", "()V", "cache", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/js/naming/SuggestedName;", "generate", "descriptor", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "generateDefault", "getSuggestedName", "", "suggest", "Companion", "js.frontend"})
public final class NameSuggestion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<DeclarationDescriptor, SuggestedName> cache;

    public NameSuggestion() {
        Map map = Collections.synchronizedMap(new WeakHashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(WeakHashMap())");
        this.cache = map;
    }

    @Nullable
    public final SuggestedName suggest(@NotNull DeclarationDescriptor descriptor2, @NotNull BindingContext bindingContext) {
        SuggestedName suggestedName;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Map<DeclarationDescriptor, SuggestedName> $this$getOrPut$iv = this.cache;
        boolean $i$f$getOrPut = false;
        SuggestedName value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl = false;
            DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.original");
            SuggestedName answer$iv = this.generate(declarationDescriptor, bindingContext);
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            suggestedName = answer$iv;
        } else {
            suggestedName = value$iv;
        }
        return suggestedName;
    }

    /*
     * WARNING - void declaration
     */
    private final SuggestedName generate(DeclarationDescriptor descriptor2, BindingContext bindingContext) {
        DeclarationDescriptor declarationDescriptor;
        if (AnnotationsUtils.isNativeObject(descriptor2) && DescriptorUtils.isCompanionObject(descriptor2)) {
            DeclarationDescriptor declarationDescriptor2 = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNull((Object)declarationDescriptor2);
            DeclarationDescriptor declarationDescriptor3 = declarationDescriptor2;
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor3, (String)"descriptor.containingDeclaration!!");
            return this.suggest(declarationDescriptor3, bindingContext);
        }
        if (descriptor2 instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor2).isSuspend() && (declarationDescriptor = ((FunctionDescriptor)descriptor2).getInitialSignatureDescriptor()) != null) {
            DeclarationDescriptor declarationDescriptor4;
            DeclarationDescriptor it = declarationDescriptor4 = declarationDescriptor;
            boolean bl = false;
            return NameSuggestion.generate$suggest(this, bindingContext, it);
        }
        if (DynamicCallsKt.isDynamic(descriptor2)) {
            List list2 = CollectionsKt.listOf((Object)descriptor2.getName().asString());
            DeclarationDescriptor declarationDescriptor5 = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNull((Object)declarationDescriptor5);
            declarationDescriptor = declarationDescriptor5;
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration!!");
            return new SuggestedName(list2, true, descriptor2, declarationDescriptor);
        }
        declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof ModuleDescriptor) {
            return null;
        }
        if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            SuggestedName suggestedName;
            if (!((PackageFragmentDescriptor)descriptor2).getFqName().isRoot()) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                List<Name> list3 = ((PackageFragmentDescriptor)descriptor2).getFqName().pathSegments();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"descriptor.fqName.pathSegments()");
                Iterable $this$map$iv = list3;
                boolean $i$f$map = false;
                Iterable bl = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    Name name2 = (Name)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    String string2 = p0.asString();
                    collection.add(string2);
                }
                collection = (List)destination$iv$iv;
                DeclarationDescriptor declarationDescriptor6 = ((PackageFragmentDescriptor)descriptor2).getContainingDeclaration();
                DeclarationDescriptor declarationDescriptor7 = descriptor2;
                boolean bl3 = true;
                List list4 = collection;
                suggestedName = new SuggestedName(list4, bl3, declarationDescriptor7, declarationDescriptor6);
            } else {
                suggestedName = null;
            }
            return suggestedName;
        }
        if (declarationDescriptor instanceof FakeCallableDescriptorForObject) {
            return NameSuggestion.generate$suggest(this, bindingContext, ((FakeCallableDescriptorForObject)descriptor2).getReferencedObject());
        }
        if (declarationDescriptor instanceof TypeAliasConstructorDescriptor) {
            return NameSuggestion.generate$suggest(this, bindingContext, ((TypeAliasConstructorDescriptor)descriptor2).getUnderlyingConstructorDescriptor());
        }
        if (declarationDescriptor instanceof ConstructorDescriptor) {
            if (((ConstructorDescriptor)descriptor2).isPrimary() || AnnotationsUtils.isNativeObject(descriptor2)) {
                ClassifierDescriptorWithTypeParameters $this$map$iv = ((ConstructorDescriptor)descriptor2).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"descriptor.containingDeclaration");
                return NameSuggestion.generate$suggest(this, bindingContext, $this$map$iv);
            }
        } else if (declarationDescriptor instanceof CallableDescriptor && DescriptorUtils.isDescriptorWithLocalVisibility(descriptor2)) {
            String ownName;
            String $this$mapTo$iv$iv = AnnotationsUtils.getNameForAnnotatedObject(descriptor2, bindingContext);
            String $i$f$map = $this$mapTo$iv$iv == null ? this.getSuggestedName(descriptor2) : $this$mapTo$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$map, (String)"getNameForAnnotatedObjec\u2026SuggestedName(descriptor)");
            String name3 = ownName = $i$f$map;
            DeclarationDescriptor destination$iv$iv = ((CallableDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)destination$iv$iv, (String)"descriptor.containingDeclaration");
            DeclarationDescriptor scope2 = destination$iv$iv;
            if (descriptor2 instanceof FunctionDescriptor) {
                DeclarationDescriptor $i$f$mapTo = ((FunctionDescriptor)descriptor2).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapTo, (String)"descriptor.containingDeclaration");
                DeclarationDescriptor container = $i$f$mapTo;
                String liftedName = ownName;
                boolean hasInline = false;
                while (container instanceof FunctionDescriptor) {
                    if (((FunctionDescriptor)container).isInline() && NameSuggestion.Companion.getOwnEffectiveVisibility((DeclarationDescriptorWithVisibility)container).isPublicAPI()) {
                        hasInline = true;
                    }
                    liftedName = this.getSuggestedName(container) + '$' + liftedName;
                    DeclarationDescriptor declarationDescriptor8 = ((FunctionDescriptor)container).getContainingDeclaration();
                    Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor8, (String)"container.containingDeclaration");
                    container = declarationDescriptor8;
                }
                if (hasInline) {
                    scope2 = container;
                    name3 = liftedName;
                }
            }
            return new SuggestedName(CollectionsKt.listOf((Object)name3), false, descriptor2, scope2);
        }
        return this.generateDefault(descriptor2, bindingContext);
    }

    private final SuggestedName generateDefault(DeclarationDescriptor descriptor2, BindingContext bindingContext) {
        Object outerFunctionName;
        String string2;
        Object object;
        CallableMemberDescriptor overridden;
        List parts2 = new ArrayList();
        Object current = descriptor2;
        if (current instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)current).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE && !ModalityUtilsKt.isOverridableOrOverrides(overridden = (CallableMemberDescriptor)NameSuggestion.Companion.getOverridden((CallableDescriptor)current))) {
            current = overridden;
        }
        DeclarationDescriptor fixedDescriptor = current;
        Collection collection = parts2;
        if (fixedDescriptor instanceof ConstructorDescriptor) {
            DeclarationDescriptor declarationDescriptor = current.getContainingDeclaration();
            Intrinsics.checkNotNull((Object)declarationDescriptor);
            object = declarationDescriptor;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"current.containingDeclaration!!");
            current = object;
            string2 = Intrinsics.stringPlus((String)this.getSuggestedName((DeclarationDescriptor)current), (Object)"_init");
        } else {
            string2 = this.getSuggestedName(fixedDescriptor);
        }
        collection.add(string2);
        if (current.getContainingDeclaration() instanceof FunctionDescriptor && !(current instanceof TypeParameterDescriptor)) {
            object = current.getContainingDeclaration();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            }
            SuggestedName suggestedName = this.suggest((FunctionDescriptor)object, bindingContext);
            Intrinsics.checkNotNull((Object)suggestedName);
            outerFunctionName = suggestedName;
            ((Collection)parts2).add(CollectionsKt.single(((SuggestedName)outerFunctionName).getNames()));
            current = ((SuggestedName)outerFunctionName).getScope();
        } else {
            DeclarationDescriptor declarationDescriptor = current.getContainingDeclaration();
            Intrinsics.checkNotNull((Object)declarationDescriptor);
            outerFunctionName = declarationDescriptor;
            Intrinsics.checkNotNullExpressionValue((Object)outerFunctionName, (String)"current.containingDeclaration!!");
            current = outerFunctionName;
        }
        if (current instanceof PropertyDescriptor) {
            outerFunctionName = ((PropertyDescriptor)current).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)outerFunctionName, (String)"current.containingDeclaration");
            current = outerFunctionName;
        }
        CollectionsKt.reverse((List)parts2);
        String unmangledName = CollectionsKt.joinToString$default((Iterable)parts2, (CharSequence)"$", null, null, (int)0, null, null, (int)62, null);
        object = NameSuggestion.Companion.mangleNameIfNecessary(unmangledName, fixedDescriptor, bindingContext);
        String id = ((Companion.NameAndStability)object).component1();
        boolean stable = ((Companion.NameAndStability)object).component2();
        return new SuggestedName(CollectionsKt.listOf((Object)id), stable, fixedDescriptor, (DeclarationDescriptor)current);
    }

    private final String getSuggestedName(DeclarationDescriptor descriptor2) {
        Object object;
        Object object2 = descriptor2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"descriptor.name");
        Name name2 = object2;
        if (name2.isSpecial()) {
            object2 = descriptor2;
            if (object2 instanceof PropertyGetterDescriptor) {
                PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)descriptor2).getCorrespondingProperty();
                Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
                object = Intrinsics.stringPlus((String)"get_", (Object)this.getSuggestedName(propertyDescriptor));
            } else if (object2 instanceof PropertySetterDescriptor) {
                PropertyDescriptor propertyDescriptor = ((PropertySetterDescriptor)descriptor2).getCorrespondingProperty();
                Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
                object = Intrinsics.stringPlus((String)"set_", (Object)this.getSuggestedName(propertyDescriptor));
            } else {
                object = "f";
            }
        } else {
            object2 = name2.asString();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"{\n            name.asString()\n        }");
            object = object2;
        }
        return object;
    }

    private static final SuggestedName generate$suggest(NameSuggestion this$0, BindingContext $bindingContext, DeclarationDescriptor d) {
        return this$0.suggest(d, $bindingContext);
    }

    @JvmStatic
    @NotNull
    public static final String getPrivateMangledName(@NotNull String baseName, @NotNull CallableDescriptor descriptor2) {
        return Companion.getPrivateMangledName(baseName, descriptor2);
    }

    @JvmStatic
    @NotNull
    public static final String getStableMangledName(@NotNull String suggestedName, @NotNull String forCalculateId) {
        return Companion.getStableMangledName(suggestedName, forCalculateId);
    }

    @JvmStatic
    @NotNull
    public static final String sanitizeName(@NotNull String name2) {
        return Companion.sanitizeName(name2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0007J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0007R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/js/naming/NameSuggestion$Companion;", "", "()V", "ownEffectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "getOwnEffectiveVisibility", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;)Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "getInternalMangledName", "", "suggestedName", "forCalculateId", "getOverridden", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "descriptor", "getPrivateMangledName", "baseName", "getStableMangledName", "mangleNameIfNecessary", "Lorg/jetbrains/kotlin/js/naming/NameSuggestion$Companion$NameAndStability;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "mangleRegularNameIfNecessary", "mangledId", "sanitizeName", "name", "NameAndStability", "js.frontend"})
    public static final class Companion {
        private Companion() {
        }

        private final NameAndStability mangleNameIfNecessary(String baseName, DeclarationDescriptor descriptor2, BindingContext bindingContext) {
            DeclarationDescriptor overriddenDescriptor2;
            block23: {
                block21: {
                    overriddenDescriptor2 = descriptor2 instanceof CallableDescriptor ? (DeclarationDescriptor)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)descriptor2, (Function1)mangleNameIfNecessary.overriddenDescriptor.1.INSTANCE)) : descriptor2;
                    String nativeName = AnnotationsUtils.getNameForAnnotatedObject(overriddenDescriptor2, bindingContext);
                    if (nativeName != null) {
                        return new NameAndStability(nativeName, true);
                    }
                    if (!(overriddenDescriptor2 instanceof FunctionDescriptor)) break block21;
                    switch (DescriptorUtilsKt.getFqNameUnsafe(overriddenDescriptor2).asString()) {
                        case "kotlin.CharSequence.get": {
                            return new NameAndStability("charCodeAt", true);
                        }
                        case "kotlin.Any.equals": {
                            return new NameAndStability("equals", true);
                        }
                    }
                    Annotated annotated = ((FunctionDescriptor)overriddenDescriptor2).getContainingDeclaration();
                    Intrinsics.checkNotNullExpressionValue((Object)annotated, (String)"overriddenDescriptor.containingDeclaration");
                    DeclarationDescriptor container = annotated;
                    if (container instanceof ClassDescriptor) {
                        annotated = ((ClassDescriptor)container).getDefaultType();
                        Intrinsics.checkNotNullExpressionValue((Object)annotated, (String)"container.defaultType");
                        if (ReflectionTypes.Companion.isNumberedKPropertyOrKMutablePropertyType((KotlinType)annotated)) {
                            String name2;
                            String string2 = ((FunctionDescriptor)overriddenDescriptor2).getName().asString();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"overriddenDescriptor.name.asString()");
                            string2 = name2 = string2;
                            if (Intrinsics.areEqual((Object)string2, (Object)"get") ? true : Intrinsics.areEqual((Object)string2, (Object)"set")) {
                                return new NameAndStability(name2, true);
                            }
                        }
                    }
                    break block23;
                }
                if (!(overriddenDescriptor2 instanceof PropertyDescriptor)) break block23;
                switch (DescriptorUtilsKt.getFqNameUnsafe(overriddenDescriptor2).asString()) {
                    case "kotlin.reflect.KCallable.name": {
                        return new NameAndStability("callableName", true);
                    }
                }
            }
            return this.mangleRegularNameIfNecessary(baseName, overriddenDescriptor2);
        }

        private final CallableDescriptor getOverridden(CallableDescriptor descriptor2) {
            return (CallableDescriptor)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)descriptor2, (Function1)getOverridden.1.INSTANCE));
        }

        private final NameAndStability mangleRegularNameIfNecessary(String baseName, DeclarationDescriptor descriptor2) {
            NameAndStability nameAndStability;
            DeclarationDescriptor containingDeclaration;
            if (descriptor2 instanceof ClassOrPackageFragmentDescriptor) {
                return new NameAndStability(baseName, !DescriptorUtils.isDescriptorWithLocalVisibility(descriptor2));
            }
            if (!(descriptor2 instanceof CallableMemberDescriptor)) {
                return org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$regularAndUnstable(baseName);
            }
            DescriptorVisibility effectiveVisibility = this.getOwnEffectiveVisibility((DeclarationDescriptorWithVisibility)descriptor2);
            DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
            declarationDescriptor = containingDeclaration = declarationDescriptor;
            if (declarationDescriptor instanceof PackageFragmentDescriptor) {
                nameAndStability = effectiveVisibility.isPublicAPI() ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (Intrinsics.areEqual((Object)effectiveVisibility, (Object)DescriptorVisibilities.INTERNAL) ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledInternal(baseName, descriptor2) : org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$regularAndUnstable(baseName));
            } else if (declarationDescriptor instanceof ClassDescriptor) {
                nameAndStability = descriptor2 instanceof FunctionDescriptor && DescriptorUtilsKt.isEnumValueOfMethod((FunctionDescriptor)descriptor2) ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (Intrinsics.areEqual((Object)effectiveVisibility, (Object)DescriptorVisibilities.PUBLIC) ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (ModalityUtilsKt.isOverridableOrOverrides((CallableMemberDescriptor)descriptor2) ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (Intrinsics.areEqual((Object)effectiveVisibility, (Object)DescriptorVisibilities.PROTECTED) && !ModalityUtilsKt.isFinalClass((ClassDescriptor)containingDeclaration) && ((ClassDescriptor)containingDeclaration).getVisibility().isPublicAPI() ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (Intrinsics.areEqual((Object)effectiveVisibility, (Object)DescriptorVisibilities.INTERNAL) ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledInternal(baseName, descriptor2) : (((ClassDescriptor)containingDeclaration).getVisibility().isPublicAPI() && !ModalityUtilsKt.isFinalClass((ClassDescriptor)containingDeclaration) ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledPrivate(baseName, descriptor2) : org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$regularAndUnstable(baseName))))));
            } else {
                boolean bl = containingDeclaration instanceof CallableMemberDescriptor;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl2 = false;
                    String string2 = "containingDeclaration for descriptor have unsupported type for mangling, descriptor: " + descriptor2 + ", containingDeclaration: " + containingDeclaration;
                    throw new AssertionError((Object)string2);
                }
                nameAndStability = org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$regularAndUnstable(baseName);
            }
            return nameAndStability;
        }

        @JvmStatic
        @NotNull
        public final String getPrivateMangledName(@NotNull String baseName, @NotNull CallableDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
            String string2 = DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"descriptor.containingDec\u2026n.fqNameUnsafe.asString()");
            String ownerName = string2;
            return this.getStableMangledName(this.sanitizeName(baseName), ownerName + '.' + baseName + ':' + EncodeSignatureKt.encodeSignature(descriptor2));
        }

        @NotNull
        public final String getInternalMangledName(@NotNull String suggestedName, @NotNull String forCalculateId) {
            Intrinsics.checkNotNullParameter((Object)suggestedName, (String)"suggestedName");
            Intrinsics.checkNotNullParameter((Object)forCalculateId, (String)"forCalculateId");
            String suffix = '_' + this.mangledId(Intrinsics.stringPlus((String)"internal:", (Object)forCalculateId)) + '$';
            return Intrinsics.stringPlus((String)suggestedName, (Object)suffix);
        }

        @JvmStatic
        @NotNull
        public final String getStableMangledName(@NotNull String suggestedName, @NotNull String forCalculateId) {
            Intrinsics.checkNotNullParameter((Object)suggestedName, (String)"suggestedName");
            Intrinsics.checkNotNullParameter((Object)forCalculateId, (String)"forCalculateId");
            String suffix = ((CharSequence)forCalculateId).length() == 0 ? "" : '_' + this.mangledId(forCalculateId) + '$';
            return Intrinsics.stringPlus((String)suggestedName, (Object)suffix);
        }

        private final String mangledId(String forCalculateId) {
            String string2;
            int absHashCode = Math.abs(forCalculateId.hashCode());
            if (absHashCode != 0) {
                String string3 = Integer.toString(absHashCode, CharsKt.checkRadix((int)36));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this, checkRadix(radix))");
                string2 = string3;
            } else {
                string2 = "";
            }
            return string2;
        }

        private final DescriptorVisibility getOwnEffectiveVisibility(DeclarationDescriptorWithVisibility $this$ownEffectiveVisibility) {
            DescriptorVisibility descriptorVisibility = $this$ownEffectiveVisibility.getVisibility();
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"visibility");
            return EffectiveVisibilityUtilsKt.toDescriptorVisibility(EffectiveVisibilityUtilsKt.effectiveVisibility(descriptorVisibility, $this$ownEffectiveVisibility, true));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final String sanitizeName(@NotNull String name2) {
            Collection<Character> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            char c;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            if (((CharSequence)name2).length() == 0) {
                return "_";
            }
            char it = c = StringsKt.first((CharSequence)name2);
            boolean $i$a$-let-NameSuggestion$Companion$sanitizeName$first$22 = false;
            char first = NameSuggestionKt.isES5IdentifierStart(it) ? it : (char)'_';
            CharSequence charSequence2 = StringsKt.drop((String)name2, (int)1);
            StringBuilder stringBuilder2 = new StringBuilder().append(first);
            boolean $i$f$map = false;
            void $i$a$-let-NameSuggestion$Companion$sanitizeName$first$22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length());
            boolean $i$f$mapTo = false;
            void var8_11 = $this$mapTo$iv$iv;
            for (int i = 0; i < var8_11.length(); ++i) {
                char it2;
                char item$iv$iv = var8_11.charAt(i);
                char c2 = item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Character c3 = Character.valueOf(NameSuggestionKt.isES5IdentifierPart(it2) ? it2 : (char)'_');
                collection.add(c3);
            }
            collection = (List)destination$iv$iv;
            return stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"", null, null, (int)0, null, null, (int)62, null)).toString();
        }

        private static final NameAndStability mangleRegularNameIfNecessary$regularAndUnstable(String $baseName) {
            return new NameAndStability($baseName, false);
        }

        private static final NameAndStability mangleRegularNameIfNecessary$mangledAndStable(String $baseName, DeclarationDescriptor $descriptor) {
            return new NameAndStability(Companion.getStableMangledName($baseName, EncodeSignatureKt.encodeSignature((CallableDescriptor)$descriptor)), true);
        }

        private static final NameAndStability mangleRegularNameIfNecessary$mangledInternal(String $baseName, DeclarationDescriptor $descriptor) {
            return new NameAndStability(Companion.getInternalMangledName($baseName, EncodeSignatureKt.encodeSignature((CallableDescriptor)$descriptor)), true);
        }

        private static final NameAndStability mangleRegularNameIfNecessary$mangledPrivate(String $baseName, DeclarationDescriptor $descriptor) {
            return new NameAndStability(Companion.getPrivateMangledName($baseName, (CallableDescriptor)$descriptor), false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/js/naming/NameSuggestion$Companion$NameAndStability;", "", "name", "", "stable", "", "(Ljava/lang/String;Z)V", "getName", "()Ljava/lang/String;", "getStable", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "js.frontend"})
        public static final class NameAndStability {
            @NotNull
            private final String name;
            private final boolean stable;

            public NameAndStability(@NotNull String name2, boolean stable) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                this.name = name2;
                this.stable = stable;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            public final boolean getStable() {
                return this.stable;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            public final boolean component2() {
                return this.stable;
            }

            @NotNull
            public final NameAndStability copy(@NotNull String name2, boolean stable) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return new NameAndStability(name2, stable);
            }

            public static /* synthetic */ NameAndStability copy$default(NameAndStability nameAndStability, String string2, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = nameAndStability.name;
                }
                if ((n & 2) != 0) {
                    bl = nameAndStability.stable;
                }
                return nameAndStability.copy(string2, bl);
            }

            @NotNull
            public String toString() {
                return "NameAndStability(name=" + this.name + ", stable=" + this.stable + ')';
            }

            public int hashCode() {
                int result2 = this.name.hashCode();
                int n = this.stable ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                result2 = result2 * 31 + n;
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NameAndStability)) {
                    return false;
                }
                NameAndStability nameAndStability = (NameAndStability)other;
                if (!Intrinsics.areEqual((Object)this.name, (Object)nameAndStability.name)) {
                    return false;
                }
                return this.stable == nameAndStability.stable;
            }
        }
    }
}

