/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaMember;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaValueParameter;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0006\u00a8\u0006\u0007"}, d2={"isMethodWithOneObjectParameter", "", "method", "Lorg/jetbrains/kotlin/load/java/structure/JavaMethod;", "isObjectMethod", "isObjectMethodInInterface", "Lorg/jetbrains/kotlin/load/java/structure/JavaMember;", "compiler.common.jvm"})
public final class JavaLoadingKt {
    public static final boolean isObjectMethodInInterface(@NotNull JavaMember $this$isObjectMethodInInterface) {
        Intrinsics.checkNotNullParameter((Object)$this$isObjectMethodInInterface, (String)"<this>");
        return $this$isObjectMethodInInterface.getContainingClass().isInterface() && $this$isObjectMethodInInterface instanceof JavaMethod && JavaLoadingKt.isObjectMethod((JavaMethod)$this$isObjectMethodInInterface);
    }

    private static final boolean isObjectMethod(JavaMethod method) {
        boolean bl;
        switch (method.getName().asString()) {
            case "hashCode": 
            case "toString": {
                bl = method.getValueParameters().isEmpty();
                break;
            }
            case "equals": {
                bl = JavaLoadingKt.isMethodWithOneObjectParameter(method);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isMethodWithOneObjectParameter(JavaMethod method) {
        JavaClassifierType javaClassifierType;
        List<JavaValueParameter> parameters2 = method.getValueParameters();
        JavaValueParameter javaValueParameter = (JavaValueParameter)CollectionsKt.singleOrNull(parameters2);
        JavaType javaType = javaValueParameter == null ? null : javaValueParameter.getType();
        JavaClassifierType javaClassifierType2 = javaClassifierType = javaType instanceof JavaClassifierType ? (JavaClassifierType)javaType : null;
        if (javaClassifierType == null) {
            return false;
        }
        JavaClassifierType type2 = javaClassifierType;
        JavaClassifier classifier = type2.getClassifier();
        if (classifier instanceof JavaClass) {
            FqName classFqName = ((JavaClass)classifier).getFqName();
            return classFqName != null && Intrinsics.areEqual((Object)classFqName.asString(), (Object)"java.lang.Object");
        }
        return false;
    }
}

