/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.OperatorCallChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.FakeCallKind;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class ForLoopConventionsChecker {
    private final KotlinBuiltIns builtIns;
    private final FakeCallResolver fakeCallResolver;

    public ForLoopConventionsChecker(@NotNull KotlinBuiltIns builtIns, @NotNull FakeCallResolver fakeCallResolver) {
        if (builtIns == null) {
            ForLoopConventionsChecker.$$$reportNull$$$0(0);
        }
        if (fakeCallResolver == null) {
            ForLoopConventionsChecker.$$$reportNull$$$0(1);
        }
        this.builtIns = builtIns;
        this.fakeCallResolver = fakeCallResolver;
    }

    @Nullable
    public KotlinType checkIterableConvention(@NotNull ExpressionReceiver loopRange, @NotNull ExpressionTypingContext context2) {
        KtExpression loopRangeExpression;
        OverloadResolutionResults<FunctionDescriptor> iteratorResolutionResults;
        if (loopRange == null) {
            ForLoopConventionsChecker.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            ForLoopConventionsChecker.$$$reportNull$$$0(3);
        }
        if (!(iteratorResolutionResults = this.fakeCallResolver.resolveFakeCall(context2, loopRange, OperatorNameConventions.ITERATOR, loopRangeExpression = loopRange.getExpression(), loopRangeExpression, FakeCallKind.ITERATOR, Collections.emptyList())).isSuccess()) {
            return null;
        }
        ResolvedCall<FunctionDescriptor> iteratorResolvedCall = iteratorResolutionResults.getResultingCall();
        context2.trace.record(BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, loopRangeExpression, iteratorResolvedCall);
        FunctionDescriptor iteratorFunction = iteratorResolvedCall.getResultingDescriptor();
        ForLoopConventionsChecker.checkIfOperatorModifierPresent(loopRangeExpression, iteratorFunction, context2.trace);
        KotlinType iteratorType = iteratorFunction.getReturnType();
        KotlinType hasNextType = this.checkConventionForIterator(context2, loopRangeExpression, iteratorType, OperatorNameConventions.HAS_NEXT, Errors.HAS_NEXT_FUNCTION_AMBIGUITY, Errors.HAS_NEXT_MISSING, Errors.HAS_NEXT_FUNCTION_NONE_APPLICABLE, BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL);
        if (hasNextType != null && !this.builtIns.isBooleanOrSubtype(hasNextType)) {
            context2.trace.report(Errors.HAS_NEXT_FUNCTION_TYPE_MISMATCH.on(loopRangeExpression, hasNextType));
        }
        return this.checkConventionForIterator(context2, loopRangeExpression, iteratorType, OperatorNameConventions.NEXT, Errors.NEXT_AMBIGUITY, Errors.NEXT_MISSING, Errors.NEXT_NONE_APPLICABLE, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL);
    }

    private static void checkIfOperatorModifierPresent(KtExpression expression2, FunctionDescriptor descriptor2, DiagnosticSink sink) {
        if (ErrorUtils.isError(descriptor2)) {
            return;
        }
        ReceiverParameterDescriptor extensionReceiverParameter2 = descriptor2.getExtensionReceiverParameter();
        if (extensionReceiverParameter2 != null && DynamicTypesKt.isDynamic(extensionReceiverParameter2.getType())) {
            return;
        }
        if (!descriptor2.isOperator()) {
            OperatorCallChecker.Companion.report((PsiElement)expression2, descriptor2, sink);
        }
    }

    @Nullable
    private KotlinType checkConventionForIterator(@NotNull ExpressionTypingContext context2, @NotNull KtExpression loopRangeExpression, @NotNull KotlinType iteratorType, @NotNull Name name2, @NotNull DiagnosticFactory1<KtExpression, KotlinType> ambiguity, @NotNull DiagnosticFactory1<KtExpression, KotlinType> missing, @NotNull DiagnosticFactory1<KtExpression, KotlinType> noneApplicable, @NotNull WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> resolvedCallKey) {
        OverloadResolutionResults<FunctionDescriptor> nextResolutionResults;
        if (context2 == null) {
            ForLoopConventionsChecker.$$$reportNull$$$0(4);
        }
        if (loopRangeExpression == null) {
            ForLoopConventionsChecker.$$$reportNull$$$0(5);
        }
        if (iteratorType == null) {
            ForLoopConventionsChecker.$$$reportNull$$$0(6);
        }
        if (name2 == null) {
            ForLoopConventionsChecker.$$$reportNull$$$0(7);
        }
        if (ambiguity == null) {
            ForLoopConventionsChecker.$$$reportNull$$$0(8);
        }
        if (missing == null) {
            ForLoopConventionsChecker.$$$reportNull$$$0(9);
        }
        if (noneApplicable == null) {
            ForLoopConventionsChecker.$$$reportNull$$$0(10);
        }
        if (resolvedCallKey == null) {
            ForLoopConventionsChecker.$$$reportNull$$$0(11);
        }
        if ((nextResolutionResults = this.fakeCallResolver.resolveFakeCall(context2, new TransientReceiver(iteratorType), name2, loopRangeExpression, loopRangeExpression, FakeCallKind.OTHER, Collections.emptyList())).isAmbiguity()) {
            context2.trace.report(ambiguity.on(loopRangeExpression, iteratorType));
        } else if (nextResolutionResults.isNothing()) {
            context2.trace.report(missing.on(loopRangeExpression, iteratorType));
        } else if (!nextResolutionResults.isSuccess()) {
            context2.trace.report(noneApplicable.on(loopRangeExpression, iteratorType));
        } else {
            assert (nextResolutionResults.isSuccess());
            ResolvedCall<FunctionDescriptor> resolvedCall2 = nextResolutionResults.getResultingCall();
            context2.trace.record(resolvedCallKey, loopRangeExpression, resolvedCall2);
            FunctionDescriptor functionDescriptor = resolvedCall2.getResultingDescriptor();
            ForLoopConventionsChecker.checkIfOperatorModifierPresent(loopRangeExpression, functionDescriptor, context2.trace);
            return functionDescriptor.getReturnType();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fakeCallResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopRange";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopRangeExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iteratorType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ambiguity";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missing";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noneApplicable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCallKey";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIterableConvention";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConventionForIterator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

