/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeTypeParameterInQualifiedAccess;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponentsKt;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0013\u001a\u00020\u0014*\u00020\u00072\u0006\u0010\r\u001a\u00020\u0015H\u0002R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirKClassWithIncorrectTypeArgumentChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "()V", "typeParameterFromError", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getTypeParameterFromError", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkTopLevelDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "isKClassTypeWithErrorOrNullableArgument", "", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "checkers"})
public final class FirKClassWithIncorrectTypeArgumentChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirKClassWithIncorrectTypeArgumentChecker INSTANCE = new FirKClassWithIncorrectTypeArgumentChecker();

    private FirKClassWithIncorrectTypeArgumentChecker() {
    }

    @Override
    public void check(@NotNull FirFile declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        for (FirDeclaration topLevelDeclaration : declaration.getDeclarations()) {
            if (!(topLevelDeclaration instanceof FirCallableDeclaration)) continue;
            this.checkTopLevelDeclaration((FirCallableDeclaration)topLevelDeclaration, context2, reporter2);
        }
    }

    private final void checkTopLevelDeclaration(FirCallableDeclaration declaration, CheckerContext context2, DiagnosticReporter reporter2) {
        FirSourceElement firSourceElement = declaration.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        if (source.getKind() instanceof FirFakeSourceElementKind) {
            return;
        }
        ConeKotlinType returnType2 = FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef());
        if (!this.isKClassTypeWithErrorOrNullableArgument(returnType2, InferenceComponentsKt.getInferenceComponents(context2.getSession()).getCtx())) {
            return;
        }
        ConeKotlinType typeArgument = ((ConeKotlinTypeProjection)returnType2.getTypeArguments()[0]).getType();
        FirTypeParameterSymbol firTypeParameterSymbol = this.getTypeParameterFromError(typeArgument);
        if (firTypeParameterSymbol != null) {
            FirTypeParameterSymbol firTypeParameterSymbol2;
            FirTypeParameterSymbol it = firTypeParameterSymbol2 = firTypeParameterSymbol;
            boolean bl = false;
            DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getKCLASS_WITH_NULLABLE_TYPE_PARAMETER_IN_SIGNATURE(), (Object)it, context2, null, 16, null);
        }
    }

    private final boolean isKClassTypeWithErrorOrNullableArgument(ConeKotlinType $this$isKClassTypeWithErrorOrNullableArgument, ConeInferenceContext context2) {
        Object object;
        ConeKotlinType coneKotlinType;
        if (!InferenceUtilsKt.isKClassType($this$isKClassTypeWithErrorOrNullableArgument)) {
            return false;
        }
        ConeTypeProjection coneTypeProjection = (ConeTypeProjection)CollectionsKt.singleOrNull((List)ArraysKt.toList((Object[])$this$isKClassTypeWithErrorOrNullableArgument.getTypeArguments()));
        if (coneTypeProjection == null) {
            coneKotlinType = null;
        } else {
            object = coneTypeProjection;
            ConeTypeProjection it = object;
            boolean bl = false;
            ConeTypeProjection coneTypeProjection2 = it;
            if (coneTypeProjection2 instanceof ConeStarProjection) {
                coneKotlinType = null;
            } else if (coneTypeProjection2 instanceof ConeKotlinTypeProjection) {
                coneKotlinType = ((ConeKotlinTypeProjection)it).getType();
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        ConeKotlinType coneKotlinType2 = coneKotlinType;
        if (coneKotlinType2 == null) {
            return false;
        }
        ConeKotlinType argumentType = coneKotlinType2;
        ConeInferenceContext $this$isKClassTypeWithErrorOrNullableArgument_u24lambda_u2d3 = context2;
        boolean bl = false;
        object = INSTANCE.getTypeParameterFromError(argumentType);
        if (object != null) {
            Object object2;
            Object typeParameterSymbol = object2 = object;
            boolean bl2 = false;
            return $this$isKClassTypeWithErrorOrNullableArgument_u24lambda_u2d3.isNullableType(FirNestedClassifierScopeKt.toConeType((FirTypeParameterSymbol)typeParameterSymbol));
        }
        return argumentType instanceof ConeClassErrorType || $this$isKClassTypeWithErrorOrNullableArgument_u24lambda_u2d3.isNullableType(argumentType);
    }

    private final FirTypeParameterSymbol getTypeParameterFromError(ConeKotlinType $this$typeParameterFromError) {
        ConeClassErrorType coneClassErrorType = $this$typeParameterFromError instanceof ConeClassErrorType ? (ConeClassErrorType)$this$typeParameterFromError : null;
        ConeDiagnostic coneDiagnostic = coneClassErrorType == null ? null : coneClassErrorType.getDiagnostic();
        ConeTypeParameterInQualifiedAccess coneTypeParameterInQualifiedAccess = coneDiagnostic instanceof ConeTypeParameterInQualifiedAccess ? (ConeTypeParameterInQualifiedAccess)coneDiagnostic : null;
        return coneTypeParameterInQualifiedAccess == null ? null : coneTypeParameterInQualifiedAccess.getSymbol();
    }
}

