/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.ConeTypeCompatibilityChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponentsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J0\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J0\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirEqualityCompatibilityChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirEqualityOperatorCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkCompatibility", "lType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "rType", "checkSensibleness", "isEnumType", "", "checkers"})
public final class FirEqualityCompatibilityChecker
extends FirExpressionChecker<FirEqualityOperatorCall> {
    @NotNull
    public static final FirEqualityCompatibilityChecker INSTANCE = new FirEqualityCompatibilityChecker();

    private FirEqualityCompatibilityChecker() {
    }

    @Override
    public void check(@NotNull FirEqualityOperatorCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        List<FirExpression> arguments2 = expression2.getArgumentList().getArguments();
        if (arguments2.size() != 2) {
            return;
        }
        ConeKotlinType lType = FirTypeUtilsKt.getConeType(arguments2.get(0).getTypeRef());
        ConeKotlinType rType = FirTypeUtilsKt.getConeType(arguments2.get(1).getTypeRef());
        this.checkCompatibility(lType, rType, context2, expression2, reporter2);
        this.checkSensibleness(lType, rType, context2, expression2, reporter2);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCompatibility(ConeKotlinType lType, ConeKotlinType rType, CheckerContext context2, FirEqualityOperatorCall expression2, DiagnosticReporter reporter2) {
        Object object;
        if (ConeTypeUtilsKt.isNullableNothing(lType) || ConeTypeUtilsKt.isNullableNothing(rType)) {
            return;
        }
        ConeInferenceContext inferenceContext = InferenceComponentsKt.getInferenceComponents(context2.getSession()).getCtx();
        try {
            object = ConeTypeCompatibilityChecker.INSTANCE.isCompatible(inferenceContext, lType, rType);
        }
        catch (Throwable e) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            Iterable iterable = context2.getContainingDeclarations();
            StringBuilder stringBuilder2 = new StringBuilder().append("Exception while determining type compatibility: lType: ").append(lType).append(", rType: ").append(rType).append(", equality ").append(FirRendererKt.render$default(expression2, null, 1, null)).append(", file ");
            boolean $i$f$filterIsInstance = false;
            void var13_13 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirFile)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            FirFile firFile = (FirFile)CollectionsKt.firstOrNull((List)list2);
            String string2 = firFile == null ? null : firFile.getName();
            Throwable throwable = e;
            String string3 = stringBuilder2.append((Object)string2).toString();
            throw new IllegalStateException(string3, throwable);
        }
        ConeTypeCompatibilityChecker.Compatibility compatibility = object;
        if (compatibility != ConeTypeCompatibilityChecker.Compatibility.COMPATIBLE) {
            FirSourceElement firSourceElement = expression2.getSource();
            Object object2 = object = firSourceElement == null ? null : firSourceElement.getKind();
            if (Intrinsics.areEqual((Object)object, (Object)FirRealSourceElementKind.INSTANCE)) {
                if (compatibility == ConeTypeCompatibilityChecker.Compatibility.HARD_INCOMPATIBLE && (this.isEnumType(lType, context2) || this.isEnumType(rType, context2))) {
                    DiagnosticReporterKt.reportOn$default(reporter2, expression2.getSource(), FirErrors.INSTANCE.getINCOMPATIBLE_ENUM_COMPARISON_ERROR(), (Object)lType, (Object)rType, context2, null, 32, null);
                } else {
                    DiagnosticReporterKt.reportOn$default(reporter2, expression2.getSource(), compatibility == ConeTypeCompatibilityChecker.Compatibility.HARD_INCOMPATIBLE ? FirErrors.INSTANCE.getEQUALITY_NOT_APPLICABLE() : FirErrors.INSTANCE.getEQUALITY_NOT_APPLICABLE_WARNING(), (Object)expression2.getOperation().getOperator(), (Object)lType, (Object)rType, context2, null, 64, null);
                }
            } else {
                DiagnosticReporterKt.reportOn$default(reporter2, expression2.getSource(), compatibility == ConeTypeCompatibilityChecker.Compatibility.HARD_INCOMPATIBLE ? FirErrors.INSTANCE.getINCOMPATIBLE_TYPES() : FirErrors.INSTANCE.getINCOMPATIBLE_TYPES_WARNING(), (Object)lType, (Object)rType, context2, null, 32, null);
            }
        }
    }

    private final boolean isEnumType(ConeKotlinType $this$isEnumType, CheckerContext context2) {
        FirRegularClass firRegularClass;
        FirRegularClass firRegularClass2;
        ConeClassLikeType coneClassLikeType;
        if (ConeTypeUtilsKt.isEnum($this$isEnumType)) {
            return true;
        }
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType = $this$isEnumType instanceof ConeClassLikeType ? (ConeClassLikeType)$this$isEnumType : null;
        if (coneClassLikeType == null) {
            firRegularClass2 = null;
        } else {
            ConeClassLikeLookupTag coneClassLikeLookupTag = coneClassLikeType.getLookupTag();
            firRegularClass2 = firRegularClass = LookupTagUtilsKt.toFirRegularClass(coneClassLikeLookupTag, context2.getSession());
        }
        if (firRegularClass == null) {
            return false;
        }
        FirRegularClass firRegularClass3 = firRegularClass;
        FirClass $this$isEnumClass$iv = firRegularClass3;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        return $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
    }

    private final void checkSensibleness(ConeKotlinType lType, ConeKotlinType rType, CheckerContext context2, FirEqualityOperatorCall expression2, DiagnosticReporter reporter2) {
        boolean bl;
        ConeKotlinType coneKotlinType;
        if (ConeTypeUtilsKt.isNullableNothing(rType)) {
            coneKotlinType = lType;
        } else if (ConeTypeUtilsKt.isNullableNothing(lType)) {
            coneKotlinType = rType;
        } else {
            return;
        }
        ConeKotlinType type2 = coneKotlinType;
        if (type2 instanceof ConeClassErrorType) {
            return;
        }
        boolean isPositiveCompare = expression2.getOperation() == FirOperation.EQ || expression2.getOperation() == FirOperation.IDENTITY;
        Object object = SessionUtilsKt.getTypeContext(context2.getSession());
        ConeInferenceContext $this$checkSensibleness_u24lambda_u2d0 = object;
        boolean bl2 = false;
        if (ConeTypeUtilsKt.isNullableNothing(type2)) {
            bl = isPositiveCompare;
        } else if (!$this$checkSensibleness_u24lambda_u2d0.isNullableType(type2)) {
            bl = !isPositiveCompare;
        } else {
            return;
        }
        boolean compareResult = bl;
        object = expression2.getSource();
        if (!Intrinsics.areEqual((Object)(object == null ? null : ((FirSourceElement)object).getElementType()), (Object)KtNodeTypes.BINARY_EXPRESSION) && type2 == lType) {
            DiagnosticReporterKt.reportOn$default(reporter2, expression2.getSource(), FirErrors.INSTANCE.getSENSELESS_NULL_IN_WHEN(), context2, null, 8, null);
        } else {
            DiagnosticReporterKt.reportOn$default(reporter2, expression2.getSource(), FirErrors.INSTANCE.getSENSELESS_COMPARISON(), (Object)expression2, (Object)compareResult, context2, null, 32, null);
        }
    }
}

