/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirOptInUsageTypeRefChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeRefChecker;", "()V", "check", "", "typeRef", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirOptInUsageTypeRefChecker
extends FirTypeChecker<FirTypeRef> {
    @NotNull
    public static final FirOptInUsageTypeRefChecker INSTANCE = new FirOptInUsageTypeRefChecker();

    private FirOptInUsageTypeRefChecker() {
    }

    @Override
    public void check(@NotNull FirTypeRef typeRef, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        FirAnnotationCall lastAnnotationCall;
        ConeClassLikeType coneClassLikeType;
        FirSourceElement source;
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirSourceElement firSourceElement = source = typeRef.getSource();
        if (!((firSourceElement == null ? null : firSourceElement.getKind()) instanceof FirRealSourceElementKind)) {
            return;
        }
        FirClassLikeSymbol<?> $this$coneTypeSafe$iv = typeRef;
        boolean $i$f$coneTypeSafe = false;
        Object object = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)((Object)$this$coneTypeSafe$iv) : null;
        ConeKotlinType coneKotlinType = object == null ? null : ((FirResolvedTypeRef)object).getType();
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        if ((coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null) {
            return;
        }
        ConeClassLikeType coneType = coneClassLikeType;
        $this$coneTypeSafe$iv = LookupTagUtilsKt.toSymbol(coneType.getLookupTag(), context2.getSession());
        if ($this$coneTypeSafe$iv == null) {
            return;
        }
        FirClassLikeSymbol<?> symbol2 = $this$coneTypeSafe$iv;
        FirPhaseManagerKt.ensureResolved((FirBasedSymbol)symbol2, FirResolvePhase.STATUS);
        ClassId classId = symbol2.getClassId();
        object = CollectionsKt.lastOrNull(context2.getQualifiedAccessOrAnnotationCalls());
        FirAnnotationCall firAnnotationCall = lastAnnotationCall = object instanceof FirAnnotationCall ? (FirAnnotationCall)object : null;
        if (lastAnnotationCall == null || lastAnnotationCall.getAnnotationTypeRef() != typeRef) {
            if (Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID()) || Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getOPT_IN_CLASS_ID())) {
                DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getEXPERIMENTAL_CAN_ONLY_BE_USED_AS_ANNOTATION(), context2, null, 8, null);
            } else if (symbol2 instanceof FirRegularClassSymbol && FirAnnotationHelpersKt.getAnnotationByClassId((FirAnnotationContainer)((FirRegularClassSymbol)symbol2).getFir(), OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID()) != null) {
                DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getEXPERIMENTAL_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_USE_EXPERIMENTAL(), context2, null, 8, null);
            }
        }
        Object $this$check_u24lambda_u2d0 = object = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        Set experimentalities = SetsKt.plus(((FirOptInUsageBaseChecker)$this$check_u24lambda_u2d0).loadExperimentalities((FirBasedSymbol)symbol2, context2, false), (Iterable)((FirOptInUsageBaseChecker)$this$check_u24lambda_u2d0).loadExperimentalitiesFromConeArguments(context2, ArraysKt.toList((Object[])coneType.getTypeArguments())));
        ((FirOptInUsageBaseChecker)$this$check_u24lambda_u2d0).reportNotAcceptedExperimentalities(experimentalities, typeRef, context2, reporter2);
    }
}

