/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0001\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\n\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0002\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000ej\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001a\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "", "typeName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "arrayTypeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getArrayTypeFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "arrayTypeFqName$delegate", "Lkotlin/Lazy;", "arrayTypeName", "Lorg/jetbrains/kotlin/name/Name;", "getArrayTypeName", "()Lorg/jetbrains/kotlin/name/Name;", "typeFqName", "getTypeFqName", "typeFqName$delegate", "getTypeName", "BOOLEAN", "CHAR", "BYTE", "SHORT", "INT", "FLOAT", "LONG", "DOUBLE", "Companion", "compiler.common"})
public final class PrimitiveType
extends Enum<PrimitiveType> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Name typeName;
    @NotNull
    private final Name arrayTypeName;
    @NotNull
    private final Lazy typeFqName$delegate;
    @NotNull
    private final Lazy arrayTypeFqName$delegate;
    @JvmField
    @NotNull
    public static final Set<PrimitiveType> NUMBER_TYPES;
    public static final /* enum */ PrimitiveType BOOLEAN;
    public static final /* enum */ PrimitiveType CHAR;
    public static final /* enum */ PrimitiveType BYTE;
    public static final /* enum */ PrimitiveType SHORT;
    public static final /* enum */ PrimitiveType INT;
    public static final /* enum */ PrimitiveType FLOAT;
    public static final /* enum */ PrimitiveType LONG;
    public static final /* enum */ PrimitiveType DOUBLE;
    private static final /* synthetic */ PrimitiveType[] $VALUES;

    private PrimitiveType(String typeName) {
        Name name2 = Name.identifier(typeName);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(typeName)");
        this.typeName = name2;
        name2 = Name.identifier(Intrinsics.stringPlus((String)typeName, (Object)"Array"));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"${typeName}Array\")");
        this.arrayTypeName = name2;
        this.typeFqName$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<FqName>(this){
            final /* synthetic */ PrimitiveType this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FqName invoke() {
                FqName fqName2 = StandardNames.BUILT_INS_PACKAGE_FQ_NAME.child(this.this$0.getTypeName());
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"BUILT_INS_PACKAGE_FQ_NAME.child(this.typeName)");
                return fqName2;
            }
        }));
        this.arrayTypeFqName$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<FqName>(this){
            final /* synthetic */ PrimitiveType this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FqName invoke() {
                FqName fqName2 = StandardNames.BUILT_INS_PACKAGE_FQ_NAME.child(this.this$0.getArrayTypeName());
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"BUILT_INS_PACKAGE_FQ_NAME.child(arrayTypeName)");
                return fqName2;
            }
        }));
    }

    @NotNull
    public final Name getTypeName() {
        return this.typeName;
    }

    @NotNull
    public final Name getArrayTypeName() {
        return this.arrayTypeName;
    }

    @NotNull
    public final FqName getTypeFqName() {
        Lazy lazy = this.typeFqName$delegate;
        Object var2_2 = null;
        return (FqName)lazy.getValue();
    }

    @NotNull
    public final FqName getArrayTypeFqName() {
        Lazy lazy = this.arrayTypeFqName$delegate;
        Object var2_2 = null;
        return (FqName)lazy.getValue();
    }

    public static PrimitiveType[] values() {
        return (PrimitiveType[])$VALUES.clone();
    }

    public static PrimitiveType valueOf(String value2) {
        return Enum.valueOf(PrimitiveType.class, value2);
    }

    @JvmStatic
    @Nullable
    public static final PrimitiveType getByShortName(@NotNull String name2) {
        return Companion.getByShortName(name2);
    }

    @JvmStatic
    @Nullable
    public static final PrimitiveType getByShortArrayName(@NotNull String name2) {
        return Companion.getByShortArrayName(name2);
    }

    static {
        BOOLEAN = new PrimitiveType("Boolean");
        CHAR = new PrimitiveType("Char");
        BYTE = new PrimitiveType("Byte");
        SHORT = new PrimitiveType("Short");
        INT = new PrimitiveType("Int");
        FLOAT = new PrimitiveType("Float");
        LONG = new PrimitiveType("Long");
        DOUBLE = new PrimitiveType("Double");
        $VALUES = primitiveTypeArray = new PrimitiveType[]{PrimitiveType.BOOLEAN, PrimitiveType.CHAR, PrimitiveType.BYTE, PrimitiveType.SHORT, PrimitiveType.INT, PrimitiveType.FLOAT, PrimitiveType.LONG, PrimitiveType.DOUBLE};
        Companion = new Companion(null);
        PrimitiveType[] primitiveTypeArray = new PrimitiveType[]{CHAR, BYTE, SHORT, INT, FLOAT, LONG, DOUBLE};
        NUMBER_TYPES = SetsKt.setOf((Object[])primitiveTypeArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/builtins/PrimitiveType$Companion;", "", "()V", "NUMBER_TYPES", "", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "getByShortArrayName", "name", "", "getByShortName", "compiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final PrimitiveType getByShortName(@NotNull String name2) {
            PrimitiveType primitiveType;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            switch (name2) {
                case "Boolean": {
                    primitiveType = BOOLEAN;
                    break;
                }
                case "Char": {
                    primitiveType = CHAR;
                    break;
                }
                case "Byte": {
                    primitiveType = BYTE;
                    break;
                }
                case "Short": {
                    primitiveType = SHORT;
                    break;
                }
                case "Int": {
                    primitiveType = INT;
                    break;
                }
                case "Float": {
                    primitiveType = FLOAT;
                    break;
                }
                case "Long": {
                    primitiveType = LONG;
                    break;
                }
                case "Double": {
                    primitiveType = DOUBLE;
                    break;
                }
                default: {
                    primitiveType = null;
                }
            }
            return primitiveType;
        }

        @JvmStatic
        @Nullable
        public final PrimitiveType getByShortArrayName(@NotNull String name2) {
            PrimitiveType primitiveType;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            switch (name2) {
                case "BooleanArray": {
                    primitiveType = BOOLEAN;
                    break;
                }
                case "CharArray": {
                    primitiveType = CHAR;
                    break;
                }
                case "ByteArray": {
                    primitiveType = BYTE;
                    break;
                }
                case "ShortArray": {
                    primitiveType = SHORT;
                    break;
                }
                case "IntArray": {
                    primitiveType = INT;
                    break;
                }
                case "FloatArray": {
                    primitiveType = FLOAT;
                    break;
                }
                case "LongArray": {
                    primitiveType = LONG;
                    break;
                }
                case "DoubleArray": {
                    primitiveType = DOUBLE;
                    break;
                }
                default: {
                    primitiveType = null;
                }
            }
            return primitiveType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

