/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.temporaryVals;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.temporaryVals.TemporaryVal;
import org.jetbrains.kotlin.codegen.optimization.temporaryVals.TemporaryValsAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0018\u0010\u0019\u001a\u00020\u0016*\u00020\u00172\n\u0010\u001a\u001a\u00020\u001b\"\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/TemporaryVariablesEliminationTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "temporaryValsAnalyzer", "Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/TemporaryValsAnalyzer;", "optimizeTemporaryVals", "", "cfg", "Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/TemporaryVariablesEliminationTransformer$ControlFlowGraph;", "temporaryVals", "", "Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/TemporaryVal;", "processLabels", "simplifyKnownSafeCallPatterns", "transform", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "isIntervening", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "context", "matchOpcodes", "opcodes", "", "", "ControlFlowGraph", "backend"})
public final class TemporaryVariablesEliminationTransformer
extends MethodTransformer {
    @NotNull
    private final GenerationState state;
    @NotNull
    private final TemporaryValsAnalyzer temporaryValsAnalyzer;

    public TemporaryVariablesEliminationTransformer(@NotNull GenerationState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
        this.temporaryValsAnalyzer = new TemporaryValsAnalyzer();
    }

    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        if (!this.state.isIrBackend()) {
            return;
        }
        ControlFlowGraph cfg = new ControlFlowGraph(methodNode);
        this.processLabels(cfg);
        this.simplifyKnownSafeCallPatterns(cfg);
        List<TemporaryVal> temporaryVals = this.temporaryValsAnalyzer.analyze(internalClassName, methodNode);
        if (!((Collection)temporaryVals).isEmpty()) {
            this.optimizeTemporaryVals(cfg, temporaryVals);
        }
        UtilKt.removeUnusedLocalVariables(methodNode);
    }

    private final void processLabels(ControlFlowGraph cfg) {
        AbstractInsnNode last;
        cfg.reset();
        MethodNode methodNode = cfg.getMethodNode();
        InsnList insnList = methodNode.instructions;
        HashSet<LabelNode> usedLabels = new HashSet<LabelNode>();
        AbstractInsnNode first = insnList.getFirst();
        if (first instanceof LabelNode) {
            usedLabels.add((LabelNode)first);
        }
        if ((last = insnList.getLast()) instanceof LabelNode) {
            usedLabels.add((LabelNode)last);
        }
        for (AbstractInsnNode insn : insnList) {
            int n = insn.getType();
            switch (n) {
                case 15: {
                    if (insn == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LineNumberNode");
                    }
                    usedLabels.add(((LineNumberNode)insn).start);
                    break;
                }
                case 7: {
                    Intrinsics.checkNotNullExpressionValue((Object)insn, (String)"insn");
                    LabelNode labelNode = ((JumpInsnNode)insn).label;
                    Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"insn as JumpInsnNode).label");
                    TemporaryVariablesEliminationTransformer.processLabels$addCfgEdgeToLabel(usedLabels, cfg, insn, labelNode);
                    break;
                }
                case 12: {
                    if (insn == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode");
                    }
                    LookupSwitchInsnNode switchInsn = (LookupSwitchInsnNode)insn;
                    Object object = switchInsn.dflt;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"switchInsn.dflt");
                    TemporaryVariablesEliminationTransformer.processLabels$addCfgEdgeToLabel(usedLabels, cfg, insn, object);
                    object = switchInsn.labels;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"switchInsn.labels");
                    TemporaryVariablesEliminationTransformer.processLabels$addCfgEdgesToLabels(usedLabels, cfg, insn, (Collection)object);
                    break;
                }
                case 11: {
                    if (insn == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode");
                    }
                    LookupSwitchInsnNode switchInsn = (TableSwitchInsnNode)insn;
                    Object object = switchInsn.dflt;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"switchInsn.dflt");
                    TemporaryVariablesEliminationTransformer.processLabels$addCfgEdgeToLabel(usedLabels, cfg, insn, object);
                    object = switchInsn.labels;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"switchInsn.labels");
                    TemporaryVariablesEliminationTransformer.processLabels$addCfgEdgesToLabels(usedLabels, cfg, insn, (Collection)object);
                }
            }
        }
        for (LocalVariableNode lv : methodNode.localVariables) {
            usedLabels.add(lv.start);
            usedLabels.add(lv.end);
        }
        for (TryCatchBlockNode tcb : methodNode.tryCatchBlocks) {
            usedLabels.add(tcb.start);
            usedLabels.add(tcb.end);
            LabelNode labelNode = tcb.start;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"tcb.start");
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)labelNode;
            labelNode = tcb.handler;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"tcb.handler");
            TemporaryVariablesEliminationTransformer.processLabels$addCfgEdgeToLabel(usedLabels, cfg, abstractInsnNode, labelNode);
        }
        AbstractInsnNode insn = insnList.getFirst();
        while (insn != null) {
            AbstractInsnNode abstractInsnNode;
            if (insn instanceof LabelNode && !usedLabels.contains(insn)) {
                AbstractInsnNode next = ((LabelNode)insn).getNext();
                insnList.remove(insn);
                abstractInsnNode = next;
            } else {
                abstractInsnNode = insn.getNext();
            }
            insn = abstractInsnNode;
        }
    }

    private final void optimizeTemporaryVals(ControlFlowGraph cfg, List<TemporaryVal> temporaryVals) {
        InsnList insnList = cfg.getMethodNode().instructions;
        for (TemporaryVal tmp : temporaryVals) {
            Iterator iterator2;
            Object aLoad1;
            Object $this$none$iv;
            VarInsnNode loadInsn;
            VarInsnNode storeInsn;
            block17: {
                block16: {
                    boolean bl;
                    block15: {
                        if (tmp.getLoadInsns().isEmpty()) {
                            int n;
                            int n2 = tmp.getStoreInsn().getOpcode();
                            switch (n2) {
                                case 54: 
                                case 56: 
                                case 58: {
                                    n = 87;
                                    break;
                                }
                                default: {
                                    n = 88;
                                }
                            }
                            int popOpcode = n;
                            insnList.insertBefore((AbstractInsnNode)tmp.getStoreInsn(), (AbstractInsnNode)new InsnNode(popOpcode));
                            insnList.remove((AbstractInsnNode)tmp.getStoreInsn());
                            continue;
                        }
                        if (tmp.getLoadInsns().size() != 1) continue;
                        storeInsn = tmp.getStoreInsn();
                        loadInsn = tmp.getLoadInsns().get(0);
                        if (Intrinsics.areEqual((Object)storeInsn.getNext(), (Object)loadInsn)) break block16;
                        AbstractInsnNode abstractInsnNode = storeInsn.getNext();
                        Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"storeInsn.next");
                        $this$none$iv = new InsnSequence(abstractInsnNode, (AbstractInsnNode)loadInsn);
                        boolean $i$f$none = false;
                        for (Object element$iv : $this$none$iv) {
                            AbstractInsnNode it = (AbstractInsnNode)element$iv;
                            boolean bl2 = false;
                            if (!this.isIntervening(it, cfg)) continue;
                            bl = false;
                            break block15;
                        }
                        bl = true;
                    }
                    if (!bl) break block17;
                }
                insnList.remove((AbstractInsnNode)storeInsn);
                insnList.remove((AbstractInsnNode)loadInsn);
                continue;
            }
            $this$none$iv = new int[3];
            $this$none$iv[0] = (Sequence)58;
            $this$none$iv[1] = (Sequence)25;
            $this$none$iv[2] = (Sequence)25;
            if (this.matchOpcodes((AbstractInsnNode)storeInsn, (int[])$this$none$iv)) {
                AbstractInsnNode $i$f$none = storeInsn.getNext();
                if ($i$f$none == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                }
                aLoad1 = (VarInsnNode)$i$f$none;
                iterator2 = aLoad1.getNext();
                if (iterator2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                }
                VarInsnNode aLoad2 = (VarInsnNode)iterator2;
                if (Intrinsics.areEqual((Object)aLoad2, (Object)loadInsn)) {
                    insnList.remove((AbstractInsnNode)storeInsn);
                    insnList.remove((AbstractInsnNode)loadInsn);
                    insnList.insert((AbstractInsnNode)aLoad1, (AbstractInsnNode)new InsnNode(95));
                    continue;
                }
            }
            if (!this.matchOpcodes((AbstractInsnNode)storeInsn, (int)(aLoad1 = new int[]{58, 178, 25}))) continue;
            AbstractInsnNode aLoad2 = storeInsn.getNext();
            if (aLoad2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.FieldInsnNode");
            }
            FieldInsnNode getStaticInsn = (FieldInsnNode)aLoad2;
            iterator2 = getStaticInsn.getNext();
            if (iterator2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
            }
            aLoad2 = (VarInsnNode)iterator2;
            if (!Intrinsics.areEqual((Object)aLoad2, (Object)loadInsn) || Type.getType((String)getStaticInsn.desc).getSize() != 1) continue;
            insnList.remove((AbstractInsnNode)storeInsn);
            insnList.remove((AbstractInsnNode)loadInsn);
            insnList.insert((AbstractInsnNode)getStaticInsn, (AbstractInsnNode)new InsnNode(95));
        }
    }

    private final void simplifyKnownSafeCallPatterns(ControlFlowGraph cfg) {
        InsnList insnList = cfg.getMethodNode().instructions;
        int maxStackIncrement = 0;
        MethodNode methodNode = insnList.toArray();
        Intrinsics.checkNotNullExpressionValue((Object)methodNode, (String)"insnList.toArray()");
        for (AbstractInsnNode insn : methodNode) {
            Object aLoad2;
            AbstractInsnNode abstractInsnNode;
            Intrinsics.checkNotNullExpressionValue((Object)insn, (String)"insn");
            int[] nArray = new int[]{25, 199};
            if (!this.matchOpcodes(insn, nArray)) continue;
            VarInsnNode aLoad1 = (VarInsnNode)insn;
            AbstractInsnNode abstractInsnNode2 = ((VarInsnNode)insn).getNext();
            if (abstractInsnNode2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
            }
            JumpInsnNode ifNonNull = (JumpInsnNode)abstractInsnNode2;
            LabelNode label1 = ifNonNull.label;
            LabelNode labelNode = ifNonNull.label;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"ifNonNull.label");
            if (!cfg.hasSinglePredecessor(labelNode, (AbstractInsnNode)ifNonNull) || (abstractInsnNode = label1.getNext()) == null) continue;
            AbstractInsnNode label1Next = abstractInsnNode;
            if (label1Next.getOpcode() == 25) {
                aLoad2 = (VarInsnNode)label1Next;
                if (aLoad2.var != aLoad1.var) continue;
                insnList.insertBefore((AbstractInsnNode)ifNonNull, (AbstractInsnNode)new InsnNode(89));
                insnList.insert((AbstractInsnNode)ifNonNull, (AbstractInsnNode)new InsnNode(87));
                insnList.remove((AbstractInsnNode)aLoad2);
                int n = 1;
                maxStackIncrement = Math.max(maxStackIncrement, n);
                continue;
            }
            aLoad2 = new int[2];
            aLoad2[0] = (VarInsnNode)178;
            aLoad2[1] = (VarInsnNode)25;
            if (!this.matchOpcodes(label1Next, (int[])aLoad2)) continue;
            FieldInsnNode getStaticInsn = (FieldInsnNode)label1Next;
            AbstractInsnNode abstractInsnNode3 = getStaticInsn.getNext();
            if (abstractInsnNode3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
            }
            VarInsnNode aLoad3 = (VarInsnNode)abstractInsnNode3;
            if (Type.getType((String)getStaticInsn.desc).getSize() != 1 || aLoad3.var != aLoad1.var) continue;
            insnList.insertBefore((AbstractInsnNode)ifNonNull, (AbstractInsnNode)new InsnNode(89));
            insnList.insert((AbstractInsnNode)ifNonNull, (AbstractInsnNode)new InsnNode(87));
            insnList.insert((AbstractInsnNode)getStaticInsn, (AbstractInsnNode)new InsnNode(95));
            insnList.remove((AbstractInsnNode)aLoad3);
            int n = 1;
            maxStackIncrement = Math.max(maxStackIncrement, n);
        }
        MethodNode methodNode2 = cfg.getMethodNode();
        methodNode2.maxStack += maxStackIncrement;
    }

    private final boolean matchOpcodes(AbstractInsnNode $this$matchOpcodes, int ... opcodes) {
        AbstractInsnNode insn = $this$matchOpcodes;
        int n = 0;
        int n2 = opcodes.length;
        while (n < n2) {
            int i = n++;
            if (insn.getOpcode() != opcodes[i]) {
                return false;
            }
            AbstractInsnNode abstractInsnNode = insn.getNext();
            if (abstractInsnNode == null) {
                return false;
            }
            insn = abstractInsnNode;
        }
        return true;
    }

    private final boolean isIntervening(AbstractInsnNode $this$isIntervening, ControlFlowGraph context2) {
        boolean bl;
        int n = $this$isIntervening.getType();
        switch (n) {
            case 14: 
            case 15: {
                bl = false;
                break;
            }
            case 8: {
                bl = context2.hasNonTrivialPredecessors((LabelNode)$this$isIntervening);
                break;
            }
            case 0: {
                if ($this$isIntervening.getOpcode() != 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    private static final void processLabels$addCfgEdgeToLabel(HashSet<LabelNode> usedLabels, ControlFlowGraph $cfg, AbstractInsnNode from2, LabelNode label) {
        usedLabels.add(label);
        $cfg.addNonTrivialPredecessor(label, from2);
    }

    private static final void processLabels$addCfgEdgesToLabels(HashSet<LabelNode> usedLabels, ControlFlowGraph $cfg, AbstractInsnNode from2, Collection<? extends LabelNode> labels2) {
        usedLabels.addAll(labels2);
        for (LabelNode labelNode : labels2) {
            $cfg.addNonTrivialPredecessor(labelNode, from2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\tJ\u0016\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000bJ\u0006\u0010\u0015\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R6\u0010\u0007\u001a*\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bj\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/TemporaryVariablesEliminationTransformer$ControlFlowGraph;", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "nonTrivialPredecessors", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lkotlin/collections/HashMap;", "addNonTrivialPredecessor", "", "label", "pred", "hasNonTrivialPredecessors", "", "hasSinglePredecessor", "expectedPredecessor", "reset", "backend"})
    private static final class ControlFlowGraph {
        @NotNull
        private final MethodNode methodNode;
        @NotNull
        private final HashMap<LabelNode, List<AbstractInsnNode>> nonTrivialPredecessors;

        public ControlFlowGraph(@NotNull MethodNode methodNode) {
            Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
            this.methodNode = methodNode;
            this.nonTrivialPredecessors = new HashMap();
        }

        @NotNull
        public final MethodNode getMethodNode() {
            return this.methodNode;
        }

        public final void reset() {
            this.nonTrivialPredecessors.clear();
        }

        public final void addNonTrivialPredecessor(@NotNull LabelNode label, @NotNull AbstractInsnNode pred) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)pred, (String)"pred");
            Map $this$getOrPut$iv = this.nonTrivialPredecessors;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(label);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new SmartList();
                $this$getOrPut$iv.put(label, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(pred);
        }

        public final boolean hasNonTrivialPredecessors(@NotNull LabelNode label) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            return this.nonTrivialPredecessors.containsKey(label);
        }

        /*
         * Unable to fully structure code
         */
        public final boolean hasSinglePredecessor(@NotNull LabelNode label, @NotNull AbstractInsnNode expectedPredecessor) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)expectedPredecessor, (String)"expectedPredecessor");
            trivialPredecessor = label.getPrevious();
            if (trivialPredecessor.getOpcode() == 167) ** GOTO lbl-1000
            var4_4 = trivialPredecessor.getOpcode();
            v0 = 172 <= var4_4 ? var4_4 < 178 : false;
            if (v0 || trivialPredecessor.getOpcode() == 191) lbl-1000:
            // 2 sources

            {
                trivialPredecessor = null;
            } else if (!Intrinsics.areEqual((Object)trivialPredecessor, (Object)expectedPredecessor)) {
                return false;
            }
            var6_6 = this.nonTrivialPredecessors.get(label);
            if (var6_6 == null) {
                return trivialPredecessor != null;
            }
            nonTrivialPredecessors = var5_7 = var6_6;
            return nonTrivialPredecessors.size() > 1 ? false : (nonTrivialPredecessors.size() == 0 ? Intrinsics.areEqual((Object)trivialPredecessor, (Object)expectedPredecessor) : trivialPredecessor == null && Intrinsics.areEqual((Object)nonTrivialPredecessors.get(0), (Object)expectedPredecessor) != false);
        }
    }
}

