/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory2;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.resolve.Compatibility;
import org.jetbrains.kotlin.resolve.ModifierCheckerHelpersKt;
import org.jetbrains.kotlin.resolve.TargetAllowedPredicate;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016JL\u0010\f\u001a\u00020\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J6\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J@\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\b\u0010!\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\"\u001a\u00020#*\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirModifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkCompatibilityType", "firstModifier", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;", "secondModifier", "reportedNodes", "", "owner", "checkModifiers", "list", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;", "checkParent", "", "modifierSource", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "modifierToken", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "actualParents", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "checkTarget", "actualTargets", "parent", "firstOrThis", "", "checkers"})
public final class FirModifierChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirModifierChecker INSTANCE = new FirModifierChecker();

    private FirModifierChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        if (declaration instanceof FirFile) {
            return;
        }
        Object object = declaration.getSource();
        if (object == null) {
            return;
        }
        Object source = object;
        if (((FirSourceElement)source).getKind() instanceof FirFakeSourceElementKind) {
            return;
        }
        if (declaration instanceof FirProperty) {
            FirModifierChecker.check$checkPropertyAccessor(context2, reporter2, ((FirProperty)declaration).getGetter());
            FirModifierChecker.check$checkPropertyAccessor(context2, reporter2, ((FirProperty)declaration).getSetter());
        }
        if ((object = FirKeywordUtilsKt.getModifierList((FirSourceElement)source)) != null) {
            Object object2;
            Object it = object2 = object;
            boolean bl = false;
            INSTANCE.checkModifiers((FirModifierList)it, declaration, context2, reporter2);
        }
    }

    private final void checkModifiers(FirModifierList list2, FirDeclaration owner, CheckerContext context2, DiagnosticReporter reporter2) {
        List<KotlinTarget> list3;
        FirDeclaration parent2;
        FirElement firElement;
        Object object;
        Object object2;
        List<KotlinTarget> actualTargets;
        HashSet reportedNodes;
        block16: {
            if (list2.getModifiers().isEmpty()) {
                return;
            }
            reportedNodes = new HashSet();
            actualTargets = FirHelpersKt.getActualTargetList(owner).getDefaultTargets();
            CheckerContext $this$findClosest$iv = context2;
            boolean $i$f$findClosest = false;
            object2 = CollectionsKt.asReversed($this$findClosest$iv.getContainingDeclarations()).iterator();
            while (object2.hasNext()) {
                FirElement firElement2;
                FirElement firElement3;
                FirElement firElement4;
                FirDeclaration it$iv = (FirDeclaration)object2.next();
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirDeclaration)) {
                    firDeclaration = null;
                }
                if ((firElement4 = (FirElement)firDeclaration) == null) {
                    firElement3 = null;
                } else {
                    FirElement firElement5 = firElement4;
                    FirDeclaration it = (FirDeclaration)firElement5;
                    boolean bl = false;
                    firElement3 = firElement2 = !(it instanceof FirPrimaryConstructor || it instanceof FirProperty || ((object = it.getSource()) == null ? null : ((FirSourceElement)object).getKind()) instanceof FirFakeSourceElementKind) ? firElement5 : null;
                }
                if (firElement2 == null) continue;
                firElement = firElement2;
                break block16;
            }
            firElement = null;
        }
        FirDeclaration $i$f$findClosest = parent2 = (FirDeclaration)firElement;
        if ($i$f$findClosest instanceof FirAnonymousObject) {
            list3 = KotlinTarget.Companion.getLOCAL_CLASS_LIST();
        } else if ($i$f$findClosest instanceof FirClass) {
            boolean bl;
            boolean bl2;
            ClassKind classKind = ((FirClass)parent2).getClassKind();
            Object object3 = object2 = parent2 instanceof FirMemberDeclaration ? (FirMemberDeclaration)((Object)parent2) : null;
            if (object2 == null) {
                bl2 = false;
            } else {
                Object $this$isInner$iv = object2;
                boolean $i$f$isInner = false;
                bl2 = $this$isInner$iv.getStatus().isInner();
            }
            Object object4 = object2 = parent2 instanceof FirRegularClass ? (FirRegularClass)parent2 : null;
            if (object2 == null) {
                bl = false;
            } else {
                Object $this$isCompanion$iv = object2;
                boolean $i$f$isCompanion = false;
                bl = ((FirRegularClass)$this$isCompanion$iv).getStatus().isCompanion();
            }
            FirClassLikeDeclaration $this$isLocal$iv = (FirClassLikeDeclaration)parent2;
            boolean $i$f$isLocal = false;
            list3 = KotlinTarget.Companion.classActualTargets(classKind, bl2, bl, $this$isLocal$iv.getSymbol().getClassId().isLocal());
        } else {
            list3 = $i$f$findClosest instanceof FirPropertyAccessor ? (((FirPropertyAccessor)parent2).isSetter() ? KotlinTarget.Companion.getPROPERTY_SETTER_LIST() : KotlinTarget.Companion.getPROPERTY_GETTER_LIST()) : ($i$f$findClosest instanceof FirFunction ? KotlinTarget.Companion.getFUNCTION_LIST() : ($i$f$findClosest instanceof FirEnumEntry ? KotlinTarget.Companion.getENUM_ENTRY_LIST() : KotlinTarget.Companion.getFILE_LIST()));
        }
        List<KotlinTarget> actualParents = list3;
        List<FirModifier<?>> modifiers2 = list2.getModifiers();
        object2 = modifiers2.iterator();
        int n = 0;
        while (object2.hasNext()) {
            int secondIndex = n++;
            FirModifier secondModifier = (FirModifier)object2.next();
            int it = 0;
            while (it < secondIndex) {
                int firstIndex = it++;
                this.checkCompatibilityType(modifiers2.get(firstIndex), secondModifier, reporter2, reportedNodes, owner, context2);
            }
            if (reportedNodes.contains(secondModifier)) continue;
            FirSourceElement modifierSource = secondModifier.getSource();
            KtModifierKeywordToken modifier = secondModifier.getToken();
            if (!this.checkTarget(modifierSource, modifier, actualTargets, parent2, context2, reporter2)) {
                object = reportedNodes;
                object.add(secondModifier);
                continue;
            }
            if (this.checkParent(modifierSource, modifier, actualParents, context2, reporter2)) continue;
            object = reportedNodes;
            object.add(secondModifier);
        }
    }

    private final void checkCompatibilityType(FirModifier<?> firstModifier, FirModifier<?> secondModifier, DiagnosticReporter reporter2, Set<FirModifier<?>> reportedNodes, FirDeclaration owner, CheckerContext context2) {
        KtModifierKeywordToken firstModifierToken = firstModifier.getToken();
        KtModifierKeywordToken secondModifierToken = secondModifier.getToken();
        Compatibility compatibilityType = ModifierCheckerHelpersKt.compatibility(firstModifierToken, secondModifierToken);
        int n = WhenMappings.$EnumSwitchMapping$0[compatibilityType.ordinal()];
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                if (!reportedNodes.add(secondModifier)) break;
                DiagnosticReporterKt.reportOn$default(reporter2, secondModifier.getSource(), FirErrors.INSTANCE.getREPEATED_MODIFIER(), (Object)secondModifierToken, context2, null, 16, null);
                break;
            }
            case 3: {
                DiagnosticReporterKt.reportOn$default(reporter2, secondModifier.getSource(), FirErrors.INSTANCE.getREDUNDANT_MODIFIER(), (Object)secondModifierToken, (Object)firstModifierToken, context2, null, 32, null);
                break;
            }
            case 4: {
                DiagnosticReporterKt.reportOn$default(reporter2, firstModifier.getSource(), FirErrors.INSTANCE.getREDUNDANT_MODIFIER(), (Object)firstModifierToken, (Object)secondModifierToken, context2, null, 32, null);
                break;
            }
            case 5: {
                DiagnosticReporterKt.reportOn$default(reporter2, firstModifier.getSource(), FirErrors.INSTANCE.getDEPRECATED_MODIFIER_PAIR(), (Object)firstModifierToken, (Object)secondModifierToken, context2, null, 32, null);
                DiagnosticReporterKt.reportOn$default(reporter2, secondModifier.getSource(), FirErrors.INSTANCE.getDEPRECATED_MODIFIER_PAIR(), (Object)secondModifierToken, (Object)firstModifierToken, context2, null, 32, null);
                break;
            }
            case 6: 
            case 7: {
                if (n == 7 && owner instanceof FirClass) {
                    return;
                }
                if (reportedNodes.add(firstModifier)) {
                    DiagnosticReporterKt.reportOn$default(reporter2, firstModifier.getSource(), FirErrors.INSTANCE.getINCOMPATIBLE_MODIFIERS(), (Object)firstModifierToken, (Object)secondModifierToken, context2, null, 32, null);
                }
                if (!reportedNodes.add(secondModifier)) break;
                DiagnosticReporterKt.reportOn$default(reporter2, secondModifier.getSource(), FirErrors.INSTANCE.getINCOMPATIBLE_MODIFIERS(), (Object)secondModifierToken, (Object)firstModifierToken, context2, null, 32, null);
            }
        }
    }

    private final boolean checkTarget(FirSourceElement modifierSource, KtModifierKeywordToken modifierToken, List<? extends KotlinTarget> actualTargets, FirDeclaration parent2, CheckerContext context2, DiagnosticReporter reporter2) {
        if (!FirModifierChecker.checkTarget$checkModifier(modifierToken, actualTargets, reporter2, modifierSource, context2, FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET())) {
            return false;
        }
        if (parent2 instanceof FirRegularClass && (Intrinsics.areEqual((Object)((Object)modifierToken), (Object)((Object)KtTokens.EXPECT_KEYWORD)) || Intrinsics.areEqual((Object)((Object)modifierToken), (Object)((Object)KtTokens.HEADER_KEYWORD)))) {
            DiagnosticReporterKt.reportOn$default(reporter2, modifierSource, FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET(), (Object)modifierToken, (Object)"nested class", context2, null, 32, null);
            return false;
        }
        KtModifierKeywordToken deprecatedModifierReplacement = ModifierCheckerHelpersKt.getDeprecatedModifierMap().get((Object)modifierToken);
        if (deprecatedModifierReplacement != null) {
            DiagnosticReporterKt.reportOn$default(reporter2, modifierSource, FirErrors.INSTANCE.getDEPRECATED_MODIFIER(), (Object)modifierToken, (Object)deprecatedModifierReplacement, context2, null, 32, null);
        } else if (FirModifierChecker.checkTarget$checkModifier(modifierToken, actualTargets, reporter2, modifierSource, context2, FirErrors.INSTANCE.getDEPRECATED_MODIFIER_FOR_TARGET())) {
            FirModifierChecker.checkTarget$checkModifier(modifierToken, actualTargets, reporter2, modifierSource, context2, FirErrors.INSTANCE.getREDUNDANT_MODIFIER_FOR_TARGET());
        }
        return true;
    }

    private final boolean checkParent(FirSourceElement modifierSource, KtModifierKeywordToken modifierToken, List<? extends KotlinTarget> actualParents, CheckerContext context2, DiagnosticReporter reporter2) {
        boolean bl;
        block11: {
            TargetAllowedPredicate $i$f$any2;
            Set<KotlinTarget> deprecatedParents = ModifierCheckerHelpersKt.getDeprecatedParentTargetMap().get((Object)modifierToken);
            if (deprecatedParents != null) {
                boolean bl2;
                block10: {
                    Iterable $this$any$iv = actualParents;
                    boolean $i$f$any2 = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KotlinTarget it = (KotlinTarget)((Object)element$iv);
                            boolean bl3 = false;
                            if (!deprecatedParents.contains((Object)it)) continue;
                            bl2 = true;
                            break block10;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    DiagnosticReporterKt.reportOn$default(reporter2, modifierSource, FirErrors.INSTANCE.getDEPRECATED_MODIFIER_CONTAINING_DECLARATION(), (Object)modifierToken, (Object)this.firstOrThis(actualParents), context2, null, 32, null);
                    return true;
                }
            }
            if (($i$f$any2 = ModifierCheckerHelpersKt.getPossibleParentTargetPredicateMap().get((Object)modifierToken)) == null) {
                return true;
            }
            TargetAllowedPredicate possibleParentPredicate = $i$f$any2;
            Iterable $this$any$iv = actualParents;
            boolean $i$f$any3 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl4 = false;
                    if (!possibleParentPredicate.isAllowed(it, FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()))) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        DiagnosticReporterKt.reportOn$default(reporter2, modifierSource, FirErrors.INSTANCE.getWRONG_MODIFIER_CONTAINING_DECLARATION(), (Object)modifierToken, (Object)this.firstOrThis(actualParents), context2, null, 32, null);
        return false;
    }

    private final String firstOrThis(List<? extends KotlinTarget> $this$firstOrThis) {
        KotlinTarget kotlinTarget = (KotlinTarget)((Object)CollectionsKt.firstOrNull($this$firstOrThis));
        return kotlinTarget == null ? "this" : kotlinTarget.getDescription();
    }

    private static final void check$checkPropertyAccessor(CheckerContext $context, DiagnosticReporter $reporter, FirPropertyAccessor propertyAccessor) {
        if (propertyAccessor != null) {
            FirPropertyAccessor $this$hasBody$iv = propertyAccessor;
            boolean $i$f$getHasBody = false;
            if (!($this$hasBody$iv.getBody() != null)) {
                INSTANCE.check(propertyAccessor, $context, $reporter);
            }
        }
    }

    private static final boolean checkTarget$checkModifier(KtModifierKeywordToken $modifierToken, List<? extends KotlinTarget> $actualTargets, DiagnosticReporter $reporter, FirSourceElement $modifierSource, CheckerContext $context, FirDiagnosticFactory2<KtModifierKeywordToken, String> factory2) {
        boolean checkResult;
        block9: {
            KotlinTarget it;
            boolean bl;
            Set set;
            Map<KtModifierKeywordToken, EnumSet<KotlinTarget>> map;
            FirDiagnosticFactory2<KtModifierKeywordToken, String> firDiagnosticFactory2 = factory2;
            Map<KtModifierKeywordToken, EnumSet<KotlinTarget>> map2 = map = Intrinsics.areEqual(firDiagnosticFactory2, FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET()) ? ModifierCheckerHelpersKt.getPossibleTargetMap() : (Intrinsics.areEqual(firDiagnosticFactory2, FirErrors.INSTANCE.getDEPRECATED_MODIFIER_FOR_TARGET()) ? ModifierCheckerHelpersKt.getDeprecatedTargetMap() : ModifierCheckerHelpersKt.getRedundantTargetMap());
            Set set2 = map2.get((Object)$modifierToken);
            Set set3 = set = set2 == null ? SetsKt.emptySet() : set2;
            if (Intrinsics.areEqual(factory2, FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET())) {
                Iterable $this$none$iv = $actualTargets;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (KotlinTarget)((Object)element$iv);
                        boolean bl2 = false;
                        if (!set.contains((Object)it)) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            } else {
                Iterable $this$any$iv = $actualTargets;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (KotlinTarget)((Object)element$iv);
                        boolean bl3 = false;
                        if (!set.contains((Object)it)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = checkResult = false;
                }
            }
        }
        if (checkResult) {
            DiagnosticReporterKt.reportOn$default($reporter, $modifierSource, factory2, (Object)$modifierToken, (Object)INSTANCE.firstOrThis($actualTargets), $context, null, 32, null);
            return false;
        }
        return true;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Compatibility.values().length];
            nArray[Compatibility.COMPATIBLE.ordinal()] = 1;
            nArray[Compatibility.REPEATED.ordinal()] = 2;
            nArray[Compatibility.REDUNDANT.ordinal()] = 3;
            nArray[Compatibility.REVERSE_REDUNDANT.ordinal()] = 4;
            nArray[Compatibility.DEPRECATED.ordinal()] = 5;
            nArray[Compatibility.INCOMPATIBLE.ordinal()] = 6;
            nArray[Compatibility.COMPATIBLE_FOR_CLASSES_ONLY.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

