/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.FirOverridesBackwardCompatibilityHelperKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirOverrideChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J<\u0010\f\u001a\u00020\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0016H\u0002J$\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e*\u00020\u00182\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0016H\u0002J8\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e*\u0006\u0012\u0002\b\u00030\u000e2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0002J:\u0010\u001a\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00162\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010\u001b\u001a\u00020\u0006*\u00020\u000b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010\u001e\u001a\u00020\u0006*\u00020\u000b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u001f\u001a\u00020\u0006*\u00020\u000b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010 \u001a\u00020\u0006*\u00020\u000b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010!\u001a\u00020\u0006*\u00020\u000b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010\"\u001a\u00020\u0006*\u00020\u000b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010#\u001a\u00020\u0006*\u00020\u000b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010$\u001a\u00020\u0006*\u00020\u000b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010%\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0016*\u00020\u00132\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J,\u0010'\u001a\u00020(*\u00020(2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkMember", "member", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "containingClass", "typeCheckerState", "Lorg/jetbrains/kotlin/types/TypeCheckerState;", "firTypeScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "checkModality", "overriddenSymbols", "", "checkMutability", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "checkReturnType", "checkVisibility", "reportCannotChangeAccessPrivilege", "overriding", "overridden", "reportCannotWeakenAccessPrivilege", "reportNothingToOverride", "reportOverridingFinalMember", "reportReturnTypeMismatchOnFunction", "reportTypeMismatchOnProperty", "reportTypeMismatchOnVariable", "reportVarOverriddenByVal", "retrieveDirectOverriddenOf", "memberSymbol", "substituteAllTypeParameters", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "overrideDeclaration", "baseDeclaration", "checkers"})
public final class FirOverrideChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirOverrideChecker INSTANCE = new FirOverrideChecker();

    private FirOverrideChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        TypeCheckerState typeCheckerState = SessionUtilsKt.getTypeContext(context2.getSession()).newTypeCheckerState(false, false);
        FirTypeScope firTypeScope = FirHelpersKt.unsubstitutedScope(declaration, context2);
        for (FirDeclaration it : declaration.getDeclarations()) {
            if (!(it instanceof FirSimpleFunction) && !(it instanceof FirProperty)) continue;
            this.checkMember(((FirCallableDeclaration)it).getSymbol(), declaration, reporter2, typeCheckerState, firTypeScope, context2);
        }
    }

    private final List<FirCallableSymbol<?>> retrieveDirectOverriddenOf(FirTypeScope $this$retrieveDirectOverriddenOf, FirCallableSymbol<?> memberSymbol) {
        List list2;
        FirCallableSymbol<?> firCallableSymbol = memberSymbol;
        if (firCallableSymbol instanceof FirNamedFunctionSymbol) {
            $this$retrieveDirectOverriddenOf.processFunctionsByName(memberSymbol.getName(), (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)retrieveDirectOverriddenOf.1.INSTANCE));
            list2 = FirTypeScopeKt.getDirectOverriddenFunctions$default($this$retrieveDirectOverriddenOf, (FirNamedFunctionSymbol)memberSymbol, false, 2, null);
        } else if (firCallableSymbol instanceof FirPropertySymbol) {
            $this$retrieveDirectOverriddenOf.processPropertiesByName(memberSymbol.getName(), retrieveDirectOverriddenOf.2.INSTANCE);
            list2 = FirTypeScopeKt.getDirectOverriddenProperties$default($this$retrieveDirectOverriddenOf, (FirPropertySymbol)memberSymbol, false, 2, null);
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"unexpected member kind ", memberSymbol));
        }
        return list2;
    }

    private final ConeKotlinType substituteAllTypeParameters(ConeKotlinType $this$substituteAllTypeParameters, FirCallableSymbol<?> overrideDeclaration, FirCallableSymbol<?> baseDeclaration, CheckerContext context2) {
        List<FirTypeParameterSymbol> overrideTypeParameters = overrideDeclaration.getTypeParameterSymbols();
        if (overrideTypeParameters.isEmpty()) {
            return $this$substituteAllTypeParameters;
        }
        List<FirTypeParameterSymbol> baseTypeParameters = baseDeclaration.getTypeParameterSymbols();
        Map map = new LinkedHashMap();
        int n = overrideTypeParameters.size();
        int n2 = baseTypeParameters.size();
        int size = Math.min(n, n2);
        n = 0;
        while (n < size) {
            int it = n++;
            FirTypeParameterSymbol to = overrideTypeParameters.get(it);
            FirTypeParameterSymbol from2 = baseTypeParameters.get(it);
            Map map2 = map;
            ConeKotlinType coneKotlinType = FirNestedClassifierScopeKt.toConeType(to);
            map2.put(from2, coneKotlinType);
        }
        return SubstitutorsKt.substitutorByMap(map, context2.getSession()).substituteOrSelf($this$substituteAllTypeParameters);
    }

    private final FirCallableSymbol<?> checkModality(List<? extends FirCallableSymbol<?>> overriddenSymbols2) {
        Iterator<FirCallableSymbol<?>> iterator2 = overriddenSymbols2.iterator();
        while (iterator2.hasNext()) {
            FirCallableSymbol<?> overridden;
            FirCallableSymbol<?> $this$modality$iv = overridden = iterator2.next();
            boolean $i$f$getModality = false;
            Modality modality = $this$modality$iv.getResolvedStatus().getModality();
            boolean isEffectivelyFinal = modality == null || modality == Modality.FINAL;
            if (!isEffectivelyFinal) continue;
            return overridden;
        }
        return null;
    }

    private final FirCallableSymbol<?> checkMutability(FirPropertySymbol $this$checkMutability, List<? extends FirCallableSymbol<?>> overriddenSymbols2) {
        Object v1;
        block2: {
            Iterable iterable;
            if ($this$checkMutability.isVar()) {
                return null;
            }
            Iterable iterable2 = iterable = (Iterable)overriddenSymbols2;
            for (Object t : iterable2) {
                FirPropertySymbol firPropertySymbol;
                FirCallableSymbol it = (FirCallableSymbol)t;
                boolean bl = false;
                FirPropertySymbol firPropertySymbol2 = firPropertySymbol = it instanceof FirPropertySymbol ? (FirPropertySymbol)it : null;
                if (!(firPropertySymbol == null ? false : firPropertySymbol.isVar())) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVisibility(FirCallableSymbol<?> $this$checkVisibility, FirClass containingClass, DiagnosticReporter reporter2, List<? extends FirCallableSymbol<?>> overriddenSymbols2, CheckerContext context2) {
        boolean hasVisibleBase;
        block18: {
            boolean bl;
            FirElement firElement;
            block17: {
                block20: {
                    List visibilities;
                    block19: {
                        void $this$mapNotNullTo$iv$iv;
                        void $this$mapNotNull$iv;
                        Collection<FirCallableSymbol> collection;
                        void $this$mapTo$iv$iv;
                        FirClass firClass;
                        DiagnosticReporter diagnosticReporter;
                        Object $this$sortedBy$iv;
                        Object object;
                        Object object2;
                        void $this$mapTo$iv$iv2;
                        if (overriddenSymbols2.isEmpty()) {
                            return;
                        }
                        Iterable $this$map$iv = overriddenSymbols2;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                            void it;
                            FirCallableSymbol firCallableSymbol = (FirCallableSymbol)item$iv$iv;
                            object2 = destination$iv$iv;
                            boolean bl2 = false;
                            void $this$visibility$iv = it;
                            boolean $i$f$getVisibility = false;
                            object = TuplesKt.to((Object)it, (Object)$this$visibility$iv.getResolvedStatus().getVisibility());
                            object2.add(object);
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$sortedBy2 = false;
                        visibilities = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator($this$checkVisibility){
                            final /* synthetic */ FirCallableSymbol $this_checkVisibility$inlined;
                            {
                                this.$this_checkVisibility$inlined = firCallableSymbol;
                            }

                            public final int compare(T a, T b) {
                                Pair pair = (Pair)a;
                                boolean bl = false;
                                FirCallableSymbol $this$visibility$iv = this.$this_checkVisibility$inlined;
                                boolean $i$f$getVisibility = false;
                                Integer n = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), (Visibility)pair.getSecond());
                                int n2 = n == null ? Integer.MIN_VALUE : n;
                                pair = (Pair)b;
                                Comparable comparable = Integer.valueOf(n2);
                                bl = false;
                                $this$visibility$iv = this.$this_checkVisibility$inlined;
                                $i$f$getVisibility = false;
                                n = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), (Visibility)pair.getSecond());
                                Integer n3 = n == null ? Integer.MIN_VALUE : n;
                                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n3);
                            }
                        });
                        if (!($this$checkVisibility instanceof FirPropertySymbol)) break block19;
                        $this$sortedBy$iv = ((FirPropertySymbol)$this$checkVisibility).getGetterSymbol();
                        if ($this$sortedBy$iv != null) {
                            void $this$map$iv2;
                            Iterable $i$f$sortedBy2 = overriddenSymbols2;
                            diagnosticReporter = reporter2;
                            firClass = containingClass;
                            object = (FirCallableSymbol)$this$sortedBy$iv;
                            object2 = this;
                            boolean $i$f$map2 = false;
                            destination$iv$iv = $this$map$iv2;
                            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                            boolean $i$f$mapTo2 = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                FirCallableSymbol bl2 = (FirCallableSymbol)item$iv$iv;
                                collection = destination$iv$iv2;
                                boolean bl3 = false;
                                FirPropertyAccessorSymbol $i$f$getVisibility = ((FirPropertySymbol)it).getGetterSymbol();
                                FirCallableSymbol firCallableSymbol = $i$f$getVisibility == null ? it : (FirCallableSymbol)$i$f$getVisibility;
                                collection.add(firCallableSymbol);
                            }
                            collection = (List)destination$iv$iv2;
                            super.checkVisibility((FirCallableSymbol<?>)object, firClass, diagnosticReporter, (List<? extends FirCallableSymbol<?>>)collection, context2);
                        }
                        $this$sortedBy$iv = ((FirPropertySymbol)$this$checkVisibility).getSetterSymbol();
                        if ($this$sortedBy$iv == null) break block20;
                        Iterable $this$map$iv2 = overriddenSymbols2;
                        diagnosticReporter = reporter2;
                        firClass = containingClass;
                        object = (FirCallableSymbol)$this$sortedBy$iv;
                        object2 = this;
                        boolean $i$f$mapNotNull = false;
                        $this$mapTo$iv$iv = $this$mapNotNull$iv;
                        Collection destination$iv$iv3 = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator it = $this$forEach$iv$iv$iv.iterator();
                        while (it.hasNext()) {
                            FirPropertyAccessorSymbol firPropertyAccessorSymbol;
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = it.next();
                            boolean bl4 = false;
                            FirCallableSymbol it2 = (FirCallableSymbol)element$iv$iv;
                            boolean bl5 = false;
                            FirPropertyAccessorSymbol firPropertyAccessorSymbol2 = ((FirPropertySymbol)it2).getSetterSymbol();
                            if (firPropertyAccessorSymbol2 == null) continue;
                            FirPropertyAccessorSymbol it$iv$iv = firPropertyAccessorSymbol = firPropertyAccessorSymbol2;
                            boolean bl6 = false;
                            destination$iv$iv3.add(it$iv$iv);
                        }
                        collection = (List)destination$iv$iv3;
                        super.checkVisibility((FirCallableSymbol<?>)object, firClass, diagnosticReporter, (List<? extends FirCallableSymbol<?>>)collection, context2);
                        break block20;
                    }
                    for (Pair $this$mapNotNull$iv : visibilities) {
                        FirCallableSymbol overridden = (FirCallableSymbol)$this$mapNotNull$iv.component1();
                        Visibility overriddenVisibility = (Visibility)$this$mapNotNull$iv.component2();
                        FirCallableSymbol<?> $this$visibility$iv = $this$checkVisibility;
                        boolean $i$f$getVisibility = false;
                        Integer compare = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), overriddenVisibility);
                        if (compare == null) {
                            this.reportCannotChangeAccessPrivilege(reporter2, $this$checkVisibility, overridden, context2);
                            break;
                        }
                        if (compare >= 0) continue;
                        this.reportCannotWeakenAccessPrivilege(reporter2, $this$checkVisibility, overridden, context2);
                        break;
                    }
                }
                if ($this$checkVisibility instanceof FirPropertyAccessorSymbol) {
                    return;
                }
                CheckerContext $this$findClosest_u24default$iv = context2;
                boolean $i$f$findClosest = false;
                for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                    FirElement element$iv$iv;
                    FirElement firElement2;
                    FirElement $i$f$forEach;
                    FirDeclaration firDeclaration = it$iv;
                    if (!(firDeclaration instanceof FirFile)) {
                        firDeclaration = null;
                    }
                    if (($i$f$forEach = (FirElement)((FirFile)firDeclaration)) == null) {
                        firElement2 = null;
                    } else {
                        FirElement it;
                        FirElement element$iv$iv$iv;
                        FirElement it3 = element$iv$iv$iv = (it = $i$f$forEach);
                        firElement2 = element$iv$iv = true ? it : null;
                    }
                    if (element$iv$iv == null) continue;
                    firElement = element$iv$iv;
                    break block17;
                }
                firElement = null;
            }
            FirFile $this$mapNotNull$iv = (FirFile)firElement;
            if ($this$mapNotNull$iv == null) {
                return;
            }
            FirFile file2 = $this$mapNotNull$iv;
            List containingDeclarations = CollectionsKt.plus((Collection)context2.getContainingDeclarations(), (Object)containingClass);
            FirVisibilityChecker visibilityChecker = FirVisibilityCheckerKt.getVisibilityChecker(context2.getSession());
            Iterable $this$any$iv = overriddenSymbols2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirCallableSymbol it = (FirCallableSymbol)element$iv;
                    boolean bl7 = false;
                    FirPhaseManagerKt.ensureResolved(it, FirResolvePhase.STATUS);
                    FirCallableDeclaration fir = (FirCallableDeclaration)it.getFir();
                    if (!visibilityChecker.isVisible(fir, context2.getSession(), file2, containingDeclarations, null)) continue;
                    bl = true;
                    break block18;
                }
                bl = hasVisibleBase = false;
            }
        }
        if (!hasVisibleBase) {
            DiagnosticReporterKt.reportOn$default(reporter2, $this$checkVisibility.getSource(), FirErrors.INSTANCE.getCANNOT_OVERRIDE_INVISIBLE_MEMBER(), $this$checkVisibility, CollectionsKt.first(overriddenSymbols2), context2, null, 32, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final FirCallableSymbol<?> checkReturnType(FirCallableSymbol<?> $this$checkReturnType, List<? extends FirCallableSymbol<?>> overriddenSymbols2, TypeCheckerState typeCheckerState, CheckerContext context2) {
        void $this$mapTo$iv$iv;
        ConeKotlinType overridingReturnType = FirTypeUtilsKt.getConeType($this$checkReturnType.getResolvedReturnTypeRef());
        if (overridingReturnType instanceof ConeClassErrorType) {
            return null;
        }
        Iterable $this$map$iv = overriddenSymbols2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirCallableSymbol firCallableSymbol = (FirCallableSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConeKotlinType coneKotlinType = ConeTypesKt.upperBoundIfFlexible(FirTypeUtilsKt.getConeType(context2.getReturnTypeCalculator().tryCalculateReturnType((FirCallableSymbol<?>)it)));
            collection.add(coneKotlinType);
        }
        List bounds = (List)destination$iv$iv;
        int n = 0;
        int n2 = bounds.size();
        while (n < n2) {
            int it = n++;
            FirCallableSymbol<?> overriddenDeclaration = overriddenSymbols2.get(it);
            ConeKotlinType overriddenReturnType = this.substituteAllTypeParameters((ConeKotlinType)bounds.get(it), $this$checkReturnType, overriddenDeclaration, context2);
            boolean isReturnTypeOkForOverride = overriddenDeclaration instanceof FirPropertySymbol && ((FirPropertySymbol)overriddenDeclaration).isVar() ? AbstractTypeChecker.INSTANCE.equalTypes(typeCheckerState, overridingReturnType, overriddenReturnType) : AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeCheckerState, (KotlinTypeMarker)overridingReturnType, (KotlinTypeMarker)overriddenReturnType, false, 8, null);
            if (isReturnTypeOkForOverride) continue;
            return overriddenDeclaration;
        }
        return null;
    }

    private final void checkMember(FirCallableSymbol<?> member2, FirClass containingClass, DiagnosticReporter reporter2, TypeCheckerState typeCheckerState, FirTypeScope firTypeScope, CheckerContext context2) {
        FirCallableSymbol<?> it;
        FirCallableSymbol<?> kind;
        List<FirCallableSymbol<?>> overriddenMemberSymbols = this.retrieveDirectOverriddenOf(firTypeScope, member2);
        FirCallableSymbol<?> $this$isOverride$iv = member2;
        boolean $i$f$isOverride2 = false;
        if (!$this$isOverride$iv.getResolvedStatus().isOverride()) {
            if (overriddenMemberSymbols.isEmpty() || FirOverridesBackwardCompatibilityHelperKt.getOverridesBackwardCompatibilityHelper(context2.getSession()).overrideCanBeOmitted(overriddenMemberSymbols, context2)) {
                return;
            }
            Object $i$f$isOverride2 = member2.getSource();
            FirCallableSymbol<?> firCallableSymbol = kind = $i$f$isOverride2 == null ? null : ((FirSourceElement)$i$f$isOverride2).getKind();
            if (kind instanceof FirFakeSourceElementKind.DataClassGeneratedMembers) {
                Object v2;
                Object object;
                block20: {
                    object = overriddenMemberSymbols;
                    Iterable iterable = object;
                    for (Object t : iterable) {
                        Modality modality$iv;
                        FirCallableSymbol it2 = (FirCallableSymbol)t;
                        boolean bl = false;
                        FirCallableSymbol $this$isFinal$iv = it2;
                        boolean $i$f$isFinal = false;
                        Modality modality = $this$isFinal$iv.getResolvedStatus().getModality();
                        boolean bl2 = modality == null ? true : (modality$iv = modality) == Modality.FINAL;
                        if (!bl2) continue;
                        v2 = t;
                        break block20;
                    }
                    v2 = null;
                }
                $i$f$isOverride2 = v2;
                if ($i$f$isOverride2 != null) {
                    Object base2 = object = $i$f$isOverride2;
                    boolean bl = false;
                    DiagnosticReporterKt.reportOn$default(reporter2, containingClass.getSource(), FirErrors.INSTANCE.getDATA_CLASS_OVERRIDE_CONFLICT(), member2, base2, context2, null, 32, null);
                }
                return;
            }
            if (!(kind instanceof FirRealSourceElementKind) && !(kind instanceof FirFakeSourceElementKind.PropertyFromParameter)) {
                return;
            }
            FirCallableSymbol $this$originalOrSelf$iv = (FirCallableSymbol)CollectionsKt.first(overriddenMemberSymbols);
            boolean $i$f$originalOrSelf = false;
            FirCallableDeclaration $this$originalOrSelf$iv$iv = (FirCallableDeclaration)$this$originalOrSelf$iv.getFir();
            boolean $i$f$originalOrSelf2 = false;
            FirCallableDeclaration result$iv$iv = $this$originalOrSelf$iv$iv;
            while (ClassMembersKt.isSubstitutionOrIntersectionOverride(result$iv$iv)) {
                FirCallableDeclaration firCallableDeclaration;
                FirCallableDeclaration firCallableDeclaration2;
                FirCallableDeclaration firCallableDeclaration3;
                FirCallableDeclaration $this$originalIfFakeOverride$iv$iv$iv = result$iv$iv;
                boolean $i$f$originalIfFakeOverride = false;
                FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                boolean $i$f$getOriginalForSubstitutionOverride = false;
                FirCallableDeclaration firCallableDeclaration4 = firCallableDeclaration3 = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv) : null;
                if (firCallableDeclaration3 == null) {
                    FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                    boolean $i$f$getBaseForIntersectionOverride = false;
                    firCallableDeclaration2 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                } else {
                    firCallableDeclaration2 = firCallableDeclaration = firCallableDeclaration3;
                }
                if (firCallableDeclaration == null) break;
                result$iv$iv = firCallableDeclaration;
            }
            FirCallableSymbol<? extends FirCallableDeclaration> firCallableSymbol2 = result$iv$iv.getSymbol();
            if (firCallableSymbol2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
            }
            FirCallableSymbol<? extends FirCallableDeclaration> overridden = firCallableSymbol2;
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass(overridden);
            FirClassLikeSymbol<?> firClassLikeSymbol = coneClassLikeLookupTag == null ? null : LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context2.getSession());
            FirRegularClassSymbol firRegularClassSymbol = $i$f$originalOrSelf = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
            if ($i$f$originalOrSelf == null) {
                return;
            }
            FirRegularClassSymbol originalContainingClassSymbol = $i$f$originalOrSelf;
            DiagnosticReporterKt.reportOn$default(reporter2, member2.getSource(), FirErrors.INSTANCE.getVIRTUAL_MEMBER_HIDDEN(), member2, (Object)originalContainingClassSymbol, context2, null, 32, null);
            return;
        }
        if (overriddenMemberSymbols.isEmpty()) {
            this.reportNothingToOverride(reporter2, member2, context2);
            return;
        }
        kind = this.checkModality(overriddenMemberSymbols);
        if (kind != null) {
            FirCallableSymbol<?> firCallableSymbol;
            it = firCallableSymbol = kind;
            boolean bl = false;
            INSTANCE.reportOverridingFinalMember(reporter2, member2, it, context2);
        }
        if (member2 instanceof FirPropertySymbol && (kind = this.checkMutability((FirPropertySymbol)member2, overriddenMemberSymbols)) != null) {
            FirCallableSymbol<?> firCallableSymbol = kind;
            it = firCallableSymbol;
            boolean bl = false;
            INSTANCE.reportVarOverriddenByVal(reporter2, member2, it, context2);
        }
        this.checkVisibility(member2, containingClass, reporter2, overriddenMemberSymbols, context2);
        FirCallableSymbol<?> firCallableSymbol = this.checkReturnType(member2, overriddenMemberSymbols, typeCheckerState, context2);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol<?> restriction = firCallableSymbol;
        firCallableSymbol = member2;
        if (firCallableSymbol instanceof FirNamedFunctionSymbol) {
            this.reportReturnTypeMismatchOnFunction(reporter2, member2, restriction, context2);
        } else if (firCallableSymbol instanceof FirPropertySymbol) {
            if (((FirPropertySymbol)member2).isVar()) {
                this.reportTypeMismatchOnVariable(reporter2, member2, restriction, context2);
            } else {
                this.reportTypeMismatchOnProperty(reporter2, member2, restriction, context2);
            }
        }
    }

    private final void reportNothingToOverride(DiagnosticReporter $this$reportNothingToOverride, FirCallableSymbol<?> declaration, CheckerContext context2) {
        DiagnosticReporterKt.reportOn$default($this$reportNothingToOverride, declaration.getSource(), FirErrors.INSTANCE.getNOTHING_TO_OVERRIDE(), declaration, context2, null, 16, null);
    }

    private final void reportOverridingFinalMember(DiagnosticReporter $this$reportOverridingFinalMember, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass(overridden);
        if (coneClassLikeLookupTag != null) {
            ConeClassLikeLookupTag coneClassLikeLookupTag2;
            ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag2 = coneClassLikeLookupTag;
            boolean bl = false;
            DiagnosticReporterKt.reportOn$default($this$reportOverridingFinalMember, overriding.getSource(), FirErrors.INSTANCE.getOVERRIDING_FINAL_MEMBER(), overridden, (Object)containingClass.getName(), context2, null, 32, null);
        }
    }

    private final void reportVarOverriddenByVal(DiagnosticReporter $this$reportVarOverriddenByVal, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        DiagnosticReporterKt.reportOn$default($this$reportVarOverriddenByVal, overriding.getSource(), FirErrors.INSTANCE.getVAR_OVERRIDDEN_BY_VAL(), overriding, overridden, context2, null, 32, null);
    }

    private final void reportCannotWeakenAccessPrivilege(DiagnosticReporter $this$reportCannotWeakenAccessPrivilege, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirCallableSymbol<?> $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        DiagnosticReporterKt.reportOn$default($this$reportCannotWeakenAccessPrivilege, overriding.getSource(), FirErrors.INSTANCE.getCANNOT_WEAKEN_ACCESS_PRIVILEGE(), (Object)$this$visibility$iv.getResolvedStatus().getVisibility(), overridden, (Object)containingClass.getName(), context2, null, 64, null);
    }

    private final void reportCannotChangeAccessPrivilege(DiagnosticReporter $this$reportCannotChangeAccessPrivilege, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirCallableSymbol<?> $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        DiagnosticReporterKt.reportOn$default($this$reportCannotChangeAccessPrivilege, overriding.getSource(), FirErrors.INSTANCE.getCANNOT_CHANGE_ACCESS_PRIVILEGE(), (Object)$this$visibility$iv.getResolvedStatus().getVisibility(), overridden, (Object)containingClass.getName(), context2, null, 64, null);
    }

    private final void reportReturnTypeMismatchOnFunction(DiagnosticReporter $this$reportReturnTypeMismatchOnFunction, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        DiagnosticReporterKt.reportOn$default($this$reportReturnTypeMismatchOnFunction, overriding.getSource(), FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, context2, null, 32, null);
    }

    private final void reportTypeMismatchOnProperty(DiagnosticReporter $this$reportTypeMismatchOnProperty, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        DiagnosticReporterKt.reportOn$default($this$reportTypeMismatchOnProperty, overriding.getSource(), FirErrors.INSTANCE.getPROPERTY_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, context2, null, 32, null);
    }

    private final void reportTypeMismatchOnVariable(DiagnosticReporter $this$reportTypeMismatchOnVariable, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        DiagnosticReporterKt.reportOn$default($this$reportTypeMismatchOnVariable, overriding.getSource(), FirErrors.INSTANCE.getVAR_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, context2, null, 32, null);
    }
}

