/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLoopJump;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedExpression;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirLoopJump;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirLoopJumpChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker
extends FirExpressionChecker<FirLoopJump> {
    @NotNull
    public static final FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker INSTANCE = new FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker();

    private FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker() {
    }

    @Override
    public void check(@NotNull FirLoopJump expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        ArrayDeque errorPathElements = new ArrayDeque();
        FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck(expression2, (ArrayDeque<FirElement>)errorPathElements, reporter2, context2, expression2.getTarget().getLabeledElement().getBlock());
    }

    private static final boolean check$findPathAndCheck$findPathAndCheckWithAddingErrorElement(ArrayDeque<FirElement> errorPathElements, FirLoopJump $expression, DiagnosticReporter $reporter, CheckerContext $context, FirElement errorElement, FirElement checkElement) {
        errorPathElements.addLast((Object)errorElement);
        boolean result2 = FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, checkElement);
        errorPathElements.removeLast();
        return result2;
    }

    private static final boolean check$findPathAndCheck(FirLoopJump $expression, ArrayDeque<FirElement> errorPathElements, DiagnosticReporter $reporter, CheckerContext $context, FirElement element) {
        if (element == null) {
            return false;
        }
        FirElement firElement = element;
        if (Intrinsics.areEqual((Object)firElement, (Object)$expression)) {
            if (CollectionsKt.any((Iterable)((Iterable)errorPathElements))) {
                DiagnosticReporterKt.reportOn$default($reporter, $expression.getSource(), FirErrors.INSTANCE.getBREAK_OR_CONTINUE_JUMPS_ACROSS_FUNCTION_BOUNDARY(), $context, null, 8, null);
            }
            return true;
        }
        if (firElement instanceof FirBlock) {
            for (FirStatement statement2 : ((FirBlock)element).getStatements()) {
                if (!FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, statement2)) continue;
                return true;
            }
        } else if (firElement instanceof FirWhenExpression) {
            for (FirWhenBranch branch : ((FirWhenExpression)element).getBranches()) {
                if (!FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, branch.getResult())) continue;
                return true;
            }
        } else {
            if (firElement instanceof FirVariable) {
                return FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, ((FirVariable)element).getInitializer());
            }
            if (firElement instanceof FirWrappedExpression) {
                return FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, ((FirWrappedExpression)element).getExpression());
            }
            if (firElement instanceof FirCall) {
                FirCall $this$arguments$iv = (FirCall)element;
                boolean $i$f$getArguments = false;
                for (FirExpression argument2 : $this$arguments$iv.getArgumentList().getArguments()) {
                    if (!FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, argument2)) continue;
                    return true;
                }
            } else if (firElement instanceof FirClass) {
                errorPathElements.addLast((Object)element);
                for (FirDeclaration declaration : ((FirClass)element).getDeclarations()) {
                    if (!FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, declaration)) continue;
                    errorPathElements.removeLast();
                    return true;
                }
                errorPathElements.removeLast();
            } else if (firElement instanceof FirFunction) {
                if (FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck$findPathAndCheckWithAddingErrorElement(errorPathElements, $expression, $reporter, $context, element, ((FirFunction)element).getBody())) {
                    return true;
                }
                if (element instanceof FirConstructor) {
                    FirArgumentList argumentList2;
                    FirDelegatedConstructorCall firDelegatedConstructorCall = ((FirConstructor)element).getDelegatedConstructor();
                    FirArgumentList firArgumentList = argumentList2 = firDelegatedConstructorCall == null ? null : firDelegatedConstructorCall.getArgumentList();
                    if (argumentList2 != null) {
                        errorPathElements.addLast((Object)element);
                        for (FirExpression argument3 : argumentList2.getArguments()) {
                            if (!FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, argument3)) continue;
                            errorPathElements.removeLast();
                            return true;
                        }
                        errorPathElements.removeLast();
                    }
                }
            } else {
                if (firElement instanceof FirAnonymousInitializer) {
                    return FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck$findPathAndCheckWithAddingErrorElement(errorPathElements, $expression, $reporter, $context, element, ((FirAnonymousInitializer)element).getBody());
                }
                if (firElement instanceof FirAnonymousObjectExpression) {
                    return FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck$findPathAndCheckWithAddingErrorElement(errorPathElements, $expression, $reporter, $context, element, ((FirAnonymousObjectExpression)element).getAnonymousObject());
                }
                if (firElement instanceof FirAnonymousFunctionExpression) {
                    return FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck$findPathAndCheckWithAddingErrorElement(errorPathElements, $expression, $reporter, $context, element, ((FirAnonymousFunctionExpression)element).getAnonymousFunction());
                }
            }
        }
        return false;
    }
}

