/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/DataClassDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class DataClassDeclarationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        if (!(declaration instanceof KtClassOrObject)) {
            return;
        }
        if (((ClassDescriptor)descriptor2).isData()) {
            KtPrimaryConstructor primaryConstructor2;
            Object object;
            List<KtParameter> parameters2;
            if (((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor() == null) {
                PsiElement psiElement = ((ClassDescriptor)descriptor2).getConstructors();
                Intrinsics.checkNotNullExpressionValue(psiElement, (String)"descriptor.constructors");
                if (!psiElement.isEmpty() && (psiElement = ((KtClassOrObject)declaration).getNameIdentifier()) != null) {
                    PsiElement psiElement2;
                    PsiElement it = psiElement2 = psiElement;
                    boolean bl = false;
                    context2.getTrace().report(Errors.PRIMARY_CONSTRUCTOR_REQUIRED_FOR_DATA_CLASS.on(it));
                }
            }
            List<KtParameter> list2 = parameters2 = (object = (primaryConstructor2 = ((KtClassOrObject)declaration).getPrimaryConstructor())) == null ? CollectionsKt.emptyList() : ((KtConstructor)object).getValueParameters();
            if (parameters2.isEmpty()) {
                KtPrimaryConstructor ktPrimaryConstructor = primaryConstructor2;
                Object bl = ktPrimaryConstructor == null ? null : ktPrimaryConstructor.getValueParameterList();
                Object object2 = object = bl == null ? ((KtClassOrObject)declaration).getNameIdentifier() : (PsiElement)bl;
                if (object != null) {
                    Object it = bl = object;
                    boolean bl2 = false;
                    context2.getTrace().report(Errors.DATA_CLASS_WITHOUT_PARAMETERS.on((PsiElement)it));
                }
            }
            for (KtParameter parameter : parameters2) {
                if (parameter.isVarArg()) {
                    context2.getTrace().report(Errors.DATA_CLASS_VARARG_PARAMETER.on((KtParameter)((PsiElement)parameter)));
                }
                if (parameter.hasValOrVar()) continue;
                context2.getTrace().report(Errors.DATA_CLASS_NOT_PROPERTY_PARAMETER.on((KtParameter)((PsiElement)parameter)));
            }
        }
    }
}

