/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.tree.IElementType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.OperationsMapGeneratedKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a \u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a0\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0006\u001a@\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u001a \u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0006\u001a0\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u001a\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0002\u001a\u0010\u0010 \u001a\u00020!2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006\u001a\u0012\u0010\"\u001a\u00020!2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u0002H\u0002\u001a\u000e\u0010%\u001a\u00020!*\u0006\u0012\u0002\b\u00030&\u001a\u000e\u0010%\u001a\u00020!*\u0006\u0012\u0002\b\u00030\u0004\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"DIVISION_OPERATION_NAMES", "", "", "createCompileTimeConstantForCompareTo", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "result", "", "operationReference", "Lorg/jetbrains/kotlin/psi/KtExpression;", "createCompileTimeConstantForEquals", "evaluateBinary", "name", "receiverTypeStr", "receiverValue", "parameterTypeStr", "parameterValue", "evaluateBinaryAndCheck", "receiverType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "parameterType", "reportIntegerOverflow", "Lkotlin/Function0;", "", "evaluateUnary", "typeStr", "value", "evaluateUnaryAndCheck", "type", "getReceiverExpressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "isIntegerType", "", "isZero", "typeStrToCompileTimeType", "str", "isStandaloneOnlyConstant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "frontend"})
public final class ConstantExpressionEvaluatorKt {
    @NotNull
    private static final Set<String> DIVISION_OPERATION_NAMES;

    private static final ConstantValue<?> createCompileTimeConstantForEquals(Object result2, KtExpression operationReference) {
        if (result2 instanceof Boolean) {
            boolean bl;
            boolean bl2 = operationReference instanceof KtSimpleNameExpression;
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-ConstantExpressionEvaluatorKt$createCompileTimeConstantForEquals$22 = false;
                String $i$a$-assert-ConstantExpressionEvaluatorKt$createCompileTimeConstantForEquals$22 = "This method should be called only for equals operations";
                throw new AssertionError((Object)$i$a$-assert-ConstantExpressionEvaluatorKt$createCompileTimeConstantForEquals$22);
            }
            IElementType operationToken = ((KtSimpleNameExpression)operationReference).getReferencedNameElementType();
            if (Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.EQEQ))) {
                bl = (Boolean)result2;
            } else if (Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.EXCLEQ))) {
                bl = !((Boolean)result2).booleanValue();
            } else if (Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.IDENTIFIER))) {
                boolean bl3 = Intrinsics.areEqual((Object)((KtSimpleNameExpression)operationReference).getReferencedNameAsName(), (Object)OperatorNameConventions.EQUALS);
                if (_Assertions.ENABLED && !bl3) {
                    boolean bl4 = false;
                    String string2 = "This method should be called only for equals operations";
                    throw new AssertionError((Object)string2);
                }
                bl = (Boolean)result2;
            } else {
                throw new IllegalStateException("Unknown equals operation token: " + operationToken + ' ' + ((KtSimpleNameExpression)operationReference).getText());
            }
            boolean value2 = bl;
            return new BooleanValue(value2);
        }
        return null;
    }

    private static final ConstantValue<?> createCompileTimeConstantForCompareTo(Object result2, KtExpression operationReference) {
        if (result2 instanceof Integer) {
            ConstantValue constantValue;
            boolean bl = operationReference instanceof KtSimpleNameExpression;
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "This method should be called only for compareTo operations";
                throw new AssertionError((Object)string2);
            }
            IElementType operationToken = ((KtSimpleNameExpression)operationReference).getReferencedNameElementType();
            if (Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.LT))) {
                constantValue = new BooleanValue(((Number)result2).intValue() < 0);
            } else if (Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.LTEQ))) {
                constantValue = new BooleanValue(((Number)result2).intValue() <= 0);
            } else if (Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.GT))) {
                constantValue = new BooleanValue(((Number)result2).intValue() > 0);
            } else if (Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.GTEQ))) {
                constantValue = new BooleanValue(((Number)result2).intValue() >= 0);
            } else {
                if (Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.IDENTIFIER))) {
                    boolean bl3 = Intrinsics.areEqual((Object)((KtSimpleNameExpression)operationReference).getReferencedNameAsName(), (Object)OperatorNameConventions.COMPARE_TO);
                    if (_Assertions.ENABLED && !bl3) {
                        boolean bl4 = false;
                        String string3 = "This method should be called only for compareTo operations";
                        throw new AssertionError((Object)string3);
                    }
                    return new IntValue(((Number)result2).intValue());
                }
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Unknown compareTo operation token: ", (Object)operationToken));
            }
            return constantValue;
        }
        return null;
    }

    public static final boolean isIntegerType(@Nullable Object value2) {
        return value2 instanceof Byte || value2 instanceof Short || value2 instanceof Integer || value2 instanceof Long;
    }

    private static final KotlinType getReceiverExpressionType(ResolvedCall<?> resolvedCall2) {
        KotlinType kotlinType;
        ExplicitReceiverKind explicitReceiverKind = resolvedCall2.getExplicitReceiverKind();
        int n = WhenMappings.$EnumSwitchMapping$0[explicitReceiverKind.ordinal()];
        switch (n) {
            case 1: {
                ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
                Intrinsics.checkNotNull((Object)receiverValue);
                kotlinType = receiverValue.getType();
                break;
            }
            case 2: {
                ReceiverValue receiverValue = resolvedCall2.getExtensionReceiver();
                Intrinsics.checkNotNull((Object)receiverValue);
                kotlinType = receiverValue.getType();
                break;
            }
            case 3: {
                kotlinType = null;
                break;
            }
            case 4: {
                kotlinType = null;
                break;
            }
            default: {
                kotlinType = null;
            }
        }
        return kotlinType;
    }

    public static final boolean isStandaloneOnlyConstant(@NotNull ConstantValue<?> $this$isStandaloneOnlyConstant) {
        Intrinsics.checkNotNullParameter($this$isStandaloneOnlyConstant, (String)"<this>");
        return $this$isStandaloneOnlyConstant instanceof KClassValue || $this$isStandaloneOnlyConstant instanceof EnumValue || $this$isStandaloneOnlyConstant instanceof AnnotationValue || $this$isStandaloneOnlyConstant instanceof ArrayValue;
    }

    public static final boolean isStandaloneOnlyConstant(@NotNull CompileTimeConstant<?> $this$isStandaloneOnlyConstant) {
        Intrinsics.checkNotNullParameter($this$isStandaloneOnlyConstant, (String)"<this>");
        CompileTimeConstant<?> compileTimeConstant = $this$isStandaloneOnlyConstant;
        if (!(compileTimeConstant instanceof TypedCompileTimeConstant)) {
            return false;
        }
        return ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(((TypedCompileTimeConstant)$this$isStandaloneOnlyConstant).getConstantValue());
    }

    private static final boolean isZero(Object value2) {
        boolean bl;
        if (ConstantExpressionEvaluatorKt.isIntegerType(value2)) {
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            bl = ((Number)value2).longValue() == 0L;
        } else {
            bl = value2 instanceof Float || value2 instanceof Double ? ((Number)value2).doubleValue() == 0.0 : false;
        }
        return bl;
    }

    private static final CompileTimeType typeStrToCompileTimeType(String str) {
        CompileTimeType compileTimeType;
        switch (str) {
            case "Byte": {
                compileTimeType = CompileTimeType.BYTE;
                break;
            }
            case "Short": {
                compileTimeType = CompileTimeType.SHORT;
                break;
            }
            case "Int": {
                compileTimeType = CompileTimeType.INT;
                break;
            }
            case "Long": {
                compileTimeType = CompileTimeType.LONG;
                break;
            }
            case "Double": {
                compileTimeType = CompileTimeType.DOUBLE;
                break;
            }
            case "Float": {
                compileTimeType = CompileTimeType.FLOAT;
                break;
            }
            case "Char": {
                compileTimeType = CompileTimeType.CHAR;
                break;
            }
            case "Boolean": {
                compileTimeType = CompileTimeType.BOOLEAN;
                break;
            }
            case "String": {
                compileTimeType = CompileTimeType.STRING;
                break;
            }
            case "Any": {
                compileTimeType = CompileTimeType.ANY;
                break;
            }
            default: {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unsupported type: ", (Object)str));
            }
        }
        return compileTimeType;
    }

    @Nullable
    public static final Object evaluateUnary(@NotNull String name2, @NotNull String typeStr, @NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)typeStr, (String)"typeStr");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return OperationsMapGeneratedKt.evalUnaryOp(name2, ConstantExpressionEvaluatorKt.typeStrToCompileTimeType(typeStr), value2);
    }

    private static final Object evaluateUnaryAndCheck(String name2, CompileTimeType type2, Object value2, Function0<Unit> reportIntegerOverflow) {
        Object object;
        Object result2 = object = OperationsMapGeneratedKt.evalUnaryOp(name2, type2, value2);
        boolean bl = false;
        if (ConstantExpressionEvaluatorKt.isIntegerType(value2) && (Intrinsics.areEqual((Object)name2, (Object)"minus") || Intrinsics.areEqual((Object)name2, (Object)"unaryMinus")) && Intrinsics.areEqual((Object)value2, (Object)result2) && !ConstantExpressionEvaluatorKt.isZero(value2)) {
            reportIntegerOverflow.invoke();
        }
        return object;
    }

    @Nullable
    public static final Object evaluateBinary(@NotNull String name2, @NotNull String receiverTypeStr, @NotNull Object receiverValue, @NotNull String parameterTypeStr, @NotNull Object parameterValue) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)receiverTypeStr, (String)"receiverTypeStr");
        Intrinsics.checkNotNullParameter((Object)receiverValue, (String)"receiverValue");
        Intrinsics.checkNotNullParameter((Object)parameterTypeStr, (String)"parameterTypeStr");
        Intrinsics.checkNotNullParameter((Object)parameterValue, (String)"parameterValue");
        CompileTimeType receiverType = ConstantExpressionEvaluatorKt.typeStrToCompileTimeType(receiverTypeStr);
        CompileTimeType parameterType = ConstantExpressionEvaluatorKt.typeStrToCompileTimeType(parameterTypeStr);
        try {
            object = OperationsMapGeneratedKt.evalBinaryOp(name2, receiverType, receiverValue, parameterType, parameterValue);
        }
        catch (Exception e) {
            object = null;
        }
        return object;
    }

    private static final Object evaluateBinaryAndCheck(String name2, CompileTimeType receiverType, Object receiverValue, CompileTimeType parameterType, Object parameterValue, Function0<Unit> reportIntegerOverflow) {
        Object object;
        try {
            object = OperationsMapGeneratedKt.evalBinaryOp(name2, receiverType, receiverValue, parameterType, parameterValue);
        }
        catch (Exception e) {
            object = null;
        }
        Object actualResult = object;
        if (actualResult != null && ConstantExpressionEvaluatorKt.isIntegerType(receiverValue) && ConstantExpressionEvaluatorKt.isIntegerType(parameterValue)) {
            BigInteger bigInteger = ConstantExpressionEvaluatorKt.evaluateBinaryAndCheck$toBigInteger(receiverValue);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"toBigInteger(receiverValue)");
            BigInteger bigInteger2 = bigInteger;
            bigInteger = ConstantExpressionEvaluatorKt.evaluateBinaryAndCheck$toBigInteger(parameterValue);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"toBigInteger(parameterValue)");
            BigInteger checkedResult = OperationsMapGeneratedKt.checkBinaryOp(name2, receiverType, bigInteger2, parameterType, bigInteger);
            if (checkedResult != null && !Intrinsics.areEqual((Object)ConstantExpressionEvaluatorKt.evaluateBinaryAndCheck$toBigInteger(actualResult), (Object)checkedResult)) {
                reportIntegerOverflow.invoke();
            }
        }
        return actualResult;
    }

    private static final BigInteger evaluateBinaryAndCheck$toBigInteger(Object value2) {
        if (value2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
        }
        return BigInteger.valueOf(((Number)value2).longValue());
    }

    public static final /* synthetic */ ConstantValue access$createCompileTimeConstantForCompareTo(Object result2, KtExpression operationReference) {
        return ConstantExpressionEvaluatorKt.createCompileTimeConstantForCompareTo(result2, operationReference);
    }

    public static final /* synthetic */ ConstantValue access$createCompileTimeConstantForEquals(Object result2, KtExpression operationReference) {
        return ConstantExpressionEvaluatorKt.createCompileTimeConstantForEquals(result2, operationReference);
    }

    public static final /* synthetic */ Object access$evaluateUnaryAndCheck(String name2, CompileTimeType type2, Object value2, Function0 reportIntegerOverflow) {
        return ConstantExpressionEvaluatorKt.evaluateUnaryAndCheck(name2, type2, value2, (Function0<Unit>)reportIntegerOverflow);
    }

    public static final /* synthetic */ Object access$evaluateBinaryAndCheck(String name2, CompileTimeType receiverType, Object receiverValue, CompileTimeType parameterType, Object parameterValue, Function0 reportIntegerOverflow) {
        return ConstantExpressionEvaluatorKt.evaluateBinaryAndCheck(name2, receiverType, receiverValue, parameterType, parameterValue, (Function0<Unit>)reportIntegerOverflow);
    }

    public static final /* synthetic */ Set access$getDIVISION_OPERATION_NAMES$p() {
        return DIVISION_OPERATION_NAMES;
    }

    public static final /* synthetic */ boolean access$isZero(Object value2) {
        return ConstantExpressionEvaluatorKt.isZero(value2);
    }

    public static final /* synthetic */ KotlinType access$getReceiverExpressionType(ResolvedCall resolvedCall2) {
        return ConstantExpressionEvaluatorKt.getReceiverExpressionType(resolvedCall2);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Name[]{OperatorNameConventions.DIV, OperatorNameConventions.REM, OperatorNameConventions.MOD};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Name name2 = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = p0.asString();
            collection.add(string2);
        }
        DIVISION_OPERATION_NAMES = CollectionsKt.toSet((Iterable)((List)var3_3));
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExplicitReceiverKind.values().length];
            nArray[ExplicitReceiverKind.DISPATCH_RECEIVER.ordinal()] = 1;
            nArray[ExplicitReceiverKind.EXTENSION_RECEIVER.ordinal()] = 2;
            nArray[ExplicitReceiverKind.NO_EXPLICIT_RECEIVER.ordinal()] = 3;
            nArray[ExplicitReceiverKind.BOTH_RECEIVERS.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

