/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFileKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001aH\u0016J\"\u0010\u001b\u001a\u0004\u0018\u00010\u0016*\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u0016H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ConstTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "inlineConstTracker", "Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "getInlineConstTracker", "()Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "getIrFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "reportInlineConst", "", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "value", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "lowerConstRead", "receiver", "shouldDropConstReceiver", "", "backend.jvm.lower"})
final class ConstTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final IrFile irFile;
    @NotNull
    private final JvmBackendContext context;
    @Nullable
    private final InlineConstTracker inlineConstTracker;

    public ConstTransformer(@NotNull IrFile irFile, @NotNull JvmBackendContext context2, @Nullable InlineConstTracker inlineConstTracker) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.irFile = irFile;
        this.context = context2;
        this.inlineConstTracker = inlineConstTracker;
    }

    @NotNull
    public final IrFile getIrFile() {
        return this.irFile;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Nullable
    public final InlineConstTracker getInlineConstTracker() {
        return this.inlineConstTracker;
    }

    private final IrExpression lowerConstRead(IrExpression $this$lowerConstRead, IrExpression receiver, IrField field2) {
        IrExpression irExpression;
        IrExpression resultExpression;
        IrElementBase irElementBase = field2;
        if (irElementBase == null || (irElementBase = JvmIrUtilsKt.constantValue((IrField)irElementBase)) == null) {
            return null;
        }
        IrElementBase value2 = irElementBase;
        this.transformChildrenVoid($this$lowerConstRead);
        this.reportInlineConst(field2, (IrConst<?>)value2);
        IrExpression irExpression2 = resultExpression = this.context.getState().getShouldInlineConstVals() ? (IrExpression)((IrConst)value2).copyWithOffsets($this$lowerConstRead.getStartOffset(), $this$lowerConstRead.getEndOffset()) : (IrExpression)new IrGetFieldImpl($this$lowerConstRead.getStartOffset(), $this$lowerConstRead.getEndOffset(), field2.getSymbol(), field2.getType(), null, null, 48, null);
        if (receiver == null || this.shouldDropConstReceiver(receiver)) {
            irExpression = resultExpression;
        } else {
            Object[] objectArray = new IrExpression[]{receiver, resultExpression};
            irExpression = new IrCompositeImpl($this$lowerConstRead.getStartOffset(), $this$lowerConstRead.getEndOffset(), resultExpression.getType(), null, CollectionsKt.listOf((Object[])objectArray));
        }
        return irExpression;
    }

    private final void reportInlineConst(IrField field2, IrConst<?> value2) {
        if (this.inlineConstTracker == null) {
            return;
        }
        if (!Intrinsics.areEqual((Object)field2.getOrigin(), (Object)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE)) {
            return;
        }
        String path2 = IrFileKt.getPath(this.irFile);
        Object object = AdditionalIrUtilsKt.getClassId(IrUtilsKt.getParentAsClass(field2));
        if (object == null || (object = ((ClassId)object).asString()) == null || (object = StringsKt.replace$default((String)object, (String)".", (String)"$", (boolean)false, (int)4, null)) == null || (object = StringsKt.replace$default((String)object, (String)"/", (String)".", (boolean)false, (int)4, null)) == null) {
            return;
        }
        Object owner = object;
        String string2 = field2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"field.name.asString()");
        String name2 = string2;
        String constType = value2.getKind().getAsString();
        this.inlineConstTracker.report(path2, (String)owner, name2, constType);
    }

    private final boolean shouldDropConstReceiver(IrExpression $this$shouldDropConstReceiver) {
        return $this$shouldDropConstReceiver instanceof IrConst || $this$shouldDropConstReceiver instanceof IrGetValue || $this$shouldDropConstReceiver instanceof IrGetObjectValue;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrFunction irFunction2 = expression2.getSymbol().getOwner();
        IrSimpleFunction irSimpleFunction = irFunction2 instanceof IrSimpleFunction ? (IrSimpleFunction)irFunction2 : null;
        if (irSimpleFunction == null) {
            return super.visitCall(expression2);
        }
        IrSimpleFunction function2 = irSimpleFunction;
        Object object = function2.getCorrespondingPropertySymbol();
        if (object == null || (object = (IrProperty)object.getOwner()) == null) {
            return super.visitCall(expression2);
        }
        Object property2 = object;
        IrExpression irExpression = this.lowerConstRead(expression2, expression2.getDispatchReceiver(), ((IrProperty)property2).getBackingField());
        if (irExpression == null) {
            irExpression = super.visitCall(expression2);
        }
        return irExpression;
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrExpression irExpression = this.lowerConstRead(expression2, expression2.getReceiver(), (IrField)expression2.getSymbol().getOwner());
        if (irExpression == null) {
            irExpression = super.visitGetField(expression2);
        }
        return irExpression;
    }
}

