/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmReflectSymbols;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocatorKt;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineScopeResolver;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.SyntheticAccessorLowering;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrBuildersKt;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.StubGeneratorExtensions;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u00192\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'H\u0002J2\u0010%\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001a2\b\u0010,\u001a\u0004\u0018\u00010\u001b2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u000201H\u0002J:\u0010/\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*2\u0006\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u001a2\b\u0010,\u001a\u0004\u0018\u00010\u001b2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00104\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bH\u0002JN\u00104\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001a2\u0006\u00105\u001a\u00020*2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001a072\b\u00108\u001a\u0004\u0018\u00010\u001b2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u001b072\u0006\u0010:\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010;\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010<\u001a\u00020\u001b2\u0006\u00100\u001a\u000201H\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020>2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\bH\u0016J\u0010\u0010G\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020$H\u0016J\u0010\u0010H\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020'H\u0016J\u0010\u0010I\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020 H\u0016J\u0010\u0010J\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u000201H\u0016J\"\u0010K\u001a\u00020\u001b*\u00020L2\u0006\u0010M\u001a\u00020\u001b2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u001b07H\u0002J\u0014\u0010N\u001a\u00020\u001b*\u00020L2\u0006\u0010M\u001a\u00020\u001bH\u0002J\u001c\u0010O\u001a\u00020\u001b*\u00020L2\u0006\u0010P\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u001bH\u0002J$\u0010Q\u001a\u00020\u001b*\u00020L2\u0006\u0010P\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u001bH\u0002J\u0014\u0010R\u001a\u00020\u001b*\u00020L2\u0006\u0010S\u001a\u00020\u001bH\u0002J\"\u0010T\u001a\u00020\u001b*\u00020L2\u0006\u0010(\u001a\u00020\u001b2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001a07H\u0002J\u001c\u0010U\u001a\u00020\u001b*\u00020L2\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020*H\u0002J*\u0010V\u001a\u00020\u001b*\u00020L2\u0006\u0010(\u001a\u00020\u001b2\u0006\u00105\u001a\u00020*2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001a07H\u0002J\u0012\u0010W\u001a\b\u0012\u0004\u0012\u00020\u001b07*\u00020XH\u0002J\u0016\u0010Y\u001a\u00020C*\u00020.2\b\b\u0002\u0010Z\u001a\u00020CH\u0002J\u0014\u0010[\u001a\u00020\u001b*\u00020L2\u0006\u0010\\\u001a\u00020\u001aH\u0002J*\u0010]\u001a\u00020\u001b*\u00020L2\u0006\u0010^\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u001b2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u001b07H\u0002J\u0014\u0010_\u001a\u00020\u001b*\u00020L2\u0006\u0010^\u001a\u00020\u001bH\u0002J\u0012\u0010`\u001a\b\u0012\u0004\u0012\u00020\u001a07*\u00020XH\u0002R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ReflectiveAccessLowering;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "callsOnCompanionObjects", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getCallsOnCompanionObjects", "()Ljava/util/Map;", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "inlineScopeResolver", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;", "getInlineScopeResolver", "()Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;", "setInlineScopeResolver", "(Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;)V", "reflectSymbols", "Lorg/jetbrains/kotlin/backend/jvm/JvmReflectSymbols;", "symbols", "Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;", "fieldLocationAndReceiver", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "generateInvokeSpecialForCall", "expression", "generateReflectiveAccessForCompanion", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "generateReflectiveAccessForGetter", "generateReflectiveAccessForSetter", "generateReflectiveConstructorInvocation", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "generateReflectiveFieldGet", "getField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "declaringClass", "fieldName", "", "fieldType", "instance", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "generateReflectiveFieldSet", "setField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "value", "type", "generateReflectiveMethodInvocation", "methodName", "parameterTypes", "", "receiver", "arguments", "returnType", "generateReflectiveStaticCall", "generateThrowIllegalAccessException", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "recordCompanionObjectAsDispatchReceiver", "shouldUseAccessor", "", "accessor", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitCall", "visitConstructorCall", "visitGetField", "visitGetObjectValue", "visitSetField", "constructorNewInstance", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "constructor", "constructorSetAccessible", "fieldGet", "fieldObject", "fieldSet", "fieldSetAccessible", "field", "getDeclaredConstructor", "getDeclaredField", "getDeclaredMethod", "getValueArguments", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "isAccessible", "withSuper", "javaClassObject", "klass", "methodInvoke", "method", "methodSetAccessible", "valueParameterTypes", "backend.jvm.lower"})
public final class ReflectiveAccessLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    public IrInlineScopeResolver inlineScopeResolver;
    @NotNull
    private final Map<IrCall, IrClassSymbol> callsOnCompanionObjects;
    @NotNull
    private final JvmSymbols symbols;
    @NotNull
    private final JvmReflectSymbols reflectSymbols;

    public ReflectiveAccessLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.callsOnCompanionObjects = new LinkedHashMap();
        this.symbols = this.context.getIr().getSymbols();
        this.reflectSymbols = this.symbols.getJavaLangReflectSymbols();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrInlineScopeResolver getInlineScopeResolver() {
        IrInlineScopeResolver irInlineScopeResolver = this.inlineScopeResolver;
        if (irInlineScopeResolver != null) {
            return irInlineScopeResolver;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"inlineScopeResolver");
        return null;
    }

    public final void setInlineScopeResolver(@NotNull IrInlineScopeResolver irInlineScopeResolver) {
        Intrinsics.checkNotNullParameter((Object)irInlineScopeResolver, (String)"<set-?>");
        this.inlineScopeResolver = irInlineScopeResolver;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.setInlineScopeResolver(IrInlineReferenceLocatorKt.findInlineCallSites(irFile, this.context));
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    private final boolean isAccessible(IrSymbol $this$isAccessible, boolean withSuper) {
        return SyntheticAccessorLowering.Companion.isAccessible($this$isAccessible, this.context, this.getCurrentScope(), this.getInlineScopeResolver(), withSuper, null);
    }

    static /* synthetic */ boolean isAccessible$default(ReflectiveAccessLowering reflectiveAccessLowering2, IrSymbol irSymbol2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return reflectiveAccessLowering2.isAccessible(irSymbol2, bl);
    }

    @NotNull
    public final Map<IrCall, IrClassSymbol> getCallsOnCompanionObjects() {
        return this.callsOnCompanionObjects;
    }

    private final void recordCompanionObjectAsDispatchReceiver(IrCall expression2) {
        IrExpression irExpression = expression2.getDispatchReceiver();
        Object object = irExpression instanceof IrGetObjectValue ? (IrGetObjectValue)irExpression : null;
        boolean bl = object != null && (object = ((IrGetObjectValue)object).getSymbol()) != null && (object = (IrClass)object.getOwner()) != null ? ((IrClass)object).isCompanion() : false;
        if (bl) {
            IrExpression irExpression2 = expression2.getDispatchReceiver();
            Intrinsics.checkNotNull((Object)irExpression2);
            this.callsOnCompanionObjects.put(expression2, ((IrGetObjectValue)irExpression2).getSymbol());
        }
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.recordCompanionObjectAsDispatchReceiver(expression2);
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        boolean withSuper = expression2.getSuperQualifierSymbol() != null;
        IrSimpleFunctionSymbol callee = expression2.getSymbol();
        if (this.isAccessible(callee, withSuper)) {
            return expression2;
        }
        if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.GET_PROPERTY.INSTANCE)) {
            irExpression = this.generateReflectiveAccessForGetter(expression2);
        } else {
            IrStatementOrigin irStatementOrigin = expression2.getOrigin();
            irExpression = (irStatementOrigin != null ? IrStatementOriginKt.isAssignmentOperator(irStatementOrigin) : false) ? this.generateReflectiveAccessForSetter(expression2) : (expression2.getDispatchReceiver() == null && expression2.getExtensionReceiver() == null ? this.generateReflectiveStaticCall(expression2) : (withSuper ? this.generateInvokeSpecialForCall(expression2) : this.generateReflectiveMethodInvocation(expression2)));
        }
        return irExpression;
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        IrFieldSymbol field2 = expression2.getSymbol();
        return ReflectiveAccessLowering.isAccessible$default(this, field2, false, 1, null) ? (IrExpression)expression2 : this.generateReflectiveFieldGet(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        IrFieldSymbol field2 = expression2.getSymbol();
        return ReflectiveAccessLowering.isAccessible$default(this, field2, false, 1, null) ? (IrExpression)expression2 : (((object = ((IrField)field2.getOwner()).getCorrespondingPropertySymbol()) != null && (object = (IrProperty)object.getOwner()) != null ? ((IrProperty)object).isConst() : false) || IrUtilsKt.isFromJava((IrDeclaration)field2.getOwner()) && ((IrField)field2.getOwner()).isFinal() ? this.generateThrowIllegalAccessException(expression2) : this.generateReflectiveFieldSet(expression2));
    }

    @Override
    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        IrConstructorSymbol callee = expression2.getSymbol();
        return ReflectiveAccessLowering.isAccessible$default(this, callee, false, 1, null) ? (IrExpression)expression2 : this.generateReflectiveConstructorInvocation(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        IrClassSymbol callee = expression2.getSymbol();
        return ReflectiveAccessLowering.isAccessible$default(this, callee, false, 1, null) ? (IrExpression)expression2 : this.generateReflectiveAccessForCompanion(expression2);
    }

    private final IrExpression javaClassObject(IrBuilderWithScope $this$javaClassObject, IrType klass) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        IrSimpleFunction irSimpleFunction = ((IrProperty)this.symbols.getKClassJava().getOwner()).getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        IrFunctionAccessExpression $this$javaClassObject_u24lambda_u2d0 = irFunctionAccessExpression = ExpressionHelpersKt.irCall($this$javaClassObject, irSimpleFunction);
        boolean bl = false;
        $this$javaClassObject_u24lambda_u2d0.setExtensionReceiver(new IrClassReferenceImpl($this$javaClassObject_u24lambda_u2d0.getStartOffset(), $this$javaClassObject_u24lambda_u2d0.getEndOffset(), IrTypesKt.getStarProjectedType($this$javaClassObject.getContext().getIrBuiltIns().getKClassClass()), $this$javaClassObject.getContext().getIrBuiltIns().getKClassClass(), klass));
        return irFunctionAccessExpression;
    }

    private final IrExpression getDeclaredField(IrBuilderWithScope $this$getDeclaredField, IrExpression declaringClass, String fieldName) {
        IrCall irCall;
        IrCall $this$getDeclaredField_u24lambda_u2d1 = irCall = ExpressionHelpersKt.irCall($this$getDeclaredField, this.reflectSymbols.getGetDeclaredField());
        boolean bl = false;
        $this$getDeclaredField_u24lambda_u2d1.setDispatchReceiver(declaringClass);
        $this$getDeclaredField_u24lambda_u2d1.putValueArgument(0, ExpressionHelpersKt.irString($this$getDeclaredField, fieldName));
        return irCall;
    }

    private final IrExpression fieldSetAccessible(IrBuilderWithScope $this$fieldSetAccessible, IrExpression field2) {
        IrCall irCall;
        IrCall $this$fieldSetAccessible_u24lambda_u2d2 = irCall = ExpressionHelpersKt.irCall($this$fieldSetAccessible, this.reflectSymbols.getJavaLangReflectFieldSetAccessible());
        boolean bl = false;
        $this$fieldSetAccessible_u24lambda_u2d2.setDispatchReceiver(field2);
        $this$fieldSetAccessible_u24lambda_u2d2.putValueArgument(0, ExpressionHelpersKt.irTrue($this$fieldSetAccessible));
        return irCall;
    }

    private final IrExpression fieldSet(IrBuilderWithScope $this$fieldSet, IrExpression fieldObject, IrExpression receiver, IrExpression value2) {
        IrCall irCall;
        IrCall $this$fieldSet_u24lambda_u2d3 = irCall = ExpressionHelpersKt.irCall($this$fieldSet, this.reflectSymbols.getJavaLangReflectFieldSet());
        boolean bl = false;
        $this$fieldSet_u24lambda_u2d3.setDispatchReceiver(fieldObject);
        $this$fieldSet_u24lambda_u2d3.putValueArgument(0, receiver);
        $this$fieldSet_u24lambda_u2d3.putValueArgument(1, value2);
        return irCall;
    }

    private final IrExpression fieldGet(IrBuilderWithScope $this$fieldGet, IrExpression fieldObject, IrExpression receiver) {
        IrCall irCall;
        IrCall $this$fieldGet_u24lambda_u2d4 = irCall = ExpressionHelpersKt.irCall($this$fieldGet, this.reflectSymbols.getJavaLangReflectFieldGet());
        boolean bl = false;
        $this$fieldGet_u24lambda_u2d4.setDispatchReceiver(fieldObject);
        $this$fieldGet_u24lambda_u2d4.putValueArgument(0, receiver);
        return irCall;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression getDeclaredMethod(IrBuilderWithScope $this$getDeclaredMethod, IrExpression declaringClass, String methodName, List<? extends IrType> parameterTypes) {
        Collection<IrExpression> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrCall irCall;
        IrCall $this$getDeclaredMethod_u24lambda_u2d6 = irCall = ExpressionHelpersKt.irCall($this$getDeclaredMethod, this.reflectSymbols.getGetDeclaredMethod());
        boolean bl = false;
        $this$getDeclaredMethod_u24lambda_u2d6.setDispatchReceiver(declaringClass);
        $this$getDeclaredMethod_u24lambda_u2d6.putValueArgument(0, ExpressionHelpersKt.irString($this$getDeclaredMethod, methodName));
        Iterable iterable = parameterTypes;
        IrType irType = IrTypesKt.getDefaultType(this.symbols.getJavaLangClass());
        IrBuilderWithScope irBuilderWithScope = $this$getDeclaredMethod;
        int n = 1;
        IrCall irCall2 = $this$getDeclaredMethod_u24lambda_u2d6;
        boolean $i$f$map = false;
        void var14_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrType irType2 = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.javaClassObject($this$getDeclaredMethod, (IrType)it));
        }
        collection = (List)destination$iv$iv;
        irCall2.putValueArgument(n, ExpressionHelpersKt.irVararg(irBuilderWithScope, irType, (List<? extends IrExpression>)collection));
        return irCall;
    }

    private final IrExpression methodSetAccessible(IrBuilderWithScope $this$methodSetAccessible, IrExpression method) {
        IrCall irCall;
        IrCall $this$methodSetAccessible_u24lambda_u2d7 = irCall = ExpressionHelpersKt.irCall($this$methodSetAccessible, this.reflectSymbols.getJavaLangReflectMethodSetAccessible());
        boolean bl = false;
        $this$methodSetAccessible_u24lambda_u2d7.setDispatchReceiver(method);
        $this$methodSetAccessible_u24lambda_u2d7.putValueArgument(0, ExpressionHelpersKt.irTrue($this$methodSetAccessible));
        return irCall;
    }

    private final IrExpression methodInvoke(IrBuilderWithScope $this$methodInvoke, IrExpression method, IrExpression receiver, List<? extends IrExpression> arguments2) {
        IrCall irCall;
        IrCall $this$methodInvoke_u24lambda_u2d8 = irCall = ExpressionHelpersKt.irCall($this$methodInvoke, this.reflectSymbols.getJavaLangReflectMethodInvoke());
        boolean bl = false;
        $this$methodInvoke_u24lambda_u2d8.setDispatchReceiver(method);
        $this$methodInvoke_u24lambda_u2d8.putValueArgument(0, receiver);
        $this$methodInvoke_u24lambda_u2d8.putValueArgument(1, ExpressionHelpersKt.irVararg($this$methodInvoke, $this$methodInvoke.getContext().getIrBuiltIns().getAnyNType(), arguments2));
        return irCall;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression getDeclaredConstructor(IrBuilderWithScope $this$getDeclaredConstructor, IrExpression declaringClass, List<? extends IrType> parameterTypes) {
        Collection<IrExpression> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrCall irCall;
        IrCall $this$getDeclaredConstructor_u24lambda_u2d10 = irCall = ExpressionHelpersKt.irCall($this$getDeclaredConstructor, this.reflectSymbols.getGetDeclaredConstructor());
        boolean bl = false;
        $this$getDeclaredConstructor_u24lambda_u2d10.setDispatchReceiver(declaringClass);
        Iterable iterable = parameterTypes;
        IrType irType = IrTypesKt.getDefaultType(this.symbols.getJavaLangClass());
        IrBuilderWithScope irBuilderWithScope = $this$getDeclaredConstructor;
        int n = 0;
        IrCall irCall2 = $this$getDeclaredConstructor_u24lambda_u2d10;
        boolean $i$f$map = false;
        void var13_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrType irType2 = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.javaClassObject($this$getDeclaredConstructor, (IrType)it));
        }
        collection = (List)destination$iv$iv;
        irCall2.putValueArgument(n, ExpressionHelpersKt.irVararg(irBuilderWithScope, irType, (List<? extends IrExpression>)collection));
        return irCall;
    }

    private final IrExpression constructorSetAccessible(IrBuilderWithScope $this$constructorSetAccessible, IrExpression constructor2) {
        IrCall irCall;
        IrCall $this$constructorSetAccessible_u24lambda_u2d11 = irCall = ExpressionHelpersKt.irCall($this$constructorSetAccessible, this.reflectSymbols.getJavaLangReflectConstructorSetAccessible());
        boolean bl = false;
        $this$constructorSetAccessible_u24lambda_u2d11.setDispatchReceiver(constructor2);
        $this$constructorSetAccessible_u24lambda_u2d11.putValueArgument(0, ExpressionHelpersKt.irTrue($this$constructorSetAccessible));
        return irCall;
    }

    private final IrExpression constructorNewInstance(IrBuilderWithScope $this$constructorNewInstance, IrExpression constructor2, List<? extends IrExpression> arguments2) {
        IrCall irCall;
        IrCall $this$constructorNewInstance_u24lambda_u2d12 = irCall = ExpressionHelpersKt.irCall($this$constructorNewInstance, this.reflectSymbols.getJavaLangReflectConstructorNewInstance());
        boolean bl = false;
        $this$constructorNewInstance_u24lambda_u2d12.setDispatchReceiver(constructor2);
        $this$constructorNewInstance_u24lambda_u2d12.putValueArgument(0, ExpressionHelpersKt.irVararg($this$constructorNewInstance, $this$constructorNewInstance.getContext().getIrBuiltIns().getAnyNType(), arguments2));
        return irCall;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveMethodInvocation(IrType declaringClass, String methodName, List<? extends IrType> parameterTypes, IrExpression receiver, List<? extends IrExpression> arguments2, IrType returnType2, IrSymbol symbol2) {
        void this_$iv$iv;
        IrBuilderWithScope $this$irBlock_u24default$iv = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, symbol2, 0, 0, 6, null);
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, returnType2, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateReflectiveMethodInvocation_u24lambda_u2d13 = this_$iv$iv;
        boolean bl = false;
        IrVariable methodVar = IrBuildersKt.createTmpVariable$default((IrStatementsBuilder)$this$generateReflectiveMethodInvocation_u24lambda_u2d13, this.getDeclaredMethod((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2d13, this.javaClassObject((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2d13, declaringClass), methodName, parameterTypes), "method", false, null, IrTypesKt.getDefaultType(this.reflectSymbols.getJavaLangReflectMethod()), 12, null);
        $this$generateReflectiveMethodInvocation_u24lambda_u2d13.unaryPlus(this.methodSetAccessible((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2d13, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2d13, methodVar)));
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2d13;
        IrExpression irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2d13, methodVar);
        IrExpression irExpression2 = receiver;
        if (irExpression2 == null) {
            irExpression2 = ExpressionHelpersKt.irNull((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2d13);
        }
        $this$generateReflectiveMethodInvocation_u24lambda_u2d13.unaryPlus(this.methodInvoke(irBuilderWithScope, irExpression, irExpression2, arguments2));
        return this_$iv$iv.doBuild();
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrExpression> getValueArguments(IrFunctionAccessExpression $this$getValueArguments) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)$this$getValueArguments.getValueArgumentsCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrExpression irExpression = $this$getValueArguments.getValueArgument((int)it);
            Intrinsics.checkNotNull((Object)irExpression);
            collection.add(irExpression);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrType> valueParameterTypes(IrFunctionAccessExpression $this$valueParameterTypes) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ((IrFunctionSymbol)$this$valueParameterTypes.getSymbol()).getOwner().getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveMethodInvocation(IrCall call2) {
        void $this$generateReflectiveMethodInvocation_u24lambda_u2d19;
        List $this$generateReflectiveMethodInvocation_u24lambda_u2d17;
        IrElementBase it;
        List list2;
        Object object = call2.getSuperQualifierSymbol();
        if (object == null || (object = IrTypesKt.getDefaultType((IrClassifierSymbol)object)) == null) {
            IrExpression irExpression = call2.getDispatchReceiver();
            Intrinsics.checkNotNull((Object)irExpression);
            object = irExpression.getType();
        }
        String string2 = ((IrSimpleFunction)call2.getSymbol().getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"call.symbol.owner.name.asString()");
        List list3 = list2 = (List)new ArrayList();
        String string3 = string2;
        Object object2 = object;
        ReflectiveAccessLowering reflectiveAccessLowering2 = this;
        boolean bl = false;
        IrValueParameter irValueParameter = ((IrSimpleFunction)call2.getSymbol().getOwner()).getExtensionReceiverParameter();
        if (irValueParameter != null) {
            it = irValueParameter;
            boolean bl2 = false;
            $this$generateReflectiveMethodInvocation_u24lambda_u2d17.add(it.getType());
        }
        $this$generateReflectiveMethodInvocation_u24lambda_u2d17.addAll((Collection)this.valueParameterTypes(call2));
        Object object3 = Unit.INSTANCE;
        List list4 = list2;
        IrExpression irExpression = call2.getDispatchReceiver();
        Intrinsics.checkNotNull((Object)irExpression);
        $this$generateReflectiveMethodInvocation_u24lambda_u2d17 = list2 = (List)new ArrayList();
        IrExpression irExpression2 = irExpression;
        object3 = list4;
        boolean bl3 = false;
        IrExpression irExpression3 = call2.getExtensionReceiver();
        if (irExpression3 != null) {
            it = irExpression3;
            boolean bl4 = false;
            $this$generateReflectiveMethodInvocation_u24lambda_u2d19.add(it);
        }
        $this$generateReflectiveMethodInvocation_u24lambda_u2d19.addAll((Collection)this.getValueArguments(call2));
        Unit unit2 = Unit.INSTANCE;
        return reflectiveAccessLowering2.generateReflectiveMethodInvocation((IrType)object2, string3, (List<? extends IrType>)object3, irExpression2, list2, call2.getType(), call2.getSymbol());
    }

    private final IrExpression generateReflectiveStaticCall(IrCall call2) {
        boolean bl;
        boolean bl2 = bl = call2.getDispatchReceiver() == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Assumed-to-be static call with a dispatch receiver";
            throw new AssertionError((Object)string2);
        }
        IrType irType = IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(call2.getSymbol().getOwner()));
        String string3 = ((IrSimpleFunction)call2.getSymbol().getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"call.symbol.owner.name.asString()");
        return this.generateReflectiveMethodInvocation(irType, string3, this.valueParameterTypes(call2), null, this.getValueArguments(call2), call2.getType(), call2.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveConstructorInvocation(IrConstructorCall call2) {
        void this_$iv$iv;
        void $this$irBlock_u24default$iv;
        IrBuilderWithScope irBuilderWithScope = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, call2.getSymbol(), 0, 0, 6, null);
        IrType resultType$iv = call2.getType();
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateReflectiveConstructorInvocation_u24lambda_u2d21 = this_$iv$iv;
        boolean bl = false;
        IrVariable constructorVar = IrBuildersKt.createTmpVariable$default((IrStatementsBuilder)$this$generateReflectiveConstructorInvocation_u24lambda_u2d21, this.getDeclaredConstructor((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2d21, this.javaClassObject((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2d21, IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(call2.getSymbol().getOwner()))), this.valueParameterTypes(call2)), "constructor", false, null, IrTypesKt.getDefaultType(this.reflectSymbols.getJavaLangReflectConstructor()), 12, null);
        $this$generateReflectiveConstructorInvocation_u24lambda_u2d21.unaryPlus(this.constructorSetAccessible((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2d21, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2d21, constructorVar)));
        $this$generateReflectiveConstructorInvocation_u24lambda_u2d21.unaryPlus(this.constructorNewInstance((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2d21, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2d21, constructorVar), this.getValueArguments(call2)));
        return this_$iv$iv.doBuild();
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveFieldGet(IrType declaringClass, String fieldName, IrType fieldType, IrExpression instance, IrSymbol symbol2) {
        void this_$iv$iv;
        void $this$irBlock_u24default$iv;
        IrBuilderWithScope irBuilderWithScope = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, symbol2, 0, 0, 6, null);
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, fieldType, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateReflectiveFieldGet_u24lambda_u2d22 = this_$iv$iv;
        boolean bl = false;
        IrStatementsBuilder irStatementsBuilder = (IrStatementsBuilder)$this$generateReflectiveFieldGet_u24lambda_u2d22;
        IrExpression irExpression = this.javaClassObject((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2d22, declaringClass);
        IrSimpleFunction irSimpleFunction = ((IrProperty)this.symbols.getKClassJava().getOwner()).getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        IrVariable classVar = IrBuildersKt.createTmpVariable$default(irStatementsBuilder, irExpression, "klass", false, null, irSimpleFunction.getReturnType(), 12, null);
        IrVariable fieldVar = IrBuildersKt.createTmpVariable$default((IrStatementsBuilder)$this$generateReflectiveFieldGet_u24lambda_u2d22, this.getDeclaredField((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2d22, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2d22, classVar), fieldName), "field", false, null, IrTypesKt.getDefaultType(this.reflectSymbols.getJavaLangReflectField()), 12, null);
        $this$generateReflectiveFieldGet_u24lambda_u2d22.unaryPlus(this.fieldSetAccessible((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2d22, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2d22, fieldVar)));
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2d22;
        IrExpression irExpression2 = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2d22, fieldVar);
        IrExpression irExpression3 = instance;
        if (irExpression3 == null) {
            irExpression3 = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2d22, classVar);
        }
        $this$generateReflectiveFieldGet_u24lambda_u2d22.unaryPlus(this.fieldGet(irBuilderWithScope2, irExpression2, irExpression3));
        return this_$iv$iv.doBuild();
    }

    private final IrExpression generateReflectiveFieldGet(IrGetField getField) {
        IrClass irClass2 = IrUtilsKt.getParentClassOrNull((IrDeclaration)getField.getSymbol().getOwner());
        Intrinsics.checkNotNull((Object)irClass2);
        IrType irType = IrUtilsKt.getDefaultType(irClass2);
        String string2 = ((IrField)getField.getSymbol().getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getField.symbol.owner.name.asString()");
        return this.generateReflectiveFieldGet(irType, string2, getField.getType(), getField.getReceiver(), getField.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveFieldSet(IrType declaringClass, String fieldName, IrExpression value2, IrType type2, IrExpression instance, IrSymbol symbol2) {
        void this_$iv$iv;
        void $this$irBlock_u24default$iv;
        IrBuilderWithScope irBuilderWithScope = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, symbol2, 0, 0, 6, null);
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, type2, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateReflectiveFieldSet_u24lambda_u2d23 = this_$iv$iv;
        boolean bl = false;
        IrVariable fieldVar = IrBuildersKt.createTmpVariable$default((IrStatementsBuilder)$this$generateReflectiveFieldSet_u24lambda_u2d23, this.getDeclaredField((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2d23, this.javaClassObject((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2d23, declaringClass), fieldName), "field", false, null, IrTypesKt.getDefaultType(this.reflectSymbols.getJavaLangReflectField()), 12, null);
        $this$generateReflectiveFieldSet_u24lambda_u2d23.unaryPlus(this.fieldSetAccessible((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2d23, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2d23, fieldVar)));
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2d23;
        IrExpression irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2d23, fieldVar);
        IrExpression irExpression2 = instance;
        if (irExpression2 == null) {
            irExpression2 = ExpressionHelpersKt.irNull((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2d23);
        }
        $this$generateReflectiveFieldSet_u24lambda_u2d23.unaryPlus(this.fieldSet(irBuilderWithScope2, irExpression, irExpression2, value2));
        return this_$iv$iv.doBuild();
    }

    private final IrExpression generateReflectiveFieldSet(IrSetField setField) {
        IrClass irClass2 = IrUtilsKt.getParentClassOrNull((IrDeclaration)setField.getSymbol().getOwner());
        Intrinsics.checkNotNull((Object)irClass2);
        IrType irType = IrUtilsKt.getDefaultType(irClass2);
        String string2 = ((IrField)setField.getSymbol().getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"setField.symbol.owner.name.asString()");
        return this.generateReflectiveFieldSet(irType, string2, setField.getValue(), setField.getType(), setField.getReceiver(), setField.getSymbol());
    }

    private final boolean shouldUseAccessor(IrSimpleFunction accessor) {
        return ((StubGeneratorExtensions)((Object)this.context.getGeneratorExtensions())).isAccessorWithExplicitImplementation(accessor);
    }

    private final Pair<IrType, IrExpression> fieldLocationAndReceiver(IrCall call2) {
        IrClassSymbol irClassSymbol = this.callsOnCompanionObjects.get(call2);
        if (irClassSymbol != null) {
            IrClassSymbol it = irClassSymbol;
            boolean bl = false;
            IrClass parentAsClass = IrUtilsKt.getParentAsClass((IrDeclaration)it.getOwner());
            if (!JvmIrUtilsKt.isJvmInterface(parentAsClass)) {
                return TuplesKt.to((Object)IrUtilsKt.getDefaultType(parentAsClass), null);
            }
        }
        IrExpression irExpression = call2.getDispatchReceiver();
        Intrinsics.checkNotNull((Object)irExpression);
        IrType irType = irExpression.getType();
        IrExpression irExpression2 = call2.getDispatchReceiver();
        Intrinsics.checkNotNull((Object)irExpression2);
        return TuplesKt.to((Object)irType, (Object)irExpression2);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveAccessForGetter(IrCall call2) {
        IrProperty property2;
        IrSimpleFunction getter2;
        block2: {
            Object object;
            String string2;
            IrType irType;
            ReflectiveAccessLowering reflectiveAccessLowering2;
            block4: {
                block3: {
                    void it;
                    getter2 = (IrSimpleFunction)call2.getSymbol().getOwner();
                    IrPropertySymbol irPropertySymbol = getter2.getCorrespondingPropertySymbol();
                    Intrinsics.checkNotNull((Object)irPropertySymbol);
                    property2 = (IrProperty)irPropertySymbol.getOwner();
                    if (!this.shouldUseAccessor(getter2)) break block2;
                    reflectiveAccessLowering2 = this;
                    irType = IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(getter2));
                    String string3 = property2.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"property.name.asString()");
                    string2 = JvmAbi.getterName(string3);
                    object = getter2.getExtensionReceiverParameter();
                    if (object == null) break block3;
                    IrValueParameter irValueParameter = object;
                    String string4 = string2;
                    IrType irType2 = irType;
                    ReflectiveAccessLowering reflectiveAccessLowering3 = reflectiveAccessLowering2;
                    boolean bl = false;
                    List list2 = CollectionsKt.listOf((Object)it.getType());
                    reflectiveAccessLowering2 = reflectiveAccessLowering3;
                    irType = irType2;
                    string2 = string4;
                    List list3 = list2;
                    object = list3;
                    if (list3 != null) break block4;
                }
                object = CollectionsKt.emptyList();
            }
            IrExpression irExpression = call2.getDispatchReceiver();
            Intrinsics.checkNotNull((Object)irExpression);
            return reflectiveAccessLowering2.generateReflectiveMethodInvocation(irType, string2, (List<? extends IrType>)object, irExpression, CollectionsKt.listOfNotNull((Object)call2.getExtensionReceiver()), getter2.getReturnType(), call2.getSymbol());
        }
        Pair<IrType, IrExpression> pair = this.fieldLocationAndReceiver(call2);
        IrType fieldLocation = (IrType)pair.component1();
        IrExpression instance = (IrExpression)pair.component2();
        String string5 = property2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"property.name.asString()");
        return this.generateReflectiveFieldGet(fieldLocation, string5, getter2.getReturnType(), instance, call2.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveAccessForSetter(IrCall call2) {
        IrSimpleFunction setter2 = (IrSimpleFunction)call2.getSymbol().getOwner();
        IrPropertySymbol irPropertySymbol = setter2.getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)irPropertySymbol);
        IrProperty property2 = (IrProperty)irPropertySymbol.getOwner();
        if (this.shouldUseAccessor(setter2)) {
            void $this$generateReflectiveAccessForSetter_u24lambda_u2d29;
            List $this$generateReflectiveAccessForSetter_u24lambda_u2d27;
            IrElementBase it;
            List list2;
            IrType irType = IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(setter2));
            String string2 = property2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"property.name.asString()");
            List list3 = list2 = (List)new ArrayList();
            String string3 = JvmAbi.setterName(string2);
            IrType irType2 = irType;
            ReflectiveAccessLowering reflectiveAccessLowering2 = this;
            boolean bl = false;
            IrValueParameter irValueParameter = setter2.getExtensionReceiverParameter();
            if (irValueParameter != null) {
                it = irValueParameter;
                boolean bl2 = false;
                $this$generateReflectiveAccessForSetter_u24lambda_u2d27.add(it.getType());
            }
            $this$generateReflectiveAccessForSetter_u24lambda_u2d27.addAll((Collection)this.valueParameterTypes(call2));
            Object object = Unit.INSTANCE;
            List list4 = list2;
            IrExpression irExpression = call2.getDispatchReceiver();
            Intrinsics.checkNotNull((Object)irExpression);
            $this$generateReflectiveAccessForSetter_u24lambda_u2d27 = list2 = (List)new ArrayList();
            IrExpression irExpression2 = irExpression;
            object = list4;
            boolean bl3 = false;
            IrExpression irExpression3 = call2.getExtensionReceiver();
            if (irExpression3 != null) {
                it = irExpression3;
                boolean bl4 = false;
                $this$generateReflectiveAccessForSetter_u24lambda_u2d29.add(it);
            }
            $this$generateReflectiveAccessForSetter_u24lambda_u2d29.addAll((Collection)this.getValueArguments(call2));
            Unit unit2 = Unit.INSTANCE;
            return reflectiveAccessLowering2.generateReflectiveMethodInvocation(irType2, string3, (List<? extends IrType>)object, irExpression2, list2, setter2.getReturnType(), call2.getSymbol());
        }
        Pair<IrType, IrExpression> pair = this.fieldLocationAndReceiver(call2);
        IrType fieldLocation = (IrType)pair.component1();
        IrExpression receiver = (IrExpression)pair.component2();
        IrPropertySymbol irPropertySymbol2 = ((IrSimpleFunction)call2.getSymbol().getOwner()).getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)irPropertySymbol2);
        String string4 = ((IrProperty)irPropertySymbol2.getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"call.symbol.owner.corres\u2026l!!.owner.name.asString()");
        IrExpression irExpression = call2.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression);
        return this.generateReflectiveFieldSet(fieldLocation, string4, irExpression, call2.getType(), receiver, call2.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateThrowIllegalAccessException(IrSetField setField) {
        void $this$generateThrowIllegalAccessException_u24lambda_u2d31_u24lambda_u2d30;
        IrCall irCall;
        void this_$iv$iv;
        IrBuilderWithScope $this$irBlock_u24default$iv = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, setField.getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateThrowIllegalAccessException_u24lambda_u2d31 = this_$iv$iv;
        boolean bl = false;
        IrCall irCall2 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$generateThrowIllegalAccessException_u24lambda_u2d31, this.symbols.getThrowIllegalAccessException());
        void var14_14 = $this$generateThrowIllegalAccessException_u24lambda_u2d31;
        boolean bl2 = false;
        $this$generateThrowIllegalAccessException_u24lambda_u2d31_u24lambda_u2d30.putValueArgument(0, ExpressionHelpersKt.irString((IrBuilderWithScope)$this$generateThrowIllegalAccessException_u24lambda_u2d31, "Can not set final field"));
        var14_14.unaryPlus(irCall);
        return this_$iv$iv.doBuild();
    }

    private final IrExpression generateInvokeSpecialForCall(IrCall expression2) {
        IrCall irCall;
        JvmMethodSignature jvmSignature = this.context.getMethodSignatureMapper().mapSignatureSkipGeneric(expression2.getSymbol().getOwner());
        IrClassSymbol irClassSymbol = expression2.getSuperQualifierSymbol();
        Intrinsics.checkNotNull((Object)irClassSymbol);
        IrClass owner = (IrClass)irClassSymbol.getOwner();
        JvmIrBuilder builder = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, expression2.getSymbol(), 0, 0, 6, null);
        IrCall $this$generateInvokeSpecialForCall_u24lambda_u2d32 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)builder, this.symbols.getJvmDebuggerInvokeSpecialIntrinsic());
        boolean bl = false;
        $this$generateInvokeSpecialForCall_u24lambda_u2d32.setDispatchReceiver(expression2.getDispatchReceiver());
        $this$generateInvokeSpecialForCall_u24lambda_u2d32.setType(((IrSimpleFunction)expression2.getSymbol().getOwner()).getReturnType());
        $this$generateInvokeSpecialForCall_u24lambda_u2d32.putValueArgument(0, ExpressionHelpersKt.irString(builder, "" + AdditionalIrUtilsKt.getPackageFqName(owner) + '/' + owner.getName()));
        IrBuilderWithScope irBuilderWithScope = builder;
        String string2 = jvmSignature.getAsmMethod().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jvmSignature.asmMethod.name");
        $this$generateInvokeSpecialForCall_u24lambda_u2d32.putValueArgument(1, ExpressionHelpersKt.irString(irBuilderWithScope, string2));
        IrBuilderWithScope irBuilderWithScope2 = builder;
        String string3 = jvmSignature.getAsmMethod().getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"jvmSignature.asmMethod.descriptor");
        $this$generateInvokeSpecialForCall_u24lambda_u2d32.putValueArgument(2, ExpressionHelpersKt.irString(irBuilderWithScope2, string3));
        $this$generateInvokeSpecialForCall_u24lambda_u2d32.putValueArgument(3, ExpressionHelpersKt.irFalse(builder));
        return irCall;
    }

    private final IrExpression generateReflectiveAccessForCompanion(IrGetObjectValue call2) {
        return this.generateReflectiveFieldGet(IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass((IrDeclaration)call2.getSymbol().getOwner())), "Companion", call2.getType(), null, call2.getSymbol());
    }
}

